/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.skills.mining;

import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.ComplexStateQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.MINING)
public class Mining
extends ComplexStateQuestHelper {
    QuestStep copperSidebar;
    QuestStep ironSidebar;
    ItemRequirement ironPickaxe;
    ItemRequirement steelPickaxe;
    ItemRequirement blackPickaxe;
    ItemRequirement mithrilPickaxe;
    ItemRequirement adamantPickaxe;
    ItemRequirement runePickaxe;
    SkillRequirement mi6;
    SkillRequirement mi11;
    SkillRequirement mi21;
    SkillRequirement mi31;
    SkillRequirement mi41;
    SkillRequirement at5;
    SkillRequirement at10;
    SkillRequirement at20;
    SkillRequirement at30;
    SkillRequirement at40;
    SkillRequirement mi15;
    ObjectStep mineCopper;
    ObjectStep mineIron;
    Requirement inCopperZone;
    Requirement inIronZone;
    Zone copperZone;
    Zone ironZone;
    DetailedQuestStep copperStep;
    DetailedQuestStep ironStep;
    WorldPoint COPPER_POINT = new WorldPoint(3287, 3366, 0);
    WorldPoint IRON_POINT = new WorldPoint(3295, 3310, 0);

    @Override
    public QuestStep loadStep() {
        this.setupRequirements();
        this.setupConditions();
        this.setupZones();
        this.setupSteps();
        ConditionalStep fullTraining = new ConditionalStep((QuestHelper)this, (QuestStep)this.copperStep, new Requirement[0]);
        fullTraining.addStep(new Conditions(this.inCopperZone), this.mineCopper);
        fullTraining.addStep(new Conditions(this.mi15, this.inIronZone), this.mineIron);
        fullTraining.addStep(this.mi15, this.ironStep);
        this.copperSidebar = new DetailedQuestStep((QuestHelper)this, "Mine Copper- and Tin ore at South-east Varrock mine until 15 Mining. You can choose to drop the ores as you go or bank them in the eastern Varrock bank.", new Requirement[0]);
        this.copperSidebar.addSubSteps(this.copperStep, this.mineCopper);
        this.ironSidebar = new DetailedQuestStep((QuestHelper)this, "Mine Iron ore at Al Kharid Mine until 99 Mining. You can choose to drop the ores as you go, smelt them on the way to the Al Kharid bank or bank the ores as they are.", new Requirement[0]);
        this.ironSidebar.addSubSteps(this.ironStep, this.mineIron);
        return fullTraining;
    }

    @Override
    public void setupRequirements() {
        this.mi6 = new SkillRequirement(Skill.MINING, 6);
        this.mi11 = new SkillRequirement(Skill.MINING, 11);
        this.mi21 = new SkillRequirement(Skill.MINING, 21);
        this.mi31 = new SkillRequirement(Skill.MINING, 31);
        this.mi41 = new SkillRequirement(Skill.MINING, 41);
        this.mi15 = new SkillRequirement(Skill.MINING, 15);
        this.ironPickaxe = new ItemRequirement("Iron pickaxe", 1267);
        this.steelPickaxe = new ItemRequirement("Steel pickaxe", 1269);
        this.blackPickaxe = new ItemRequirement("Black pickaxe", 12297);
        this.mithrilPickaxe = new ItemRequirement("Mithril pickaxe", 1273);
        this.adamantPickaxe = new ItemRequirement("Adamant pickaxe", 1271);
        this.runePickaxe = new ItemRequirement("Rune pickaxe", 1275);
        this.ironPickaxe = this.ironPickaxe.showConditioned(new Conditions(LogicType.NOR, this.at5, this.mi6)).isNotConsumed();
        this.steelPickaxe = this.steelPickaxe.showConditioned(new Conditions(this.at5, this.mi6, new Conditions(LogicType.NOR, this.at10, this.mi11))).isNotConsumed();
        this.blackPickaxe = this.blackPickaxe.showConditioned(new Conditions(this.at10, this.mi11, new Conditions(LogicType.NOR, this.at20, this.mi21))).isNotConsumed();
        this.mithrilPickaxe = this.mithrilPickaxe.showConditioned(new Conditions(this.at20, this.mi21, new Conditions(LogicType.NOR, this.at30, this.mi31))).isNotConsumed();
        this.adamantPickaxe = this.adamantPickaxe.showConditioned(new Conditions(this.at30, this.mi31, new Conditions(LogicType.NOR, this.at40, this.mi41))).isNotConsumed();
        this.runePickaxe = this.runePickaxe.showConditioned(new Conditions(this.mi41, this.at40)).isNotConsumed();
    }

    public void setupConditions() {
        this.inCopperZone = new ZoneRequirement(this.copperZone);
        this.inIronZone = new ZoneRequirement(this.ironZone);
    }

    public void setupZones() {
        this.copperZone = new Zone(this.COPPER_POINT);
        this.ironZone = new Zone(this.IRON_POINT);
    }

    private void setupSteps() {
        this.copperStep = new DetailedQuestStep((QuestHelper)this, this.COPPER_POINT, "Mine Copper- and Tin ore at South-east Varrock mine until 15 Mining. You can choose to drop the ores as you go or bank them in the eastern Varrock bank.", this.ironPickaxe, this.steelPickaxe, this.blackPickaxe);
        this.copperStep.addTileMarker(this.COPPER_POINT, 209);
        this.ironStep = new DetailedQuestStep((QuestHelper)this, this.IRON_POINT, "Mine Iron ore at Al Kharid Mine until 99 Mining. You can choose to drop the ores as you go, smelt them on the way to the Al Kharid bank or bank the ores as they are.", this.steelPickaxe, this.blackPickaxe, this.mithrilPickaxe, this.adamantPickaxe, this.runePickaxe);
        this.ironStep.addTileMarker(this.IRON_POINT, 209);
        this.mineCopper = new ObjectStep((QuestHelper)this, 11360, this.COPPER_POINT, "Mine Copper- and Tin ore at South-east Varrock mine until 15 Mining. You can choose to drop the ores as you go or bank them in the eastern Varrock bank.", true, this.ironPickaxe, this.steelPickaxe, this.blackPickaxe);
        this.mineCopper.addAlternateObjects(11360, 11161, 10943);
        this.mineIron = new ObjectStep((QuestHelper)this, 11364, this.IRON_POINT, "Mine Iron ore at Al Kharid Mine until 99 Mining. You can choose to drop the ores as you go, smelt them on the way to the Al Kharid bank or bank the ores as they are.", true, this.steelPickaxe, this.blackPickaxe, this.mithrilPickaxe, this.adamantPickaxe, this.runePickaxe);
        this.mineIron.addAlternateObjects(11365);
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("Ability to purchase Mining Cape for 99k"));
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.ironPickaxe, this.steelPickaxe, this.blackPickaxe, this.mithrilPickaxe, this.adamantPickaxe, this.runePickaxe);
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("1 - 15: Mine Copper/Tin", Collections.singletonList(this.copperSidebar), this.ironPickaxe, this.steelPickaxe, this.blackPickaxe));
        allSteps.add(new PanelDetails("15 - 99: Mine Iron ore", Collections.singletonList(this.ironSidebar), this.steelPickaxe, this.blackPickaxe, this.mithrilPickaxe, this.adamantPickaxe, this.runePickaxe));
        return allSteps;
    }
}

