/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.skills.agility;

import com.questhelper.helpers.skills.agility.AgilityCourse;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.Arrays;
import java.util.Collections;
import net.runelite.api.coords.WorldPoint;

public class Varrock
extends AgilityCourse {
    QuestStep varrockSidebar;
    QuestStep climbRoughWall;
    QuestStep crossClothesLine;
    QuestStep leapFirstGap;
    QuestStep balanceWall;
    QuestStep leapSecondGap;
    QuestStep leapThirdGap;
    QuestStep leapFourthGap;
    QuestStep hurdleLedge;
    QuestStep jumpEdge;
    Zone clothesLineZone;
    Zone firstGapZone;
    Zone wallZone;
    Zone secondGapZone;
    Zone thirdGapZone;
    Zone fourthGapZone;
    Zone ledgeZone;
    Zone edgeZone;
    ZoneRequirement inClothesLineZone;
    ZoneRequirement inFirstGapZone;
    ZoneRequirement inWallZone;
    ZoneRequirement inSecondGapZone;
    ZoneRequirement inThirdGapZone;
    ZoneRequirement inFourthGapZone;
    ZoneRequirement inLedgeZone;
    ZoneRequirement inEdgeZone;
    ConditionalStep varrockStep;
    PanelDetails varrockPanels;

    public Varrock(QuestHelper questHelper) {
        super(questHelper);
    }

    @Override
    protected ConditionalStep loadStep() {
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
        this.addSteps();
        return this.varrockStep;
    }

    @Override
    protected void setupConditions() {
        this.inClothesLineZone = new ZoneRequirement(this.clothesLineZone);
        this.inFirstGapZone = new ZoneRequirement(this.firstGapZone);
        this.inWallZone = new ZoneRequirement(this.wallZone);
        this.inSecondGapZone = new ZoneRequirement(this.secondGapZone);
        this.inThirdGapZone = new ZoneRequirement(this.thirdGapZone);
        this.inFourthGapZone = new ZoneRequirement(this.fourthGapZone);
        this.inLedgeZone = new ZoneRequirement(this.ledgeZone);
        this.inEdgeZone = new ZoneRequirement(this.edgeZone);
    }

    @Override
    protected void setupZones() {
        this.clothesLineZone = new Zone(new WorldPoint(3210, 3410, 3), new WorldPoint(3219, 3419, 3));
        this.firstGapZone = new Zone(new WorldPoint(3201, 3413, 3), new WorldPoint(3209, 3419, 1));
        this.wallZone = new Zone(new WorldPoint(3190, 3407, 1), new WorldPoint(3197, 3416, 3));
        this.secondGapZone = new Zone(new WorldPoint(3191, 3399, 3), new WorldPoint(3198, 3406, 3));
        this.thirdGapZone = new Zone(new WorldPoint(3183, 3383, 3), new WorldPoint(3217, 3403, 3));
        this.fourthGapZone = new Zone(new WorldPoint(3218, 3393, 3), new WorldPoint(3234, 3403, 3));
        this.ledgeZone = new Zone(new WorldPoint(3235, 3403, 3), new WorldPoint(3240, 3409, 3));
        this.edgeZone = new Zone(new WorldPoint(3236, 3410, 3), new WorldPoint(3240, 3416, 3));
    }

    @Override
    protected void setupSteps() {
        this.climbRoughWall = new ObjectStep(this.questHelper, 14412, new WorldPoint(3221, 3414, 0), "Climb the rough wall on the east side of the General Store.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
        this.crossClothesLine = new ObjectStep(this.questHelper, 14413, new WorldPoint(3213, 3414, 3), "Cross the clothes line.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
        this.leapFirstGap = new ObjectStep(this.questHelper, 14414, new WorldPoint(3200, 3416, 3), "Leap off the first gap.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
        this.balanceWall = new ObjectStep(this.questHelper, 14832, new WorldPoint(3192, 3416, 1), "Balance across the wall.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
        this.leapSecondGap = new ObjectStep(this.questHelper, 14833, new WorldPoint(3195, 3401, 3), "Leap across second gap.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
        this.leapThirdGap = new ObjectStep(this.questHelper, 14834, new WorldPoint(3209, 3399, 3), "Leap across third gap.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
        this.leapFourthGap = new ObjectStep(this.questHelper, 14835, new WorldPoint(3233, 3402, 3), "Leap across fourth gap.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
        this.hurdleLedge = new ObjectStep(this.questHelper, 14836, new WorldPoint(3238, 3409, 3), "Hurdle across the ledge.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
        this.jumpEdge = new ObjectStep(this.questHelper, 14841, new WorldPoint(3238, 3416, 3), "Jump off the edge.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
    }

    @Override
    protected void addSteps() {
        this.varrockStep = new ConditionalStep(this.questHelper, this.climbRoughWall, new Requirement[0]);
        this.varrockStep.addStep(this.inClothesLineZone, this.crossClothesLine);
        this.varrockStep.addStep(this.inFirstGapZone, this.leapFirstGap);
        this.varrockStep.addStep(this.inWallZone, this.balanceWall);
        this.varrockStep.addStep(this.inSecondGapZone, this.leapSecondGap);
        this.varrockStep.addStep(this.inThirdGapZone, this.leapThirdGap);
        this.varrockStep.addStep(this.inFourthGapZone, this.leapFourthGap);
        this.varrockStep.addStep(this.inLedgeZone, this.hurdleLedge);
        this.varrockStep.addStep(this.inEdgeZone, this.jumpEdge);
        this.varrockSidebar = new DetailedQuestStep(this.questHelper, "Train agility at the Varrock Rooftop Course, starting on the east side of the General Store.", new Requirement[0]);
        this.varrockSidebar.addSubSteps(this.climbRoughWall, this.crossClothesLine, this.leapFirstGap, this.balanceWall, this.leapSecondGap, this.leapThirdGap, this.leapFourthGap, this.hurdleLedge, this.jumpEdge, this.varrockStep);
    }

    @Override
    protected PanelDetails getPanelDetails() {
        this.varrockPanels = new PanelDetails("30 - 40: Varrock", Collections.singletonList(this.varrockSidebar), new Requirement[0]);
        return this.varrockPanels;
    }
}

