/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.skills.agility;

import com.questhelper.helpers.skills.agility.AgilityCourse;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.Arrays;
import java.util.Collections;
import net.runelite.api.coords.WorldPoint;

public class SeersVillage
extends AgilityCourse {
    QuestStep seersSidebar;
    QuestStep climbWall;
    QuestStep jumpFirstGap;
    QuestStep crossTightrope;
    QuestStep jumpSecondGap;
    QuestStep jumpThirdGap;
    QuestStep jumpEdgeZone;
    Zone firstGapZone;
    Zone tightropeZone;
    Zone secondGapZone;
    Zone thirdGapZone;
    Zone edgeZone;
    ZoneRequirement inFirstGapZone;
    ZoneRequirement inTightropeZone;
    ZoneRequirement inSecondGapZone;
    ZoneRequirement inThirdGapZone;
    ZoneRequirement inEdgeZone;
    ConditionalStep seersStep;
    PanelDetails seersPanels;

    protected SeersVillage(QuestHelper questHelper) {
        super(questHelper);
    }

    @Override
    protected ConditionalStep loadStep() {
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
        this.addSteps();
        return this.seersStep;
    }

    @Override
    protected void setupConditions() {
        this.inFirstGapZone = new ZoneRequirement(this.firstGapZone);
        this.inTightropeZone = new ZoneRequirement(this.tightropeZone);
        this.inSecondGapZone = new ZoneRequirement(this.secondGapZone);
        this.inThirdGapZone = new ZoneRequirement(this.thirdGapZone);
        this.inEdgeZone = new ZoneRequirement(this.edgeZone);
    }

    @Override
    protected void setupZones() {
        this.firstGapZone = new Zone(new WorldPoint(2730, 3490, 3), new WorldPoint(2715, 3495, 2));
        this.tightropeZone = new Zone(new WorldPoint(2704, 3483, 2), new WorldPoint(2714, 3498, 2));
        this.secondGapZone = new Zone(new WorldPoint(2709, 3476, 2), new WorldPoint(2716, 3482, 2));
        this.thirdGapZone = new Zone(new WorldPoint(2699, 3468, 3), new WorldPoint(2716, 3475, 3));
        this.edgeZone = new Zone(new WorldPoint(2690, 3459, 3), new WorldPoint(2703, 3467, 2));
    }

    @Override
    protected void setupSteps() {
        this.climbWall = new ObjectStep(this.questHelper, 14927, new WorldPoint(2729, 3489, 0), "Climb up the wall outside the Seers' Bank.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
        this.jumpFirstGap = new ObjectStep(this.questHelper, 14928, new WorldPoint(2720, 3494, 3), "Jump across first gap.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
        this.crossTightrope = new ObjectStep(this.questHelper, 14932, new WorldPoint(2710, 3489, 2), "Cross the tightrope.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
        this.jumpSecondGap = new ObjectStep(this.questHelper, 14929, new WorldPoint(2712, 3476, 2), "Jump across second gap.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
        this.jumpThirdGap = new ObjectStep(this.questHelper, 14930, new WorldPoint(2702, 3469, 3), "Jump across third gap.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
        this.jumpEdgeZone = new ObjectStep(this.questHelper, 14931, new WorldPoint(2703, 3463, 2), "Jump off the edge.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
    }

    @Override
    protected void addSteps() {
        this.seersStep = new ConditionalStep(this.questHelper, this.climbWall, new Requirement[0]);
        this.seersStep.addStep(new Conditions(this.inFirstGapZone), this.jumpFirstGap);
        this.seersStep.addStep(new Conditions(this.inTightropeZone), this.crossTightrope);
        this.seersStep.addStep(new Conditions(this.inSecondGapZone), this.jumpSecondGap);
        this.seersStep.addStep(new Conditions(this.inThirdGapZone), this.jumpThirdGap);
        this.seersStep.addStep(new Conditions(this.inEdgeZone), this.jumpEdgeZone);
        this.seersSidebar = new DetailedQuestStep(this.questHelper, "Train agility at the Seer's Village Rooftop Course, starting just outside the Seer's Bank.\n\n60-80 Agility: If completed Kandarin Hard Diary, configure the Camelot Teleport Spell to Seer's and stay on Seer's rooftop course until 80 Agility. After each completed lap, use the teleport spell to get close to the course starting point", new Requirement[0]);
        this.seersSidebar.addSubSteps(this.climbWall, this.jumpFirstGap, this.crossTightrope, this.jumpSecondGap, this.jumpThirdGap, this.jumpEdgeZone, this.seersStep);
    }

    @Override
    protected PanelDetails getPanelDetails() {
        this.seersPanels = new PanelDetails("60 - 70/80: Seer's Village", Collections.singletonList(this.seersSidebar), new Requirement[0]);
        return this.seersPanels;
    }
}

