/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.skills.agility;

import com.questhelper.helpers.skills.agility.AgilityCourse;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.Arrays;
import java.util.Collections;
import net.runelite.api.coords.WorldPoint;

public class Rellekka
extends AgilityCourse {
    QuestStep rellekkaSidebar;
    QuestStep climbRoughWall;
    QuestStep leapFirstGap;
    QuestStep walkFirstRope;
    QuestStep leapSecondGap;
    QuestStep hurdleGap;
    QuestStep walkSecondRope;
    QuestStep jumpInFish;
    Zone firstGapZone;
    Zone firstRopeZone;
    Zone secondGapZone;
    Zone thirdGapZone;
    Zone secondRopeZone;
    Zone fishZone;
    ZoneRequirement inFirstGapZone;
    ZoneRequirement inFirstRopeZone;
    ZoneRequirement inSecondGapZone;
    ZoneRequirement inThirdGapZone;
    ZoneRequirement inSecondRopeZone;
    ZoneRequirement inFishZone;
    ConditionalStep rellekkaStep;
    PanelDetails rellekkaPanels;

    protected Rellekka(QuestHelper questHelper) {
        super(questHelper);
    }

    @Override
    protected ConditionalStep loadStep() {
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
        this.addSteps();
        return this.rellekkaStep;
    }

    @Override
    protected void setupConditions() {
        this.inFirstGapZone = new ZoneRequirement(this.firstGapZone);
        this.inFirstRopeZone = new ZoneRequirement(this.firstRopeZone);
        this.inSecondGapZone = new ZoneRequirement(this.secondGapZone);
        this.inThirdGapZone = new ZoneRequirement(this.thirdGapZone);
        this.inSecondRopeZone = new ZoneRequirement(this.secondRopeZone);
        this.inFishZone = new ZoneRequirement(this.fishZone);
    }

    @Override
    protected void setupZones() {
        this.firstGapZone = new Zone(new WorldPoint(2626, 3676, 3), new WorldPoint(2621, 3669, 3));
        this.firstRopeZone = new Zone(new WorldPoint(2615, 3668, 3), new WorldPoint(2626, 3655, 3));
        this.secondGapZone = new Zone(new WorldPoint(2626, 3651, 3), new WorldPoint(2637, 3659, 3));
        this.thirdGapZone = new Zone(new WorldPoint(2638, 3649, 3), new WorldPoint(2644, 3655, 3));
        this.secondRopeZone = new Zone(new WorldPoint(2643, 3656, 3), new WorldPoint(2653, 3670, 3));
        this.fishZone = new Zone(new WorldPoint(2649, 3665, 3), new WorldPoint(2666, 3685, 3));
    }

    @Override
    protected void setupSteps() {
        this.climbRoughWall = new ObjectStep(this.questHelper, 14946, new WorldPoint(2625, 3677, 0), "Climb the rough wall in the north-western part of Rellekka, just south of the westernmost dock.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
        this.leapFirstGap = new ObjectStep(this.questHelper, 14947, new WorldPoint(2622, 3670, 3), "Leap across the gap.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
        this.walkFirstRope = new ObjectStep(this.questHelper, 14987, new WorldPoint(2623, 3658, 3), "Cross the tightrope.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
        this.leapSecondGap = new ObjectStep(this.questHelper, 14990, new WorldPoint(2630, 3656, 3), "Leap across the gap.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
        this.hurdleGap = new ObjectStep(this.questHelper, 14991, new WorldPoint(2643, 3654, 3), "Hurdle across the gap.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
        this.walkSecondRope = new ObjectStep(this.questHelper, 14992, new WorldPoint(2647, 3663, 3), "Cross the tightrope.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
        this.jumpInFish = new ObjectStep(this.questHelper, 14994, new WorldPoint(2654, 3676, 3), "Jump down into the pile of fish.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
    }

    @Override
    protected void addSteps() {
        this.rellekkaStep = new ConditionalStep(this.questHelper, this.climbRoughWall, new Requirement[0]);
        this.rellekkaStep.addStep(new Conditions(this.inFirstGapZone), this.leapFirstGap);
        this.rellekkaStep.addStep(new Conditions(this.inFirstRopeZone), this.walkFirstRope);
        this.rellekkaStep.addStep(new Conditions(this.inSecondGapZone), this.leapSecondGap);
        this.rellekkaStep.addStep(new Conditions(this.inThirdGapZone), this.hurdleGap);
        this.rellekkaStep.addStep(new Conditions(this.inSecondRopeZone), this.walkSecondRope);
        this.rellekkaStep.addStep(new Conditions(this.inFishZone), this.jumpInFish);
        this.rellekkaSidebar = new DetailedQuestStep(this.questHelper, "Train agility at the Rellekka Rooftop Course, starting in the north-western part of Rellekka, just south of the westernmost dock.", new Requirement[0]);
        this.rellekkaSidebar.addSubSteps(this.climbRoughWall, this.leapFirstGap, this.walkFirstRope, this.leapSecondGap, this.hurdleGap, this.walkSecondRope, this.jumpInFish);
    }

    @Override
    protected PanelDetails getPanelDetails() {
        this.rellekkaPanels = new PanelDetails("80 - 90: Rellekka", Collections.singletonList(this.rellekkaSidebar), new Requirement[0]);
        return this.rellekkaPanels;
    }
}

