/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.skills.agility;

import com.questhelper.helpers.skills.agility.AgilityCourse;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.Arrays;
import java.util.Collections;
import net.runelite.api.coords.WorldPoint;

public class GnomeStronghold
extends AgilityCourse {
    QuestStep gnomeSidebar;
    QuestStep walkLog;
    QuestStep climbFirstNet;
    QuestStep climbFirstTree;
    QuestStep walkRope;
    QuestStep climbSecondTree;
    QuestStep climbSecondNet;
    QuestStep squeezePipe;
    Zone firstNetZone;
    Zone firstTreeZone;
    Zone ropeZone;
    Zone secondTreeZone;
    Zone secondNetZone;
    Zone pipeZone;
    ZoneRequirement inFirstNetZone;
    ZoneRequirement inFirstTreeZone;
    ZoneRequirement inRopeZone;
    ZoneRequirement inSecondTreeZone;
    ZoneRequirement inSecondNetZone;
    ZoneRequirement inPipeZone;
    ConditionalStep gnomeStep;
    PanelDetails gnomePanels;

    public GnomeStronghold(QuestHelper questHelper) {
        super(questHelper);
    }

    @Override
    protected ConditionalStep loadStep() {
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
        this.addSteps();
        return this.gnomeStep;
    }

    @Override
    protected void setupConditions() {
        this.inFirstNetZone = new ZoneRequirement(this.firstNetZone);
        this.inFirstTreeZone = new ZoneRequirement(this.firstTreeZone);
        this.inRopeZone = new ZoneRequirement(this.ropeZone);
        this.inSecondTreeZone = new ZoneRequirement(this.secondTreeZone);
        this.inSecondNetZone = new ZoneRequirement(this.secondNetZone);
        this.inPipeZone = new ZoneRequirement(this.pipeZone);
    }

    @Override
    protected void setupZones() {
        this.firstNetZone = new Zone(new WorldPoint(2471, 3425, 0), new WorldPoint(2476, 3429, 1));
        this.firstTreeZone = new Zone(new WorldPoint(2471, 3422, 1), new WorldPoint(2476, 3424, 2));
        this.ropeZone = new Zone(new WorldPoint(2472, 3418, 2), new WorldPoint(2477, 3421, 2));
        this.secondTreeZone = new Zone(new WorldPoint(2478, 3418, 1), new WorldPoint(2488, 3421, 2));
        this.secondNetZone = new Zone(new WorldPoint(2482, 3418, 0), new WorldPoint(2490, 3426, 0));
        this.pipeZone = new Zone(new WorldPoint(2482, 3427, 0), new WorldPoint(2490, 3436, 0));
    }

    @Override
    protected void setupSteps() {
        this.walkLog = new ObjectStep(this.questHelper, 23145, new WorldPoint(2474, 3435, 0), "Walk-across log south-east of the Spirit tree in Gnome Stronghold.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
        this.climbFirstNet = new ObjectStep(this.questHelper, 23134, new WorldPoint(2473, 3425, 0), "Climb over the west net.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
        this.climbFirstTree = new ObjectStep(this.questHelper, 23559, new WorldPoint(2473, 3422, 1), "Climb up the tree branch.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
        this.walkRope = new ObjectStep(this.questHelper, 23557, new WorldPoint(2478, 3420, 2), "Walk on the balancing rope.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
        this.climbSecondTree = new ObjectStep(this.questHelper, 23560, new WorldPoint(2486, 3419, 2), "Climb down the tree branch.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
        this.climbSecondNet = new ObjectStep(this.questHelper, 23135, new WorldPoint(2485, 3426, 0), "Climb over the east net.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
        this.squeezePipe = new ObjectStep(this.questHelper, 23138, new WorldPoint(2484, 3431, 0), "Squeeze through the pipe.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
    }

    @Override
    protected void addSteps() {
        this.gnomeStep = new ConditionalStep(this.questHelper, this.walkLog, new Requirement[0]);
        this.gnomeStep.addStep(this.inFirstNetZone, this.climbFirstNet);
        this.gnomeStep.addStep(this.inFirstTreeZone, this.climbFirstTree);
        this.gnomeStep.addStep(this.inRopeZone, this.walkRope);
        this.gnomeStep.addStep(this.inSecondTreeZone, this.climbSecondTree);
        this.gnomeStep.addStep(this.inSecondNetZone, this.climbSecondNet);
        this.gnomeStep.addStep(this.inPipeZone, this.squeezePipe);
        this.gnomeSidebar = new DetailedQuestStep(this.questHelper, "Train agility at the Gnome Stronghold Agility Course, south-east of the Spirit tree in Gnome Stronghold.", new Requirement[0]);
        this.gnomeSidebar.addSubSteps(this.walkLog, this.climbFirstNet, this.climbFirstTree, this.walkRope, this.climbSecondTree, this.climbSecondNet, this.squeezePipe);
    }

    @Override
    protected PanelDetails getPanelDetails() {
        this.gnomePanels = new PanelDetails("1 - 10: Gnome Stronghold", Collections.singletonList(this.gnomeSidebar), new Requirement[0]);
        return this.gnomePanels;
    }
}

