/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.skills.agility;

import com.questhelper.helpers.skills.agility.AgilityCourse;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.Arrays;
import java.util.Collections;
import net.runelite.api.coords.WorldPoint;

public class DraynorVillage
extends AgilityCourse {
    QuestStep draynorSidebar;
    QuestStep climbRoughWall;
    QuestStep walkFirstRope;
    QuestStep walkSecondRope;
    QuestStep balanceWall;
    QuestStep jumpUpWall;
    QuestStep jumpGap;
    QuestStep climbDownCrate;
    Zone firstRopeZone;
    Zone secondRopeZone;
    Zone narrowWallZone;
    Zone wallZone;
    Zone gapZone;
    Zone crateZone;
    ZoneRequirement inFirstRopeZone;
    ZoneRequirement inSecondRopeZone;
    ZoneRequirement inNarrowWallZone;
    ZoneRequirement inWallZone;
    ZoneRequirement inGapZone;
    ZoneRequirement inCrateZone;
    ConditionalStep draynorStep;
    PanelDetails draynorPanels;

    public DraynorVillage(QuestHelper questHelper) {
        super(questHelper);
    }

    @Override
    protected ConditionalStep loadStep() {
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
        this.addSteps();
        return this.draynorStep;
    }

    @Override
    protected void setupConditions() {
        this.inFirstRopeZone = new ZoneRequirement(this.firstRopeZone);
        this.inSecondRopeZone = new ZoneRequirement(this.secondRopeZone);
        this.inNarrowWallZone = new ZoneRequirement(this.narrowWallZone);
        this.inWallZone = new ZoneRequirement(this.wallZone);
        this.inGapZone = new ZoneRequirement(this.gapZone);
        this.inCrateZone = new ZoneRequirement(this.crateZone);
    }

    @Override
    protected void setupZones() {
        this.firstRopeZone = new Zone(new WorldPoint(3094, 3277, 3), new WorldPoint(3102, 3281, 3));
        this.secondRopeZone = new Zone(new WorldPoint(3087, 3272, 3), new WorldPoint(3093, 3278, 2));
        this.narrowWallZone = new Zone(new WorldPoint(3089, 3262, 3), new WorldPoint(3094, 3271, 3));
        this.wallZone = new Zone(new WorldPoint(3087, 3256, 3), new WorldPoint(3088, 3262, 3));
        this.gapZone = new Zone(new WorldPoint(3087, 3252, 3), new WorldPoint(3095, 3255, 3));
        this.crateZone = new Zone(new WorldPoint(3095, 3256, 3), new WorldPoint(3101, 3261, 3));
    }

    @Override
    protected void setupSteps() {
        this.climbRoughWall = new ObjectStep(this.questHelper, 11404, new WorldPoint(3103, 3279, 0), "Climb the rough wall just north-west of the gate of the big wheat-field in Draynor Village.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
        this.walkFirstRope = new ObjectStep(this.questHelper, 11405, new WorldPoint(3098, 3277, 3), "Cross the tightrope.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
        this.walkSecondRope = new ObjectStep(this.questHelper, 11406, new WorldPoint(3092, 3276, 3), "Cross the next tightrope.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
        this.balanceWall = new ObjectStep(this.questHelper, 11430, new WorldPoint(3089, 3264, 3), "Balance across thr narrow wall.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
        this.jumpUpWall = new ObjectStep(this.questHelper, 11630, new WorldPoint(3088, 3256, 3), "Jump up the wall.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
        this.jumpGap = new ObjectStep(this.questHelper, 11631, new WorldPoint(3095, 3255, 3), "Climb over the gap.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
        this.climbDownCrate = new ObjectStep(this.questHelper, 11632, new WorldPoint(3102, 3261, 3), "Climb down onto the crate.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
    }

    @Override
    protected void addSteps() {
        this.draynorStep = new ConditionalStep(this.questHelper, this.climbRoughWall, new Requirement[0]);
        this.draynorStep.addStep(this.inFirstRopeZone, this.walkFirstRope);
        this.draynorStep.addStep(this.inSecondRopeZone, this.walkSecondRope);
        this.draynorStep.addStep(this.inNarrowWallZone, this.balanceWall);
        this.draynorStep.addStep(this.inWallZone, this.jumpUpWall);
        this.draynorStep.addStep(this.inGapZone, this.jumpGap);
        this.draynorStep.addStep(this.inCrateZone, this.climbDownCrate);
        this.draynorSidebar = new DetailedQuestStep(this.questHelper, "Train agility at the Draynor Village Rooftop Course, starting just north-west of the gate of the big wheat-field in Draynor Village.", new Requirement[0]);
        this.draynorSidebar.addSubSteps(this.climbRoughWall, this.walkFirstRope, this.walkSecondRope, this.balanceWall, this.jumpUpWall, this.jumpGap, this.climbDownCrate);
    }

    @Override
    protected PanelDetails getPanelDetails() {
        this.draynorPanels = new PanelDetails("10 - 20: Draynor Village", Collections.singletonList(this.draynorSidebar), new Requirement[0]);
        return this.draynorPanels;
    }
}

