/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.skills.agility;

import com.questhelper.helpers.skills.agility.AgilityCourse;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.Arrays;
import java.util.Collections;
import net.runelite.api.coords.WorldPoint;

public class Canifis
extends AgilityCourse {
    QuestStep canifisSidebar;
    QuestStep climbTallTree;
    QuestStep jumpFirstGap;
    QuestStep jumpSecondGap;
    QuestStep jumpThirdGap;
    QuestStep jumpFourthGap;
    QuestStep vaultPoleVault;
    QuestStep jumpFifthGap;
    QuestStep jumpSixthGap;
    Zone firstGapZone;
    Zone secondGapZone;
    Zone thirdGapZone;
    Zone fourthGapZone;
    Zone poleVaultZone;
    Zone fifthGapZone;
    Zone sixthGapzone;
    ZoneRequirement inFirstGapZone;
    ZoneRequirement inSecondGapZone;
    ZoneRequirement inThirdGapZone;
    ZoneRequirement inFourthGapZone;
    ZoneRequirement inPoleVaultZone;
    ZoneRequirement inFifthGapZone;
    ZoneRequirement inSixthGapZone;
    ConditionalStep canifisStep;
    PanelDetails canifisPanels;

    public Canifis(QuestHelper questHelper) {
        super(questHelper);
    }

    @Override
    protected ConditionalStep loadStep() {
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
        this.addSteps();
        return this.canifisStep;
    }

    @Override
    protected void setupConditions() {
        this.inFirstGapZone = new ZoneRequirement(this.firstGapZone);
        this.inSecondGapZone = new ZoneRequirement(this.secondGapZone);
        this.inThirdGapZone = new ZoneRequirement(this.thirdGapZone);
        this.inFourthGapZone = new ZoneRequirement(this.fourthGapZone);
        this.inPoleVaultZone = new ZoneRequirement(this.poleVaultZone);
        this.inFifthGapZone = new ZoneRequirement(this.fifthGapZone);
        this.inSixthGapZone = new ZoneRequirement(this.sixthGapzone);
    }

    @Override
    protected void setupZones() {
        this.firstGapZone = new Zone(new WorldPoint(3504, 3490, 2), new WorldPoint(3512, 3501, 2));
        this.secondGapZone = new Zone(new WorldPoint(3495, 3502, 2), new WorldPoint(3505, 3508, 2));
        this.thirdGapZone = new Zone(new WorldPoint(3482, 3497, 2), new WorldPoint(3494, 3506, 3));
        this.fourthGapZone = new Zone(new WorldPoint(3480, 3500, 3), new WorldPoint(3474, 3489, 2));
        this.poleVaultZone = new Zone(new WorldPoint(3476, 3478, 2), new WorldPoint(3487, 3488, 3));
        this.fifthGapZone = new Zone(new WorldPoint(3486, 3468, 3), new WorldPoint(3506, 3479, 2));
        this.sixthGapzone = new Zone(new WorldPoint(3507, 3473, 2), new WorldPoint(3517, 3484, 2));
    }

    @Override
    protected void setupSteps() {
        this.climbTallTree = new ObjectStep(this.questHelper, 14843, new WorldPoint(3507, 3489, 0), "Climb the tall tree just north of the bank in Canifis.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
        this.jumpFirstGap = new ObjectStep(this.questHelper, 14844, new WorldPoint(3506, 3498, 2), "Jump across the first gap.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
        this.jumpSecondGap = new ObjectStep(this.questHelper, 14845, new WorldPoint(3497, 3504, 2), "Jump across the second gap.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
        this.jumpThirdGap = new ObjectStep(this.questHelper, 14848, new WorldPoint(3486, 3499, 2), "Jump across the third gap.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
        this.jumpFourthGap = new ObjectStep(this.questHelper, 14846, new WorldPoint(3478, 3492, 3), "Jump across the fourth gap.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
        this.vaultPoleVault = new ObjectStep(this.questHelper, 14894, new WorldPoint(3480, 3483, 2), "Vault across the roofs.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
        this.jumpFifthGap = new ObjectStep(this.questHelper, 14847, new WorldPoint(3503, 3476, 3), "Jump across the fifth gap.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
        this.jumpSixthGap = new ObjectStep(this.questHelper, 14897, new WorldPoint(3510, 3483, 2), "Jump across the sixth gap.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
    }

    @Override
    protected void addSteps() {
        this.canifisStep = new ConditionalStep(this.questHelper, this.climbTallTree, new Requirement[0]);
        this.canifisStep.addStep(this.inFirstGapZone, this.jumpFirstGap);
        this.canifisStep.addStep(this.inSecondGapZone, this.jumpSecondGap);
        this.canifisStep.addStep(this.inThirdGapZone, this.jumpThirdGap);
        this.canifisStep.addStep(this.inFourthGapZone, this.jumpFourthGap);
        this.canifisStep.addStep(this.inPoleVaultZone, this.vaultPoleVault);
        this.canifisStep.addStep(this.inFifthGapZone, this.jumpFifthGap);
        this.canifisStep.addStep(this.inSixthGapZone, this.jumpSixthGap);
        this.canifisSidebar = new DetailedQuestStep(this.questHelper, "Train agility at the Canifis Rooftop Course, starting just north of Canifis Bank.", new Requirement[0]);
        this.canifisSidebar.addText("40-60 Agility: Canifis Rooftop Course is the best source of Mark of Grace until 60 Agility.");
        this.canifisSidebar.addText("Stay on Canifis Rooftop Course for fastest spawn of Mark of Grace until 60 Agility, then go directly to Seer's Village");
        this.canifisSidebar.addSubSteps(this.climbTallTree, this.jumpFirstGap, this.jumpSecondGap, this.jumpThirdGap, this.jumpFourthGap, this.vaultPoleVault, this.jumpFifthGap, this.jumpSixthGap, this.canifisStep);
    }

    @Override
    protected PanelDetails getPanelDetails() {
        this.canifisPanels = new PanelDetails("40 - 50/60: Canifis", Collections.singletonList(this.canifisSidebar), new Requirement[0]);
        this.canifisPanels.setLockingStep(this.canifisStep);
        return this.canifisPanels;
    }
}

