/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.skills.agility;

import com.questhelper.helpers.skills.agility.AgilityCourse;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.Arrays;
import java.util.Collections;
import net.runelite.api.coords.WorldPoint;

public class Ardougne
extends AgilityCourse {
    QuestStep ardougneSidebar;
    QuestStep climbWoodenBeam;
    QuestStep jumpFirstGap;
    QuestStep walkOnPlank;
    QuestStep jumpSecondGap;
    QuestStep jumpThirdGap;
    QuestStep balanceRoof;
    QuestStep jumpForthGap;
    Zone firstGapZone;
    Zone plankZone;
    Zone secondGapZone;
    Zone thirdGapZone;
    Zone balanceZone;
    Zone forthGapZone;
    ZoneRequirement inFirstGapZone;
    ZoneRequirement inPlankZone;
    ZoneRequirement inSecondGapZone;
    ZoneRequirement inThirdGapZone;
    ZoneRequirement inBalanceZone;
    ZoneRequirement inForthGapZone;
    ConditionalStep ardougneStep;
    PanelDetails ardougnePanels;

    public Ardougne(QuestHelper questHelper) {
        super(questHelper);
    }

    @Override
    protected ConditionalStep loadStep() {
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
        this.addSteps();
        return this.ardougneStep;
    }

    @Override
    protected void setupConditions() {
        this.inFirstGapZone = new ZoneRequirement(this.firstGapZone);
        this.inPlankZone = new ZoneRequirement(this.plankZone);
        this.inSecondGapZone = new ZoneRequirement(this.secondGapZone);
        this.inThirdGapZone = new ZoneRequirement(this.thirdGapZone);
        this.inBalanceZone = new ZoneRequirement(this.balanceZone);
        this.inForthGapZone = new ZoneRequirement(this.forthGapZone);
    }

    @Override
    protected void setupZones() {
        this.firstGapZone = new Zone(new WorldPoint(2671, 3299, 3), new WorldPoint(2666, 3318, 3));
        this.plankZone = new Zone(new WorldPoint(2665, 3318, 3), new WorldPoint(2657, 3318, 3));
        this.secondGapZone = new Zone(new WorldPoint(2656, 3318, 3), new WorldPoint(2653, 3315, 3));
        this.thirdGapZone = new Zone(new WorldPoint(2653, 3314, 3), new WorldPoint(2653, 3310, 3));
        this.balanceZone = new Zone(new WorldPoint(2651, 3309, 3), new WorldPoint(2655, 3298, 3));
        this.forthGapZone = new Zone(new WorldPoint(2656, 3297, 3), new WorldPoint(2667, 3297, 0));
    }

    @Override
    protected void setupSteps() {
        this.climbWoodenBeam = new ObjectStep(this.questHelper, 15608, new WorldPoint(2729, 3489, 0), "Climb up the wooden beams on the outside of the house south east of the East Ardougne Marketplace.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
        this.jumpFirstGap = new ObjectStep(this.questHelper, 15609, new WorldPoint(2729, 3489, 0), "Jump across the gap.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
        this.walkOnPlank = new ObjectStep(this.questHelper, 26635, new WorldPoint(2729, 3489, 0), "Walk across the plank.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
        this.jumpSecondGap = new ObjectStep(this.questHelper, 15610, new WorldPoint(2729, 3489, 0), "Jump across the gap.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
        this.jumpThirdGap = new ObjectStep(this.questHelper, 15611, new WorldPoint(2729, 3489, 0), "Jump across another gap.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
        this.balanceRoof = new ObjectStep(this.questHelper, 28912, new WorldPoint(2729, 3489, 0), "Balance across the steep roof.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
        this.jumpForthGap = new ObjectStep(this.questHelper, 15612, new WorldPoint(2729, 3489, 0), "Balance across the final steep roof.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
    }

    @Override
    protected void addSteps() {
        this.ardougneStep = new ConditionalStep(this.questHelper, this.climbWoodenBeam, new Requirement[0]);
        this.ardougneStep.addStep(new Conditions(this.inFirstGapZone), this.jumpFirstGap);
        this.ardougneStep.addStep(new Conditions(this.inPlankZone), this.walkOnPlank);
        this.ardougneStep.addStep(new Conditions(this.inSecondGapZone), this.jumpSecondGap);
        this.ardougneStep.addStep(new Conditions(this.inThirdGapZone), this.jumpThirdGap);
        this.ardougneStep.addStep(new Conditions(this.inBalanceZone), this.balanceRoof);
        this.ardougneStep.addStep(new Conditions(this.inForthGapZone), this.jumpForthGap);
        this.ardougneSidebar = new DetailedQuestStep(this.questHelper, "Train agility at the Ardougne Rooftop Course, starting outside of the house south east of the East Ardougne Marketplace.", new Requirement[0]);
        this.ardougneSidebar.addSubSteps(this.climbWoodenBeam, this.jumpFirstGap, this.walkOnPlank, this.jumpSecondGap, this.jumpThirdGap, this.balanceRoof, this.jumpForthGap);
    }

    @Override
    protected PanelDetails getPanelDetails() {
        this.ardougnePanels = new PanelDetails("90 - 99: Ardougne", Collections.singletonList(this.ardougneSidebar), new Requirement[0]);
        return this.ardougnePanels;
    }
}

