/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.skills.agility;

import com.questhelper.helpers.skills.agility.AgilityCourse;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.Arrays;
import java.util.Collections;
import net.runelite.api.coords.WorldPoint;

public class AlKharid
extends AgilityCourse {
    QuestStep alKharidSidebar;
    QuestStep climbRoughWall;
    QuestStep walkFirstRope;
    QuestStep swingCable;
    QuestStep gripZipLine;
    QuestStep swingTree;
    QuestStep climbBeams;
    QuestStep walkSecondRope;
    QuestStep jumpGap;
    Zone firstRopeZone;
    Zone cableZone;
    Zone zipLineZone;
    Zone treeZone;
    Zone beamsZone;
    Zone secondRopeZone;
    Zone gapZone;
    ZoneRequirement inFirstRopeZone;
    ZoneRequirement inCableZone;
    ZoneRequirement inZipLineZone;
    ZoneRequirement inTreeZone;
    ZoneRequirement inBeamsZone;
    ZoneRequirement inSecondRopeZone;
    ZoneRequirement inGapZone;
    ConditionalStep alKharidStep;
    PanelDetails alKharidPanels;

    public AlKharid(QuestHelper questHelper) {
        super(questHelper);
    }

    @Override
    protected ConditionalStep loadStep() {
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
        this.addSteps();
        return this.alKharidStep;
    }

    @Override
    protected void setupConditions() {
        this.inFirstRopeZone = new ZoneRequirement(this.firstRopeZone);
        this.inCableZone = new ZoneRequirement(this.cableZone);
        this.inZipLineZone = new ZoneRequirement(this.zipLineZone);
        this.inTreeZone = new ZoneRequirement(this.treeZone);
        this.inBeamsZone = new ZoneRequirement(this.beamsZone);
        this.inSecondRopeZone = new ZoneRequirement(this.secondRopeZone);
        this.inGapZone = new ZoneRequirement(this.gapZone);
    }

    @Override
    protected void setupZones() {
        this.firstRopeZone = new Zone(new WorldPoint(3272, 3174, 3), new WorldPoint(3278, 3192, 3));
        this.cableZone = new Zone(new WorldPoint(3265, 3161, 3), new WorldPoint(3272, 3173, 3));
        this.zipLineZone = new Zone(new WorldPoint(3283, 3160, 3), new WorldPoint(3312, 3176, 1));
        this.treeZone = new Zone(new WorldPoint(3313, 3160, 1), new WorldPoint(3318, 3172, 2));
        this.beamsZone = new Zone(new WorldPoint(3312, 3173, 2), new WorldPoint(3318, 3179, 3));
        this.secondRopeZone = new Zone(new WorldPoint(3307, 3180, 3), new WorldPoint(3318, 3186, 3));
        this.gapZone = new Zone(new WorldPoint(3297, 3185, 3), new WorldPoint(3306, 3194, 3));
    }

    @Override
    protected void setupSteps() {
        this.climbRoughWall = new ObjectStep(this.questHelper, 11633, new WorldPoint(3273, 3195, 0), "Climb the rough wall just southeast of the Gnome Glider in Al Kharid.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
        this.walkFirstRope = new ObjectStep(this.questHelper, 14398, new WorldPoint(3272, 3181, 3), "Cross the tightrope.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
        this.swingCable = new ObjectStep(this.questHelper, 14402, new WorldPoint(3269, 3166, 3), "Swing across the cable.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
        this.gripZipLine = new ObjectStep(this.questHelper, 14403, new WorldPoint(3303, 3163, 3), "Teeth-grip the zip line.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
        this.swingTree = new ObjectStep(this.questHelper, 14404, new WorldPoint(3318, 3166, 1), "Swing across the tropical tree.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
        this.climbBeams = new ObjectStep(this.questHelper, 11634, new WorldPoint(3316, 3179, 2), "Climb the roof top beams.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
        this.walkSecondRope = new ObjectStep(this.questHelper, 14409, new WorldPoint(3313, 3186, 3), "Cross the tightrope.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
        this.jumpGap = new ObjectStep(this.questHelper, 14399, new WorldPoint(3300, 3193, 3), "Jump down the gap.", Collections.EMPTY_LIST, Arrays.asList(this.recommendedItems));
    }

    @Override
    protected void addSteps() {
        this.alKharidStep = new ConditionalStep(this.questHelper, this.climbRoughWall, new Requirement[0]);
        this.alKharidStep.addStep(this.inFirstRopeZone, this.walkFirstRope);
        this.alKharidStep.addStep(this.inCableZone, this.swingCable);
        this.alKharidStep.addStep(this.inZipLineZone, this.gripZipLine);
        this.alKharidStep.addStep(this.inTreeZone, this.swingTree);
        this.alKharidStep.addStep(this.inBeamsZone, this.climbBeams);
        this.alKharidStep.addStep(this.inSecondRopeZone, this.walkSecondRope);
        this.alKharidStep.addStep(this.inGapZone, this.jumpGap);
        this.alKharidSidebar = new DetailedQuestStep(this.questHelper, "Train agility at the Al Kharid Rooftop Course, starting north of the Tannery.", new Requirement[0]);
        this.alKharidSidebar.addSubSteps(this.climbRoughWall, this.walkFirstRope, this.swingCable, this.gripZipLine, this.swingTree, this.climbBeams, this.walkSecondRope, this.jumpGap, this.alKharidStep);
    }

    @Override
    protected PanelDetails getPanelDetails() {
        this.alKharidPanels = new PanelDetails("20 - 30: Al Kharid", Collections.singletonList(this.alKharidSidebar), new Requirement[0]);
        return this.alKharidPanels;
    }
}

