/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.skills.agility;

import com.questhelper.collections.ItemCollections;
import com.questhelper.helpers.skills.agility.AgilityCourse;
import com.questhelper.helpers.skills.agility.AlKharid;
import com.questhelper.helpers.skills.agility.Ardougne;
import com.questhelper.helpers.skills.agility.Canifis;
import com.questhelper.helpers.skills.agility.DraynorVillage;
import com.questhelper.helpers.skills.agility.Falador;
import com.questhelper.helpers.skills.agility.GnomeStronghold;
import com.questhelper.helpers.skills.agility.Pollnivneach;
import com.questhelper.helpers.skills.agility.Rellekka;
import com.questhelper.helpers.skills.agility.SeersVillage;
import com.questhelper.helpers.skills.agility.Varrock;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.ComplexStateQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.ItemRequirements;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;

@QuestDescriptor(quest=QuestHelperQuest.AGILITY)
public class Agility
extends ComplexStateQuestHelper {
    ItemRequirement bootsOfLightness;
    ItemRequirement gracefulOutfit;
    ItemRequirement gracefulHood;
    ItemRequirement gracefulTop;
    ItemRequirement gracefulLegs;
    ItemRequirement gracefulGloves;
    ItemRequirement gracefulBoots;
    ItemRequirement gracefulCape;
    SkillRequirement ag10;
    SkillRequirement ag20;
    SkillRequirement ag30;
    SkillRequirement ag40;
    SkillRequirement ag50;
    SkillRequirement ag60;
    SkillRequirement ag70;
    SkillRequirement ag80;
    SkillRequirement ag90;
    SkillRequirement ag45;
    AgilityCourse gnomeStronghold;
    AgilityCourse draynorVillage;
    AgilityCourse alKharid;
    AgilityCourse varrock;
    AgilityCourse canifis;
    AgilityCourse falador;
    AgilityCourse seersVillage;
    AgilityCourse pollnivneach;
    AgilityCourse rellekka;
    AgilityCourse ardougne;
    ConditionalStep gnomeStep;
    ConditionalStep draynorStep;
    ConditionalStep alKharidStep;
    ConditionalStep varrockStep;
    ConditionalStep canifisStep;
    ConditionalStep faladorStep;
    ConditionalStep seersStep;
    ConditionalStep pollnivneachStep;
    ConditionalStep rellekkaStep;
    ConditionalStep ardougneStep;

    @Override
    public QuestStep loadStep() {
        this.setupRequirements();
        this.gnomeStep = this.gnomeStronghold.loadStep();
        this.draynorStep = this.draynorVillage.loadStep();
        this.alKharidStep = this.alKharid.loadStep();
        this.varrockStep = this.varrock.loadStep();
        this.canifisStep = this.canifis.loadStep();
        this.faladorStep = this.falador.loadStep();
        this.seersStep = this.seersVillage.loadStep();
        this.pollnivneachStep = this.pollnivneach.loadStep();
        this.rellekkaStep = this.rellekka.loadStep();
        this.ardougneStep = this.ardougne.loadStep();
        ConditionalStep superStep = new ConditionalStep((QuestHelper)this, (QuestStep)this.gnomeStep, new Requirement[0]);
        superStep.addStep(this.ag90, this.ardougneStep);
        superStep.addStep(this.ag80, this.rellekkaStep);
        superStep.addStep(new Conditions(LogicType.NAND, this.ag70, new QuestRequirement(QuestHelperQuest.KANDARIN_HARD, QuestState.FINISHED)), this.pollnivneachStep);
        superStep.addStep(this.ag60, this.seersStep);
        superStep.addStep(this.ag40, this.canifisStep);
        superStep.addStep(this.ag50, this.faladorStep);
        superStep.addStep(this.ag30, this.varrockStep);
        superStep.addStep(this.ag20, this.alKharidStep);
        superStep.addStep(this.ag10, this.draynorStep);
        return superStep;
    }

    @Override
    public void setupRequirements() {
        this.gnomeStronghold = new GnomeStronghold(this);
        this.draynorVillage = new DraynorVillage(this);
        this.alKharid = new AlKharid(this);
        this.varrock = new Varrock(this);
        this.canifis = new Canifis(this);
        this.falador = new Falador(this);
        this.seersVillage = new SeersVillage(this);
        this.pollnivneach = new Pollnivneach(this);
        this.rellekka = new Rellekka(this);
        this.ardougne = new Ardougne(this);
        this.ag10 = new SkillRequirement(Skill.AGILITY, 10);
        this.ag20 = new SkillRequirement(Skill.AGILITY, 20);
        this.ag30 = new SkillRequirement(Skill.AGILITY, 30);
        this.ag40 = new SkillRequirement(Skill.AGILITY, 40);
        this.ag50 = new SkillRequirement(Skill.AGILITY, 50);
        this.ag60 = new SkillRequirement(Skill.AGILITY, 60);
        this.ag70 = new SkillRequirement(Skill.AGILITY, 70);
        this.ag80 = new SkillRequirement(Skill.AGILITY, 80);
        this.ag90 = new SkillRequirement(Skill.AGILITY, 90);
        this.ag45 = new SkillRequirement(Skill.AGILITY, 45);
        this.bootsOfLightness = new ItemRequirement("Boots of Lightness", 88).showConditioned(new Conditions(LogicType.NOR, this.ag45)).isNotConsumed();
        this.gracefulHood = new ItemRequirement("Graceful hood", ItemCollections.GRACEFUL_HOOD, 1, true).showConditioned(new Conditions(this.ag45)).isNotConsumed();
        this.gracefulTop = new ItemRequirement("Graceful top", ItemCollections.GRACEFUL_TOP, 1, true).showConditioned(new Conditions(this.ag45)).isNotConsumed();
        this.gracefulLegs = new ItemRequirement("Graceful legs", ItemCollections.GRACEFUL_LEGS, 1, true).showConditioned(new Conditions(this.ag45)).isNotConsumed();
        this.gracefulCape = new ItemRequirement("Graceful cape", ItemCollections.GRACEFUL_CAPE, 1, true).showConditioned(new Conditions(this.ag45)).isNotConsumed();
        this.gracefulGloves = new ItemRequirement("Graceful gloves", ItemCollections.GRACEFUL_GLOVES, 1, true).showConditioned(new Conditions(this.ag45)).isNotConsumed();
        this.gracefulBoots = new ItemRequirement("Graceful boots", ItemCollections.GRACEFUL_BOOTS, 1, true).showConditioned(new Conditions(this.ag45)).isNotConsumed();
        this.gracefulBoots.addAlternates(88);
        this.gracefulOutfit = new ItemRequirements("Graceful outfit (equipped)", this.gracefulHood, this.gracefulTop, this.gracefulLegs, this.gracefulGloves, this.gracefulBoots, this.gracefulCape).isNotConsumed();
        this.gnomeStronghold.setRecommended(this.bootsOfLightness);
        this.draynorVillage.setRecommended(this.bootsOfLightness);
        this.alKharid.setRecommended(this.bootsOfLightness);
        this.varrock.setRecommended(this.bootsOfLightness);
        this.canifis.setRecommended(this.bootsOfLightness, this.gracefulOutfit);
        this.falador.setRecommended(this.gracefulOutfit);
        this.seersVillage.setRecommended(this.gracefulOutfit);
        this.pollnivneach.setRecommended(this.gracefulOutfit);
        this.rellekka.setRecommended(this.gracefulOutfit);
        this.ardougne.setRecommended(this.gracefulOutfit);
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("Ability to purchase agility Cape for 99k"));
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.bootsOfLightness, this.gracefulHood, this.gracefulTop, this.gracefulLegs, this.gracefulGloves, this.gracefulBoots, this.gracefulCape);
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(this.gnomeStronghold.getPanelDetails());
        allSteps.add(this.draynorVillage.getPanelDetails());
        allSteps.add(this.alKharid.getPanelDetails());
        allSteps.add(this.varrock.getPanelDetails());
        allSteps.add(this.canifis.getPanelDetails());
        allSteps.add(this.falador.getPanelDetails());
        allSteps.add(this.seersVillage.getPanelDetails());
        allSteps.add(this.pollnivneach.getPanelDetails());
        allSteps.add(this.rellekka.getPanelDetails());
        allSteps.add(this.ardougne.getPanelDetails());
        return allSteps;
    }

    @Override
    public List<String> getNotes() {
        return Arrays.asList("40-60 Agility: Stay on Canifis Rooftop Course for best spawn of Mark of Grace until 60 Agility, then go directly to Seer's Village\n\n", "60-80 Agility: If completed Kandarin Hard Diary, configure the Camelot Teleport Spell to Seer's and stay on Seer's rooftop course until 80 Agility. After each completed lap, use the teleport spell to get close to the course starting point");
    }
}

