/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.zogreflesheaters;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemOnTileRequirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.npc.DialogRequirement;
import com.questhelper.requirements.player.FreeInventorySlotRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.ZOGRE_FLESH_EATERS)
public class ZogreFleshEaters
extends BasicQuestHelper {
    ItemRequirement knife;
    ItemRequirement backpack;
    ItemRequirement tankard;
    ItemRequirement tornPage;
    ItemRequirement blackPrism;
    ItemRequirement necroBook;
    ItemRequirement hamBook;
    ItemRequirement portrait;
    ItemRequirement goodPort;
    ItemRequirement strangePotionHighlighted;
    ItemRequirement sanfew;
    ItemRequirement badPort;
    ItemRequirement charcoal;
    ItemRequirement papyrus;
    ItemRequirement signedPort;
    ItemRequirement cupOfTea;
    ItemRequirement strangePotion;
    ItemRequirement grishKey;
    ItemRequirement ogreRelic;
    ItemRequirement combatGear;
    ItemRequirement knifeHighlighted;
    ItemRequirement tankardHighlighted;
    Requirement askedAboutSickies;
    Requirement inSurface;
    Requirement inTombF2;
    Requirement killedZombie;
    Requirement searchedCoffin;
    Requirement usedKnife;
    Requirement openedCoffin;
    Requirement talkedToZavistic;
    Requirement hasBackpackOrTankard;
    Requirement atSith;
    Requirement askedSithToLookAround;
    Requirement hasOrShownNecroBook;
    Requirement hasOrShownHamBook;
    Requirement shownNecroBook;
    Requirement shownHamBook;
    Requirement shownTankard;
    Requirement usedTankardOnBartender;
    Requirement usedPortraitOnBartender;
    Requirement hasOrShownSignedPortrait;
    Requirement shownSignedPortrait;
    Requirement sithTransformed;
    Requirement askedAboutDisease;
    Requirement askedAboutGettingRidOfUndead;
    Requirement askedAboutBow;
    Requirement inTombF0;
    Requirement inTombF2ToBoss;
    Requirement ogreRelicNearby;
    QuestStep talkToGrish;
    QuestStep talkToGuard;
    QuestStep climbBarricade;
    QuestStep goDownStairs;
    QuestStep searchSkeleton;
    QuestStep killZombie;
    QuestStep searchLectern;
    QuestStep searchCoffin;
    QuestStep useKnifeOnCoffin;
    QuestStep openCoffin;
    QuestStep openBackpack;
    QuestStep searchCoffinProperly;
    QuestStep useTankardOnBartender;
    QuestStep talkToZavistic;
    QuestStep goUpToSith;
    QuestStep talkToSith;
    QuestStep searchDrawers;
    QuestStep searchCupboard;
    QuestStep searchWardrobe;
    QuestStep dropPortraitAndSearchDrawers;
    QuestStep usePapyrusOnSith;
    QuestStep usePortraitOnBartender;
    QuestStep bringSignedPortraitToZavistic;
    QuestStep goUpToSithAgain;
    QuestStep usePotionOnTea;
    QuestStep goDownstairsFromSith;
    QuestStep goUpToOgreSith;
    QuestStep talkToSithForAnswers;
    QuestStep askAboutRemovingUndead;
    QuestStep askAboutRemovingDisease;
    QuestStep talkToGrishForKey;
    QuestStep talkToGrishForBow;
    QuestStep climbBarricadeForBoss;
    QuestStep goDownStairsForBoss;
    QuestStep enterDoors;
    QuestStep goDownToBoss;
    QuestStep searchStand;
    QuestStep pickUpOgreArtefact;
    QuestStep returnArtefactToGrish;
    Zone surface;
    Zone tombF2;
    Zone sith;
    Zone tombF0;
    Zone tombF2ToBoss;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToGrish);
        steps.put(2, this.talkToGuard);
        ConditionalStep explore = new ConditionalStep((QuestHelper)this, this.climbBarricade, new Requirement[0]);
        explore.addStep(new Conditions(this.hasOrShownHamBook, this.hasOrShownNecroBook, this.hasOrShownSignedPortrait), this.bringSignedPortraitToZavistic);
        explore.addStep(new Conditions(this.hasOrShownHamBook, this.hasOrShownNecroBook, this.goodPort, this.usedTankardOnBartender), this.usePortraitOnBartender);
        explore.addStep(new Conditions(this.tankard, this.hasOrShownHamBook, this.hasOrShownNecroBook, this.goodPort), this.useTankardOnBartender);
        explore.addStep(new Conditions(this.tankard, this.atSith, this.hasOrShownHamBook, this.hasOrShownNecroBook, this.papyrus), this.usePapyrusOnSith);
        explore.addStep(new Conditions(this.tankard, this.atSith, this.hasOrShownHamBook, this.hasOrShownNecroBook, this.badPort), this.dropPortraitAndSearchDrawers);
        explore.addStep(new Conditions(this.tankard, this.atSith, this.hasOrShownHamBook, this.hasOrShownNecroBook), this.searchDrawers);
        explore.addStep(new Conditions(this.tankard, this.atSith, this.hasOrShownHamBook), this.searchCupboard);
        explore.addStep(new Conditions(this.tankard, this.atSith, this.askedSithToLookAround), this.searchWardrobe);
        explore.addStep(new Conditions(this.tankard, this.talkedToZavistic, this.atSith), this.talkToSith);
        explore.addStep(new Conditions(this.tankard, this.talkedToZavistic), this.goUpToSith);
        explore.addStep(new Conditions(this.tankard, this.tornPage, this.blackPrism), this.talkToZavistic);
        explore.addStep(new Conditions(this.inTombF2, this.tankard, this.tornPage, this.openedCoffin), this.searchCoffinProperly);
        explore.addStep(new Conditions(this.inTombF2, this.tankard, this.tornPage, this.usedKnife), this.openCoffin);
        explore.addStep(new Conditions(this.inTombF2, this.tankard, this.tornPage, this.searchedCoffin), this.useKnifeOnCoffin);
        explore.addStep(new Conditions(this.inTombF2, this.tankard, this.tornPage), this.searchCoffin);
        explore.addStep(new Conditions(this.inTombF2, this.tankard), this.searchLectern);
        explore.addStep(new Conditions(this.inTombF2, this.backpack), this.openBackpack);
        explore.addStep(this.inTombF2, this.searchSkeleton);
        explore.addStep(this.inSurface, this.goDownStairs);
        steps.put(3, explore);
        ConditionalStep poisonSith = new ConditionalStep((QuestHelper)this, this.goUpToSithAgain, new Requirement[0]);
        poisonSith.addStep(this.atSith, this.usePotionOnTea);
        steps.put(4, poisonSith);
        steps.put(5, poisonSith);
        ConditionalStep askSithQuestions = new ConditionalStep((QuestHelper)this, this.goDownstairsFromSith, new Requirement[0]);
        askSithQuestions.addStep(new Conditions(this.sithTransformed, this.atSith), this.talkToSithForAnswers);
        askSithQuestions.addStep(this.sithTransformed, this.goUpToOgreSith);
        steps.put(6, askSithQuestions);
        ConditionalStep askAboutDiseaseAndOgres = new ConditionalStep((QuestHelper)this, this.goUpToOgreSith, new Requirement[0]);
        askAboutDiseaseAndOgres.addStep(new Conditions(this.askedAboutGettingRidOfUndead, this.askedAboutDisease), this.talkToGrishForKey);
        askAboutDiseaseAndOgres.addStep(new Conditions(this.askedAboutGettingRidOfUndead, this.atSith), this.askAboutRemovingDisease);
        askAboutDiseaseAndOgres.addStep(this.atSith, this.askAboutRemovingUndead);
        steps.put(8, askAboutDiseaseAndOgres);
        ConditionalStep goKillBash = new ConditionalStep((QuestHelper)this, this.talkToGrishForBow, new Requirement[0]);
        goKillBash.addStep(this.inTombF0, this.searchStand);
        goKillBash.addStep(new Conditions(this.inTombF2ToBoss, this.askedAboutBow), this.goDownToBoss);
        goKillBash.addStep(new Conditions(this.inTombF2, this.askedAboutBow), this.enterDoors);
        goKillBash.addStep(new Conditions(this.inSurface, this.askedAboutBow), this.goDownStairsForBoss);
        goKillBash.addStep(this.askedAboutBow, this.climbBarricadeForBoss);
        steps.put(10, goKillBash);
        ConditionalStep returnRelic = new ConditionalStep((QuestHelper)this, this.returnArtefactToGrish, new Requirement[0]);
        returnRelic.addStep(this.ogreRelicNearby, this.pickUpOgreArtefact);
        steps.put(12, returnRelic);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.backpack = new ItemRequirement("Ruined backpack", 4810);
        this.backpack.setHighlightInInventory(true);
        this.tankard = new ItemRequirement("Dragon inn tankard", 4811);
        this.tankardHighlighted = new ItemRequirement("Dragon inn tankard", 4811);
        this.tankardHighlighted.setHighlightInInventory(true);
        this.tornPage = new ItemRequirement("Torn page", 4809);
        this.blackPrism = new ItemRequirement("Black prism", 4808);
        this.knife = new ItemRequirement("Knife", 946).isNotConsumed();
        this.knifeHighlighted = new ItemRequirement("Knife", 946);
        this.knifeHighlighted.setHighlightInInventory(true);
        this.necroBook = new ItemRequirement("Necromancy book", 4837);
        this.hamBook = new ItemRequirement("Book of 'h.a.m'", 4829);
        this.portrait = new ItemRequirement("Book of portraiture", 4817);
        this.goodPort = new ItemRequirement("Sithik portrait", 4814);
        this.goodPort.setHighlightInInventory(true);
        this.badPort = new ItemRequirement("Sithik portrait", 4815);
        this.signedPort = new ItemRequirement("Signed portrait", 4816);
        this.papyrus = new ItemRequirement("Papyrus", 970);
        this.papyrus.setHighlightInInventory(true);
        this.sanfew = new ItemRequirement("Sanfew serum or Relicym's balm", 10931);
        this.sanfew.addAlternates(10929, 10927, 10925, 4848, 4846, 4844, 4842);
        this.sanfew.setTooltip("To help prevent disease and restore stats.");
        this.charcoal = new ItemRequirement("Charcoal", 973);
        this.cupOfTea = new ItemRequirement("Cup of tea", 4838);
        this.strangePotion = new ItemRequirement("Strange potion", 4836);
        this.strangePotion.setTooltip("You can get another from Zavistic Rarve");
        this.strangePotionHighlighted = new ItemRequirement("Strange potion", 4836);
        this.strangePotionHighlighted.setTooltip("You can get another from Zavistic Rarve");
        this.strangePotionHighlighted.setHighlightInInventory(true);
        this.grishKey = new ItemRequirement("Ogre gate key", 4839);
        this.ogreRelic = new ItemRequirement("Ogre artefact", 4818);
        this.ogreRelic.setTooltip("You can get another by searching the stand where you fought Slash Bash");
        this.combatGear = new ItemRequirement("Either brutal arrows or Crumble Undead for fighting Slash Bash", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
    }

    public void loadZones() {
        this.surface = new Zone(new WorldPoint(2456, 3037, 0), new WorldPoint(2491, 3058, 0));
        this.tombF2 = new Zone(new WorldPoint(2434, 9400, 2), new WorldPoint(2494, 9474, 2));
        this.tombF0 = new Zone(new WorldPoint(2432, 9409, 0), new WorldPoint(2492, 9465, 0));
        this.sith = new Zone(new WorldPoint(2590, 3102, 1), new WorldPoint(2598, 3108, 1));
        this.tombF2ToBoss = new Zone(new WorldPoint(2433, 9408, 2), new WorldPoint(2449, 9432, 2));
    }

    public void setupConditions() {
        this.askedAboutSickies = new DialogRequirement("Da sickies is when yous creature goes like orange");
        this.inSurface = new ZoneRequirement(this.surface);
        this.inTombF2 = new ZoneRequirement(this.tombF2);
        this.inTombF0 = new ZoneRequirement(this.tombF0);
        this.inTombF2ToBoss = new ZoneRequirement(this.tombF2ToBoss);
        this.killedZombie = new VarbitRequirement(503, 2);
        this.hasBackpackOrTankard = new Conditions(LogicType.OR, this.backpack, this.tankard);
        this.searchedCoffin = new VarbitRequirement(488, 1);
        this.usedKnife = new VarbitRequirement(488, 2);
        this.openedCoffin = new VarbitRequirement(488, 3);
        this.talkedToZavistic = new VarbitRequirement(488, 4, Operation.GREATER_EQUAL);
        this.askedSithToLookAround = new VarbitRequirement(488, 5);
        this.atSith = new ZoneRequirement(this.sith);
        this.usedTankardOnBartender = new VarbitRequirement(489, 1);
        this.usedPortraitOnBartender = new VarbitRequirement(490, 1);
        this.shownNecroBook = new VarbitRequirement(491, 1);
        this.shownHamBook = new VarbitRequirement(492, 1);
        this.shownTankard = new VarbitRequirement(493, 1);
        this.shownSignedPortrait = new VarbitRequirement(494, 1);
        this.hasOrShownHamBook = new Conditions(LogicType.OR, this.shownHamBook, this.hamBook);
        this.hasOrShownNecroBook = new Conditions(LogicType.OR, this.shownNecroBook, this.necroBook);
        this.hasOrShownSignedPortrait = new Conditions(LogicType.OR, this.shownSignedPortrait, this.signedPort);
        this.sithTransformed = new VarbitRequirement(495, 1);
        this.askedAboutDisease = new VarbitRequirement(498, 1);
        this.askedAboutGettingRidOfUndead = new VarbitRequirement(499, 1);
        this.askedAboutBow = new VarbitRequirement(500, 1);
        this.ogreRelicNearby = new ItemOnTileRequirement(this.ogreRelic);
    }

    public void setupSteps() {
        this.talkToGrish = new NpcStep((QuestHelper)this, 860, new WorldPoint(2447, 3049, 0), "Talk to Grish south of Castle Wars.", new Requirement[0]);
        this.talkToGrish.addDialogStepWithExclusion("What do you mean sickies?", "Can I help in any way?");
        this.talkToGrish.addDialogSteps("Can I help in any way?", "Ok, I'll check things out then and report back.", "Yes, I'm really sure!", "Yes, I want to help you out and find out about the zogres.");
        this.talkToGuard = new NpcStep((QuestHelper)this, 864, new WorldPoint(2454, 3048, 0), "Talk to the guard east of Grish.", new Requirement[0]);
        this.climbBarricade = new ObjectStep((QuestHelper)this, 6878, new WorldPoint(2456, 3048, 0), "Climb over the barricade east of Grish.", new Requirement[0]);
        this.goDownStairs = new ObjectStep((QuestHelper)this, 6841, new WorldPoint(2486, 3043, 0), "Climb down the stairs to the east.", new Requirement[0]);
        this.searchSkeleton = new ObjectStep((QuestHelper)this, 6893, new WorldPoint(2442, 9459, 2), "Search the skeleton in the north west corner of this area.", new Requirement[0]);
        this.killZombie = new NpcStep((QuestHelper)this, 880, new WorldPoint(2442, 9459, 2), "Kill the zombie which appeared, and pick up the ruined backpack that appeared.", new Requirement[0]);
        this.openBackpack = new DetailedQuestStep((QuestHelper)this, "Open the backpack for a knife and a dragon inn tankard.", this.backpack);
        this.searchLectern = new ObjectStep((QuestHelper)this, 6846, new WorldPoint(2443, 9459, 2), "Search the broken lecturn in the north west corner of the tombs.", new Requirement[0]);
        this.searchCoffin = new ObjectStep((QuestHelper)this, 6843, new WorldPoint(2439, 9459, 2), "Search the ogre coffin next to the skeleton.", new Requirement[0]);
        this.useKnifeOnCoffin = new ObjectStep((QuestHelper)this, 6843, new WorldPoint(2439, 9459, 2), "Use a knife on the ogre coffin next to the skeleton.", this.knifeHighlighted);
        this.useKnifeOnCoffin.addIcon(946);
        this.openCoffin = new ObjectStep((QuestHelper)this, 6843, new WorldPoint(2439, 9459, 2), "Search the coffin next to the skeleton again. It may take a few attempts to open.", new Requirement[0]);
        this.searchCoffinProperly = new ObjectStep((QuestHelper)this, 6843, new WorldPoint(2439, 9459, 2), "Search the coffin for a black prism.", new Requirement[0]);
        this.talkToZavistic = new NpcStep((QuestHelper)this, 881, new WorldPoint(2598, 3087, 0), "Talk to Zavistic Rarve at the Yanille Wizards' Guild. If you don't have 66 Magic, ring the bell outside the guild.", new Requirement[0]);
        this.talkToZavistic.addDialogStep("I'm here about the sicks...err Zogres");
        this.goUpToSith = new ObjectStep((QuestHelper)this, 16683, new WorldPoint(2597, 3107, 0), "Go upstairs to Sithik upstairs in north Yanille.", new Requirement[0]);
        this.talkToSith = new ObjectStep((QuestHelper)this, 6887, new WorldPoint(2591, 3104, 1), "Talk to Sithik Ints in the bed to the west.", new Requirement[0]);
        this.talkToSith.addDialogStep("Do you mind if I look around?");
        this.goUpToSith.addSubSteps(this.talkToSith);
        this.searchWardrobe = new ObjectStep((QuestHelper)this, 6877, new WorldPoint(2590, 3103, 1), "Search Sithik's wardrobe.", new Requirement[0]);
        this.searchCupboard = new ObjectStep((QuestHelper)this, 6876, new WorldPoint(2593, 3105, 1), "Search Sithik's cupboard.", new Requirement[0]);
        this.goUpToOgreSith = new ObjectStep((QuestHelper)this, 16683, new WorldPoint(2597, 3107, 0), "Go talk to Sithik upstairs in north Yanille.", new Requirement[0]);
        this.searchDrawers = new ObjectStep((QuestHelper)this, 6875, new WorldPoint(2593, 3103, 1), "Search Sithik's drawers for more papyrus.", new Requirement[0]);
        this.dropPortraitAndSearchDrawers = new ObjectStep((QuestHelper)this, 6875, new WorldPoint(2593, 3103, 1), "The portrait drawn is wrong. Drop it and try drawing him again.", new Requirement[0]);
        this.searchDrawers.addSubSteps(this.dropPortraitAndSearchDrawers);
        this.usePapyrusOnSith = new ObjectStep((QuestHelper)this, 6887, new WorldPoint(2591, 3104, 1), "Use the papyrus on Sithik Ints.", this.papyrus, this.charcoal);
        this.usePapyrusOnSith.addIcon(970);
        this.useTankardOnBartender = new NpcStep((QuestHelper)this, 1320, new WorldPoint(2555, 3080, 0), "Travel to the Dragon Inn in Yanille and use the dragon inn tankard on the bartender.", this.tankardHighlighted);
        this.useTankardOnBartender.addIcon(4811);
        this.usePortraitOnBartender = new NpcStep((QuestHelper)this, 1320, new WorldPoint(2555, 3080, 0), "Use the portrait on the bartender.", this.goodPort);
        this.usePortraitOnBartender.addIcon(4814);
        this.bringSignedPortraitToZavistic = new NpcStep((QuestHelper)this, 881, new WorldPoint(2598, 3087, 0), "Bring the books and signed portrait to Zavistic Rarve at the Yanille Wizards' Guild. If you don't have 66 Magic, ring the bell outside the guild.", this.signedPort, this.hamBook, this.necroBook);
        this.bringSignedPortraitToZavistic.addDialogStep("I'm here about the sicks...err Zogres");
        this.bringSignedPortraitToZavistic.addDialogStep("I have some items that I'd like you to look at.");
        this.goUpToSithAgain = new ObjectStep((QuestHelper)this, 16683, new WorldPoint(2597, 3107, 0), "Go upstairs to Sithik upstairs in north Yanille.", this.strangePotion);
        this.usePotionOnTea = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2593, 3103, 1), "Use the strange potion on the cup of tea next to Sithik.", this.strangePotionHighlighted);
        this.usePotionOnTea.addIcon(4836);
        this.goDownstairsFromSith = new ObjectStep((QuestHelper)this, 16681, new WorldPoint(2597, 3107, 1), "Leave Sithik Int's house.", new Requirement[0]);
        this.goUpToOgreSith = new ObjectStep((QuestHelper)this, 16683, new WorldPoint(2597, 3107, 0), "Go upstairs to Sithik again.", new Requirement[0]);
        this.talkToSithForAnswers = new ObjectStep((QuestHelper)this, 6887, new WorldPoint(2591, 3104, 1), "Talk to the transformed Sithik Ints for answers.", new Requirement[0]);
        this.talkToSithForAnswers.addDialogSteps("How do I remove the effects of the spell from the area?");
        this.askAboutRemovingUndead = new ObjectStep((QuestHelper)this, 6887, new WorldPoint(2591, 3104, 1), "Talk to the transformed Sithik Ints for answers.", new Requirement[0]);
        this.askAboutRemovingUndead.addDialogStep("How do I get rid of the undead ogres?");
        this.askAboutRemovingDisease = new ObjectStep((QuestHelper)this, 6887, new WorldPoint(2591, 3104, 1), "Talk to the transformed Sithik Ints for answers.", new Requirement[0]);
        this.askAboutRemovingDisease.addDialogStep("How do I get rid of the disease?");
        this.talkToSithForAnswers.addSubSteps(this.askAboutRemovingDisease, this.askAboutRemovingUndead);
        this.talkToGrishForKey = new NpcStep((QuestHelper)this, 860, new WorldPoint(2447, 3049, 0), "Talk to Grish south of Castle Wars. Be prepared to fight Slash Bash. You'll need to use either brutal arrows or the Crumble Undead spell.", new Requirement[0]);
        this.talkToGrishForKey.addDialogSteps("I found who's responsible for the Zogres being here.");
        this.talkToGrishForBow = new NpcStep((QuestHelper)this, 860, new WorldPoint(2447, 3049, 0), "Talk to Grish south of Castle Wars again to learn how to make composite ogre bows.", new Requirement[0]);
        this.talkToGrishForBow.addDialogStep("There must be an easier way to kill these zogres!");
        this.climbBarricadeForBoss = new ObjectStep((QuestHelper)this, 6878, new WorldPoint(2456, 3048, 0), "Climb over the barricade east of Grish, prepared to fight Slash Bash.", this.grishKey);
        this.climbBarricadeForBoss.addDialogStep("Sorry, I have to go.");
        this.goDownStairsForBoss = new ObjectStep((QuestHelper)this, 6841, new WorldPoint(2486, 3043, 0), "Climb down the stairs to the east.", new Requirement[0]);
        this.enterDoors = new ObjectStep((QuestHelper)this, 6872, new WorldPoint(2442, 9433, 2), "Enter the doors at the west side of the area.", this.grishKey);
        this.goDownToBoss = new ObjectStep((QuestHelper)this, 6841, new WorldPoint(2444, 9418, 2), "Go down the stairs to the boss.", new Requirement[0]);
        this.searchStand = new ObjectStep((QuestHelper)this, 6897, new WorldPoint(2483, 9445, 0), "Search the stand in the north east corner, and kill Slash Bash when he spawns.", new Requirement[0]);
        this.pickUpOgreArtefact = new ItemStep((QuestHelper)this, "Pick up the ogre artefact.", this.ogreRelic);
        this.returnArtefactToGrish = new NpcStep((QuestHelper)this, 860, new WorldPoint(2447, 3049, 0), "Return to Grish with the ogre artefact.", this.ogreRelic);
        this.returnArtefactToGrish.addDialogStep("Yeah, I have them here!");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Collections.singletonList(this.combatGear);
    }

    @Override
    public List<String> getCombatRequirements() {
        ArrayList<String> reqs = new ArrayList<String>();
        reqs.add("Slash Bash (level 111)");
        reqs.add("Zombie (level 39)");
        return reqs;
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new QuestRequirement(QuestHelperQuest.BIG_CHOMPY_BIRD_HUNTING, QuestState.FINISHED));
        req.add(new QuestRequirement(QuestHelperQuest.JUNGLE_POTION, QuestState.FINISHED));
        req.add(new SkillRequirement(Skill.SMITHING, 4));
        req.add(new SkillRequirement(Skill.HERBLORE, 8));
        req.add(new SkillRequirement(Skill.RANGED, 30));
        return req;
    }

    @Override
    public List<Requirement> getGeneralRecommended() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new FreeInventorySlotRequirement(8));
        req.add(this.sanfew);
        return req;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.FLETCHING, 2000), new ExperienceReward(Skill.RANGED, 2000), new ExperienceReward(Skill.HERBLORE, 2000));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Ourg Bones", 4834, 3), new ItemReward("Zogre Bones", 7848, 2));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Ability to make Relicym's balm"), new UnlockReward("Ability to fletch Comp Ogre Bows and Brutal Arrows"), new UnlockReward("Ability to wear Inoculation Bracelets"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Arrays.asList(this.talkToGrish, this.talkToGuard, this.goDownStairs, this.searchSkeleton, this.killZombie, this.openBackpack, this.searchLectern, this.searchCoffin, this.useKnifeOnCoffin, this.openCoffin, this.searchCoffinProperly), new Requirement[0]));
        allSteps.add(new PanelDetails("Investigating", Arrays.asList(this.talkToZavistic, this.goUpToSith, this.searchWardrobe, this.searchCupboard, this.searchDrawers, this.usePapyrusOnSith, this.useTankardOnBartender, this.usePortraitOnBartender, this.bringSignedPortraitToZavistic), new Requirement[0]));
        allSteps.add(new PanelDetails("Discover the truth", Arrays.asList(this.goUpToSithAgain, this.usePotionOnTea, this.goDownstairsFromSith, this.goUpToOgreSith, this.talkToSithForAnswers), new Requirement[0]));
        allSteps.add(new PanelDetails("Help the ogres", Arrays.asList(this.talkToGrishForKey, this.talkToGrishForBow, this.climbBarricadeForBoss, this.goDownStairsForBoss, this.enterDoors, this.goDownToBoss, this.searchStand, this.pickUpOgreArtefact, this.returnArtefactToGrish), this.combatGear));
        return allSteps;
    }
}

