/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.xmarksthespot;

import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.steps.DigStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.X_MARKS_THE_SPOT)
public class XMarksTheSpot
extends BasicQuestHelper {
    ItemRequirement spade;
    ItemRequirement glory;
    QuestStep speakVeosLumbridge;
    QuestStep digOutsideBob;
    QuestStep digCastle;
    QuestStep digDraynor;
    QuestStep digMartin;
    QuestStep speakVeosSarim;
    QuestStep speakVeosSarimWithoutCasket;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupRequirements();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.speakVeosLumbridge);
        steps.put(1, (QuestStep)steps.get(0));
        steps.put(2, this.digOutsideBob);
        steps.put(3, this.digCastle);
        steps.put(4, this.digDraynor);
        steps.put(5, this.digMartin);
        steps.put(6, this.speakVeosSarim);
        steps.put(7, this.speakVeosSarimWithoutCasket);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.spade = new ItemRequirement("Spade", 952).isNotConsumed();
        this.glory = new ItemRequirement("Amulet of Glory for faster teleport to Draynor Village.", ItemCollections.AMULET_OF_GLORIES).isNotConsumed();
    }

    private void setupSteps() {
        this.speakVeosLumbridge = new NpcStep((QuestHelper)this, 8484, new WorldPoint(3228, 3242, 0), "Talk to Veos in The Sheared Ram pub in Lumbridge to start the quest.", new Requirement[0]);
        this.speakVeosLumbridge.addDialogStep("I'm looking for a quest.");
        this.speakVeosLumbridge.addDialogStep("Sounds good, what should I do?");
        this.speakVeosLumbridge.addDialogSteps("Can I help?", "Yes.");
        this.digOutsideBob = new DigStep((QuestHelper)this, new WorldPoint(3230, 3209, 0), "Dig north of Bob's Brilliant Axes, on the west side of the plant against the wall of his house.", new Requirement[0]);
        this.digOutsideBob.addDialogStep("Okay, thanks Veos.");
        this.digCastle = new DigStep((QuestHelper)this, new WorldPoint(3203, 3212, 0), "Dig behind Lumbridge Castle, just outside the kitchen door.", new Requirement[0]);
        this.digDraynor = new DigStep((QuestHelper)this, new WorldPoint(3109, 3264, 0), "Dig north-west of the Draynor Village jail, just by the wheat farm.", new Requirement[0]);
        this.digMartin = new DigStep((QuestHelper)this, new WorldPoint(3078, 3259, 0), "Dig in the pig pen just west where Martin the Master Gardener is.", new ItemRequirement("Treasure scroll", 23070));
        ItemRequirement ancientCasket = new ItemRequirement("Ancient casket", 23071);
        ancientCasket.setTooltip("If you've lost this you can get another by digging in the pig pen in Draynor Village.");
        this.speakVeosSarim = new NpcStep((QuestHelper)this, 8484, new WorldPoint(3054, 3245, 0), "Talk to Veos directly south of the Rusty Anchor Inn in Port Sarim to finish the quest.", ancientCasket);
        ((NpcStep)this.speakVeosSarim).addAlternateNpcs(8630);
        this.speakVeosSarimWithoutCasket = new NpcStep((QuestHelper)this, 8484, new WorldPoint(3054, 3245, 0), "Talk to Veos directly south of the Rusty Anchor Inn in Port Sarim to finish the quest.", new Requirement[0]);
        ((NpcStep)this.speakVeosSarimWithoutCasket).addAlternateNpcs(8630);
        this.speakVeosSarim.addSubSteps(this.speakVeosSarimWithoutCasket);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.spade);
        return reqs;
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.glory);
        return reqs;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("300 Exp. Lamp (Any Skill)", 4447, 1), new ItemReward("Coins", 995, 200), new ItemReward("A Beginner Clue Scroll", 23182, 1));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Speak to Veos", Collections.singletonList(this.speakVeosLumbridge), this.spade));
        allSteps.add(new PanelDetails("Solve the clue scroll", Arrays.asList(this.digOutsideBob, this.digCastle, this.digDraynor, this.digMartin), new Requirement[0]));
        allSteps.add(new PanelDetails("Bring the casket to Veos", Collections.singletonList(this.speakVeosSarim), new Requirement[0]));
        return allSteps;
    }
}

