/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.witchspotion;

import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.WITCHS_POTION)
public class WitchsPotion
extends BasicQuestHelper {
    ItemRequirement ratTail;
    ItemRequirement onion;
    ItemRequirement burntMeat;
    ItemRequirement eyeOfNewt;
    QuestStep talkToWitch;
    QuestStep killRat;
    QuestStep returnToWitch;
    QuestStep drinkPotion;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupRequirements();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToWitch);
        ConditionalStep getIngredients = new ConditionalStep((QuestHelper)this, this.killRat, new Requirement[0]);
        getIngredients.addStep(this.ratTail.alsoCheckBank(this.questBank), this.returnToWitch);
        steps.put(1, getIngredients);
        steps.put(2, this.drinkPotion);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.ratTail = new ItemRequirement("Rat's tail", 300);
        this.onion = new ItemRequirement("Onion", 1957);
        this.onion.setTooltip("You can pick one from the field north of Rimmington");
        this.burntMeat = new ItemRequirement("Burnt meat", 2146);
        this.burntMeat.setTooltip("You can use cooked meat on a fire/range to burn it");
        this.eyeOfNewt = new ItemRequirement("Eye of newt", 221);
        this.eyeOfNewt.setTooltip("You can buy one from Betty in Port Sarim for 3gp");
    }

    public void setupSteps() {
        this.talkToWitch = new NpcStep((QuestHelper)this, 4619, new WorldPoint(2968, 3205, 0), "Talk to Hetty in Rimmington.", this.onion, this.eyeOfNewt, this.burntMeat);
        this.talkToWitch.addDialogStep("I am in search of a quest.");
        this.talkToWitch.addDialogStep("Yes, help me become one with my darker side.");
        this.killRat = new NpcStep((QuestHelper)this, 2855, new WorldPoint(2956, 3203, 0), "Kill a rat in the house to the west for a rat tail.", this.ratTail);
        this.returnToWitch = new NpcStep((QuestHelper)this, 4619, new WorldPoint(2968, 3205, 0), "Bring the ingredients to Hetty.", this.onion, this.eyeOfNewt, this.burntMeat, this.ratTail);
        this.drinkPotion = new ObjectStep((QuestHelper)this, 2024, new WorldPoint(2967, 3205, 0), "Drink from the cauldron to finish off the quest.", new Requirement[0]);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.onion);
        reqs.add(this.burntMeat);
        reqs.add(this.eyeOfNewt);
        return reqs;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.MAGIC, 325));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Collections.singletonList(this.talkToWitch), new Requirement[0]));
        allSteps.add(new PanelDetails("Make the potion", Arrays.asList(this.killRat, this.returnToWitch), new Requirement[0]));
        return allSteps;
    }
}

