/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.witchshouse;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.conditional.NpcCondition;
import com.questhelper.requirements.conditional.ObjectCondition;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.FreeInventorySlotRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.WITCHS_HOUSE)
public class WitchsHouse
extends BasicQuestHelper {
    ItemRequirement cheese;
    ItemRequirement leatherGloves;
    ItemRequirement houseKey;
    ItemRequirement magnet;
    ItemRequirement shedKey;
    ItemRequirement ball;
    ItemRequirement armourAndWeapon;
    Requirement inHouse;
    Requirement inUpstairsHouse;
    Requirement inDownstairsHouseWest;
    Requirement inDownstairsHouseEast;
    Requirement inDownstairsHouse;
    Requirement inHouseOrGarden;
    Requirement ratHasMagnet;
    Requirement inShed;
    Requirement experimentNearby;
    QuestStep talkToBoy;
    QuestStep getKey;
    QuestStep goDownstairs;
    QuestStep enterGate;
    QuestStep goDownstairsFromTop;
    QuestStep openCupboardAndLoot;
    QuestStep openCupboardAndLoot2;
    QuestStep goBackUpstairs;
    QuestStep useCheeseOnHole;
    QuestStep enterHouse;
    QuestStep searchFountain;
    QuestStep enterShed;
    QuestStep enterShedWithoutKey;
    QuestStep killWitchsExperiment;
    QuestStep returnToBoy;
    QuestStep pickupBall;
    QuestStep grabBall;
    Zone house;
    Zone upstairsHouse;
    Zone downstairsHouseEast;
    Zone downstairsHouseWest;
    Zone garden1;
    Zone garden2;
    Zone garden3;
    Zone shed;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToBoy);
        ConditionalStep getTheMagnet = new ConditionalStep((QuestHelper)this, this.getKey, new Requirement[0]);
        getTheMagnet.addStep(new Conditions(this.inHouse, this.magnet), this.useCheeseOnHole);
        getTheMagnet.addStep(new Conditions(this.inDownstairsHouse, this.magnet), this.goBackUpstairs);
        getTheMagnet.addStep(new Conditions(this.inDownstairsHouseWest, new ObjectCondition(2869)), this.openCupboardAndLoot2);
        getTheMagnet.addStep(this.inDownstairsHouseWest, this.openCupboardAndLoot);
        getTheMagnet.addStep(this.inDownstairsHouseEast, this.enterGate);
        getTheMagnet.addStep(this.inHouse, this.goDownstairs);
        getTheMagnet.addStep(this.inUpstairsHouse, this.goDownstairsFromTop);
        getTheMagnet.addStep(this.houseKey.alsoCheckBank(this.questBank), this.enterHouse);
        steps.put(1, getTheMagnet);
        steps.put(2, getTheMagnet);
        steps.put(4, getTheMagnet);
        ConditionalStep killExperiment = new ConditionalStep((QuestHelper)this, this.getKey, new Requirement[0]);
        killExperiment.addStep(new Conditions(this.inShed, this.experimentNearby), this.killWitchsExperiment);
        killExperiment.addStep(this.inShed, this.grabBall);
        killExperiment.addStep(new Conditions(this.ratHasMagnet, this.inHouseOrGarden, this.shedKey), this.enterShed);
        killExperiment.addStep(new Conditions(this.ratHasMagnet, this.inHouseOrGarden), this.searchFountain);
        killExperiment.addStep(new Conditions(this.ratHasMagnet, this.inDownstairsHouse), this.goBackUpstairs);
        killExperiment.addStep(new Conditions(this.inHouse, this.magnet), this.useCheeseOnHole);
        killExperiment.addStep(new Conditions(this.inDownstairsHouse, this.magnet), this.goBackUpstairs);
        killExperiment.addStep(new Conditions(this.inDownstairsHouseWest, new ObjectCondition(2869)), this.openCupboardAndLoot2);
        killExperiment.addStep(this.inDownstairsHouseWest, this.openCupboardAndLoot);
        killExperiment.addStep(this.inDownstairsHouseEast, this.enterGate);
        killExperiment.addStep(this.inHouse, this.goDownstairs);
        killExperiment.addStep(this.inUpstairsHouse, this.goDownstairsFromTop);
        killExperiment.addStep(this.houseKey.alsoCheckBank(this.questBank), this.enterHouse);
        steps.put(3, killExperiment);
        steps.put(5, killExperiment);
        ConditionalStep returnBall = new ConditionalStep((QuestHelper)this, this.getKey, new Requirement[0]);
        returnBall.addStep(this.ball.alsoCheckBank(this.questBank), this.returnToBoy);
        returnBall.addStep(this.inShed, this.pickupBall);
        returnBall.addStep(this.inHouseOrGarden, this.enterShedWithoutKey);
        returnBall.addStep(this.houseKey.alsoCheckBank(this.questBank), this.enterHouse);
        returnBall.addStep(this.inDownstairsHouse, this.goBackUpstairs);
        returnBall.addStep(this.inUpstairsHouse, this.goDownstairsFromTop);
        steps.put(6, returnBall);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.cheese = new ItemRequirement("Cheese (multiple if you mess up)", 1985);
        this.leatherGloves = new ItemRequirement("Leather gloves", 1059, 1, true).isNotConsumed();
        this.leatherGloves.canBeObtainedDuringQuest();
        this.houseKey = new ItemRequirement("Door key", 2409);
        this.magnet = new ItemRequirement("Magnet", 2410);
        this.shedKey = new ItemRequirement("Key", 2411);
        this.shedKey.setHighlightInInventory(true);
        this.ball = new ItemRequirement("Ball", 2407);
        this.armourAndWeapon = new ItemRequirement("Combat gear and food for monsters up to level 53", -1, -1).isNotConsumed();
        this.armourAndWeapon.setDisplayItemId(BankSlotIcons.getCombatGear());
    }

    public void loadZones() {
        this.house = new Zone(new WorldPoint(2901, 3466, 0), new WorldPoint(2907, 3476, 0));
        this.upstairsHouse = new Zone(new WorldPoint(2900, 3466, 1), new WorldPoint(2907, 3476, 1));
        this.downstairsHouseWest = new Zone(new WorldPoint(2897, 9870, 0), new WorldPoint(2902, 9878, 0));
        this.downstairsHouseEast = new Zone(new WorldPoint(2903, 9870, 0), new WorldPoint(2909, 9878, 0));
        this.garden1 = new Zone(new WorldPoint(2900, 3459, 0), new WorldPoint(2933, 3465, 0));
        this.garden2 = new Zone(new WorldPoint(2908, 3466, 0), new WorldPoint(2933, 3467, 0));
        this.garden3 = new Zone(new WorldPoint(2908, 3467, 0), new WorldPoint(2912, 3475, 0));
        this.shed = new Zone(new WorldPoint(2934, 3459, 0), new WorldPoint(2937, 3467, 0));
    }

    public void setupConditions() {
        this.inHouse = new ZoneRequirement(this.house);
        this.inUpstairsHouse = new ZoneRequirement(this.upstairsHouse);
        this.inDownstairsHouseWest = new ZoneRequirement(this.downstairsHouseWest);
        this.inDownstairsHouseEast = new ZoneRequirement(this.downstairsHouseEast);
        this.inDownstairsHouse = new ZoneRequirement(this.downstairsHouseEast, this.downstairsHouseWest);
        this.inHouseOrGarden = new ZoneRequirement(this.house, this.garden1, this.garden2, this.garden3);
        this.ratHasMagnet = new VarplayerRequirement(226, 3);
        this.inShed = new ZoneRequirement(this.shed);
        this.experimentNearby = new Conditions(LogicType.OR, new NpcCondition(3996), new NpcCondition(3997), new NpcCondition(3998), new NpcCondition(3999));
    }

    public void setupSteps() {
        this.talkToBoy = new NpcStep((QuestHelper)this, 3994, new WorldPoint(2928, 3456, 0), "Talk to the Boy in Taverley to start.", new Requirement[0]);
        this.talkToBoy.addDialogSteps("What's the matter?", "Ok, I'll see what I can do.");
        this.getKey = new ObjectStep((QuestHelper)this, 2867, new WorldPoint(2900, 3474, 0), "Look under the potted plant just outside the witch's house.", new Requirement[0]);
        this.enterHouse = new ObjectStep((QuestHelper)this, 2861, new WorldPoint(2900, 3473, 0), "Enter the witch's house.", this.houseKey);
        this.goDownstairs = new ObjectStep((QuestHelper)this, 24718, new WorldPoint(2907, 3476, 0), "Go down the ladder to the basement.", new Requirement[0]);
        this.enterGate = new ObjectStep((QuestHelper)this, 2866, new WorldPoint(2902, 9873, 0), "Go through the gate whilst wearing gloves. Search the nearby boxes if you don't have gloves.", this.leatherGloves);
        this.openCupboardAndLoot = new ObjectStep((QuestHelper)this, 2868, new WorldPoint(2898, 9874, 0), "Open the cupboard and get a magnet from it", new Requirement[0]);
        this.openCupboardAndLoot2 = new ObjectStep((QuestHelper)this, 2869, new WorldPoint(2898, 9874, 0), "Open the cupboard and get a magnet from it", new Requirement[0]);
        this.openCupboardAndLoot.addSubSteps(this.openCupboardAndLoot2);
        this.goBackUpstairs = new ObjectStep((QuestHelper)this, 24717, new WorldPoint(2907, 9876, 0), "Climb back up the ladder.", new Requirement[0]);
        this.goDownstairsFromTop = new ObjectStep((QuestHelper)this, 24673, new WorldPoint(2907, 3471, 1), "Go back downstairs.", new Requirement[0]);
        this.useCheeseOnHole = new ObjectStep((QuestHelper)this, 2870, new WorldPoint(2903, 3466, 0), "Use the cheese on the mouse hole in the south room, then use the magnet on the mouse which emerges.", this.cheese, this.magnet);
        this.searchFountain = new ObjectStep((QuestHelper)this, 2864, new WorldPoint(2910, 3471, 0), "Enter the garden and sneak around the perimeter to search the fountain. If the witch spots you you'll be teleported outside.", new Requirement[0]);
        this.enterShed = new ObjectStep((QuestHelper)this, 2863, new WorldPoint(2934, 3463, 0), "Use the shed key on the shed door to enter.", this.shedKey);
        this.enterShedWithoutKey = new ObjectStep((QuestHelper)this, 2863, new WorldPoint(2934, 3463, 0), "Enter the shed.", new Requirement[0]);
        this.enterShed.addSubSteps(this.enterShedWithoutKey);
        this.enterShed.addIcon(2411);
        this.grabBall = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2936, 3470, 0), "If an experiment hasn't spawned, attempt to pick up the ball once.", this.ball);
        this.killWitchsExperiment = new NpcStep((QuestHelper)this, 3996, new WorldPoint(2935, 3463, 0), "Kill all four forms of the Witch's experiment (levels 19, 30, 42, and 53). You can safe spot the last two forms from the crate in the south of the room.", new Requirement[0]);
        ((NpcStep)this.killWitchsExperiment).addAlternateNpcs(3997, 3998, 3999);
        this.killWitchsExperiment.addSubSteps(this.grabBall);
        this.pickupBall = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2936, 3470, 0), "Pick up the ball.", this.ball);
        this.returnToBoy = new NpcStep((QuestHelper)this, 3994, new WorldPoint(2928, 3456, 0), "Return the ball to the boy. Make sure the witch doesn't spot you or you'll have to get the ball back again..", new Requirement[0]);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.cheese);
        reqs.add(this.leatherGloves);
        return reqs;
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.armourAndWeapon);
        return reqs;
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("Witch's experiment (level 19, 30, 42 and 53)");
    }

    @Override
    public List<Requirement> getGeneralRecommended() {
        return Collections.singletonList(new FreeInventorySlotRequirement(2));
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(4);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.HITPOINTS, 6325));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Start the quest", Collections.singletonList(this.talkToBoy), this.cheese, this.leatherGloves, this.armourAndWeapon));
        allSteps.add(new PanelDetails("Accessing the garden", Arrays.asList(this.getKey, this.enterHouse, this.goDownstairs, this.enterGate, this.openCupboardAndLoot, this.goBackUpstairs, this.useCheeseOnHole), new Requirement[0]));
        allSteps.add(new PanelDetails("Defeat the witch's experiment", Arrays.asList(this.searchFountain, this.enterShed, this.killWitchsExperiment, this.pickupBall, this.returnToBoy), new Requirement[0]));
        return allSteps;
    }
}

