/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.whatliesbelow;

import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.WHAT_LIES_BELOW)
public class WhatLiesBelow
extends BasicQuestHelper {
    ItemRequirement intel5;
    ItemRequirement bowl;
    ItemRequirement chaosRunes15;
    ItemRequirement emptyFolder;
    ItemRequirement usedFolder;
    ItemRequirement fullFolder;
    ItemRequirement chaosTalismanOrAbyss;
    ItemRequirement folder;
    ItemRequirement wand;
    ItemRequirement wandHighlight;
    ItemRequirement beaconRing;
    ItemRequirement letterToSurok;
    ItemRequirement infusedWand;
    ItemRequirement suroksLetter;
    ItemRequirement chronicle;
    Requirement inChaosAltar;
    Requirement inBattle;
    QuestStep talkToRat;
    QuestStep bringFolderToRat;
    QuestStep talkToRatAfterFolder;
    QuestStep talkToSurok;
    QuestStep talkToSurokNoLetter;
    QuestStep enterChaosAltar;
    QuestStep useWandOnAltar;
    QuestStep bringWandToSurok;
    QuestStep talkToRatAfterSurok;
    QuestStep talkToZaff;
    QuestStep talkToSurokToFight;
    QuestStep fightRoald;
    QuestStep talkToRatToFinish;
    QuestStep talkToRatAfterSurokNoLetter;
    NpcStep killOutlaws;
    Zone chaosAltar;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToRat);
        steps.put(5, this.talkToRat);
        ConditionalStep getIntel = new ConditionalStep((QuestHelper)this, (QuestStep)this.killOutlaws, new Requirement[0]);
        getIntel.addStep(this.fullFolder, this.bringFolderToRat);
        steps.put(10, getIntel);
        steps.put(20, this.talkToRatAfterFolder);
        steps.put(25, this.talkToSurok);
        steps.put(30, this.talkToSurokNoLetter);
        steps.put(40, this.talkToSurokNoLetter);
        steps.put(45, this.talkToSurokNoLetter);
        steps.put(46, this.talkToSurokNoLetter);
        ConditionalStep chargeWand = new ConditionalStep((QuestHelper)this, this.enterChaosAltar, new Requirement[0]);
        chargeWand.addStep(this.inChaosAltar, this.useWandOnAltar);
        steps.put(50, chargeWand);
        steps.put(55, this.bringWandToSurok);
        steps.put(60, this.talkToRatAfterSurok);
        steps.put(61, this.talkToRatAfterSurok);
        steps.put(70, this.talkToRatAfterSurokNoLetter);
        steps.put(71, this.talkToRatAfterSurokNoLetter);
        steps.put(72, this.talkToRatAfterSurokNoLetter);
        steps.put(80, this.talkToZaff);
        steps.put(81, this.talkToZaff);
        ConditionalStep defeatSurok = new ConditionalStep((QuestHelper)this, this.talkToSurokToFight, new Requirement[0]);
        defeatSurok.addStep(this.inBattle, this.fightRoald);
        steps.put(110, defeatSurok);
        steps.put(115, defeatSurok);
        steps.put(120, defeatSurok);
        steps.put(140, this.talkToRatToFinish);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.intel5 = new ItemRequirement("Rat's paper", 11008, 5);
        this.intel5.setHighlightInInventory(true);
        this.emptyFolder = new ItemRequirement("An empty folder", 11003);
        this.usedFolder = new ItemRequirement("Used folder", 11006);
        this.fullFolder = new ItemRequirement("Full folder", 11007);
        this.folder = new ItemRequirement("Folder", 11003);
        this.folder.addAlternates(11006, 11007);
        this.folder.setTooltip("You can get another empty folder from Rat");
        this.folder.setHighlightInInventory(true);
        this.bowl = new ItemRequirement("Bowl", 1923);
        this.chaosRunes15 = new ItemRequirement("Chaos runes", 562, 15);
        this.wand = new ItemRequirement("Wand", 11012);
        this.wandHighlight = new ItemRequirement("Wand", 11012);
        this.wandHighlight.setHighlightInInventory(true);
        this.infusedWand = new ItemRequirement("Infused wand", 11013);
        this.infusedWand.setTooltip("You can make another by getting a wand from Surok, and using it on the chaos altar with 15 chaos runes");
        this.chaosTalismanOrAbyss = new ItemRequirement("Chaos Talisman or access to the Abyss", 1452).isNotConsumed();
        this.beaconRing = new ItemRequirement("Beacon ring", 11014);
        this.beaconRing.setTooltip("You can get another from Zaff");
        this.letterToSurok = new ItemRequirement("Letter to Surok", 11009);
        this.letterToSurok.setTooltip("You can get another from Rat");
        this.suroksLetter = new ItemRequirement("Surok's letter", 11010);
        this.suroksLetter.setTooltip("You can get another from Surok");
        this.chronicle = new ItemRequirement("Chronicle for teleports to south of Varrock", 13660);
    }

    public void loadZones() {
        this.chaosAltar = new Zone(new WorldPoint(2245, 4823, 0), new WorldPoint(2299, 4860, 2));
    }

    public void setupConditions() {
        this.inChaosAltar = new ZoneRequirement(this.chaosAltar);
        this.inBattle = new VarbitRequirement(6719, 2);
    }

    public void setupSteps() {
        this.talkToRat = new NpcStep((QuestHelper)this, 4158, new WorldPoint(3266, 3333, 0), "Talk to Rat Burgiss south of Varrock.", new Requirement[0]);
        this.talkToRat.addDialogStep("Shall I get them back for you?");
        this.talkToRat.addDialogStep("Of course! Tell me what you need me to do.");
        this.killOutlaws = new NpcStep((QuestHelper)this, 4167, new WorldPoint(3118, 3472, 0), "Go to the Bandits west of the Grand Exchange and kill 5 for intel. Put the intel into the folder Rat gave you.", true, this.folder, this.intel5);
        this.killOutlaws.addAlternateNpcs(4168, 4169, 4170, 4171, 4172, 4173, 4174, 4175, 4176);
        this.bringFolderToRat = new NpcStep((QuestHelper)this, 4158, new WorldPoint(3266, 3333, 0), "Return to Rat Burgiss south of Varrock.", this.fullFolder);
        this.talkToRatAfterFolder = new NpcStep((QuestHelper)this, 4158, new WorldPoint(3266, 3333, 0), "Return to Rat Burgiss south of Varrock.", new Requirement[0]);
        this.bringFolderToRat.addSubSteps(this.talkToRatAfterFolder);
        this.talkToSurok = new NpcStep((QuestHelper)this, 4159, new WorldPoint(3211, 3493, 0), "Talk to Surok Magis in the Varrock Library.", this.letterToSurok);
        this.talkToSurokNoLetter = new NpcStep((QuestHelper)this, 4159, new WorldPoint(3211, 3493, 0), "Talk to Surok Magis in the Varrock Library.", new Requirement[0]);
        this.talkToSurokNoLetter.addDialogSteps("Go on, then!", "Go on then!");
        this.talkToSurok.addSubSteps(this.talkToSurokNoLetter);
        this.enterChaosAltar = new DetailedQuestStep((QuestHelper)this, "Travel to the chaos altar with the wand and 15 chaos runes. You can either enter with a chaos talisman, or use the abyss.", this.wand, this.chaosRunes15, this.chaosTalismanOrAbyss);
        this.useWandOnAltar = new ObjectStep((QuestHelper)this, 34769, new WorldPoint(2271, 4842, 0), "Use the wand on the chaos altar.", this.wandHighlight, this.chaosRunes15);
        this.useWandOnAltar.addIcon(11012);
        this.bringWandToSurok = new NpcStep((QuestHelper)this, 4159, new WorldPoint(3211, 3493, 0), "Return to Surok Magis in the Varrock Library with the wand and a bowl.", this.infusedWand, this.bowl);
        this.bringWandToSurok.addDialogStep("I have the things you wanted!");
        this.talkToRatAfterSurok = new NpcStep((QuestHelper)this, 4158, new WorldPoint(3266, 3333, 0), "Return to Rat Burgiss south of Varrock.", this.suroksLetter);
        this.talkToRatAfterSurok.addDialogStep("Yes! I have a letter for you.");
        this.talkToRatAfterSurokNoLetter = new NpcStep((QuestHelper)this, 4158, new WorldPoint(3266, 3333, 0), "Return to Rat Burgiss south of Varrock.", new Requirement[0]);
        this.talkToZaff = new NpcStep((QuestHelper)this, 2880, new WorldPoint(3202, 3434, 0), "Talk to Zaff in the Varrock staff shop.", new Requirement[0]);
        this.talkToZaff.addDialogStep("Rat Burgiss sent me!");
        this.talkToSurokToFight = new NpcStep((QuestHelper)this, 4160, new WorldPoint(3211, 3493, 0), "Prepare to fight King Roald (level 47), then go talk to Surok Magis in the Varrock Library.", this.beaconRing);
        this.talkToSurokToFight.addDialogStep("Bring it on!");
        this.fightRoald = new NpcStep((QuestHelper)this, 4163, new WorldPoint(3211, 3493, 0), "Fight King Roald. When he's at 1hp, right-click operate the beacon ring.", this.beaconRing);
        this.talkToRatToFinish = new NpcStep((QuestHelper)this, 4158, new WorldPoint(3266, 3333, 0), "Return to Rat Burgiss south of Varrock to finish the quest.", new Requirement[0]);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.bowl);
        reqs.add(this.chaosRunes15);
        reqs.add(this.chaosTalismanOrAbyss);
        return reqs;
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.chronicle);
        return reqs;
    }

    @Override
    public List<String> getCombatRequirements() {
        ArrayList<String> reqs = new ArrayList<String>();
        reqs.add("5 outlaws (level 32)");
        reqs.add("King Roald (level 47)");
        return reqs;
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new QuestRequirement(QuestHelperQuest.RUNE_MYSTERIES, QuestState.FINISHED));
        req.add(new SkillRequirement(Skill.MINING, 42, false));
        req.add(new SkillRequirement(Skill.RUNECRAFT, 35));
        return req;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.RUNECRAFT, 8000), new ExperienceReward(Skill.DEFENCE, 2000));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("The Beacon Ring", 11014, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("Access to a shortcut to the Chaos Altar"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Collections.singletonList(this.talkToRat), new Requirement[0]));
        allSteps.add(new PanelDetails("Help Rat", Arrays.asList(this.killOutlaws, this.bringFolderToRat), new Requirement[0]));
        allSteps.add(new PanelDetails("Help Surok", Arrays.asList(this.talkToSurok, this.enterChaosAltar, this.useWandOnAltar, this.bringWandToSurok), this.chaosRunes15, this.chaosTalismanOrAbyss, this.bowl));
        allSteps.add(new PanelDetails("Defeat Surok", Arrays.asList(this.talkToRatAfterSurok, this.talkToZaff, this.talkToSurokToFight, this.fightRoald, this.talkToRatToFinish), new Requirement[0]));
        return allSteps;
    }
}

