/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.waterfallquest;

import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.WATERFALL_QUEST)
public class WaterfallQuest
extends BasicQuestHelper {
    ItemRequirement rope;
    ItemRequirement highlightRope;
    ItemRequirement glarialsPebble;
    ItemRequirement glarialsUrn;
    ItemRequirement glarialsAmulet;
    ItemRequirement unequippedAmulet;
    ItemRequirement book;
    ItemRequirement key;
    ItemRequirement baxKey;
    ItemRequirement airRunes;
    ItemRequirement waterRunes;
    ItemRequirement earthRunes;
    ItemRequirement airRune;
    ItemRequirement waterRune;
    ItemRequirement earthRune;
    ItemRequirement gamesNecklace;
    ItemRequirement food;
    Requirement inGnomeBasement;
    Requirement inGlarialTomb;
    Requirement inFalls;
    Requirement onHudonIsland;
    Requirement onDeadTreeIsland;
    Requirement onLedge;
    Requirement inUpstairsInHouse;
    Requirement inGolrieRoom;
    Requirement gotPebble;
    Requirement inEndRoom;
    Requirement inEnd2;
    QuestStep talkToAlmera;
    QuestStep boardRaft;
    QuestStep talkToHudon;
    QuestStep useRopeOnRock;
    QuestStep useRopeOnTree;
    QuestStep getInBarrel;
    QuestStep goUpstairsHadley;
    QuestStep searchBookcase;
    QuestStep readBook;
    QuestStep enterGnomeDungeon;
    QuestStep searchGnomeCrate;
    QuestStep enterGnomeDoor;
    QuestStep talkToGolrie;
    QuestStep usePebble;
    QuestStep searchGlarialCoffin;
    QuestStep getFinalItems;
    QuestStep boardRaftFinal;
    QuestStep useRopeOnRockFinal;
    QuestStep useRopeOnTreeFinal;
    QuestStep enterFalls;
    QuestStep searchFallsCrate;
    QuestStep useKeyOnFallsDoor;
    QuestStep useRunes;
    QuestStep useAmuletOnStatue;
    QuestStep useUrnOnChalice;
    ObjectStep searchGlarialChest;
    ConditionalStep goGetPebble;
    ConditionalStep getGlarialStuff;
    Zone gnomeBasement;
    Zone glarialTomb;
    Zone falls;
    Zone endRoom;
    Zone end2;
    Zone hudonIsland;
    Zone deadTreeIsland;
    Zone ledge;
    Zone upstairsInHouse;
    Zone golrieRoom;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToAlmera);
        ConditionalStep goTalkToHudon = new ConditionalStep((QuestHelper)this, this.boardRaft, new Requirement[0]);
        goTalkToHudon.addStep(this.onHudonIsland, this.talkToHudon);
        steps.put(1, goTalkToHudon);
        ConditionalStep goReadBook = new ConditionalStep((QuestHelper)this, this.goUpstairsHadley, new Requirement[0]);
        goReadBook.addStep(this.book, this.readBook);
        goReadBook.addStep(this.inUpstairsInHouse, this.searchBookcase);
        goReadBook.addStep(this.onLedge, this.getInBarrel);
        goReadBook.addStep(this.onDeadTreeIsland, this.useRopeOnTree);
        goReadBook.addStep(this.onHudonIsland, this.useRopeOnRock);
        steps.put(2, goReadBook);
        this.goGetPebble = new ConditionalStep((QuestHelper)this, this.enterGnomeDungeon, new Requirement[0]);
        this.goGetPebble.addStep(this.inGolrieRoom, this.talkToGolrie);
        this.goGetPebble.addStep(new Conditions(this.inGnomeBasement, this.key), this.enterGnomeDoor);
        this.goGetPebble.addStep(this.inGnomeBasement, this.searchGnomeCrate);
        this.goGetPebble.setLockingCondition(this.gotPebble);
        this.getGlarialStuff = new ConditionalStep((QuestHelper)this, this.usePebble, new Requirement[0]);
        this.getGlarialStuff.addStep(new Conditions(this.glarialsAmulet.alsoCheckBank(this.questBank), this.inGlarialTomb), this.searchGlarialCoffin);
        this.getGlarialStuff.addStep(this.inGlarialTomb, this.searchGlarialChest);
        this.getGlarialStuff.setLockingCondition(new Conditions(new Conditions(this.glarialsAmulet.alsoCheckBank(this.questBank), this.glarialsUrn.alsoCheckBank(this.questBank))));
        ConditionalStep puttingToRest = new ConditionalStep((QuestHelper)this, this.getFinalItems, new Requirement[0]);
        puttingToRest.addStep(this.inEnd2, this.useUrnOnChalice);
        puttingToRest.addStep(this.inEndRoom, this.useRunes);
        puttingToRest.addStep(new Conditions(this.inFalls, this.baxKey), this.useKeyOnFallsDoor);
        puttingToRest.addStep(this.inFalls, this.searchFallsCrate);
        puttingToRest.addStep(this.onLedge, this.enterFalls);
        puttingToRest.addStep(this.onDeadTreeIsland, this.useRopeOnTreeFinal);
        puttingToRest.addStep(this.onHudonIsland, this.useRopeOnRockFinal);
        puttingToRest.addStep(new Conditions(this.glarialsUrn, this.glarialsAmulet, this.airRunes, this.earthRunes, this.waterRunes, this.rope), this.boardRaftFinal);
        ConditionalStep finishingSteps = new ConditionalStep((QuestHelper)this, (QuestStep)this.goGetPebble, new Requirement[0]);
        finishingSteps.addStep(new Conditions(this.glarialsUrn.alsoCheckBank(this.questBank), this.glarialsAmulet.alsoCheckBank(this.questBank)), puttingToRest);
        finishingSteps.addStep(this.gotPebble, this.getGlarialStuff);
        steps.put(3, finishingSteps);
        steps.put(4, finishingSteps);
        steps.put(5, puttingToRest);
        steps.put(6, puttingToRest);
        steps.put(7, puttingToRest);
        steps.put(8, puttingToRest);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.highlightRope = new ItemRequirement("Rope", 954).isNotConsumed();
        this.highlightRope.setHighlightInInventory(true);
        this.rope = new ItemRequirement("Rope", 954).isNotConsumed();
        this.book = new ItemRequirement("Book on baxtorian", 292);
        this.book.setHighlightInInventory(true);
        this.glarialsPebble = new ItemRequirement("Glarial's pebble", 294);
        this.glarialsPebble.setHighlightInInventory(true);
        this.glarialsPebble.setTooltip("You can get another from Golrie under the Tree Gnome Village");
        this.glarialsUrn = new ItemRequirement("Glarial's urn", 296);
        this.glarialsUrn.setTooltip("You can get another from the chest in Glarial's tomb");
        this.glarialsAmulet = new ItemRequirement("Glarial's amulet", 295, 1, true);
        this.glarialsAmulet.setTooltip("You can get another from the chest in Glarial's tomb");
        this.unequippedAmulet = new ItemRequirement("Glarial's amulet", 295);
        this.key = new ItemRequirement("Key", 293);
        this.baxKey = new ItemRequirement("Key", 298);
        this.airRunes = new ItemRequirement("Air runes", 556, 6);
        this.airRune = new ItemRequirement("Air rune", 556);
        this.earthRunes = new ItemRequirement("Earth runes", 557, 6);
        this.earthRune = new ItemRequirement("Earth rune", 557);
        this.waterRunes = new ItemRequirement("Water runes", 555, 6);
        this.waterRune = new ItemRequirement("Water rune", 555);
        this.gamesNecklace = new ItemRequirement("Games necklace", ItemCollections.GAMES_NECKLACES);
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
    }

    public void loadZones() {
        this.gnomeBasement = new Zone(new WorldPoint(2497, 9552, 0), new WorldPoint(2559, 9593, 0));
        this.glarialTomb = new Zone(new WorldPoint(2524, 9801, 0), new WorldPoint(2557, 9849, 0));
        this.golrieRoom = new Zone(new WorldPoint(2502, 9576, 0), new WorldPoint(2523, 9593, 0));
        this.hudonIsland = new Zone(new WorldPoint(2510, 3476, 0), new WorldPoint(2515, 3482, 0));
        this.deadTreeIsland = new Zone(new WorldPoint(2512, 3465, 0), new WorldPoint(2513, 3475, 0));
        this.ledge = new Zone(new WorldPoint(2510, 3462, 0), new WorldPoint(2513, 3464, 0));
        this.upstairsInHouse = new Zone(new WorldPoint(2516, 3424, 1), new WorldPoint(2520, 3431, 1));
        this.falls = new Zone(new WorldPoint(2556, 9861, 0), new WorldPoint(2595, 9920, 0));
        this.endRoom = new Zone(new WorldPoint(2561, 9902, 0), new WorldPoint(2570, 9917, 0));
        this.end2 = new Zone(new WorldPoint(2599, 9890, 0), new WorldPoint(2608, 9916, 0));
    }

    public void setupConditions() {
        this.onDeadTreeIsland = new ZoneRequirement(this.deadTreeIsland);
        this.onHudonIsland = new ZoneRequirement(this.hudonIsland);
        this.onLedge = new ZoneRequirement(this.ledge);
        this.inUpstairsInHouse = new ZoneRequirement(this.upstairsInHouse);
        this.inGnomeBasement = new ZoneRequirement(this.gnomeBasement);
        this.inGolrieRoom = new ZoneRequirement(this.golrieRoom);
        this.inGlarialTomb = new ZoneRequirement(this.glarialTomb);
        this.inFalls = new ZoneRequirement(this.falls);
        this.inEndRoom = new ZoneRequirement(this.endRoom);
        this.inEnd2 = new ZoneRequirement(this.end2);
        this.gotPebble = new VarbitRequirement(9110, 1);
    }

    public void setupSteps() {
        this.talkToAlmera = new NpcStep((QuestHelper)this, 4181, new WorldPoint(2521, 3495, 0), "Talk to Almera on top of Baxtorian Falls.", new Requirement[0]);
        this.talkToAlmera.addDialogStep("How can I help?");
        this.boardRaft = new ObjectStep((QuestHelper)this, 1987, new WorldPoint(2509, 3494, 0), "Board the log raft west of Almera.", new Requirement[0]);
        this.talkToHudon = new NpcStep((QuestHelper)this, 4182, new WorldPoint(2511, 3484, 0), "Talk to Hudon.", new Requirement[0]);
        this.useRopeOnRock = new ObjectStep((QuestHelper)this, 1996, new WorldPoint(2512, 3468, 0), "Use a rope on the rock to the south.", this.highlightRope);
        this.useRopeOnRock.addIcon(954);
        this.useRopeOnTree = new ObjectStep((QuestHelper)this, 2020, new WorldPoint(2512, 3465, 0), "Use a rope on the dead tree.", this.highlightRope);
        this.useRopeOnTree.addIcon(954);
        this.getInBarrel = new ObjectStep((QuestHelper)this, 2022, new WorldPoint(2512, 3463, 0), "Get in the barrel.", new Requirement[0]);
        this.goUpstairsHadley = new ObjectStep((QuestHelper)this, 16671, new WorldPoint(2518, 3430, 0), "Go up the stairs in the house south of Almera's house.", new Requirement[0]);
        this.searchBookcase = new ObjectStep((QuestHelper)this, 1989, new WorldPoint(2520, 3427, 1), "Search the south east bookcase.", new Requirement[0]);
        this.readBook = new DetailedQuestStep((QuestHelper)this, "Read the book.", this.book);
        this.enterGnomeDungeon = new ObjectStep((QuestHelper)this, 5250, new WorldPoint(2533, 3155, 0), "Go to the centre of the Tree Gnome Village and go down the ladder at the entrance.", new Requirement[0]);
        ((ObjectStep)this.enterGnomeDungeon).setLinePoints(Arrays.asList(new WorldPoint(2505, 3190, 0), new WorldPoint(2512, 3190, 0), new WorldPoint(2512, 3188, 0), new WorldPoint(2532, 3188, 0), new WorldPoint(2532, 3182, 0), new WorldPoint(2523, 3181, 0), new WorldPoint(2523, 3185, 0), new WorldPoint(2521, 3185, 0), new WorldPoint(2520, 3179, 0), new WorldPoint(2514, 3179, 0), new WorldPoint(2514, 3177, 0), new WorldPoint(2527, 3177, 0), new WorldPoint(2527, 3179, 0), new WorldPoint(2529, 3179, 0), new WorldPoint(2529, 3177, 0), new WorldPoint(2531, 3177, 0), new WorldPoint(2531, 3179, 0), new WorldPoint(2533, 3179, 0), new WorldPoint(2533, 3177, 0), new WorldPoint(2544, 3177, 0), new WorldPoint(2544, 3174, 0), new WorldPoint(2549, 3174, 0), new WorldPoint(2549, 3165, 0), new WorldPoint(2545, 3165, 0), new WorldPoint(2545, 3159, 0), new WorldPoint(2550, 3159, 0), new WorldPoint(2550, 3156, 0), new WorldPoint(2548, 3156, 0), new WorldPoint(2548, 3145, 0), new WorldPoint(2538, 3145, 0), new WorldPoint(2538, 3150, 0), new WorldPoint(2541, 3150, 0), new WorldPoint(2541, 3148, 0), new WorldPoint(2544, 3148, 0), new WorldPoint(2544, 3150, 0), new WorldPoint(2545, 3150, 0), new WorldPoint(2545, 3155, 0), new WorldPoint(2533, 3155, 0)));
        this.searchGnomeCrate = new ObjectStep((QuestHelper)this, 1990, new WorldPoint(2548, 9565, 0), "Search the off-coloured crate in the east room.", new Requirement[0]);
        this.enterGnomeDoor = new ObjectStep((QuestHelper)this, 1991, new WorldPoint(2515, 9575, 0), "Go through the gate in the west room.", this.key);
        this.talkToGolrie = new NpcStep((QuestHelper)this, 4183, new WorldPoint(2514, 9580, 0), "Talk to Golrie.", new Requirement[0]);
        this.usePebble = new ObjectStep((QuestHelper)this, 1992, new WorldPoint(2559, 3445, 0), "Bank everything besides the pebble and some food. After, go use Glarial's pebble to Glarial's Tombstone east of Baxtorian Falls.", this.glarialsPebble);
        this.usePebble.addIcon(294);
        this.searchGlarialChest = new ObjectStep((QuestHelper)this, 1994, new WorldPoint(2530, 9844, 0), "Search the chest in the western room.", new Requirement[0]);
        this.searchGlarialChest.addAlternateObjects(1995);
        this.searchGlarialCoffin = new ObjectStep((QuestHelper)this, 1993, new WorldPoint(2542, 9812, 0), "Search Glarial's Tomb in the south room.", new Requirement[0]);
        this.getFinalItems = new DetailedQuestStep((QuestHelper)this, "Leave Glarial's Tomb and get 6 air, water and earth runes, a rope, glarial's amulet, glarial's urn, a rope, and some food.", this.airRunes, this.earthRunes, this.waterRunes, this.glarialsAmulet, this.glarialsUrn, this.rope);
        this.boardRaftFinal = new ObjectStep((QuestHelper)this, 1987, new WorldPoint(2509, 3494, 0), "Board the log raft west of Almera.", new Requirement[0]);
        this.useRopeOnRockFinal = new ObjectStep((QuestHelper)this, 1996, new WorldPoint(2512, 3468, 0), "Use a rope on the rock to the south.", this.highlightRope);
        this.useRopeOnRockFinal.addIcon(954);
        this.useRopeOnTreeFinal = new ObjectStep((QuestHelper)this, 2020, new WorldPoint(2512, 3465, 0), "Use a rope on the dead tree.", this.highlightRope);
        this.useRopeOnTreeFinal.addIcon(954);
        this.enterFalls = new ObjectStep((QuestHelper)this, 2010, new WorldPoint(2511, 3464, 0), "EQUIP Glarial's amulet, then enter the falls.", this.glarialsAmulet);
        this.searchFallsCrate = new ObjectStep((QuestHelper)this, 1999, new WorldPoint(2589, 9888, 0), "Search the crate in the east room for a key.", new Requirement[0]);
        this.useKeyOnFallsDoor = new ObjectStep((QuestHelper)this, 2002, new WorldPoint(2566, 9901, 0), "Go through the doors from the west room.", this.baxKey);
        this.useRunes = new DetailedQuestStep((QuestHelper)this, "Use 1 earth, water and air rune on each of the 6 pillars in the room. Afterwards, use Glarial's amulet on the statue of Glarial.", this.airRune, this.waterRune, this.earthRune);
        this.useAmuletOnStatue = new ObjectStep((QuestHelper)this, 2006, new WorldPoint(2603, 9915, 0), "Use Glarial's amulet on the Statue of Glarial", this.unequippedAmulet);
        this.useAmuletOnStatue.addIcon(295);
        this.useUrnOnChalice = new ObjectStep((QuestHelper)this, 2014, new WorldPoint(2604, 9911, 0), "DO NOT LEFT-CLICK THE CHALICE! Use Glarial's urn on the Chalice to finish the quest.", this.glarialsUrn);
        this.useUrnOnChalice.addIcon(296);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.highlightRope);
        reqs.add(this.airRunes);
        reqs.add(this.earthRunes);
        reqs.add(this.waterRunes);
        return reqs;
    }

    @Override
    public List<String> getCombatRequirements() {
        ArrayList<String> reqs = new ArrayList<String>();
        reqs.add("Able to survive enemies up to level 86 attacking you");
        return reqs;
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.gamesNecklace);
        reqs.add(this.food);
        return reqs;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.STRENGTH, 13750), new ExperienceReward(Skill.ATTACK, 13750));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Diamonds", 1601, 2), new ItemReward("Gold Bars", 2357, 2), new ItemReward("Mithril Seeds", 299, 40));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Collections.singletonList(this.talkToAlmera), new Requirement[0]));
        allSteps.add(new PanelDetails("Investigate", Arrays.asList(this.boardRaft, this.talkToHudon, this.useRopeOnRock, this.useRopeOnTree, this.getInBarrel, this.goUpstairsHadley, this.searchBookcase, this.readBook), this.rope));
        PanelDetails getPebblePanel = new PanelDetails("Get Glarial's Pebble", Arrays.asList(this.enterGnomeDungeon, this.searchGnomeCrate, this.enterGnomeDoor, this.talkToGolrie), new Requirement[0]);
        getPebblePanel.setLockingStep(this.goGetPebble);
        allSteps.add(getPebblePanel);
        PanelDetails getGlarialStuffPanel = new PanelDetails("Loot Glarial's tomb", Arrays.asList(this.usePebble, this.searchGlarialChest, this.searchGlarialCoffin), new Requirement[0]);
        getGlarialStuffPanel.setLockingStep(this.getGlarialStuff);
        allSteps.add(getGlarialStuffPanel);
        PanelDetails finishOffPanel = new PanelDetails("Put Glarial to rest", Arrays.asList(this.getFinalItems, this.boardRaftFinal, this.useRopeOnRockFinal, this.useRopeOnTreeFinal, this.enterFalls, this.searchFallsCrate, this.useKeyOnFallsDoor, this.useRunes, this.useUrnOnChalice), this.rope, this.airRunes, this.earthRunes, this.waterRunes, this.glarialsUrn, this.glarialsAmulet);
        allSteps.add(finishOffPanel);
        return allSteps;
    }
}

