/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.wanted;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questhelpers.QuestUtil;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.ItemRequirements;
import com.questhelper.requirements.npc.DialogRequirement;
import com.questhelper.requirements.npc.NpcHintArrowRequirement;
import com.questhelper.requirements.player.FreeInventorySlotRequirement;
import com.questhelper.requirements.quest.QuestPointRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.WANTED)
public class Wanted
extends BasicQuestHelper {
    private static final String TEXT_ASK_ABOUT_WANTED_QUEST = "Ask about the Wanted! Quest";
    ItemRequirement commorbComponents;
    ItemRequirement tenThousandGp;
    ItemRequirement commorbComponentsOrTenThousandGp;
    ItemRequirement lightSource;
    ItemRequirement spinyHelmet;
    ItemRequirement rope;
    ItemRequirement combatGear;
    ItemRequirement commorb;
    ItemRequirement highlightedCommorb;
    ItemRequirement runeEssence;
    ItemRequirement pureEssence;
    ItemRequirement essence;
    ItemRequirement amuletOfGlory;
    ItemRequirement ringOfDueling;
    ItemRequirement faladorTeleport;
    ItemRequirement varrockTeleport;
    ItemRequirement canifisTeleport;
    Zone whiteKnightsCastleF1;
    Zone whiteKnightsCastleF2;
    Zone taverleyDungeonP1;
    Zone taverleyDungeonP2;
    Zone blackKnightsBase;
    Zone nearCanifis;
    Zone canifis;
    Zone championsGuild;
    Zone essenceMine;
    Zone dorgeshKaan;
    Zone lumbridgeCellar;
    Zone musaPoint;
    Zone draynorMarket;
    Zone goblinVillage;
    Zone ardougneMarket;
    Zone grandTree;
    Zone scorpiusShrine;
    Zone nearAliMorrisane;
    Zone wizardsTower;
    Zone brimhavenPub;
    Zone castleWars;
    Zone rellekka;
    Zone mcGruborsWood1;
    Zone mcGruborsWood2;
    Zone slayerTower;
    Zone yanillePub;
    Zone lumbridgeCaves;
    Zone endOfLumbridgeSwampCaves;
    Zone chasmOfTears;
    Requirement isInWhiteKnightsCastleF1;
    Requirement isInWhiteKnightsCastleF2;
    Requirement becameSquire;
    Requirement isInTaverleyDungeon;
    Requirement isInCommorbWithGpConversation;
    Requirement isInCommorbWithComponentsConversation;
    Requirement isInBlackKnightsBase;
    Requirement hasKilledBlackKnight;
    Requirement startedEnterTheAbyss;
    Requirement talkedToSavantNearCanifis;
    Requirement isNearCanifis;
    Requirement isInCanifis;
    Requirement gotAssignmentDetailsFromSavant;
    Requirement talkedToLordDaquarius;
    Requirement investigatedLordDaquarius;
    Requirement talkedToMageOfZamorak;
    Requirement mustChaseToChampionsGuild;
    Requirement isInChampionsGuild;
    Requirement mustChaseToDorgeshKaan;
    Requirement isAtAliMorrisane;
    Requirement isAtCastleWars;
    Requirement isAtEndOfLumbridgeCaves;
    Requirement isAtScorpiusShrine;
    Requirement isInArdougneMarket;
    Requirement isInBrimhavenPub;
    Requirement isInChasmOfTears;
    Requirement isInDorgeshKaan;
    Requirement isInDraynorMarket;
    Requirement isInEssenceMine;
    Requirement isInGoblinVillage;
    Requirement isInGrandTree;
    Requirement isInLumbridgeCaves;
    Requirement isInLumbridgeCellarOrTunnels;
    Requirement isInMcGruborsWood;
    Requirement isInSlayerTower;
    Requirement isInYanillePub;
    Requirement isInMusaPoint;
    Requirement isInRellekka;
    Requirement isInWizardsTower;
    Requirement mustChaseToAliMorrisane;
    Requirement mustChaseToArdougneMarket;
    Requirement mustChaseToBrimhavenPub;
    Requirement mustChaseToCastleWars;
    Requirement mustChaseToDraynorMarket;
    Requirement mustChaseToEssenceMine;
    Requirement mustChaseToGoblinVillage;
    Requirement mustChaseToGrandTree;
    Requirement mustChaseToLumbridgeSwamp;
    Requirement mustChaseToMcGruborsWood;
    Requirement mustChaseToMusaPoint;
    Requirement mustChaseToRellekka;
    Requirement mustChaseToScorpiusShrine;
    Requirement mustChaseToSlayerTower;
    Requirement mustChaseToWizardsTower;
    Requirement mustChaseToYanillePub;
    Requirement solusHat;
    Requirement oneFreeInventorySlot;
    Requirement placedRope;
    Requirement blackKnightNearby;
    QuestStep talkToSirTiffy1;
    QuestStep climbToWhiteKnightsCastleF1;
    QuestStep climbToWhiteKnightsCastleF2;
    QuestStep talkToSirTiffyAfterBecomingSquire;
    QuestStep talkToSirAmik1;
    QuestStep talkToSirTiffy2;
    QuestStep talkToSirAmik2;
    QuestStep talkToSirTiffy3;
    QuestStep getCommorbFromSirTiffy;
    QuestStep getCommorbWithComponents;
    QuestStep getCommorbWithGp;
    QuestStep doNotGetCommorbWithGp;
    QuestStep talkToSavantAfterGettingCommorb;
    QuestStep enterTaverleyDungeon;
    QuestStep talkToLordDaquarius;
    QuestStep killBlackKnight;
    QuestStep talkToIntimidatedLordDaquarius;
    QuestStep goToBlackKnightsBase;
    QuestStep talkToMageOfZamorakInWilderness;
    QuestStep talkToMageOfZamorak;
    QuestStep giveEssenceToMageOfZamorak;
    QuestStep scanWithCommorb;
    QuestStep moveOutOfCanifisAgain;
    QuestStep chaseToCanifis;
    QuestStep enterCanifis;
    QuestStep huntDownSolus;
    QuestStep goToChampionsGuild;
    QuestStep goToDorgeshKaan;
    QuestStep goToEssenceMine;
    QuestStep goToMusaPoint;
    QuestStep goToDraynorMarket;
    QuestStep goToGoblinVillage;
    QuestStep goToArdougneMarket;
    QuestStep goToGrandTree;
    QuestStep goToScorpiusShrine;
    QuestStep goToAliMorrisane;
    QuestStep goToWizardsTower;
    QuestStep goToBrimhavenPub;
    QuestStep goToCastleWars;
    QuestStep goToRellekka;
    QuestStep goToMcGruborsWood;
    QuestStep goToSlayerTower;
    QuestStep goToYanillePub;
    QuestStep enterLumbridgeSwampCavesFromTears;
    QuestStep goToEndOfLumbridgeSwampCaves;
    QuestStep goDownToLumbridgeSwampCaves;
    QuestStep goDownToLumbridgeSwampCavesPlacedRope;
    QuestStep killSolus;
    QuestStep goTalkToSirAmikAfterFinalBattle;
    QuestStep goDownToLumbridgeCellar;
    QuestStep killBlackKnightFromScan;
    ConditionalStep goTalkToSirAmik1;
    ConditionalStep goTalkToSirAmik2;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupRequirements();
        this.setupZones();
        this.setupOtherRequirements();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToSirTiffy1);
        steps.put(1, this.talkToSirTiffy1);
        steps.put(2, this.talkToSirTiffy1);
        ConditionalStep goToSirAmik = new ConditionalStep((QuestHelper)this, this.climbToWhiteKnightsCastleF1, new Requirement[0]);
        goToSirAmik.addStep(this.isInWhiteKnightsCastleF1, this.climbToWhiteKnightsCastleF2);
        this.goTalkToSirAmik1 = new ConditionalStep((QuestHelper)this, (QuestStep)goToSirAmik, "Go tell Sir Amik Varze in the White Knights' Castle you wish to join the White Knights, BUT refuse to be a Squire.", new Requirement[0]);
        this.goTalkToSirAmik1.addStep(this.isInWhiteKnightsCastleF2, this.talkToSirAmik1);
        ConditionalStep goDoAmikP1 = new ConditionalStep((QuestHelper)this, (QuestStep)this.goTalkToSirAmik1, new Requirement[0]);
        goDoAmikP1.addStep(this.becameSquire, this.talkToSirTiffyAfterBecomingSquire);
        steps.put(3, goDoAmikP1);
        steps.put(4, this.talkToSirTiffy2);
        this.goTalkToSirAmik2 = new ConditionalStep((QuestHelper)this, (QuestStep)goToSirAmik, "Go back to Sir Amik Varze in the White Knights' Castle.", new Requirement[0]);
        this.goTalkToSirAmik2.addStep(this.isInWhiteKnightsCastleF2, this.talkToSirAmik2);
        steps.put(5, this.goTalkToSirAmik2);
        steps.put(6, this.talkToSirTiffy3);
        ConditionalStep goGetCommorb = new ConditionalStep((QuestHelper)this, this.getCommorbFromSirTiffy, this.commorbComponentsOrTenThousandGp);
        goGetCommorb.addStep(new Conditions(this.tenThousandGp, this.commorbComponents, this.isInCommorbWithGpConversation), this.doNotGetCommorbWithGp);
        goGetCommorb.addStep(new Conditions(this.commorbComponents, this.isInCommorbWithComponentsConversation), this.getCommorbWithComponents);
        goGetCommorb.addStep(new Conditions(this.tenThousandGp, this.isInCommorbWithGpConversation), this.getCommorbWithGp);
        steps.put(7, goGetCommorb);
        ConditionalStep investigation = new ConditionalStep((QuestHelper)this, this.talkToSavantAfterGettingCommorb, new Requirement[0]);
        investigation.addStep(this.talkedToMageOfZamorak, this.giveEssenceToMageOfZamorak);
        investigation.addStep(new Conditions(this.startedEnterTheAbyss, this.investigatedLordDaquarius), this.talkToMageOfZamorak);
        investigation.addStep(this.investigatedLordDaquarius, this.talkToMageOfZamorakInWilderness);
        investigation.addStep(new Conditions(this.hasKilledBlackKnight, this.isInTaverleyDungeon), this.talkToIntimidatedLordDaquarius);
        investigation.addStep(this.hasKilledBlackKnight, this.enterTaverleyDungeon);
        investigation.addStep(new Conditions(this.talkedToLordDaquarius, this.isInBlackKnightsBase), this.killBlackKnight);
        investigation.addStep(this.talkedToLordDaquarius, this.goToBlackKnightsBase);
        investigation.addStep(new Conditions(this.gotAssignmentDetailsFromSavant, this.isInTaverleyDungeon), this.talkToLordDaquarius);
        investigation.addStep(this.gotAssignmentDetailsFromSavant, this.enterTaverleyDungeon);
        steps.put(8, investigation);
        ConditionalStep goScanInCanifis = new ConditionalStep((QuestHelper)this, this.chaseToCanifis, new Requirement[0]);
        goScanInCanifis.addStep(new Conditions(this.isInCanifis, this.talkedToSavantNearCanifis), this.scanWithCommorb);
        goScanInCanifis.addStep(new Conditions(this.isNearCanifis, this.talkedToSavantNearCanifis), this.enterCanifis);
        goScanInCanifis.addStep(this.isNearCanifis, this.moveOutOfCanifisAgain);
        ConditionalStep goScanInChampionsGuild = new ConditionalStep((QuestHelper)this, this.goToChampionsGuild, new Requirement[0]);
        goScanInChampionsGuild.addStep(this.isInChampionsGuild, this.scanWithCommorb);
        ConditionalStep goScanInDorgeshKaan = new ConditionalStep((QuestHelper)this, this.goDownToLumbridgeCellar, this.lightSource);
        goScanInDorgeshKaan.addStep(this.isInDorgeshKaan, this.scanWithCommorb);
        goScanInDorgeshKaan.addStep(this.isInLumbridgeCellarOrTunnels, this.goToDorgeshKaan);
        ConditionalStep goKillSolusInEssenceMine = new ConditionalStep((QuestHelper)this, this.goToEssenceMine, this.combatGear);
        goKillSolusInEssenceMine.addStep(this.isInEssenceMine, this.killSolus);
        ConditionalStep goScanInMusaPoint = new ConditionalStep((QuestHelper)this, this.goToMusaPoint, new Requirement[0]);
        goScanInMusaPoint.addStep(this.isInMusaPoint, this.scanWithCommorb);
        ConditionalStep goScanInDraynorMarket = new ConditionalStep((QuestHelper)this, this.goToDraynorMarket, new Requirement[0]);
        goScanInDraynorMarket.addStep(this.isInDraynorMarket, this.scanWithCommorb);
        ConditionalStep goScanInGoblinVillage = new ConditionalStep((QuestHelper)this, this.goToGoblinVillage, new Requirement[0]);
        goScanInGoblinVillage.addStep(this.isInGoblinVillage, this.scanWithCommorb);
        ConditionalStep goScanInArdougneMarket = new ConditionalStep((QuestHelper)this, this.goToArdougneMarket, new Requirement[0]);
        goScanInArdougneMarket.addStep(this.isInArdougneMarket, this.scanWithCommorb);
        ConditionalStep goScanInGrandTree = new ConditionalStep((QuestHelper)this, this.goToGrandTree, new Requirement[0]);
        goScanInGrandTree.addStep(this.isInGrandTree, this.scanWithCommorb);
        ConditionalStep goScanAtScorpiusShrine = new ConditionalStep((QuestHelper)this, this.goToScorpiusShrine, new Requirement[0]);
        goScanAtScorpiusShrine.addStep(this.isAtScorpiusShrine, this.scanWithCommorb);
        ConditionalStep goScanAtAliMorrisane = new ConditionalStep((QuestHelper)this, this.goToAliMorrisane, new Requirement[0]);
        goScanAtAliMorrisane.addStep(this.isAtAliMorrisane, this.scanWithCommorb);
        ConditionalStep goScanInWizardsTower = new ConditionalStep((QuestHelper)this, this.goToWizardsTower, new Requirement[0]);
        goScanInWizardsTower.addStep(this.isInWizardsTower, this.scanWithCommorb);
        ConditionalStep goScanInBrimhavenPub = new ConditionalStep((QuestHelper)this, this.goToBrimhavenPub, new Requirement[0]);
        goScanInBrimhavenPub.addStep(this.isInBrimhavenPub, this.scanWithCommorb);
        ConditionalStep goScanAtCastleWars = new ConditionalStep((QuestHelper)this, this.goToCastleWars, new Requirement[0]);
        goScanAtCastleWars.addStep(this.isAtCastleWars, this.scanWithCommorb);
        ConditionalStep goScanInRellekka = new ConditionalStep((QuestHelper)this, this.goToRellekka, new Requirement[0]);
        goScanInRellekka.addStep(this.isInRellekka, this.scanWithCommorb);
        ConditionalStep goScanInMcGruborsWood = new ConditionalStep((QuestHelper)this, this.goToMcGruborsWood, new Requirement[0]);
        goScanInMcGruborsWood.addStep(this.isInMcGruborsWood, this.scanWithCommorb);
        ConditionalStep goScanInSlayerTower = new ConditionalStep((QuestHelper)this, this.goToSlayerTower, new Requirement[0]);
        goScanInSlayerTower.addStep(this.isInSlayerTower, this.scanWithCommorb);
        ConditionalStep goScanInYanillePub = new ConditionalStep((QuestHelper)this, this.goToYanillePub, new Requirement[0]);
        goScanInYanillePub.addStep(this.isInYanillePub, this.scanWithCommorb);
        ConditionalStep goScanInLumbridgeSwampCaves = new ConditionalStep((QuestHelper)this, this.goDownToLumbridgeSwampCaves, new Requirement[0]);
        goScanInLumbridgeSwampCaves.addStep(this.isAtEndOfLumbridgeCaves, this.scanWithCommorb);
        goScanInLumbridgeSwampCaves.addStep(this.isInChasmOfTears, this.enterLumbridgeSwampCavesFromTears);
        goScanInLumbridgeSwampCaves.addStep(this.isInLumbridgeCaves, this.goToEndOfLumbridgeSwampCaves);
        goScanInLumbridgeSwampCaves.addStep(this.placedRope, this.goDownToLumbridgeSwampCavesPlacedRope);
        ConditionalStep goHuntForSolus = new ConditionalStep((QuestHelper)this, (QuestStep)goScanInCanifis, new Requirement[0]);
        goHuntForSolus.addStep(this.blackKnightNearby, this.killBlackKnightFromScan);
        goHuntForSolus.addStep(this.mustChaseToEssenceMine, goKillSolusInEssenceMine);
        goHuntForSolus.addStep(this.mustChaseToChampionsGuild, goScanInChampionsGuild);
        goHuntForSolus.addStep(this.mustChaseToDorgeshKaan, goScanInDorgeshKaan);
        goHuntForSolus.addStep(this.mustChaseToMusaPoint, goScanInMusaPoint);
        goHuntForSolus.addStep(this.mustChaseToDraynorMarket, goScanInDraynorMarket);
        goHuntForSolus.addStep(this.mustChaseToGoblinVillage, goScanInGoblinVillage);
        goHuntForSolus.addStep(this.mustChaseToArdougneMarket, goScanInArdougneMarket);
        goHuntForSolus.addStep(this.mustChaseToGrandTree, goScanInGrandTree);
        goHuntForSolus.addStep(this.mustChaseToScorpiusShrine, goScanAtScorpiusShrine);
        goHuntForSolus.addStep(this.mustChaseToAliMorrisane, goScanAtAliMorrisane);
        goHuntForSolus.addStep(this.mustChaseToWizardsTower, goScanInWizardsTower);
        goHuntForSolus.addStep(this.mustChaseToBrimhavenPub, goScanInBrimhavenPub);
        goHuntForSolus.addStep(this.mustChaseToCastleWars, goScanAtCastleWars);
        goHuntForSolus.addStep(this.mustChaseToRellekka, goScanInRellekka);
        goHuntForSolus.addStep(this.mustChaseToMcGruborsWood, goScanInMcGruborsWood);
        goHuntForSolus.addStep(this.mustChaseToSlayerTower, goScanInSlayerTower);
        goHuntForSolus.addStep(this.mustChaseToYanillePub, goScanInYanillePub);
        goHuntForSolus.addStep(this.mustChaseToLumbridgeSwamp, goScanInLumbridgeSwampCaves);
        steps.put(9, goHuntForSolus);
        steps.put(10, this.goTalkToSirAmikAfterFinalBattle);
        return steps;
    }

    @Override
    public void setupRequirements() {
        ItemRequirement lawRune = new ItemRequirement("A law rune", 563, 1);
        ItemRequirement enchantedGem = new ItemRequirement("Enchanted gem", 4155, 1);
        ItemRequirement moltenGlass = new ItemRequirement("Molten glass", 1775, 1);
        this.commorbComponents = new ItemRequirements("A law rune, an enchanted gem and some molten glass", lawRune, enchantedGem, moltenGlass);
        this.commorbComponents.setTooltip("Alternatively, you can bring 10k gp.");
        this.tenThousandGp = new ItemRequirement("10k gp", ItemCollections.COINS, 10000);
        this.commorbComponentsOrTenThousandGp = new ItemRequirements(LogicType.OR, "A law rune, an enchanted gem and some molten glass OR 10k gp", this.commorbComponents, this.tenThousandGp);
        this.runeEssence = new ItemRequirement("20 Rune Essence (UNNOTED)", 1436, 20);
        this.pureEssence = new ItemRequirement("20 Pure Essence (UNNOTED)", 7936, 20);
        this.essence = new ItemRequirements(LogicType.OR, "20 Rune or Pure Essence (UNNOTED)", this.runeEssence, this.pureEssence);
        this.lightSource = new ItemRequirement("A light source", ItemCollections.LIGHT_SOURCES).isNotConsumed();
        this.rope = new ItemRequirement("A rope", 954);
        this.spinyHelmet = new ItemRequirement("A spiny helmet or slayer helm", 4551).isNotConsumed();
        this.spinyHelmet.addAlternates(ItemCollections.SLAYER_HELMETS);
        this.combatGear = new ItemRequirement("Combat gear", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.amuletOfGlory = new ItemRequirement("Amulet of glory", ItemCollections.AMULET_OF_GLORIES).isNotConsumed();
        this.ringOfDueling = new ItemRequirement("Ring of Dueling", ItemCollections.RING_OF_DUELINGS);
        this.faladorTeleport = new ItemRequirement("A teleport to Falador", 8009, -1);
        this.varrockTeleport = new ItemRequirement("A teleport to Varrock", 8007, -1);
        this.canifisTeleport = new ItemRequirement("A teleport to Canifis", 19621, -1);
        this.solusHat = new ItemRequirement("Solus' hat", 6636);
        this.commorb = new ItemRequirement("Commorb", 6635);
        this.highlightedCommorb = this.commorb.copy();
        this.highlightedCommorb.setHighlightInInventory(true);
    }

    public void setupZones() {
        this.taverleyDungeonP1 = new Zone(new WorldPoint(2814, 9854, 0), new WorldPoint(2944, 9670, 0));
        this.taverleyDungeonP2 = new Zone(new WorldPoint(2944, 9803, 0), new WorldPoint(2971, 9769, 0));
        this.whiteKnightsCastleF1 = new Zone(new WorldPoint(2954, 3353, 1), new WorldPoint(2998, 3327, 1));
        this.whiteKnightsCastleF2 = new Zone(new WorldPoint(2954, 3353, 2), new WorldPoint(2998, 3327, 2));
        this.blackKnightsBase = new Zone(new WorldPoint(2889, 9713, 0), new WorldPoint(2934, 9671, 0));
        this.nearCanifis = new Zone(new WorldPoint(3457, 3521, 0), new WorldPoint(3520, 3464, 0));
        this.canifis = new Zone(new WorldPoint(3477, 3485, 0), new WorldPoint(3489, 3471, 0));
        this.championsGuild = new Zone(new WorldPoint(3188, 3362, 0), new WorldPoint(3194, 3352, 0));
        this.dorgeshKaan = new Zone(new WorldPoint(3310, 9656, 0), new WorldPoint(3327, 9600, 0));
        this.lumbridgeCellar = new Zone(new WorldPoint(3207, 9651, 0), new WorldPoint(3327, 9601, 0));
        this.musaPoint = new Zone(new WorldPoint(2913, 1366, 0), new WorldPoint(2919, 3158, 0));
        this.draynorMarket = new Zone(new WorldPoint(3077, 3254, 0), new WorldPoint(3085, 3246, 0));
        this.goblinVillage = new Zone(new WorldPoint(2947, 3516, 0), new WorldPoint(2967, 3499, 0));
        this.ardougneMarket = new Zone(new WorldPoint(2655, 3313, 0), new WorldPoint(2668, 3301, 0));
        this.grandTree = new Zone(new WorldPoint(2463, 3499, 0), new WorldPoint(2469, 3493, 0));
        this.scorpiusShrine = new Zone(new WorldPoint(2461, 3231, 0), new WorldPoint(2470, 3225, 0));
        this.nearAliMorrisane = new Zone(new WorldPoint(3300, 3216, 0), new WorldPoint(3306, 3209, 0));
        this.wizardsTower = new Zone(new WorldPoint(3104, 3166, 0), new WorldPoint(3114, 3155, 0));
        this.brimhavenPub = new Zone(new WorldPoint(2791, 3170, 0), new WorldPoint(2800, 3154, 0));
        this.castleWars = new Zone(new WorldPoint(2435, 3099, 0), new WorldPoint(2447, 3081, 0));
        this.rellekka = new Zone(new WorldPoint(2654, 3665, 0), new WorldPoint(2664, 3650, 0));
        this.mcGruborsWood1 = new Zone(new WorldPoint(2624, 3502, 0), new WorldPoint(2654, 3470, 0));
        this.mcGruborsWood2 = new Zone(new WorldPoint(2662, 3504, 0), new WorldPoint(2677, 3484, 0));
        this.slayerTower = new Zone(new WorldPoint(3405, 3580, 0), new WorldPoint(3453, 3534, 0));
        this.yanillePub = new Zone(new WorldPoint(2548, 3082, 0), new WorldPoint(2557, 3077, 0));
        this.lumbridgeCaves = new Zone(new WorldPoint(3144, 9602, 0), new WorldPoint(3260, 9538, 0));
        this.chasmOfTears = new Zone(new WorldPoint(3208, 9533, 2), new WorldPoint(3261, 9486, 2));
        this.endOfLumbridgeSwampCaves = new Zone(new WorldPoint(3216, 9555, 0), new WorldPoint(3239, 9540, 0));
        this.essenceMine = new Zone(new WorldPoint(2880, 4806, 0), new WorldPoint(2938, 4861, 0));
    }

    public void setupOtherRequirements() {
        this.oneFreeInventorySlot = new FreeInventorySlotRequirement(1);
        this.startedEnterTheAbyss = new VarplayerRequirement(492, 1, Operation.GREATER_EQUAL);
        this.isInCommorbWithGpConversation = new DialogRequirement("You have that kind of money with you?");
        this.isInCommorbWithComponentsConversation = new DialogRequirement("You wish me to make you one now then, what?");
        this.isInTaverleyDungeon = new ZoneRequirement(this.taverleyDungeonP1, this.taverleyDungeonP2);
        this.isInWhiteKnightsCastleF1 = new ZoneRequirement(this.whiteKnightsCastleF1);
        this.isInWhiteKnightsCastleF2 = new ZoneRequirement(this.whiteKnightsCastleF2);
        this.isInBlackKnightsBase = new ZoneRequirement(this.blackKnightsBase);
        this.isNearCanifis = new ZoneRequirement(this.nearCanifis);
        this.isInCanifis = new ZoneRequirement(this.canifis);
        this.isInChampionsGuild = new ZoneRequirement(this.championsGuild);
        this.isAtAliMorrisane = new ZoneRequirement(this.nearAliMorrisane);
        this.isAtCastleWars = new ZoneRequirement(this.castleWars);
        this.isAtEndOfLumbridgeCaves = new ZoneRequirement(this.endOfLumbridgeSwampCaves);
        this.isAtScorpiusShrine = new ZoneRequirement(this.scorpiusShrine);
        this.isInArdougneMarket = new ZoneRequirement(this.ardougneMarket);
        this.isInBrimhavenPub = new ZoneRequirement(this.brimhavenPub);
        this.isInDorgeshKaan = new ZoneRequirement(this.dorgeshKaan);
        this.isInDraynorMarket = new ZoneRequirement(this.draynorMarket);
        this.isInEssenceMine = new ZoneRequirement(this.essenceMine);
        this.isInGoblinVillage = new ZoneRequirement(this.goblinVillage);
        this.isInGrandTree = new ZoneRequirement(this.grandTree);
        this.isInChasmOfTears = new ZoneRequirement(this.chasmOfTears);
        this.isInLumbridgeCaves = new ZoneRequirement(this.lumbridgeCaves);
        this.isInLumbridgeCellarOrTunnels = new ZoneRequirement(this.lumbridgeCellar);
        this.isInMcGruborsWood = new ZoneRequirement(this.mcGruborsWood1, this.mcGruborsWood2);
        this.isInSlayerTower = new ZoneRequirement(this.slayerTower);
        this.isInYanillePub = new ZoneRequirement(this.yanillePub);
        this.isInMusaPoint = new ZoneRequirement(this.musaPoint);
        this.isInRellekka = new ZoneRequirement(this.rellekka);
        this.isInWizardsTower = new ZoneRequirement(this.wizardsTower);
        this.becameSquire = new VarbitRequirement(1052, 1);
        this.gotAssignmentDetailsFromSavant = new VarbitRequirement(1053, 1);
        this.talkedToLordDaquarius = new VarbitRequirement(1055, 1);
        this.hasKilledBlackKnight = new VarbitRequirement(1055, 2);
        this.investigatedLordDaquarius = new VarbitRequirement(1058, 1);
        this.talkedToMageOfZamorak = new VarbitRequirement(1056, 1);
        this.talkedToSavantNearCanifis = new VarbitRequirement(1065, 1);
        this.mustChaseToChampionsGuild = new VarbitRequirement(1067, 1);
        this.mustChaseToDorgeshKaan = new VarbitRequirement(1069, 1);
        this.mustChaseToEssenceMine = new VarbitRequirement(1071, 1);
        this.mustChaseToMusaPoint = new VarbitRequirement(1073, 1);
        this.mustChaseToDraynorMarket = new VarbitRequirement(1075, 1);
        this.mustChaseToGoblinVillage = new VarbitRequirement(1077, 1);
        this.mustChaseToArdougneMarket = new VarbitRequirement(1079, 1);
        this.mustChaseToGrandTree = new VarbitRequirement(1081, 1);
        this.mustChaseToScorpiusShrine = new VarbitRequirement(1083, 1);
        this.mustChaseToAliMorrisane = new VarbitRequirement(1085, 1);
        this.mustChaseToWizardsTower = new VarbitRequirement(1087, 1);
        this.mustChaseToBrimhavenPub = new VarbitRequirement(1089, 1);
        this.mustChaseToCastleWars = new VarbitRequirement(1091, 1);
        this.mustChaseToRellekka = new VarbitRequirement(1093, 1);
        this.mustChaseToMcGruborsWood = new VarbitRequirement(1095, 1);
        this.mustChaseToSlayerTower = new VarbitRequirement(1097, 1);
        this.mustChaseToYanillePub = new VarbitRequirement(1099, 1);
        this.mustChaseToLumbridgeSwamp = new VarbitRequirement(1101, 1);
        this.placedRope = new VarbitRequirement(279, 1);
        this.blackKnightNearby = new NpcHintArrowRequirement(4959);
    }

    public void setupSteps() {
        WorldPoint locationSirTaffy = new WorldPoint(2997, 3373, 0);
        this.talkToSirTiffy1 = new NpcStep((QuestHelper)this, 4687, locationSirTaffy, "Talk to Sir Tiffy Cashien in Falador Park.", new Requirement[0]);
        this.talkToSirTiffy1.addDialogSteps("Do you have any jobs for me yet?", "Yes, I'm interested.", TEXT_ASK_ABOUT_WANTED_QUEST, "How will all that help?");
        this.climbToWhiteKnightsCastleF1 = new ObjectStep((QuestHelper)this, 24072, new WorldPoint(2955, 3339, 0), "Climb to the second floor of the White Knights' castle.", new Requirement[0]);
        this.climbToWhiteKnightsCastleF2 = new ObjectStep((QuestHelper)this, 24072, new WorldPoint(2961, 3339, 1), "Climb to the second floor of the White Knights' castle.", new Requirement[0]);
        this.talkToSirAmik1 = new NpcStep((QuestHelper)this, 4771, "Talk to Sir Amik Varze.", new Requirement[0]);
        this.talkToSirAmik1.addDialogStep("No, not right now...");
        this.talkToSirTiffyAfterBecomingSquire = new NpcStep((QuestHelper)this, 4687, locationSirTaffy, "Talk to Sir Tiffy Cashien about your new job as a Squire in Falador Park.", new Requirement[0]);
        this.talkToSirTiffyAfterBecomingSquire.addDialogStep(TEXT_ASK_ABOUT_WANTED_QUEST);
        this.talkToSirTiffy2 = new NpcStep((QuestHelper)this, 4687, locationSirTaffy, "Return to Sir Tiffy Cashien in Falador Park.", new Requirement[0]);
        this.talkToSirTiffy2.addDialogStep(TEXT_ASK_ABOUT_WANTED_QUEST);
        this.talkToSirAmik2 = new NpcStep((QuestHelper)this, 4771, "Talk to Sir Amik Varze again.", new Requirement[0]);
        this.talkToSirAmik2.addDialogStep("Sure, I'll help you!");
        this.talkToSirTiffy3 = new NpcStep((QuestHelper)this, 4687, locationSirTaffy, "Report back to Sir Tiffy Cashien in Falador Park.", new Requirement[0]);
        this.talkToSirTiffy3.addDialogStep(TEXT_ASK_ABOUT_WANTED_QUEST);
        this.getCommorbWithGp = new NpcStep((QuestHelper)this, 4687, locationSirTaffy, "Get a Commorb from Sir Tiffy Cashien in Falador Park.", new Requirement[0]);
        this.getCommorbWithGp.addDialogSteps(TEXT_ASK_ABOUT_WANTED_QUEST, "Buy One", "YES");
        this.getCommorbWithComponents = new NpcStep((QuestHelper)this, 4687, locationSirTaffy, "Get a Commorb from Sir Tiffy Cashien in Falador Park.", new Requirement[0]);
        this.getCommorbWithComponents.addDialogSteps(TEXT_ASK_ABOUT_WANTED_QUEST, "Have One Made", "YES");
        this.doNotGetCommorbWithGp = new NpcStep((QuestHelper)this, 4687, locationSirTaffy, "Get a Commorb from Sir Tiffy Cashien in Falador Park.", new Requirement[0]);
        this.doNotGetCommorbWithGp.addDialogSteps(TEXT_ASK_ABOUT_WANTED_QUEST, "NO");
        this.getCommorbFromSirTiffy = new NpcStep((QuestHelper)this, 4687, locationSirTaffy, "Get a Commorb from Sir Tiffy Cashien in Falador Park.", new Requirement[0]);
        this.getCommorbFromSirTiffy.addDialogSteps(TEXT_ASK_ABOUT_WANTED_QUEST);
        this.getCommorbFromSirTiffy.addSubSteps(this.getCommorbWithGp, this.getCommorbWithComponents, this.doNotGetCommorbWithGp);
        this.talkToSavantAfterGettingCommorb = new DetailedQuestStep((QuestHelper)this, "Right-click the Commorb and select 'contact' to contact Savant.", this.highlightedCommorb);
        this.talkToSavantAfterGettingCommorb.addDialogStep("Current Assignment");
        this.enterTaverleyDungeon = new ObjectStep((QuestHelper)this, 16680, new WorldPoint(2884, 3397, 0), "Enter Taverley Dungeon.", this.combatGear, this.commorb);
        this.talkToLordDaquarius = new NpcStep((QuestHelper)this, 4929, new WorldPoint(2891, 9681, 0), "Talk to Lord Daquarius in Taverley Dungeon.", this.commorb);
        this.talkToLordDaquarius.addSubSteps(this.enterTaverleyDungeon);
        this.goToBlackKnightsBase = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2896, 9681, 0), "Go to the Black Knights' Base in Taverley Dungeon.", new Requirement[0]);
        this.killBlackKnight = new NpcStep((QuestHelper)this, 516, new WorldPoint(2891, 9681, 0), "Kill a Black Knight near Daquarius.", true, this.combatGear);
        this.talkToIntimidatedLordDaquarius = new NpcStep((QuestHelper)this, 4929, new WorldPoint(2891, 9681, 0), "Talk to Lord Daquarius in Taverley Dungeon again.", new Requirement[0]);
        this.talkToMageOfZamorakInWilderness = new NpcStep((QuestHelper)this, 2580, new WorldPoint(3106, 3558, 0), "Talk to the Mage of Zamorak in the wilderness just north of Edgeville.", this.commorb);
        this.talkToMageOfZamorak = new NpcStep((QuestHelper)this, 2582, new WorldPoint(3258, 3388, 0), "Talk to the Mage of Zamorak in south east Varrock.", this.commorb);
        this.talkToMageOfZamorak.addDialogStep("Solus Dellagar");
        this.giveEssenceToMageOfZamorak = new NpcStep((QuestHelper)this, 2582, new WorldPoint(3258, 3388, 0), "Bring the 20 rune or pure essence to the Mage of Zamorak in Varrock.", this.commorb, this.essence);
        this.giveEssenceToMageOfZamorak.addDialogStep("Solus Dellagar");
        this.scanWithCommorb = new DetailedQuestStep((QuestHelper)this, "Use the 'scan' option on the Commorb.", this.highlightedCommorb);
        this.moveOutOfCanifisAgain = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3450, 3488, 0), "Finish the conversation with Savant. Move out of Canifis again first to trigger it again if needed.", new Requirement[0]);
        this.chaseToCanifis = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3485, 3481, 0), "Go to Canifis. Finish the conversation when Savant calls you. If you accidentally exit this conversation, move away and enter Canifis again.", this.commorb);
        this.enterCanifis = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3485, 3481, 0), "Go to Canifis.", this.commorb);
        this.enterCanifis.addSubSteps(this.chaseToCanifis, this.moveOutOfCanifisAgain);
        this.goToChampionsGuild = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3190, 3359, 0), "Go to the Champions' Guild.", this.commorb);
        this.goDownToLumbridgeCellar = new ObjectStep((QuestHelper)this, 14880, new WorldPoint(3209, 3216, 0), "Go down to the Lumbridge Cellars.", this.commorb);
        this.goToDorgeshKaan = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3317, 9612, 0), "Go to the mines near the entrance of Dorgesh Kaan.", this.commorb);
        this.goToMusaPoint = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2916, 3160, 0), "Go to Musa Point on Karamja.", this.commorb);
        this.goToDraynorMarket = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3082, 3249, 0), "Go to Draynor Market.", this.commorb);
        this.goToGoblinVillage = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2956, 3506, 0), "Go to goblin village north of Falador.", this.commorb);
        this.goToArdougneMarket = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2662, 3305, 0), "Go to Ardougne market.", this.commorb);
        this.goToGrandTree = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2465, 3496, 0), "Go to the Grand Tree.", this.commorb);
        this.goToScorpiusShrine = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2465, 3227, 0), "Go to the Shrine of Scorpius north of the Observatory.", this.commorb);
        this.goToAliMorrisane = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3304, 3211, 0), "Go to Ali Morrisane in Al Kharid.", this.commorb);
        this.goToWizardsTower = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3109, 3164, 0), "Go to the Wizards' Tower.", this.commorb);
        this.goToBrimhavenPub = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2795, 3162, 0), "Go to the pub in Brimhaven.", this.commorb);
        this.goToCastleWars = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2441, 3090, 0), "Go to Castle Wars.", this.commorb);
        this.goToRellekka = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2660, 3657, 0), "Go to Rellekka.", this.commorb);
        this.goToMcGruborsWood = new ObjectStep((QuestHelper)this, 51, new WorldPoint(2662, 3500, 0), "Go to McGrubor's Wood. Fairy ring ALS.", this.commorb);
        this.goToSlayerTower = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3428, 3537, 0), "Go to the Slayer Tower in Morytania.", this.commorb);
        this.goToYanillePub = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2551, 3081, 0), "Go to the pub in Yanille.", this.commorb);
        this.enterLumbridgeSwampCavesFromTears = new ObjectStep((QuestHelper)this, 6658, new WorldPoint(3219, 9534, 2), "Enter the Lumbridge Swamp caves.", new Requirement[0]);
        this.goToEndOfLumbridgeSwampCaves = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3221, 9550, 0), "Go to the point indicated in the Lumbridge Swamp Caves.", this.commorb, this.lightSource, this.spinyHelmet.equipped());
        this.goDownToLumbridgeSwampCaves = new ObjectStep((QuestHelper)this, 5947, new WorldPoint(3169, 3172, 0), "Enter the Lumbridge Swamp Caves. Use a Games Necklace teleport to Tears of Guthix for a faster route.", this.commorb, this.lightSource, this.rope.highlighted(), this.spinyHelmet);
        this.goDownToLumbridgeSwampCaves.addIcon(954);
        this.goDownToLumbridgeSwampCavesPlacedRope = new ObjectStep((QuestHelper)this, 5947, new WorldPoint(3169, 3172, 0), "Enter the Lumbridge Swamp Caves. Use a Games Necklace teleport to Tears of Guthix for a faster route.", this.commorb, this.lightSource, this.spinyHelmet);
        this.killBlackKnightFromScan = new NpcStep((QuestHelper)this, 4959, "Kill the Black Knight, or run away.", new Requirement[0]);
        this.huntDownSolus = new DetailedQuestStep((QuestHelper)this, "Hunt down Solus Dellagar across Gielinor.", new Requirement[0]);
        this.huntDownSolus.addSubSteps(this.goToChampionsGuild, this.goDownToLumbridgeCellar, this.goToDorgeshKaan, this.goToMusaPoint, this.goToDraynorMarket, this.goToGoblinVillage, this.goToArdougneMarket, this.goToGrandTree, this.goToScorpiusShrine, this.goToAliMorrisane, this.goToWizardsTower, this.goToBrimhavenPub, this.goToCastleWars, this.goToRellekka, this.goToMcGruborsWood, this.goToSlayerTower, this.goToYanillePub, this.goDownToLumbridgeSwampCaves, this.goDownToLumbridgeSwampCavesPlacedRope, this.goToEndOfLumbridgeSwampCaves, this.enterLumbridgeSwampCavesFromTears, this.scanWithCommorb);
        this.goToEssenceMine = new NpcStep((QuestHelper)this, 10681, new WorldPoint(3253, 3402, 0), "Go to the Rune Essence mine by talking to any of the NPC's that can teleport you there.", this.commorb, this.combatGear);
        this.killSolus = new NpcStep((QuestHelper)this, 4962, "Kill Solus Dellagar.", this.combatGear);
        NpcStep talkToSirAmikAfterSolusFight = new NpcStep((QuestHelper)this, 4771, "Talk to Sir Amik Varze at the White Knights' Castle in Falador.", new Requirement[0]);
        DetailedQuestStep getSolusHatFromSavant = new DetailedQuestStep((QuestHelper)this, "Right click the Commorb and select the 'contact' option to get Solus' Hat from Savant.", this.highlightedCommorb, this.oneFreeInventorySlot);
        getSolusHatFromSavant.addDialogStep("Current Assignment");
        this.goTalkToSirAmikAfterFinalBattle = new ConditionalStep((QuestHelper)this, (QuestStep)getSolusHatFromSavant, "Show Solus' Hat to Sir Amik Varze in Falador.", this.solusHat);
        ((ConditionalStep)this.goTalkToSirAmikAfterFinalBattle).addStep(new Conditions(this.solusHat, this.isInWhiteKnightsCastleF2), talkToSirAmikAfterSolusFight);
        ((ConditionalStep)this.goTalkToSirAmikAfterFinalBattle).addStep(this.isInWhiteKnightsCastleF1, this.climbToWhiteKnightsCastleF2);
        ((ConditionalStep)this.goTalkToSirAmikAfterFinalBattle).addStep(this.solusHat, this.climbToWhiteKnightsCastleF1);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return QuestUtil.toArrayList(this.essence, this.lightSource, this.rope.hideConditioned(this.placedRope), this.combatGear, this.commorbComponentsOrTenThousandGp);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return QuestUtil.toArrayList(this.amuletOfGlory, this.ringOfDueling, this.faladorTeleport, this.varrockTeleport, this.canifisTeleport, this.spinyHelmet);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        return QuestUtil.toArrayList(new QuestPointRequirement(32), new QuestRequirement(QuestHelperQuest.ENTER_THE_ABYSS, QuestState.FINISHED), new QuestRequirement(QuestHelperQuest.RECRUITMENT_DRIVE, QuestState.FINISHED), new QuestRequirement(QuestHelperQuest.THE_LOST_TRIBE, QuestState.FINISHED), new QuestRequirement(QuestHelperQuest.PRIEST_IN_PERIL, QuestState.FINISHED));
    }

    @Override
    public List<String> getCombatRequirements() {
        return Arrays.asList("Black Knight (level 33)", "Solus Dellagar (similar strength)");
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.SLAYER, 5000));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("Access to the White Knight's Armory"));
    }

    public ArrayList<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Getting started", Arrays.asList(this.talkToSirTiffy1, this.goTalkToSirAmik1, this.talkToSirTiffy2, this.goTalkToSirAmik2, this.talkToSirTiffy3, this.getCommorbFromSirTiffy, this.talkToSavantAfterGettingCommorb), this.commorbComponentsOrTenThousandGp));
        allSteps.add(new PanelDetails("Daquarius", Arrays.asList(this.talkToLordDaquarius, this.killBlackKnight, this.talkToIntimidatedLordDaquarius), this.combatGear, this.commorb));
        allSteps.add(new PanelDetails("Mage of Zamorak", Arrays.asList(this.talkToMageOfZamorak, this.giveEssenceToMageOfZamorak), this.essence, this.commorb));
        allSteps.add(new PanelDetails("The Hunt for Solus", Arrays.asList(this.enterCanifis, this.huntDownSolus), this.lightSource, this.rope.hideConditioned(this.placedRope), this.spinyHelmet, this.commorb));
        allSteps.add(new PanelDetails("Final battle", Arrays.asList(this.goToEssenceMine, this.killSolus, this.goTalkToSirAmikAfterFinalBattle), this.combatGear, this.commorb));
        return allSteps;
    }
}

