/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.vampyreslayer;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.NpcCondition;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.VAMPYRE_SLAYER)
public class VampyreSlayer
extends BasicQuestHelper {
    ItemRequirement hammer;
    ItemRequirement beer;
    ItemRequirement garlic;
    ItemRequirement garlicObtainable;
    ItemRequirement stake;
    ItemRequirement combatGear;
    ItemRequirement varrockTeleport;
    ItemRequirement draynorManorTeleport;
    Requirement inManor;
    Requirement inBasement;
    Requirement isUpstairsInMorgans;
    Requirement draynorNearby;
    QuestStep talkToMorgan;
    QuestStep goUpstairsMorgan;
    QuestStep getGarlic;
    QuestStep ifNeedGarlic;
    QuestStep talkToHarlow;
    QuestStep talkToHarlowAgain;
    QuestStep enterDraynorManor;
    QuestStep goDownToBasement;
    QuestStep openCoffin;
    QuestStep killDraynor;
    Zone manor;
    Zone basement;
    Zone upstairsInMorgans;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupRequirements();
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToMorgan);
        ConditionalStep getGarlicAndStake = new ConditionalStep((QuestHelper)this, this.goUpstairsMorgan, new Requirement[0]);
        getGarlicAndStake.addStep(this.garlic, this.talkToHarlow);
        getGarlicAndStake.addStep(this.isUpstairsInMorgans, this.getGarlic);
        steps.put(1, getGarlicAndStake);
        ConditionalStep prepareAndKillDraynor = new ConditionalStep((QuestHelper)this, (QuestStep)getGarlicAndStake, new Requirement[0]);
        prepareAndKillDraynor.addStep(this.draynorNearby, this.killDraynor);
        prepareAndKillDraynor.addStep(this.inBasement, this.openCoffin);
        prepareAndKillDraynor.addStep(this.inManor, this.goDownToBasement);
        prepareAndKillDraynor.addStep(this.stake, this.enterDraynorManor);
        steps.put(2, prepareAndKillDraynor);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.varrockTeleport = new ItemRequirement("Teleport to Varrock", 8007);
        this.draynorManorTeleport = new ItemRequirement("Draynor manor teleport", 19615);
        this.stake = new ItemRequirement("Stake", 1549);
        this.stake.setTooltip("You can get another from Dr. Harlow in the Blue Moon Inn in Varrock.");
        this.hammer = new ItemRequirement("Hammer", ItemCollections.HAMMER).isNotConsumed();
        this.garlic = new ItemRequirement("Garlic", 1550);
        this.garlic.setTooltip("Optional, makes Count Draynor weaker");
        this.beer = new ItemRequirement("A beer, or 2 coins to buy one", 1917);
        this.combatGear = new ItemRequirement("Combat gear + food to defeat Count Draynor", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.garlicObtainable = new ItemRequirement("Garlic", 1550);
        this.garlicObtainable.canBeObtainedDuringQuest();
    }

    public void setupConditions() {
        this.inBasement = new ZoneRequirement(this.basement);
        this.inManor = new ZoneRequirement(this.manor);
        this.isUpstairsInMorgans = new ZoneRequirement(this.upstairsInMorgans);
        this.draynorNearby = new NpcCondition(3481);
    }

    public void setupZones() {
        this.basement = new Zone(new WorldPoint(3074, 9767, 0), new WorldPoint(3081, 9779, 0));
        this.manor = new Zone(new WorldPoint(3097, 3354, 0), new WorldPoint(3119, 3373, 0));
        this.upstairsInMorgans = new Zone(new WorldPoint(3096, 3266, 1), new WorldPoint(3102, 3270, 1));
    }

    public void setupSteps() {
        this.talkToMorgan = new NpcStep((QuestHelper)this, 3479, new WorldPoint(3098, 3268, 0), "Talk to Morgan in the north of Draynor Village.", new Requirement[0]);
        this.talkToMorgan.addDialogStep("Ok, I'm up for an adventure.");
        this.talkToMorgan.addDialogStep("Accept quest");
        this.goUpstairsMorgan = new ObjectStep((QuestHelper)this, 15645, new WorldPoint(3100, 3267, 0), "Go upstairs in Morgan's house and search the cupboard for some garlic.", new Requirement[0]);
        this.getGarlic = new ObjectStep((QuestHelper)this, 2613, new WorldPoint(3096, 3270, 1), "Search the cupboard upstairs in Morgan's house.", new Requirement[0]);
        ((ObjectStep)this.getGarlic).addAlternateObjects(2612);
        this.ifNeedGarlic = new DetailedQuestStep((QuestHelper)this, "If you need garlic, you can get some from the cupboard upstairs in Morgan's house.", new Requirement[0]);
        this.ifNeedGarlic.addSubSteps(this.goUpstairsMorgan, this.getGarlic);
        this.talkToHarlow = new NpcStep((QuestHelper)this, 3480, new WorldPoint(3222, 3399, 0), "Talk to Dr. Harlow in the Blue Moon Inn in Varrock.", this.beer);
        this.talkToHarlow.addDialogStep("Morgan needs your help!");
        this.talkToHarlowAgain = new NpcStep((QuestHelper)this, 3480, new WorldPoint(3222, 3399, 0), "Talk to Dr. Harlow again with a beer. You can buy one for 2gp in the Blue Moon Inn.", this.beer);
        this.enterDraynorManor = new ObjectStep((QuestHelper)this, 134, new WorldPoint(3108, 3353, 0), "Prepare to fight Count Draynor (level 34), and enter Draynor Manor.", this.combatGear, this.stake, this.hammer, this.garlic);
        this.goDownToBasement = new ObjectStep((QuestHelper)this, 2616, new WorldPoint(3116, 3358, 0), "Enter Draynor Manor's basement.", this.combatGear, this.stake, this.hammer, this.garlic);
        this.openCoffin = new ObjectStep((QuestHelper)this, 46237, new WorldPoint(3078, 9776, 0), "Open the coffin and kill Count Draynor.", this.combatGear, this.stake, this.hammer, this.garlic);
        this.killDraynor = new NpcStep((QuestHelper)this, 3481, new WorldPoint(3077, 9769, 0), "Kill Count Draynor.", this.combatGear, this.stake, this.hammer, this.garlic);
        this.openCoffin.addSubSteps(this.killDraynor);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.hammer);
        reqs.add(this.beer);
        reqs.add(this.combatGear);
        return reqs;
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.varrockTeleport);
        reqs.add(this.draynorManorTeleport);
        reqs.add(this.garlicObtainable);
        return reqs;
    }

    @Override
    public List<String> getCombatRequirements() {
        ArrayList<String> reqs = new ArrayList<String>();
        reqs.add("Count Draynor (level 34)");
        return reqs;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(3);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.ATTACK, 4825));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Arrays.asList(this.talkToMorgan, this.ifNeedGarlic), new Requirement[0]));
        allSteps.add(new PanelDetails("Get a stake", Arrays.asList(this.talkToHarlow, this.talkToHarlowAgain), this.beer));
        allSteps.add(new PanelDetails("Kill Count Draynor", Arrays.asList(this.enterDraynorManor, this.goDownToBasement, this.openCoffin), this.hammer, this.stake, this.garlic, this.combatGear));
        return allSteps;
    }
}

