/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.trollstronghold;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemOnTileRequirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.ItemRequirements;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.TROLL_STRONGHOLD)
public class TrollStronghold
extends BasicQuestHelper {
    ItemRequirement climbingBoots;
    ItemRequirement climbingBootsOr12Coins;
    ItemRequirement climbingBootsEquipped;
    ItemRequirement coins12;
    ItemRequirement prisonKey;
    ItemRequirement cellKey1;
    ItemRequirement cellKey2;
    ItemRequirement mageRangedGear;
    ItemRequirement gamesNecklace;
    ItemRequirement foodAndPotions;
    Requirement inStrongholdFloor1;
    Requirement inStrongholdFloor2;
    Requirement inTenzingHut;
    Requirement onMountainPath;
    Requirement inTrollArea1;
    Requirement inArena;
    Requirement inNorthArena;
    Requirement beatenDad;
    Requirement inArenaCave;
    Requirement inTrollheimArea;
    Requirement prisonKeyNearby;
    Requirement prisonDoorUnlocked;
    Requirement inPrisonStairsRoom;
    Requirement inPrison;
    Requirement freedEadgar;
    Requirement freedGodric;
    Requirement cellKey1Nearby;
    Requirement cellKey2Nearby;
    QuestStep talkToDenulth;
    QuestStep buyClimbingBoots;
    QuestStep travelToTenzing;
    QuestStep getCoinsOrBoots;
    QuestStep climbOverStile;
    QuestStep climbOverRocks;
    QuestStep enterArena;
    QuestStep fightDad;
    QuestStep leaveArena;
    QuestStep enterArenaCavern;
    QuestStep leaveArenaCavern;
    QuestStep enterStronghold;
    QuestStep killGeneral;
    QuestStep pickupPrisonKey;
    QuestStep goDownInStronghold;
    QuestStep goThroughPrisonDoor;
    QuestStep goUpTo2ndFloor;
    QuestStep goDownToPrison;
    QuestStep getTwigKey;
    QuestStep getBerryKey;
    QuestStep pickupKey1;
    QuestStep pickupKey2;
    QuestStep freeEadgar;
    QuestStep freeGodric;
    QuestStep goToDunstan;
    Zone strongholdFloor1;
    Zone strongholdFloor2;
    Zone tenzingHut;
    Zone mountainPath1;
    Zone mountainPath2;
    Zone mountainPath3;
    Zone mountainPath4;
    Zone mountainPath5;
    Zone trollArea1;
    Zone arena;
    Zone northArena;
    Zone arenaCave;
    Zone trollheimArea;
    Zone prisonStairsRoom;
    Zone prison;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToDenulth);
        ConditionalStep enterTheStronghold = new ConditionalStep((QuestHelper)this, this.getCoinsOrBoots, new Requirement[0]);
        enterTheStronghold.addStep(new Conditions(this.freedEadgar, this.freedGodric), this.goToDunstan);
        enterTheStronghold.addStep(new Conditions(this.inPrison, this.freedEadgar, this.cellKey1), this.freeGodric);
        enterTheStronghold.addStep(new Conditions(this.inPrison, this.freedEadgar, this.cellKey1Nearby), this.pickupKey1);
        enterTheStronghold.addStep(new Conditions(this.inPrison, this.freedEadgar), this.getTwigKey);
        enterTheStronghold.addStep(new Conditions(this.inPrison, this.cellKey2), this.freeEadgar);
        enterTheStronghold.addStep(new Conditions(this.inPrison, this.cellKey2Nearby), this.pickupKey2);
        enterTheStronghold.addStep(this.inPrison, this.getBerryKey);
        enterTheStronghold.addStep(this.inPrisonStairsRoom, this.goDownToPrison);
        enterTheStronghold.addStep(new Conditions(new Conditions(LogicType.OR, this.prisonDoorUnlocked, this.prisonKey), this.inStrongholdFloor1), this.goThroughPrisonDoor);
        enterTheStronghold.addStep(new Conditions(new Conditions(LogicType.OR, this.prisonDoorUnlocked, this.prisonKey), this.inStrongholdFloor2), this.goDownInStronghold);
        enterTheStronghold.addStep(this.prisonKeyNearby, this.pickupPrisonKey);
        enterTheStronghold.addStep(this.inStrongholdFloor2, this.killGeneral);
        enterTheStronghold.addStep(this.inStrongholdFloor1, this.goUpTo2ndFloor);
        enterTheStronghold.addStep(this.inTrollheimArea, this.enterStronghold);
        enterTheStronghold.addStep(this.inArenaCave, this.leaveArenaCavern);
        enterTheStronghold.addStep(this.inNorthArena, this.enterArenaCavern);
        enterTheStronghold.addStep(new Conditions(this.inArena, this.beatenDad), this.leaveArena);
        enterTheStronghold.addStep(this.inArena, this.fightDad);
        enterTheStronghold.addStep(this.inTrollArea1, this.enterArena);
        enterTheStronghold.addStep(new Conditions(this.climbingBoots, this.onMountainPath), this.climbOverRocks);
        enterTheStronghold.addStep(new Conditions(this.climbingBoots, this.inTenzingHut), this.climbOverStile);
        enterTheStronghold.addStep(this.climbingBoots, this.travelToTenzing);
        enterTheStronghold.addStep(this.coins12, this.buyClimbingBoots);
        steps.put(10, enterTheStronghold);
        steps.put(20, enterTheStronghold);
        steps.put(30, enterTheStronghold);
        steps.put(40, enterTheStronghold);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.climbingBoots = new ItemRequirement("Climbing boots", 3105).isNotConsumed();
        this.climbingBootsEquipped = this.climbingBoots.equipped();
        this.coins12 = new ItemRequirement("Coins", ItemCollections.COINS, 12);
        this.climbingBootsOr12Coins = new ItemRequirements(LogicType.OR, "Climbing boots or 12 coins", this.climbingBoots, this.coins12).isNotConsumed();
        this.gamesNecklace = new ItemRequirement("Games necklace", ItemCollections.GAMES_NECKLACES);
        this.mageRangedGear = new ItemRequirement("Mage or ranged gear for safe spotting", -1, -1).isNotConsumed();
        this.mageRangedGear.setDisplayItemId(BankSlotIcons.getMagicCombatGear());
        this.foodAndPotions = new ItemRequirement("Food + prayer potions", ItemCollections.GOOD_EATING_FOOD, -1);
        this.prisonKey = new ItemRequirement("Prison key", 3135);
        this.cellKey1 = new ItemRequirement("Cell key 1", 3136);
        this.cellKey2 = new ItemRequirement("Cell key 2", 3137);
    }

    public void loadZones() {
        this.tenzingHut = new Zone(new WorldPoint(2814, 3553, 0), new WorldPoint(2822, 3562, 0));
        this.mountainPath1 = new Zone(new WorldPoint(2814, 3563, 0), new WorldPoint(2823, 3593, 0));
        this.mountainPath2 = new Zone(new WorldPoint(2824, 3589, 0), new WorldPoint(2831, 3599, 0));
        this.mountainPath3 = new Zone(new WorldPoint(2832, 3595, 0), new WorldPoint(2836, 3603, 0));
        this.mountainPath4 = new Zone(new WorldPoint(2837, 3601, 0), new WorldPoint(2843, 3607, 0));
        this.mountainPath5 = new Zone(new WorldPoint(2844, 3607, 0), new WorldPoint(2876, 3611, 0));
        this.trollArea1 = new Zone(new WorldPoint(2822, 3613, 0), new WorldPoint(2896, 3637, 0));
        this.arena = new Zone(new WorldPoint(2897, 3598, 0), new WorldPoint(2924, 3628, 0));
        this.northArena = new Zone(new WorldPoint(2898, 3629, 0), new WorldPoint(2927, 3644, 0));
        this.arenaCave = new Zone(new WorldPoint(2904, 10019, 0), new WorldPoint(2927, 10035, 0));
        this.trollheimArea = new Zone(new WorldPoint(2836, 3651, 0), new WorldPoint(2934, 3773, 0));
        this.strongholdFloor1 = new Zone(new WorldPoint(2820, 10048, 1), new WorldPoint(2862, 10110, 1));
        this.strongholdFloor2 = new Zone(new WorldPoint(2820, 10048, 2), new WorldPoint(2862, 10110, 2));
        this.prisonStairsRoom = new Zone(new WorldPoint(2848, 10104, 1), new WorldPoint(2857, 10110, 1));
        this.prison = new Zone(new WorldPoint(2822, 10049, 0), new WorldPoint(2859, 10110, 0));
    }

    public void setupConditions() {
        this.inTenzingHut = new ZoneRequirement(this.tenzingHut);
        this.onMountainPath = new ZoneRequirement(this.mountainPath1, this.mountainPath2, this.mountainPath3, this.mountainPath4, this.mountainPath5);
        this.inTrollArea1 = new ZoneRequirement(this.trollArea1);
        this.inArena = new ZoneRequirement(this.arena);
        this.inNorthArena = new ZoneRequirement(this.northArena);
        this.beatenDad = new VarplayerRequirement(317, 20, Operation.GREATER_EQUAL);
        this.prisonDoorUnlocked = new VarplayerRequirement(317, 30, Operation.GREATER_EQUAL);
        this.inArenaCave = new ZoneRequirement(this.arenaCave);
        this.inTrollheimArea = new ZoneRequirement(this.trollheimArea);
        this.inStrongholdFloor1 = new ZoneRequirement(this.strongholdFloor1);
        this.inStrongholdFloor2 = new ZoneRequirement(this.strongholdFloor2);
        this.inPrisonStairsRoom = new ZoneRequirement(this.prisonStairsRoom);
        this.inPrison = new ZoneRequirement(this.prison);
        this.prisonKeyNearby = new ItemOnTileRequirement(3135);
        this.cellKey1Nearby = new ItemOnTileRequirement(this.cellKey1);
        this.cellKey2Nearby = new ItemOnTileRequirement(this.cellKey2);
        this.freedEadgar = new VarbitRequirement(0, 1);
        this.freedGodric = new VarplayerRequirement(317, 40);
    }

    public void setupSteps() {
        this.talkToDenulth = new NpcStep((QuestHelper)this, 4083, new WorldPoint(2895, 3528, 0), "Talk to Denulth in Burthorpe.", new Requirement[0]);
        this.talkToDenulth.addDialogStep("How goes your fight with the trolls?");
        this.talkToDenulth.addDialogStep("Is there anything I can do to help?");
        this.talkToDenulth.addDialogStep("I'll get Godric back!");
        this.getCoinsOrBoots = new DetailedQuestStep((QuestHelper)this, "Get some climbing boots or 12 coins, and prepare for fighting Dad and the Troll General. Both can be safe spotted by ranged/mage.", this.climbingBootsOr12Coins);
        this.travelToTenzing = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2820, 3555, 0), "Follow the path west of Burthorpe, then go along the path going south.", new Requirement[0]);
        this.buyClimbingBoots = new NpcStep((QuestHelper)this, 4094, new WorldPoint(2820, 3555, 0), "Follow the path west of Burthorpe, then go along the path going south. Buy some climbing boots from Tenzing in his hut here.", this.coins12);
        this.buyClimbingBoots.addDialogStep("Can I buy some Climbing boots?");
        this.buyClimbingBoots.addDialogStep("OK, sounds good.");
        this.travelToTenzing.addSubSteps(this.getCoinsOrBoots, this.buyClimbingBoots);
        this.climbOverStile = new ObjectStep((QuestHelper)this, 3730, new WorldPoint(2817, 3563, 0), "Climb over the stile north of Tenzing.", new Requirement[0]);
        this.climbOverRocks = new ObjectStep((QuestHelper)this, 3748, new WorldPoint(2856, 3612, 0), "Follow the path until you reach some rocks. Climb over them.", this.climbingBootsEquipped);
        this.enterArena = new ObjectStep((QuestHelper)this, 3783, new WorldPoint(2897, 3619, 0), "Follow the path from here east until you enter the arena.", new Requirement[0]);
        this.fightDad = new NpcStep((QuestHelper)this, 4130, new WorldPoint(2913, 3617, 0), "Fight Dad until he gives up. You can safe spot him from the gate you entered through.", new Requirement[0]);
        this.fightDad.addDialogStep("I accept your challenge!");
        ((NpcStep)this.fightDad).addSafeSpots(new WorldPoint(2897, 3619, 0));
        this.leaveArena = new ObjectStep((QuestHelper)this, 3785, new WorldPoint(2916, 3629, 0), "Leave the arena and continue through the cave to the north.", new Requirement[0]);
        this.leaveArena.addDialogStep("I'll be going now.");
        this.enterArenaCavern = new ObjectStep((QuestHelper)this, 3757, new WorldPoint(2904, 3645, 0), "Enter the cave entrance.", new Requirement[0]);
        this.leaveArenaCavern = new ObjectStep((QuestHelper)this, 3758, new WorldPoint(2907, 10037, 0), "Leave through cave's north exit.", new Requirement[0]);
        this.enterStronghold = new ObjectStep((QuestHelper)this, 3771, new WorldPoint(2839, 3690, 0), "Follow the path around Trollheim until you reach the Stronghold's entrance. Be wary of thrower trolls on the path, you'll want to use Protect from Ranged.", new Requirement[0]);
        if (this.client.getRealSkillLevel(Skill.AGILITY) >= 47) {
            this.enterStronghold.getText().add("They can be avoided by taking the agility shortcuts across the mountain.");
        }
        this.killGeneral = new NpcStep((QuestHelper)this, 4120, new WorldPoint(2830, 10086, 2), "Enter the west rooms and kill any of the Troll Generals for a prison key.", new Requirement[0]);
        this.pickupPrisonKey = new ItemStep((QuestHelper)this, "Pick up the prison key.", this.prisonKey);
        this.goDownInStronghold = new ObjectStep((QuestHelper)this, 3789, new WorldPoint(2844, 10109, 2), "Climb down the north staircase.", new Requirement[0]);
        this.goThroughPrisonDoor = new ObjectStep((QuestHelper)this, 3780, new WorldPoint(2848, 10107, 1), "Enter the prison door.", new Requirement[0]);
        this.goUpTo2ndFloor = new ObjectStep((QuestHelper)this, 3788, new WorldPoint(2843, 10109, 1), "Go back up the stairs.", new Requirement[0]);
        this.goDownToPrison = new ObjectStep((QuestHelper)this, 3789, new WorldPoint(2853, 10108, 1), "Climb down the stairs to the prison.", new Requirement[0]);
        if (this.client.getRealSkillLevel(Skill.THIEVING) >= 30) {
            this.getTwigKey = new NpcStep((QuestHelper)this, 4133, new WorldPoint(2833, 10079, 0), "Pickpocket or kill Twig for a cell key.", new Requirement[0]);
            this.getBerryKey = new NpcStep((QuestHelper)this, 4134, new WorldPoint(2833, 10083, 0), "Pickpocket or kill Berry for a cell key.", new Requirement[0]);
        } else {
            this.getTwigKey = new NpcStep((QuestHelper)this, 4133, new WorldPoint(2833, 10079, 0), "Kill Twig for a cell key.", new Requirement[0]);
            this.getBerryKey = new NpcStep((QuestHelper)this, 4134, new WorldPoint(2833, 10083, 0), "Kill Berry for a cell key.", new Requirement[0]);
        }
        ((NpcStep)this.getTwigKey).addAlternateNpcs(4131);
        ((NpcStep)this.getBerryKey).addAlternateNpcs(4132);
        this.pickupKey1 = new ItemStep((QuestHelper)this, "Pickup the key.", this.cellKey1);
        this.pickupKey2 = new ItemStep((QuestHelper)this, "Pickup the key.", this.cellKey2);
        this.getTwigKey.addSubSteps(this.pickupKey1);
        this.getBerryKey.addSubSteps(this.pickupKey2);
        this.freeGodric = new ObjectStep((QuestHelper)this, 3767, new WorldPoint(2832, 10078, 0), "Unlock Godric's cell.", new Requirement[0]);
        this.freeEadgar = new ObjectStep((QuestHelper)this, 3765, new WorldPoint(2832, 10082, 0), "Unlock Eadgar's cell.", new Requirement[0]);
        this.goToDunstan = new NpcStep((QuestHelper)this, 4105, new WorldPoint(2919, 3574, 0), "Talk to Dunstan in north east Burthorpe to finish the quest.", new Requirement[0]);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.climbingBootsOr12Coins);
        return reqs;
    }

    @Override
    public List<String> getCombatRequirements() {
        ArrayList<String> reqs = new ArrayList<String>();
        reqs.add("Dad (level 101) (safespottable)");
        reqs.add("Troll General (level 113) (safespottable)");
        return reqs;
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.gamesNecklace);
        reqs.add(this.foodAndPotions);
        reqs.add(this.mageRangedGear);
        return reqs;
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new QuestRequirement(QuestHelperQuest.DEATH_PLATEAU, QuestState.FINISHED));
        req.add(new SkillRequirement(Skill.AGILITY, 15, true, "15 Agility (47+ Agility is recommended)"));
        return req;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("Law Talisman", 1458, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Ability to make Law Runes"), new UnlockReward("Access to Trollheim and the Troll Stronghold"), new UnlockReward("Access to the God Wars Dungeon"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Collections.singletonList(this.talkToDenulth), new Requirement[0]));
        allSteps.add(new PanelDetails("Reach the Stronghold", Arrays.asList(this.travelToTenzing, this.climbOverStile, this.climbOverRocks, this.enterArena, this.fightDad, this.leaveArena, this.enterArenaCavern, this.leaveArenaCavern, this.enterStronghold), this.climbingBootsOr12Coins, this.mageRangedGear, this.foodAndPotions));
        allSteps.add(new PanelDetails("Free the prisoners", Arrays.asList(this.killGeneral, this.goDownInStronghold, this.goThroughPrisonDoor, this.goDownToPrison, this.getBerryKey, this.freeEadgar, this.getTwigKey, this.freeGodric), new Requirement[0]));
        allSteps.add(new PanelDetails("Finish off", Collections.singletonList(this.goToDunstan), new Requirement[0]));
        return allSteps;
    }
}

