/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.trollromance;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.conditional.NpcCondition;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.TROLL_ROMANCE)
public class TrollRomance
extends BasicQuestHelper {
    ItemRequirement ironBar;
    ItemRequirement mapleLog;
    ItemRequirement rope;
    ItemRequirement cakeTin;
    ItemRequirement swampTar;
    ItemRequirement bucketOfWax;
    ItemRequirement wax;
    ItemRequirement sled;
    ItemRequirement waxedSled;
    ItemRequirement trollweissFlowers;
    ItemRequirement combatGear;
    ItemRequirement sledEquipped;
    ItemRequirement climbingBoots;
    ItemRequirement gamesNeck;
    Requirement inStrongholdFloor1;
    Requirement inStrongholdFloor2;
    Requirement inPrison;
    Requirement inTrollweiss;
    Requirement atFlowerLocation;
    Requirement inTrollCave;
    Requirement fightableArrgNearby;
    DetailedQuestStep enterStronghold;
    DetailedQuestStep goDownToUg;
    DetailedQuestStep goUpToUg;
    DetailedQuestStep talkToUg;
    DetailedQuestStep talkToAga;
    DetailedQuestStep talkToTenzing;
    DetailedQuestStep talkToDunstan;
    DetailedQuestStep talkToDunstanAgain;
    DetailedQuestStep useTarOnWax;
    DetailedQuestStep useWaxOnSled;
    DetailedQuestStep enterTrollCave;
    DetailedQuestStep leaveTrollCave;
    DetailedQuestStep equipSled;
    DetailedQuestStep sledSouth;
    DetailedQuestStep goDownToUgAgain;
    DetailedQuestStep goUpToUgAgain;
    DetailedQuestStep enterStrongholdAgain;
    DetailedQuestStep talkToUgWithFlowers;
    DetailedQuestStep goDownToUgForFight;
    DetailedQuestStep goUpToUgForFight;
    DetailedQuestStep enterStrongholdForFight;
    DetailedQuestStep goDownToUgForEnd;
    DetailedQuestStep goUpToUgForEnd;
    DetailedQuestStep enterStrongholdForEnd;
    DetailedQuestStep challengeArrg;
    DetailedQuestStep killArrg;
    DetailedQuestStep returnToUg;
    ObjectStep pickFlowers;
    Zone strongholdFloor1;
    Zone strongholdFloor2;
    Zone prison;
    Zone trollweiss;
    Zone flowerLocation;
    Zone trollCave;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        ConditionalStep startingOffSteps = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterStronghold, new Requirement[0]);
        startingOffSteps.addStep(this.inStrongholdFloor1, this.talkToUg);
        startingOffSteps.addStep(this.inPrison, this.goUpToUg);
        startingOffSteps.addStep(this.inStrongholdFloor2, this.goDownToUg);
        steps.put(0, startingOffSteps);
        steps.put(5, this.talkToAga);
        steps.put(10, this.talkToTenzing);
        steps.put(15, this.talkToDunstan);
        steps.put(20, this.talkToDunstanAgain);
        ConditionalStep getSled = new ConditionalStep((QuestHelper)this, (QuestStep)this.useTarOnWax, new Requirement[0]);
        getSled.addStep(this.wax, this.useWaxOnSled);
        steps.put(22, getSled);
        ConditionalStep getFlower = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterTrollCave, new Requirement[0]);
        getFlower.addStep(this.atFlowerLocation, this.pickFlowers);
        getFlower.addStep(new Conditions(this.inTrollweiss, this.sledEquipped), this.sledSouth);
        getFlower.addStep(this.inTrollweiss, this.equipSled);
        getFlower.addStep(this.inTrollCave, this.leaveTrollCave);
        steps.put(25, getFlower);
        ConditionalStep bringFlowerToUg = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterStrongholdAgain, new Requirement[0]);
        bringFlowerToUg.addStep(this.inStrongholdFloor1, this.talkToUgWithFlowers);
        bringFlowerToUg.addStep(this.inPrison, this.goUpToUgAgain);
        bringFlowerToUg.addStep(this.inStrongholdFloor2, this.goDownToUgAgain);
        steps.put(30, bringFlowerToUg);
        ConditionalStep defeatArrg = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterStrongholdForFight, new Requirement[0]);
        defeatArrg.addStep(this.fightableArrgNearby, this.killArrg);
        defeatArrg.addStep(this.inStrongholdFloor1, this.challengeArrg);
        defeatArrg.addStep(this.inPrison, this.goUpToUgForFight);
        defeatArrg.addStep(this.inStrongholdFloor2, this.goDownToUgForFight);
        steps.put(35, defeatArrg);
        ConditionalStep finishQuest = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterStrongholdForEnd, new Requirement[0]);
        finishQuest.addStep(this.inStrongholdFloor1, this.returnToUg);
        finishQuest.addStep(this.inPrison, this.goUpToUgForEnd);
        finishQuest.addStep(this.inStrongholdFloor2, this.goDownToUgForEnd);
        steps.put(40, finishQuest);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.ironBar = new ItemRequirement("Iron bar", 2351);
        this.mapleLog = new ItemRequirement("Maple/yew logs", 1517);
        this.mapleLog.addAlternates(1515);
        this.rope = new ItemRequirement("Rope", 954);
        this.cakeTin = new ItemRequirement("Cake tin", 1887);
        this.swampTar = new ItemRequirement("Swamp tar", 1939);
        this.swampTar.setHighlightInInventory(true);
        this.bucketOfWax = new ItemRequirement("Bucket of wax", 30);
        this.bucketOfWax.setHighlightInInventory(true);
        this.wax = new ItemRequirement("Wax", 4085);
        this.wax.setHighlightInInventory(true);
        this.sled = new ItemRequirement("Sled", 4083);
        this.sled.setTooltip("You can have Dunstan make another. Bring him a maple log, a rope and an iron bar");
        this.sled.setHighlightInInventory(true);
        this.waxedSled = new ItemRequirement("Sled", 4084);
        this.waxedSled.setTooltip("You can have Dunstan make another. Bring him a maple log, a rope and an iron bar. You then can apply some wax to it");
        this.sledEquipped = new ItemRequirement("Sled", 4084, 1, true);
        this.sledEquipped.setHighlightInInventory(true);
        this.sledEquipped.setTooltip("You can have Dunstan make another. Bring him a maple log, a rope and an iron bar. You then can apply some wax to it");
        this.trollweissFlowers = new ItemRequirement("Trollweiss", 4086);
        this.trollweissFlowers.setTooltip("You can get another from the Trollweiss mountain");
        this.climbingBoots = new ItemRequirement("Climbing boots", ItemCollections.CLIMBING_BOOTS).isNotConsumed();
        this.combatGear = new ItemRequirement("Combat gear, food, and potions", -1, -1);
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.gamesNeck = new ItemRequirement("Games necklace", ItemCollections.GAMES_NECKLACES);
    }

    public void loadZones() {
        this.strongholdFloor1 = new Zone(new WorldPoint(2820, 10048, 1), new WorldPoint(2862, 10110, 1));
        this.strongholdFloor2 = new Zone(new WorldPoint(2820, 10048, 2), new WorldPoint(2862, 10110, 2));
        this.prison = new Zone(new WorldPoint(2822, 10049, 0), new WorldPoint(2859, 10110, 0));
        this.trollweiss = new Zone(new WorldPoint(2753, 3801, 0), new WorldPoint(2816, 3877, 0));
        this.flowerLocation = new Zone(new WorldPoint(2771, 3771, 0), new WorldPoint(2817, 3800, 0));
        this.trollCave = new Zone(new WorldPoint(2764, 10184, 0), new WorldPoint(2808, 10237, 0));
    }

    public void setupConditions() {
        this.inStrongholdFloor1 = new ZoneRequirement(this.strongholdFloor1);
        this.inStrongholdFloor2 = new ZoneRequirement(this.strongholdFloor2);
        this.inPrison = new ZoneRequirement(this.prison);
        this.inTrollweiss = new ZoneRequirement(this.trollweiss);
        this.inTrollCave = new ZoneRequirement(this.trollCave);
        this.atFlowerLocation = new ZoneRequirement(this.flowerLocation);
        this.fightableArrgNearby = new NpcCondition(643);
    }

    public void setupSteps() {
        this.enterStronghold = new ObjectStep((QuestHelper)this, 3771, new WorldPoint(2839, 3690, 0), "Enter the Troll Stronghold.", new Requirement[0]);
        this.goDownToUg = new ObjectStep((QuestHelper)this, 3789, new WorldPoint(2844, 10109, 2), "Climb down the north staircase.", new Requirement[0]);
        this.goDownToUg.setWorldMapPoint(new WorldPoint(2971, 10172, 1));
        this.goUpToUg = new ObjectStep((QuestHelper)this, 3788, new WorldPoint(2853, 10107, 0), "Go up the stairs from the prison.", new Requirement[0]);
        this.goUpToUg.setWorldMapPoint(new WorldPoint(2853, 10106, 1));
        this.talkToUg = new NpcStep((QuestHelper)this, 640, new WorldPoint(2827, 10064, 1), "Talk to Ug in the south west room of the Troll Stronghold's first floor.", new Requirement[0]);
        this.talkToUg.addDialogSteps("Awww, you poor troll. What seems to be the problem?", "Don't worry now, I'll see what I can do.");
        this.talkToUg.setWorldMapPoint(new WorldPoint(2891, 10097, 0));
        this.talkToUg.addSubSteps(this.enterStronghold, this.goDownToUg, this.goUpToUg);
        this.talkToAga = new NpcStep((QuestHelper)this, 641, new WorldPoint(2828, 10104, 1), "Talk to Aga north of Ug.", new Requirement[0]);
        this.talkToAga.addDialogStep("So... how's your... um... love life?");
        this.talkToAga.setWorldMapPoint(new WorldPoint(2892, 10136, 0));
        this.talkToTenzing = new NpcStep((QuestHelper)this, 4094, new WorldPoint(2820, 3555, 0), "Talk to Tenzing west of Burthorpe.", new Requirement[0]);
        this.talkToTenzing.addDialogSteps("Do you know where I can find Trollweiss?", "What would I need to make such a sled?");
        this.talkToDunstan = new NpcStep((QuestHelper)this, 4105, new WorldPoint(2919, 3574, 0), "Talk to Dunstan in north east Burthorpe.", this.ironBar, this.mapleLog, this.rope);
        this.talkToDunstan.addDialogSteps("Talk about a quest.", "I need a sled!!", "No.");
        this.talkToDunstanAgain = new NpcStep((QuestHelper)this, 4105, new WorldPoint(2919, 3574, 0), "Talk to Dunstan again.", this.ironBar, this.mapleLog, this.rope);
        this.talkToDunstanAgain.addDialogSteps("Talk about a quest.");
        this.useTarOnWax = new DetailedQuestStep((QuestHelper)this, "Use some swamp tar on a bucket of wax.", this.swampTar, this.bucketOfWax, this.cakeTin);
        this.useWaxOnSled = new DetailedQuestStep((QuestHelper)this, "Use the wax on the sled.", this.wax, this.sled);
        this.enterTrollCave = new ObjectStep((QuestHelper)this, 5007, new WorldPoint(2821, 3744, 0), "Enter the cave north of Trollheim. There are high leveled ice trolls in here, so Protect from Melee and be careful!", this.waxedSled);
        this.leaveTrollCave = new ObjectStep((QuestHelper)this, 5025, new WorldPoint(2772, 10233, 0), "Leave the cave via the north crevice.", new Requirement[0]);
        this.equipSled = new DetailedQuestStep((QuestHelper)this, "Equip the sled.", this.sledEquipped);
        this.sledSouth = new ObjectStep((QuestHelper)this, 5015, new WorldPoint(2773, 3835, 0), "Sled to the south.", this.sledEquipped);
        this.pickFlowers = new ObjectStep((QuestHelper)this, 5006, new WorldPoint(2781, 3783, 0), "Pick a rare flower.", new Requirement[0]);
        this.enterStrongholdAgain = new ObjectStep((QuestHelper)this, 3771, new WorldPoint(2839, 3690, 0), "Return to Ug with the trollweiss flowers.", this.trollweissFlowers, this.combatGear);
        this.goDownToUgAgain = new ObjectStep((QuestHelper)this, 3789, new WorldPoint(2844, 10109, 2), "Return to Ug with the trollweiss flowers.", new Requirement[0]);
        this.goDownToUgAgain.setWorldMapPoint(new WorldPoint(2971, 10172, 1));
        this.goUpToUgAgain = new ObjectStep((QuestHelper)this, 3788, new WorldPoint(2853, 10107, 0), "Return to Ug with the trollweiss flowers.", new Requirement[0]);
        this.goUpToUgAgain.setWorldMapPoint(new WorldPoint(2853, 10106, 1));
        this.talkToUgWithFlowers = new NpcStep((QuestHelper)this, 640, new WorldPoint(2827, 10064, 1), "Return to Ug with the trollweiss flowers.", this.trollweissFlowers);
        this.talkToUgWithFlowers.setWorldMapPoint(new WorldPoint(2891, 10097, 0));
        this.talkToUgWithFlowers.addSubSteps(this.enterStrongholdAgain, this.goDownToUgAgain, this.goUpToUgAgain);
        this.enterStrongholdForEnd = new ObjectStep((QuestHelper)this, 3771, new WorldPoint(2839, 3690, 0), "Return to Ug to finish.", new Requirement[0]);
        this.goDownToUgForEnd = new ObjectStep((QuestHelper)this, 3789, new WorldPoint(2844, 10109, 2), "Return to Ug to finish.", new Requirement[0]);
        this.goDownToUgForEnd.setWorldMapPoint(new WorldPoint(2971, 10172, 1));
        this.goUpToUgForEnd = new ObjectStep((QuestHelper)this, 3788, new WorldPoint(2853, 10107, 0), "Return to Ug to finish.", new Requirement[0]);
        this.goUpToUgForEnd.setWorldMapPoint(new WorldPoint(2853, 10106, 1));
        this.enterStrongholdForFight = new ObjectStep((QuestHelper)this, 3771, new WorldPoint(2839, 3690, 0), "Challenge Arrg to a fight.", this.combatGear);
        this.goDownToUgForFight = new ObjectStep((QuestHelper)this, 3789, new WorldPoint(2844, 10109, 2), "Challenge Arrg to a fight.", this.combatGear);
        this.goDownToUgForFight.setWorldMapPoint(new WorldPoint(2971, 10172, 1));
        this.goUpToUgForFight = new ObjectStep((QuestHelper)this, 3788, new WorldPoint(2853, 10107, 0), "Challenge Arrg to a fight.", this.combatGear);
        this.goUpToUgForFight.setWorldMapPoint(new WorldPoint(2853, 10106, 1));
        this.challengeArrg = new NpcStep((QuestHelper)this, 642, new WorldPoint(2829, 10095, 1), "Challenge Arrg to a fight.", this.combatGear);
        this.challengeArrg.addDialogStep("I am here to kill you!");
        this.challengeArrg.setWorldMapPoint(new WorldPoint(2892, 10127, 0));
        this.challengeArrg.addSubSteps(this.enterStrongholdForFight, this.goUpToUgForFight, this.goDownToUgForFight);
        this.killArrg = new NpcStep((QuestHelper)this, 643, "Kill Arrg.", new Requirement[0]);
        this.returnToUg = new NpcStep((QuestHelper)this, 640, new WorldPoint(2827, 10064, 1), "Talk to Ug in the south west room to finish the quest.", new Requirement[0]);
        this.returnToUg.setWorldMapPoint(new WorldPoint(2891, 10097, 0));
        this.returnToUg.addSubSteps(this.goDownToUgForEnd, this.goUpToUgForEnd, this.enterStrongholdForEnd);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.ironBar, this.mapleLog, this.rope, this.cakeTin, this.swampTar, this.bucketOfWax, this.combatGear, this.climbingBoots);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.gamesNeck);
    }

    @Override
    public List<String> getCombatRequirements() {
        ArrayList<String> reqs = new ArrayList<String>();
        reqs.add("Arrg (level 113) can be safe spotted");
        return reqs;
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new QuestRequirement(QuestHelperQuest.TROLL_STRONGHOLD, QuestState.FINISHED));
        req.add(new SkillRequirement(Skill.AGILITY, 28));
        return req;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(2);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.AGILITY, 8000), new ExperienceReward(Skill.STRENGTH, 4000));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Diamond", 1601, 1), new ItemReward("Rubies", 1603, 2), new ItemReward("Emeralds", 1605, 4), new ItemReward("A Sled", 4083, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("Sledding route from Trollweiss Mountain."));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Arrays.asList(this.talkToUg, this.talkToAga), this.climbingBoots));
        allSteps.add(new PanelDetails("Make a sled", Arrays.asList(this.talkToTenzing, this.talkToDunstan, this.talkToDunstanAgain, this.useTarOnWax, this.useWaxOnSled), this.mapleLog, this.ironBar, this.rope, this.swampTar, this.bucketOfWax, this.cakeTin));
        allSteps.add(new PanelDetails("Get flowers", Arrays.asList(this.enterTrollCave, this.leaveTrollCave, this.equipSled, this.sledSouth, this.pickFlowers), this.waxedSled));
        allSteps.add(new PanelDetails("Fighting for Aga", Arrays.asList(this.talkToUgWithFlowers, this.challengeArrg, this.killArrg, this.returnToUg), this.trollweissFlowers, this.combatGear));
        return allSteps;
    }
}

