/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.tribaltotem;

import com.google.common.collect.ImmutableMap;
import com.questhelper.collections.ItemCollections;
import com.questhelper.helpers.quests.tribaltotem.PuzzleStep;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.conditional.ObjectCondition;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.widget.WidgetTextRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.TRIBAL_TOTEM)
public class TribalTotem
extends BasicQuestHelper {
    ItemRequirement addressLabel;
    ItemRequirement totem;
    ItemRequirement coins;
    ItemRequirement amuletOfGlory;
    ItemRequirement ardougneTeleports;
    QuestStep talkToKangaiMau;
    QuestStep investigateCrate;
    QuestStep useLabel;
    QuestStep talkToEmployee;
    QuestStep talkToCromperty;
    QuestStep enterPassword;
    QuestStep solvePassword;
    QuestStep climbStairs;
    QuestStep searchChest;
    QuestStep leaveHouse;
    QuestStep talkToKangaiMauAgain;
    Requirement inEntrance;
    Requirement inMiddleRoom;
    Requirement openedLockWidget;
    Requirement inStairway;
    Requirement investigatedStairs;
    Requirement isUpstairs;
    Requirement chestOpened;
    Zone houseGroundFloorEntrance;
    Zone houseGroundFloorMiddleRoom;
    Zone houseGroundFloor;
    Zone houseFirstFloor;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        ConditionalStep useLabelOnCrate = new ConditionalStep((QuestHelper)this, this.investigateCrate, new Requirement[0]);
        useLabelOnCrate.addStep(this.addressLabel, this.useLabel);
        ConditionalStep navigateMansion = new ConditionalStep((QuestHelper)this, this.talkToCromperty, new Requirement[0]);
        navigateMansion.addStep(this.totem.alsoCheckBank(this.questBank), this.talkToKangaiMauAgain);
        navigateMansion.addStep(new Conditions(this.openedLockWidget, this.inMiddleRoom), this.solvePassword);
        navigateMansion.addStep(this.inStairway, this.climbStairs);
        navigateMansion.addStep(this.isUpstairs, this.searchChest);
        navigateMansion.addStep(this.inEntrance, this.enterPassword);
        navigateMansion.addStep(this.inMiddleRoom, this.enterPassword);
        return new ImmutableMap.Builder().put((Object)0, (Object)this.talkToKangaiMau).put((Object)1, (Object)useLabelOnCrate).put((Object)2, (Object)this.talkToEmployee).put((Object)3, (Object)this.talkToCromperty).put((Object)4, (Object)navigateMansion).build();
    }

    @Override
    public void setupRequirements() {
        this.coins = new ItemRequirement("Coins or more for boat trips", ItemCollections.COINS, 90);
        this.amuletOfGlory = new ItemRequirement("Amulet of glory", ItemCollections.AMULET_OF_GLORIES).isNotConsumed();
        this.ardougneTeleports = new ItemRequirement("Ardougne teleports", 8011);
        this.addressLabel = new ItemRequirement("Address label", 1858);
        this.addressLabel.setHighlightInInventory(true);
        this.totem = new ItemRequirement("Totem", 1857);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.coins);
        reqs.add(this.amuletOfGlory);
        reqs.add(this.ardougneTeleports);
        return reqs;
    }

    public void loadZones() {
        this.houseGroundFloorEntrance = new Zone(new WorldPoint(2637, 3320, 0), new WorldPoint(2639, 3325, 0));
        this.houseGroundFloorMiddleRoom = new Zone(new WorldPoint(2634, 3322, 0), new WorldPoint(2636, 3324, 0));
        this.houseGroundFloor = new Zone(new WorldPoint(2629, 3321, 0), new WorldPoint(2633, 3325, 0));
        this.houseFirstFloor = new Zone(new WorldPoint(2630, 3318, 1), new WorldPoint(2639, 3323, 1));
    }

    public void setupConditions() {
        this.inEntrance = new ZoneRequirement(this.houseGroundFloorEntrance);
        this.inMiddleRoom = new ZoneRequirement(this.houseGroundFloorMiddleRoom);
        this.openedLockWidget = new WidgetTextRequirement(369, 54, "Combination Lock Door");
        this.inStairway = new ZoneRequirement(this.houseGroundFloor);
        this.investigatedStairs = new WidgetTextRequirement(229, 1, "Your trained senses as a thief enable you to see that there is a trap<br>in these stairs. You make a note of its location for future reference<br>when using these stairs.");
        this.isUpstairs = new ZoneRequirement(this.houseFirstFloor);
        this.chestOpened = new ObjectCondition(2710);
    }

    public void setupSteps() {
        this.talkToKangaiMau = new NpcStep((QuestHelper)this, 5316, new WorldPoint(2794, 3182, 0), "Talk to Kangai Mau in the Brimhaven food store.", new Requirement[0]);
        this.talkToKangaiMau.addDialogSteps("I'm in search of adventure!", "Ok, I will get it back.");
        this.investigateCrate = new ObjectStep((QuestHelper)this, 2707, new WorldPoint(2650, 3273, 0), "Travel to the GPDT depot in Ardougne and investigate the most northeastern crate for a label.", new Requirement[0]);
        this.useLabel = new ObjectStep((QuestHelper)this, 2708, new WorldPoint(2650, 3271, 0), "Use the label on the highlighted crate.", this.addressLabel);
        this.useLabel.addIcon(1858);
        this.talkToEmployee = new NpcStep((QuestHelper)this, 5313, new WorldPoint(2647, 3272, 0), "Talk to a nearby GPDT employee.", true, new Requirement[0]);
        this.talkToEmployee.addDialogStep("So, when are you going to deliver this crate?");
        this.talkToCromperty = new NpcStep((QuestHelper)this, 8480, new WorldPoint(2683, 3326, 0), "Talk to Wizard Cromperty in north east Ardougne.", new Requirement[0]);
        this.talkToCromperty.addDialogSteps("Chat.", "So what have you invented?", "Can I be teleported please?", "Yes, that sounds good. Teleport me!");
        this.enterPassword = new ObjectStep((QuestHelper)this, 2705, new WorldPoint(2634, 3323, 0), "Try and open the door to the west. The password is 'KURT', (K=10 right, U=6 left, R=9 left, T=7 left)", new Requirement[0]);
        this.solvePassword = new PuzzleStep(this);
        this.climbStairs = new ObjectStep((QuestHelper)this, 2711, new WorldPoint(2632, 3323, 0), "FIRST Right-click 'Investigate' the stairs to disable a trap, then climb the stairs.", new Requirement[0]);
        this.searchChest = new ObjectStep((QuestHelper)this, 2709, new WorldPoint(2638, 3324, 1), "Open the chest on the top floor and search it for the totem.", new Requirement[0]);
        ((ObjectStep)this.searchChest).addAlternateObjects(2710);
        this.leaveHouse = new DetailedQuestStep((QuestHelper)this, "Travel back to Brimhaven.", new Requirement[0]);
        this.talkToKangaiMauAgain = new NpcStep((QuestHelper)this, 5316, new WorldPoint(2794, 3182, 0), "Return to Kangai Mau in Brimhaven.", this.totem);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        return Collections.singletonList(new SkillRequirement(Skill.THIEVING, 21, true));
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.THIEVING, 1775));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("Swordfish", 373, 5));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Retrieving the totem", Arrays.asList(this.talkToKangaiMau, this.investigateCrate, this.useLabel, this.talkToEmployee, this.talkToCromperty, this.enterPassword, this.solvePassword, this.climbStairs, this.searchChest, this.talkToKangaiMauAgain), new Requirement[0]));
        return allSteps;
    }
}

