/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.treegnomevillage;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.questinfo.QuestVarPlayer;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemOnTileRequirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.npc.NpcHintArrowRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.TREE_GNOME_VILLAGE)
public class TreeGnomeVillage
extends BasicQuestHelper {
    ItemRequirement logRequirement;
    ItemRequirement orbsOfProtection;
    private QuestStep talkToCommanderMontai;
    private QuestStep bringWoodToCommanderMontai;
    private QuestStep talkToCommanderMontaiAgain;
    private QuestStep firstTracker;
    private QuestStep secondTracker;
    private QuestStep thirdTracker;
    private QuestStep fireBallista;
    private QuestStep fireBallista1;
    private QuestStep fireBallista2;
    private QuestStep fireBallista3;
    private QuestStep fireBallista4;
    private QuestStep climbTheLadder;
    private QuestStep talkToKingBolrenFirstOrb;
    private QuestStep talkToTheWarlord;
    private QuestStep fightTheWarlord;
    private QuestStep returnOrbs;
    private QuestStep finishQuestDialog;
    private QuestStep elkoySkip;
    Requirement completeFirstTracker;
    Requirement completeSecondTracker;
    Requirement completeThirdTracker;
    Requirement handedInOrbs;
    Requirement notCompleteFirstTracker;
    Requirement notCompleteSecondTracker;
    Requirement notCompleteThirdTracker;
    Requirement orbsOfProtectionNearby;
    Requirement givenWood;
    private Conditions talkToSecondTracker;
    private Conditions talkToThirdTracker;
    private Conditions completedTrackers;
    private Conditions shouldFireBallista1;
    private Conditions shouldFireBallista2;
    private Conditions shouldFireBallista3;
    private Conditions shouldFireBallista4;
    private ConditionalStep retrieveOrb;
    private ConditionalStep talkToBolrenAtCentreOfMaze;
    private ConditionalStep fireBalistaConditional;
    private ConditionalStep returnFirstOrb;
    Zone upstairsTower;
    Zone zoneVillage;
    ZoneRequirement isUpstairsTower;
    ZoneRequirement insideGnomeVillage;
    private final int TRACKER_1_VARBITID = 599;
    private final int TRACKER_2_VARBITID = 600;
    private final int TRACKER_3_VARBITID = 601;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        return this.CreateSteps();
    }

    private Map<Integer, QuestStep> CreateSteps() {
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToBolrenAtCentreOfMaze);
        steps.put(1, this.talkToCommanderMontai);
        steps.put(2, this.bringWoodToCommanderMontai);
        steps.put(3, this.talkToCommanderMontaiAgain);
        steps.put(4, this.talkToTrackersStep());
        steps.put(5, this.retrieveOrbStep());
        steps.put(6, this.returnFirstOrb);
        steps.put(7, this.defeatWarlordStep());
        steps.put(8, this.returnOrbsStep());
        return steps;
    }

    private QuestStep talkToTrackersStep() {
        this.fireBalistaConditional = new ConditionalStep((QuestHelper)this, this.fireBallista, "Fire the ballista at the tower.", new Requirement[0]);
        this.fireBalistaConditional.addStep(this.shouldFireBallista1, this.fireBallista1);
        this.fireBalistaConditional.addStep(this.shouldFireBallista2, this.fireBallista2);
        this.fireBalistaConditional.addStep(this.shouldFireBallista3, this.fireBallista3);
        this.fireBalistaConditional.addStep(this.shouldFireBallista4, this.fireBallista4);
        this.fireBalistaConditional.addSubSteps(this.fireBallista, this.fireBallista1, this.fireBallista2, this.fireBallista3, this.fireBallista4);
        ConditionalStep talkToTrackers = new ConditionalStep((QuestHelper)this, this.firstTracker, new Requirement[0]);
        talkToTrackers.addStep(this.talkToSecondTracker, this.secondTracker);
        talkToTrackers.addStep(this.talkToThirdTracker, this.thirdTracker);
        talkToTrackers.addStep(this.completedTrackers, this.fireBalistaConditional);
        return talkToTrackers;
    }

    private QuestStep retrieveOrbStep() {
        this.retrieveOrb = new ConditionalStep((QuestHelper)this, this.climbTheLadder, "Enter the tower by the Crumbled wall and climb the ladder to retrieve the first orb from chest.", new Requirement[0]);
        ObjectStep getOrbFromChest = new ObjectStep((QuestHelper)this, 2183, new WorldPoint(2506, 3259, 1), "Retrieve the first orb from chest.", new Requirement[0]);
        getOrbFromChest.addAlternateObjects(2182);
        this.retrieveOrb.addStep(this.isUpstairsTower, getOrbFromChest);
        this.retrieveOrb.addSubSteps(getOrbFromChest, this.climbTheLadder);
        return this.retrieveOrb;
    }

    private QuestStep defeatWarlordStep() {
        NpcHintArrowRequirement fightingWarlord = new NpcHintArrowRequirement(7622);
        this.fightTheWarlord = new NpcStep((QuestHelper)this, 7622, new WorldPoint(2456, 3301, 0), "Defeat the warlord and retrieve orbs.", new Requirement[0]);
        this.talkToTheWarlord = new NpcStep((QuestHelper)this, 7621, new WorldPoint(2456, 3301, 0), "Talk to the Warlord south west of West Ardougne, ready to fight him.", new Requirement[0]);
        ItemRequirement food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        ItemRequirement combatGear = new ItemRequirement("A Weapon & Armour (magic is best)", -1);
        combatGear.setDisplayItemId(BankSlotIcons.getMagicCombatGear());
        ConditionalStep defeatTheWarlord = new ConditionalStep((QuestHelper)this, this.talkToTheWarlord, food, combatGear);
        defeatTheWarlord.addStep(fightingWarlord, this.fightTheWarlord);
        return defeatTheWarlord;
    }

    private QuestStep returnOrbsStep() {
        this.handedInOrbs = new VarbitRequirement(598, 1, Operation.GREATER_EQUAL);
        this.orbsOfProtectionNearby = new ItemOnTileRequirement(588);
        ItemStep pickupOrb = new ItemStep((QuestHelper)this, "Pick up the nearby Orbs of Protection.", this.orbsOfProtection);
        this.returnOrbs.addSubSteps(pickupOrb);
        ConditionalStep returnOrbsSteps = new ConditionalStep((QuestHelper)this, this.returnOrbs, new Requirement[0]);
        returnOrbsSteps.addStep(this.orbsOfProtectionNearby, pickupOrb);
        returnOrbsSteps.addStep(this.handedInOrbs, this.finishQuestDialog);
        return returnOrbsSteps;
    }

    @Override
    public void setupRequirements() {
        this.givenWood = new VarplayerRequirement(QuestVarPlayer.QUEST_TREE_GNOME_VILLAGE.getId(), 3, Operation.GREATER_EQUAL);
        this.logRequirement = new ItemRequirement("Logs", 1511, 6).hideConditioned(this.givenWood);
        this.orbsOfProtection = new ItemRequirement("Orbs of protection", 588);
        this.orbsOfProtection.setTooltip("You can retrieve the orbs of protection again by killing the Khazard Warlord again.");
    }

    private void setupZones() {
        this.upstairsTower = new Zone(new WorldPoint(2500, 3251, 1), new WorldPoint(2506, 3259, 1));
        this.zoneVillage = new Zone(new WorldPoint(2514, 3158, 0), new WorldPoint(2542, 3175, 0));
    }

    public void setupConditions() {
        this.notCompleteFirstTracker = new VarbitRequirement(599, 0);
        this.notCompleteSecondTracker = new VarbitRequirement(600, 0);
        this.notCompleteThirdTracker = new VarbitRequirement(601, 0);
        this.completeFirstTracker = new VarbitRequirement(599, 1);
        this.completeSecondTracker = new VarbitRequirement(600, 1);
        this.completeThirdTracker = new VarbitRequirement(601, 1);
        this.insideGnomeVillage = new ZoneRequirement(this.zoneVillage);
        this.isUpstairsTower = new ZoneRequirement(this.upstairsTower);
        this.talkToSecondTracker = new Conditions(LogicType.AND, this.completeFirstTracker, this.notCompleteSecondTracker);
        this.talkToThirdTracker = new Conditions(LogicType.AND, this.completeFirstTracker, this.notCompleteThirdTracker);
        this.completedTrackers = new Conditions(LogicType.AND, this.completeFirstTracker, this.completeSecondTracker, this.completeThirdTracker);
        this.shouldFireBallista1 = new Conditions(LogicType.AND, this.completedTrackers, new VarbitRequirement(602, 0));
        this.shouldFireBallista2 = new Conditions(LogicType.AND, this.completedTrackers, new VarbitRequirement(602, 1));
        this.shouldFireBallista3 = new Conditions(LogicType.AND, this.completedTrackers, new VarbitRequirement(602, 2));
        this.shouldFireBallista4 = new Conditions(LogicType.AND, this.completedTrackers, new VarbitRequirement(602, 3));
    }

    private void setupSteps() {
        NpcStep talkToKingBolren = new NpcStep((QuestHelper)this, 4963, new WorldPoint(2541, 3170, 0), "", new Requirement[0]);
        talkToKingBolren.addDialogStep("Can I help at all?");
        talkToKingBolren.addDialogStep("I would be glad to help.");
        DetailedQuestStep goThroughMaze = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2541, 3170, 0), "Follow the marked path to walk through the maze.", new Requirement[0]);
        List<WorldPoint> pathThroughMaze = Arrays.asList(new WorldPoint(2505, 3190, 0), new WorldPoint(2512, 3190, 0), new WorldPoint(2512, 3188, 0), new WorldPoint(2532, 3188, 0), new WorldPoint(2532, 3182, 0), new WorldPoint(2523, 3181, 0), new WorldPoint(2523, 3185, 0), new WorldPoint(2521, 3185, 0), new WorldPoint(2520, 3179, 0), new WorldPoint(2514, 3179, 0), new WorldPoint(2514, 3177, 0), new WorldPoint(2527, 3177, 0), new WorldPoint(2527, 3179, 0), new WorldPoint(2529, 3179, 0), new WorldPoint(2529, 3177, 0), new WorldPoint(2531, 3177, 0), new WorldPoint(2531, 3179, 0), new WorldPoint(2533, 3179, 0), new WorldPoint(2533, 3177, 0), new WorldPoint(2544, 3177, 0), new WorldPoint(2544, 3174, 0), new WorldPoint(2549, 3174, 0), new WorldPoint(2549, 3165, 0), new WorldPoint(2545, 3165, 0), new WorldPoint(2545, 3159, 0), new WorldPoint(2550, 3159, 0), new WorldPoint(2550, 3156, 0), new WorldPoint(2548, 3156, 0), new WorldPoint(2548, 3145, 0), new WorldPoint(2538, 3145, 0), new WorldPoint(2538, 3150, 0), new WorldPoint(2541, 3150, 0), new WorldPoint(2541, 3148, 0), new WorldPoint(2544, 3148, 0), new WorldPoint(2544, 3150, 0), new WorldPoint(2545, 3150, 0), new WorldPoint(2545, 3156, 0), new WorldPoint(2520, 3156, 0), new WorldPoint(2520, 3159, 0), new WorldPoint(2515, 3159, 0));
        goThroughMaze.setLinePoints(pathThroughMaze);
        this.talkToBolrenAtCentreOfMaze = new ConditionalStep((QuestHelper)this, (QuestStep)goThroughMaze, "Speak to King Bolren in the centre of the Tree Gnome Maze.", new Requirement[0]);
        this.talkToBolrenAtCentreOfMaze.addStep(this.insideGnomeVillage, talkToKingBolren);
        this.talkToBolrenAtCentreOfMaze.addSubSteps(talkToKingBolren, goThroughMaze);
        this.talkToCommanderMontai = new NpcStep((QuestHelper)this, 4964, new WorldPoint(2523, 3208, 0), "Speak with Commander Montai.", new Requirement[0]);
        this.talkToCommanderMontai.addDialogStep("Ok, I'll gather some wood.");
        this.bringWoodToCommanderMontai = new NpcStep((QuestHelper)this, 4964, new WorldPoint(2523, 3208, 0), "Speak with Commander Montai again to give him the wood.", this.logRequirement);
        this.talkToCommanderMontaiAgain = new NpcStep((QuestHelper)this, 4964, new WorldPoint(2523, 3208, 0), "Speak with Commander Montai.", new Requirement[0]);
        this.talkToCommanderMontaiAgain.addDialogStep("I'll try my best.");
        this.firstTracker = new NpcStep((QuestHelper)this, 4975, new WorldPoint(2501, 3261, 0), "Talk to the first tracker gnome to the northwest.", new Requirement[0]);
        this.secondTracker = new NpcStep((QuestHelper)this, 4976, new WorldPoint(2524, 3257, 0), "Talk to the second tracker gnome inside the jail.", new Requirement[0]);
        this.thirdTracker = new NpcStep((QuestHelper)this, 4977, new WorldPoint(2497, 3234, 0), "Talk to the third tracker gnome to the southwest.", new Requirement[0]);
        this.fireBallista = new ObjectStep((QuestHelper)this, 2181, new WorldPoint(2509, 3211, 0), "", new Requirement[0]);
        this.fireBallista1 = new ObjectStep((QuestHelper)this, 2181, new WorldPoint(2509, 3211, 0), "", new Requirement[0]);
        this.fireBallista1.addDialogStep("0001");
        this.fireBallista2 = new ObjectStep((QuestHelper)this, 2181, new WorldPoint(2509, 3211, 0), "", new Requirement[0]);
        this.fireBallista2.addDialogStep("0002");
        this.fireBallista3 = new ObjectStep((QuestHelper)this, 2181, new WorldPoint(2509, 3211, 0), "", new Requirement[0]);
        this.fireBallista3.addDialogStep("0003");
        this.fireBallista4 = new ObjectStep((QuestHelper)this, 2181, new WorldPoint(2509, 3211, 0), "", new Requirement[0]);
        this.fireBallista4.addDialogStep("0004");
        this.climbTheLadder = new ObjectStep((QuestHelper)this, 16683, new WorldPoint(2503, 3252, 0), "Climb the ladder", new Requirement[0]);
        ItemRequirement firstOrb = new ItemRequirement("Orb of protection", 587, 1);
        firstOrb.setTooltip("If you have lost the orb you can get another from the chest");
        this.talkToKingBolrenFirstOrb = new NpcStep((QuestHelper)this, 4963, new WorldPoint(2541, 3170, 0), "Speak to King Bolren in the centre of the Tree Gnome Maze.", firstOrb);
        this.talkToKingBolrenFirstOrb.addDialogStep("I will find the warlord and bring back the orbs.");
        this.elkoySkip = new NpcStep((QuestHelper)this, 4968, new WorldPoint(2505, 3191, 0), "Talk to Elkoy outside the maze to travel to the centre.", new Requirement[0]);
        this.returnFirstOrb = new ConditionalStep((QuestHelper)this, this.elkoySkip, "Speak to King Bolren in the centre of the Tree Gnome Maze.", new Requirement[0]);
        this.returnFirstOrb.addStep(this.insideGnomeVillage, this.talkToKingBolrenFirstOrb);
        this.returnFirstOrb.addSubSteps(this.talkToKingBolrenFirstOrb, this.elkoySkip);
        this.returnOrbs = new NpcStep((QuestHelper)this, 4963, new WorldPoint(2541, 3170, 0), "Talk to King Bolren in the centre of the Tree Gnome Maze.", this.orbsOfProtection);
        this.finishQuestDialog = new NpcStep((QuestHelper)this, 4963, new WorldPoint(2541, 3170, 0), "Speak to King Bolren in the centre of the Tree Gnome Maze.", new Requirement[0]);
        this.returnOrbs.addSubSteps(this.finishQuestDialog);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Collections.singletonList(this.logRequirement);
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("Khazard Warlord (level 112)");
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(2);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.ATTACK, 11450));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("Use of the Spirit Tree transportation method."));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> steps = new ArrayList<PanelDetails>();
        steps.add(new PanelDetails("Getting started", Collections.singletonList(this.talkToBolrenAtCentreOfMaze), new Requirement[0]));
        steps.add(new PanelDetails("The three trackers", Arrays.asList(this.talkToCommanderMontai, this.bringWoodToCommanderMontai, this.talkToCommanderMontaiAgain, this.firstTracker, this.secondTracker, this.thirdTracker, this.fireBalistaConditional), this.logRequirement));
        ItemRequirement food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        ItemRequirement combatGear = new ItemRequirement("Weapon & Armour (magic is best)", -1);
        combatGear.setDisplayItemId(BankSlotIcons.getMagicCombatGear());
        steps.add(new PanelDetails("Retrieving the orbs", Arrays.asList(this.retrieveOrb, this.elkoySkip, this.talkToKingBolrenFirstOrb, this.talkToTheWarlord, this.fightTheWarlord, this.returnOrbs), combatGear, food));
        return steps;
    }
}

