/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.toweroflife;

import com.questhelper.collections.ItemCollections;
import com.questhelper.helpers.quests.toweroflife.PuzzleSolver;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.FreeInventorySlotRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.PuzzleStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.TOWER_OF_LIFE)
public class TowerOfLife
extends BasicQuestHelper {
    ItemRequirement beer;
    ItemRequirement hammer;
    ItemRequirement saw;
    ItemRequirement buildersHat;
    ItemRequirement buildersShirt;
    ItemRequirement buildersTrousers;
    ItemRequirement buildersBoots;
    ItemRequirement buildersHatEquipped;
    ItemRequirement buildersShirtEquipped;
    ItemRequirement buildersTrousersEquipped;
    ItemRequirement buildersBootsEquipped;
    ItemRequirement pressureMachineSheets;
    ItemRequirement pressureMachineBalls;
    ItemRequirement pressureMachineWheels;
    ItemRequirement pipeMachinePipes;
    ItemRequirement pipeMachineRings;
    ItemRequirement pipeMachineRivets;
    ItemRequirement cageMetalBar;
    ItemRequirement cageBindingFluid;
    ItemRequirement rawSwordfish;
    ItemRequirement rawChicken;
    Requirement hasSpokenToNoFingers;
    Requirement isPressureMachineBuilt;
    Requirement isPressureMachineFixed;
    Requirement isPipeMachineBuilt;
    Requirement isPipeMachineFixed;
    Requirement isCageBuilt;
    Requirement isCageFixed;
    Requirement isTowerFixed;
    QuestStep talkToEffigy;
    QuestStep talkToBonafido;
    QuestStep talkToBlackeye;
    QuestStep talkToNoFingers;
    QuestStep pickpocketNoFingers;
    QuestStep getBeerForGuns;
    QuestStep talkToGuns;
    QuestStep getTrousers;
    QuestStep talkToBonafidoWithOutfit;
    QuestStep enterTower;
    QuestStep fixPressureMachineGetSheets;
    QuestStep fixPressureMachineGetBalls;
    QuestStep fixPressureMachineGetWheels;
    QuestStep buildPressureMachine;
    QuestStep calibratePressureMachine;
    QuestStep solvePressureMachinePuzzle;
    QuestStep fixPipeMachineGetPipes;
    QuestStep fixPipeMachineGetRings;
    QuestStep fixPipeMachineGetRivets;
    QuestStep buildPipeMachine;
    QuestStep solvePipeMachinePuzzle;
    QuestStep fixCageGetBars;
    QuestStep fixCageGetFluid;
    QuestStep buildCage;
    QuestStep solveCagePuzzle;
    QuestStep talkToEffigyAgain;
    QuestStep talkToHomunculusTopOfTower;
    QuestStep talkToHomunculusBasement;
    QuestStep climbUpToFloor1;
    QuestStep climbUpToFloor2;
    QuestStep climbUpToFloor3;
    QuestStep climbDownToGround;
    QuestStep climbDownToFloor1;
    QuestStep climbDownToFloor2;
    QuestStep climbDownToBasement;
    QuestStep climbBackDownToGround;
    QuestStep climbBackDownToFloor1;
    QuestStep climbBackDownToFloor2;
    QuestStep enterTowerAgain;
    QuestStep climbBackUpToFloor1;
    QuestStep climbBackUpToFloor2;
    QuestStep climbBackUpToFloor3;
    ConditionalStep getBuildersOutfit;
    ConditionalStep fixTheTower;
    ConditionalStep fixPressureMachine;
    ConditionalStep fixPipeMachine;
    ConditionalStep fixCage;
    ConditionalStep followTheAlchemists;
    ConditionalStep confrontEffigy;
    ConditionalStep confrontTheHomunculus;
    ConditionalStep scareTheAlchemists;
    ConditionalStep talkToHomunculusInDungeon;
    Zone towerBasement;
    Zone tower1;
    Zone tower2;
    Zone tower3;
    Zone tower4;
    Zone tower11;
    Zone tower12;
    Zone tower13;
    Zone tower14;
    Zone tower21;
    Zone tower22;
    Zone tower23;
    Zone tower24;
    Zone tower31;
    Zone tower32;
    Zone tower33;
    Zone tower34;
    Zone tower41;
    Zone tower42;
    Zone tower43;
    Zone tower44;
    ZoneRequirement inTower;
    ZoneRequirement inTowerBasement;
    ZoneRequirement inTowerGround;
    ZoneRequirement inTowerFloor1;
    ZoneRequirement inTowerFloor2;
    ZoneRequirement inTowerFloor3;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupRequirements();
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToEffigy);
        steps.put(2, this.talkToBonafido);
        steps.put(4, this.getBuildersOutfit);
        steps.put(6, this.enterTower);
        steps.put(8, this.fixTheTower);
        steps.put(10, this.followTheAlchemists);
        steps.put(11, this.confrontEffigy);
        steps.put(12, this.confrontTheHomunculus);
        steps.put(14, this.confrontTheHomunculus);
        steps.put(16, this.scareTheAlchemists);
        steps.put(17, this.talkToHomunculusInDungeon);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.rawSwordfish = new ItemRequirement("Raw swordfish (for diary task)", 371);
        this.rawChicken = new ItemRequirement("Raw chicken (for diary task)", 2138);
        this.beer = new ItemRequirement("Beer", 1917);
        this.hammer = new ItemRequirement("Hammer", ItemCollections.HAMMER).isNotConsumed();
        this.saw = new ItemRequirement("Saw", ItemCollections.SAW).isNotConsumed();
        this.buildersHat = new ItemRequirement("Hard Hat", 10862);
        this.buildersShirt = new ItemRequirement("Builder's Shirt", 10863);
        this.buildersTrousers = new ItemRequirement("Builder's Trousers", 10864);
        this.buildersBoots = new ItemRequirement("Builder's Boots", 10865);
        this.buildersHatEquipped = new ItemRequirement("Hard Hat", 10862, 1, true);
        this.buildersShirtEquipped = new ItemRequirement("Builder's Shirt", 10863, 1, true);
        this.buildersTrousersEquipped = new ItemRequirement("Builder's Trousers", 10864, 1, true);
        this.buildersBootsEquipped = new ItemRequirement("Builder's Boots", 10865, 1, true);
        this.pressureMachineSheets = new ItemRequirement("Metal sheets", 10873, 3);
        this.pressureMachineBalls = new ItemRequirement("Coloured balls", 10874, 4);
        this.pressureMachineWheels = new ItemRequirement("Valve wheels", 10875, 4);
        this.pipeMachinePipes = new ItemRequirement("Pipes", 10871, 4);
        this.pipeMachineRings = new ItemRequirement("Pipe rings", 10872, 5);
        this.pipeMachineRivets = new ItemRequirement("Rivets", 10866, 6);
        this.cageMetalBar = new ItemRequirement("Metal bars", 10876, 5);
        this.cageBindingFluid = new ItemRequirement("Binding fluid", 10870, 4);
    }

    public void setupZones() {
        WorldPoint z1a = new WorldPoint(2652, 3224, 0);
        WorldPoint z1b = new WorldPoint(2646, 3212, 0);
        WorldPoint z2a = new WorldPoint(2653, 3223, 0);
        WorldPoint z2b = new WorldPoint(2645, 3213, 0);
        WorldPoint z3a = new WorldPoint(2654, 3222, 0);
        WorldPoint z3b = new WorldPoint(2644, 3214, 0);
        WorldPoint z4a = new WorldPoint(2655, 3221, 0);
        WorldPoint z4b = new WorldPoint(2643, 3215, 0);
        this.towerBasement = new Zone(new WorldPoint(3010, 4354, 0), new WorldPoint(3068, 4412, 0));
        this.tower1 = new Zone(z1a, z1b.dz(3));
        this.tower2 = new Zone(z2a, z2b.dz(3));
        this.tower3 = new Zone(z3a, z3b.dz(3));
        this.tower4 = new Zone(z4a, z4b.dz(3));
        this.tower11 = new Zone(z1a, z1b);
        this.tower12 = new Zone(z2a, z2b);
        this.tower13 = new Zone(z3a, z3b);
        this.tower14 = new Zone(z4a, z4b);
        this.tower21 = new Zone(z1a.dz(1), z1b.dz(1));
        this.tower22 = new Zone(z2a.dz(1), z2b.dz(1));
        this.tower23 = new Zone(z3a.dz(1), z3b.dz(1));
        this.tower24 = new Zone(z4a.dz(1), z4b.dz(1));
        this.tower31 = new Zone(z1a.dz(2), z1b.dz(2));
        this.tower32 = new Zone(z2a.dz(2), z2b.dz(2));
        this.tower33 = new Zone(z3a.dz(2), z3b.dz(2));
        this.tower34 = new Zone(z4a.dz(2), z4b.dz(2));
        this.tower41 = new Zone(z1a.dz(3), z1b.dz(3));
        this.tower42 = new Zone(z2a.dz(3), z2b.dz(3));
        this.tower43 = new Zone(z3a.dz(3), z3b.dz(3));
        this.tower44 = new Zone(z4a.dz(3), z4b.dz(3));
    }

    public void setupConditions() {
        this.inTower = new ZoneRequirement(this.tower1, this.tower2, this.tower3, this.tower4);
        this.inTowerBasement = new ZoneRequirement(this.towerBasement);
        this.inTowerGround = new ZoneRequirement(this.tower11, this.tower12, this.tower13, this.tower14);
        this.inTowerFloor1 = new ZoneRequirement(this.tower21, this.tower22, this.tower23, this.tower24);
        this.inTowerFloor2 = new ZoneRequirement(this.tower31, this.tower32, this.tower33, this.tower34);
        this.inTowerFloor3 = new ZoneRequirement(this.tower41, this.tower42, this.tower43, this.tower44);
        this.isPressureMachineBuilt = new VarbitRequirement(3338, 1);
        this.isPressureMachineFixed = new VarbitRequirement(3338, 2);
        this.isPipeMachineBuilt = new VarbitRequirement(3339, 1);
        this.isPipeMachineFixed = new VarbitRequirement(3339, 2);
        this.isCageBuilt = new VarbitRequirement(3340, 1);
        this.isCageFixed = new VarbitRequirement(3340, 2);
        this.isTowerFixed = new VarbitRequirement(3354, 1);
    }

    public void setupSteps() {
        this.talkToEffigy = new NpcStep((QuestHelper)this, 3585, new WorldPoint(2637, 3218, 0), "Talk to Effigy outside the Tower of Life.", new Requirement[0]);
        this.talkToEffigy.addDialogStep("Sure, why not.");
        this.talkToBonafido = new NpcStep((QuestHelper)this, 3587, new WorldPoint(2651, 3228, 0), "Talk to Bonafido.", new Requirement[0]);
        this.setupGetBuildersCostume();
        this.enterTower = new ObjectStep((QuestHelper)this, 21814, new WorldPoint(2649, 3225, 0), "Enter the tower.", this.buildersHatEquipped, this.buildersShirtEquipped, this.buildersTrousersEquipped, this.buildersBootsEquipped);
        this.climbUpToFloor1 = new ObjectStep((QuestHelper)this, 21871, new WorldPoint(2645, 3220, 0), "Go upstairs.", new Requirement[0]);
        this.climbUpToFloor2 = new ObjectStep((QuestHelper)this, 21871, new WorldPoint(2653, 3220, 1), "Go upstairs.", new Requirement[0]);
        this.climbUpToFloor3 = new ObjectStep((QuestHelper)this, 17974, new WorldPoint(2647, 3221, 2), "Go upstairs.", new Requirement[0]);
        this.climbDownToGround = new ObjectStep((QuestHelper)this, 21872, new WorldPoint(2645, 3220, 1), "Go downstairs.", new Requirement[0]);
        this.climbDownToFloor1 = new ObjectStep((QuestHelper)this, 21872, new WorldPoint(2653, 3220, 2), "Go downstairs.", new Requirement[0]);
        this.climbDownToFloor2 = new ObjectStep((QuestHelper)this, 17975, new WorldPoint(2647, 3221, 3), "Go downstairs.", new Requirement[0]);
        this.climbDownToBasement = new ObjectStep((QuestHelper)this, 21944, new WorldPoint(2648, 3212, 0), "Go downstairs.", new Requirement[0]);
        this.enterTowerAgain = new ObjectStep((QuestHelper)this, 21814, new WorldPoint(2649, 3225, 0), "Go back into the tower.", new Requirement[0]);
        this.climbBackUpToFloor1 = new ObjectStep((QuestHelper)this, 21871, new WorldPoint(2645, 3220, 0), "Go back upstairs.", new Requirement[0]);
        this.climbBackUpToFloor2 = new ObjectStep((QuestHelper)this, 21871, new WorldPoint(2653, 3220, 1), "Go back upstairs.", new Requirement[0]);
        this.climbBackUpToFloor3 = new ObjectStep((QuestHelper)this, 17974, new WorldPoint(2647, 3221, 2), "Go back upstairs.", new Requirement[0]);
        this.climbBackDownToGround = new ObjectStep((QuestHelper)this, 21872, new WorldPoint(2645, 3220, 1), "Go back downstairs.", new Requirement[0]);
        this.climbBackDownToFloor1 = new ObjectStep((QuestHelper)this, 21872, new WorldPoint(2653, 3220, 2), "Go back downstairs.", new Requirement[0]);
        this.climbBackDownToFloor2 = new ObjectStep((QuestHelper)this, 17975, new WorldPoint(2647, 3221, 3), "Go back downstairs.", new Requirement[0]);
        this.setupFixTower();
        this.followTheAlchemists = new ConditionalStep((QuestHelper)this, this.enterTowerAgain, "Follow the alchemists.", new Requirement[0]);
        this.followTheAlchemists.addStep(this.inTowerGround, this.climbBackUpToFloor1);
        this.followTheAlchemists.addStep(this.inTowerFloor1, this.climbBackUpToFloor2);
        this.followTheAlchemists.addStep(this.inTowerFloor2, this.climbBackUpToFloor3);
        this.confrontEffigy = new ConditionalStep((QuestHelper)this, this.talkToEffigyAgain, "Confront the alchemists.", new Requirement[0]);
        this.confrontEffigy.addStep(this.inTowerFloor3, this.climbBackDownToFloor2);
        this.confrontEffigy.addStep(this.inTowerFloor2, this.climbBackDownToFloor1);
        this.confrontEffigy.addStep(this.inTowerFloor1, this.climbBackDownToGround);
        this.talkToHomunculusTopOfTower = new NpcStep((QuestHelper)this, 3590, new WorldPoint(2649, 3218, 3), "Talk to the homunculus.", new Requirement[0]);
        this.confrontTheHomunculus = new ConditionalStep((QuestHelper)this, this.enterTowerAgain, "Confront the homunculus.", new Requirement[0]);
        this.confrontTheHomunculus.addStep(this.inTowerGround, this.climbBackUpToFloor1);
        this.confrontTheHomunculus.addStep(this.inTowerFloor1, this.climbBackUpToFloor2);
        this.confrontTheHomunculus.addStep(this.inTowerFloor2, this.climbBackUpToFloor3);
        this.confrontTheHomunculus.addStep(this.inTowerFloor3, this.talkToHomunculusTopOfTower);
        this.talkToHomunculusTopOfTower.addDialogStep("With the aid of 5 fire runes.");
        this.talkToHomunculusTopOfTower.addDialogStep("With the help of the magical dragonstones!");
        this.talkToHomunculusTopOfTower.addDialogStep("Runecraft, enchant jewellery, perform alchemy.");
        this.talkToHomunculusTopOfTower.addDialogStep("Turn them into bananas or peaches!");
        this.talkToHomunculusTopOfTower.addDialogStep("Depends where you are headed, but teleport spells are a safe bet.");
        this.talkToHomunculusTopOfTower.addDialogStep("Yes, you can make magic potions to boost your skills.");
        this.talkToHomunculusTopOfTower.addDialogStep("By harnessing the power of the gods!");
        this.talkToHomunculusTopOfTower.addDialogStep("Yep, you can use the Telekinetic Grab spell.");
        this.talkToHomunculusTopOfTower.addDialogStep("Through the power of alchemy.");
        this.talkToHomunculusTopOfTower.addDialogStep("You have special powers - no surprise seeing how you were created.");
        this.talkToHomunculusTopOfTower.addDialogStep("How about Magic and Runecrafting?");
        this.talkToHomunculusTopOfTower.addDialogStep("Can't see why not, anything is possible.");
        this.talkToHomunculusTopOfTower.addDialogStep("Your very existense speaks of mystical forces.");
        this.talkToHomunculusTopOfTower.addDialogStep("Magic.");
        this.scareTheAlchemists = new ConditionalStep((QuestHelper)this, this.talkToEffigyAgain, "Scare the alchemists.", new Requirement[0]);
        this.scareTheAlchemists.addStep(this.inTowerFloor3, this.climbBackDownToFloor2);
        this.scareTheAlchemists.addStep(this.inTowerFloor2, this.climbBackDownToFloor1);
        this.scareTheAlchemists.addStep(this.inTowerFloor1, this.climbBackDownToGround);
        this.talkToHomunculusBasement = new NpcStep((QuestHelper)this, 3588, new WorldPoint(3040, 4400, 0), "Talk to the homunculus.", new Requirement[0]);
        this.talkToHomunculusInDungeon = new ConditionalStep((QuestHelper)this, this.enterTower, "Talk to the homunculus in the basement.", new Requirement[0]);
        this.talkToHomunculusInDungeon.addStep(this.inTowerBasement, this.talkToHomunculusBasement);
        this.talkToHomunculusInDungeon.addStep(this.inTowerGround, this.climbDownToBasement);
    }

    private void setupFixTower() {
        this.fixPressureMachineGetSheets = new ObjectStep((QuestHelper)this, 21913, new WorldPoint(2643, 3219, 0), "Get 3 Metal sheets.", new Requirement[0]);
        this.fixPressureMachineGetBalls = new ObjectStep((QuestHelper)this, 21914, new WorldPoint(2644, 3216, 0), "Get 4 Coloured balls.", new Requirement[0]);
        this.fixPressureMachineGetWheels = new ObjectStep((QuestHelper)this, 21912, new WorldPoint(2655, 3217, 0), "Get 4 Valve wheels.", new Requirement[0]);
        Conditions hasAllPressureItems = new Conditions(this.pressureMachineSheets, this.pressureMachineBalls, this.pressureMachineWheels);
        this.buildPressureMachine = new ObjectStep((QuestHelper)this, 21873, new WorldPoint(2649, 3223, 1), "Build the Pressure Machine.", this.saw, this.hammer);
        this.buildPressureMachine.addDialogStep("Yes");
        this.buildPressureMachine.addSubSteps(this.fixPressureMachineGetSheets, this.fixPressureMachineGetBalls, this.fixPressureMachineGetWheels, this.climbUpToFloor1, this.climbUpToFloor2, this.climbUpToFloor3, this.climbDownToGround, this.climbDownToFloor1, this.climbDownToFloor2);
        this.calibratePressureMachine = new ObjectStep((QuestHelper)this, 21873, new WorldPoint(2649, 3223, 1), "Calibrate the Pressure Machine.", new Requirement[0]);
        this.solvePressureMachinePuzzle = new PuzzleStep((QuestHelper)this, "Click the wheels to calibrate the machine", new PuzzleSolver(this.client)::pressureSolver, new Requirement[0]);
        this.fixPressureMachine = new ConditionalStep((QuestHelper)this, this.fixPressureMachineGetSheets, new Requirement[0]);
        this.fixPressureMachine.addStep(this.isPressureMachineBuilt, this.solvePressureMachinePuzzle);
        this.fixPressureMachine.addStep(new Conditions(hasAllPressureItems, this.inTowerFloor1), this.buildPressureMachine);
        this.fixPressureMachine.addStep(new Conditions(hasAllPressureItems, this.inTowerFloor2), this.climbDownToFloor1);
        this.fixPressureMachine.addStep(new Conditions(hasAllPressureItems, this.inTowerFloor3), this.climbDownToFloor2);
        this.fixPressureMachine.addStep(new Conditions(hasAllPressureItems, this.inTowerGround), this.climbUpToFloor1);
        this.fixPressureMachine.addStep(this.inTowerFloor1, this.climbDownToGround);
        this.fixPressureMachine.addStep(this.inTowerFloor2, this.climbDownToFloor1);
        this.fixPressureMachine.addStep(this.inTowerFloor3, this.climbDownToFloor2);
        this.fixPressureMachine.addStep(new Conditions(this.pressureMachineSheets, this.pressureMachineBalls), this.fixPressureMachineGetWheels);
        this.fixPressureMachine.addStep(this.pressureMachineSheets, this.fixPressureMachineGetBalls);
        this.fixPipeMachineGetPipes = new ObjectStep((QuestHelper)this, 21909, new WorldPoint(2648, 3222, 0), "Get 4 Pipes.", new Requirement[0]);
        this.fixPipeMachineGetRings = new ObjectStep((QuestHelper)this, 21910, new WorldPoint(2652, 3222, 0), "Get 5 Pipe rings.", new Requirement[0]);
        this.fixPipeMachineGetRivets = new ObjectStep((QuestHelper)this, 21911, new WorldPoint(2654, 3220, 0), "Get 6 Rivets.", new Requirement[0]);
        Conditions hasAllPipeItems = new Conditions(this.pipeMachinePipes, this.pipeMachineRings, this.pipeMachineRivets);
        this.buildPipeMachine = new ObjectStep((QuestHelper)this, 21943, new WorldPoint(2650, 3214, 2), "Build the Pipe Machine.", new Requirement[0]);
        this.buildPipeMachine.addDialogStep("Yes");
        this.buildPipeMachine.addSubSteps(this.fixPipeMachineGetPipes, this.fixPipeMachineGetRings, this.fixPipeMachineGetRivets, this.climbUpToFloor1, this.climbUpToFloor2, this.climbUpToFloor3, this.climbDownToGround, this.climbDownToFloor1, this.climbDownToFloor2);
        this.solvePipeMachinePuzzle = new PuzzleStep((QuestHelper)this, "Calibrate the pipe machine. Select pipe pieces on the right side of the UI to see where to put them.", new PuzzleSolver(this.client)::pipeSolver, new Requirement[0]);
        this.fixPipeMachine = new ConditionalStep((QuestHelper)this, this.fixPipeMachineGetPipes, new Requirement[0]);
        this.fixPipeMachine.addStep(this.isPipeMachineBuilt, this.solvePipeMachinePuzzle);
        this.fixPipeMachine.addStep(new Conditions(hasAllPipeItems, this.inTowerFloor2), this.buildPipeMachine);
        this.fixPipeMachine.addStep(new Conditions(hasAllPipeItems, this.inTowerFloor3), this.climbDownToFloor2);
        this.fixPipeMachine.addStep(new Conditions(hasAllPipeItems, this.inTowerFloor1), this.climbUpToFloor2);
        this.fixPipeMachine.addStep(new Conditions(hasAllPipeItems, this.inTowerGround), this.climbUpToFloor1);
        this.fixPipeMachine.addStep(this.inTowerFloor1, this.climbDownToGround);
        this.fixPipeMachine.addStep(this.inTowerFloor2, this.climbDownToFloor1);
        this.fixPipeMachine.addStep(this.inTowerFloor3, this.climbDownToFloor2);
        this.fixPipeMachine.addStep(new Conditions(this.pipeMachinePipes, this.pipeMachineRings), this.fixPipeMachineGetRivets);
        this.fixPipeMachine.addStep(this.pipeMachinePipes, this.fixPipeMachineGetRings);
        this.fixCageGetBars = new ObjectStep((QuestHelper)this, 21917, new WorldPoint(2650, 3212, 0), "Get 5 Metal bars.", new Requirement[0]);
        this.fixCageGetFluid = new ObjectStep((QuestHelper)this, 21915, new WorldPoint(2651, 3213, 0), "Get 4 Binding fluid.", new Requirement[0]);
        Conditions hasAllCageItems = new Conditions(this.cageMetalBar, this.cageBindingFluid);
        this.buildCage = new ObjectStep((QuestHelper)this, 21941, new WorldPoint(2649, 3218, 3), "Build the cage.", new Requirement[0]);
        this.buildCage.addDialogStep("Yes");
        this.buildCage.addSubSteps(this.fixCageGetBars, this.fixCageGetFluid, this.climbUpToFloor1, this.climbUpToFloor2, this.climbUpToFloor3, this.climbDownToGround, this.climbDownToFloor1, this.climbDownToFloor2);
        this.solveCagePuzzle = new PuzzleStep((QuestHelper)this, "Assemble the cage.", new PuzzleSolver(this.client)::cageSolver, new Requirement[0]);
        this.fixCage = new ConditionalStep((QuestHelper)this, this.fixCageGetBars, new Requirement[0]);
        this.fixCage.addStep(this.isCageBuilt, this.solveCagePuzzle);
        this.fixCage.addStep(new Conditions(hasAllCageItems, this.inTowerFloor3), this.buildCage);
        this.fixCage.addStep(new Conditions(hasAllCageItems, this.inTowerFloor2), this.climbUpToFloor3);
        this.fixCage.addStep(new Conditions(hasAllCageItems, this.inTowerFloor1), this.climbUpToFloor2);
        this.fixCage.addStep(new Conditions(hasAllCageItems, this.inTowerGround), this.climbUpToFloor1);
        this.fixCage.addStep(this.inTowerFloor1, this.climbDownToGround);
        this.fixCage.addStep(this.inTowerFloor2, this.climbDownToFloor1);
        this.fixCage.addStep(this.inTowerFloor3, this.climbDownToFloor2);
        this.fixCage.addStep(this.cageMetalBar, this.fixCageGetFluid);
        this.talkToEffigyAgain = new NpcStep((QuestHelper)this, 3585, new WorldPoint(2637, 3218, 0), "Go back and talk to Effigy.", new Requirement[0]);
        this.talkToEffigyAgain.addSubSteps(this.climbBackDownToGround, this.climbBackDownToFloor1, this.climbBackDownToFloor2);
        this.fixTheTower = new ConditionalStep((QuestHelper)this, this.enterTower, new Requirement[0]);
        this.fixTheTower.addStep(new Conditions(this.isTowerFixed, this.inTowerFloor1), this.climbBackDownToGround);
        this.fixTheTower.addStep(new Conditions(this.isTowerFixed, this.inTowerFloor2), this.climbBackDownToFloor1);
        this.fixTheTower.addStep(new Conditions(this.isTowerFixed, this.inTowerFloor3), this.climbBackDownToFloor2);
        this.fixTheTower.addStep(this.isTowerFixed, this.talkToEffigyAgain);
        this.fixTheTower.addStep(new Conditions(this.inTower, this.isPressureMachineFixed, this.isPipeMachineFixed), this.fixCage);
        this.fixTheTower.addStep(new Conditions(this.inTower, this.isPressureMachineFixed), this.fixPipeMachine);
        this.fixTheTower.addStep(this.inTower, this.fixPressureMachine);
    }

    private void setupGetBuildersCostume() {
        this.talkToBlackeye = new NpcStep((QuestHelper)this, 3596, "Get the Hard Hat from 'Black-eye'.", new Requirement[0]);
        this.talkToBlackeye.addDialogStep(3, "Three");
        this.talkToBlackeye.addDialogStep(1, "Torn curtains");
        this.talkToBlackeye.addDialogStep(2, "10 clay pieces");
        this.talkToNoFingers = new NpcStep((QuestHelper)this, 3597, new WorldPoint(2645, 3224, 0), "Talk to 'No fingers'.", new Requirement[0]);
        this.pickpocketNoFingers = new NpcStep((QuestHelper)this, 3597, new WorldPoint(2645, 3224, 0), "Pickpocket 'No fingers'.", new Requirement[0]);
        this.hasSpokenToNoFingers = new VarbitRequirement(3376, 1);
        ConditionalStep getBoots = new ConditionalStep((QuestHelper)this, this.talkToNoFingers, new Requirement[0]);
        getBoots.addStep(this.hasSpokenToNoFingers, this.pickpocketNoFingers);
        this.talkToGuns = new NpcStep((QuestHelper)this, 3599, new WorldPoint(2643, 3226, 0), "Talk to 'The Guns'.", new Requirement[0]);
        this.getBeerForGuns = new ItemStep((QuestHelper)this, "Get a Beer for 'The Guns'.", this.beer);
        ConditionalStep getShirt = new ConditionalStep((QuestHelper)this, this.getBeerForGuns, new Requirement[0]);
        getShirt.addStep(this.beer, this.talkToGuns);
        this.getTrousers = new ObjectStep((QuestHelper)this, 21924, "Search the bushes to the south for some Builder's Trousers.", new Requirement[0]);
        this.getTrousers.addText("(Hint: try the south-east bushes first).");
        ((DetailedQuestStep)this.getTrousers).setHideWorldArrow(true);
        this.talkToBonafidoWithOutfit = new NpcStep((QuestHelper)this, 3587, "Speak to Bonafido.", this.buildersHatEquipped, this.buildersShirtEquipped, this.buildersTrousersEquipped, this.buildersBootsEquipped);
        this.talkToBonafidoWithOutfit.addDialogStep(2, "Tea");
        this.talkToBonafidoWithOutfit.addDialogStep(3, "Whistle for attention");
        this.talkToBonafidoWithOutfit.addDialogStep(1, "Your legs are getting a bit cold");
        this.talkToBonafidoWithOutfit.addDialogStep(2, "Carry on, it'll fix itself");
        this.getBuildersOutfit = new ConditionalStep((QuestHelper)this, this.talkToBlackeye, new Requirement[0]);
        this.getBuildersOutfit.addStep(new Conditions(this.buildersHat, this.buildersBoots, this.buildersShirt, this.buildersTrousers), this.talkToBonafidoWithOutfit);
        this.getBuildersOutfit.addStep(new Conditions(this.buildersHat, this.buildersBoots, this.buildersShirt), this.getTrousers);
        this.getBuildersOutfit.addStep(new Conditions(this.buildersHat, this.buildersBoots), getShirt);
        this.getBuildersOutfit.addStep(this.buildersHat, getBoots);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.beer, this.hammer, this.saw);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.rawSwordfish, this.rawChicken);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        return Collections.singletonList(new SkillRequirement(Skill.CONSTRUCTION, 10));
    }

    @Override
    public List<Requirement> getGeneralRecommended() {
        return Collections.singletonList(new FreeInventorySlotRequirement(11));
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(2);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.CONSTRUCTION, 1000), new ExperienceReward(Skill.CRAFTING, 500), new ExperienceReward(Skill.THIEVING, 500));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("Access to Creature Creation."));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Arrays.asList(this.talkToEffigy, this.talkToBonafido), this.saw, this.hammer, this.beer));
        PanelDetails getBuildersOutfitPanel = new PanelDetails("Get the Builders' outfit", Arrays.asList(this.talkToBlackeye, this.talkToNoFingers, this.pickpocketNoFingers, this.getBeerForGuns, this.talkToGuns, this.getTrousers, this.talkToBonafidoWithOutfit), this.beer);
        getBuildersOutfitPanel.setLockingStep(this.getBuildersOutfit);
        allSteps.add(getBuildersOutfitPanel);
        allSteps.add(new PanelDetails("Fix the tower", Arrays.asList(this.enterTower, this.buildPressureMachine, this.solvePressureMachinePuzzle, this.buildPipeMachine, this.solvePipeMachinePuzzle, this.buildCage, this.solveCagePuzzle), this.saw, this.hammer));
        allSteps.add(new PanelDetails("The Alchemists' Secret", this.talkToEffigyAgain, this.followTheAlchemists, this.confrontEffigy, this.confrontTheHomunculus, this.scareTheAlchemists, this.talkToHomunculusInDungeon));
        return allSteps;
    }
}

