/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.toweroflife;

import com.questhelper.steps.WidgetDetails;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import net.runelite.api.Client;
import net.runelite.api.widgets.Widget;

public class PuzzleSolver {
    private Client client;
    private static final WidgetDetails PRSS_1_WHEEL_LEFT = new WidgetDetails(510, 128, 0);
    private static final WidgetDetails PRSS_1_WHEEL_RIGHT = new WidgetDetails(510, 129, 0);
    private static final WidgetDetails PRSS_2_WHEEL_LEFT = new WidgetDetails(510, 130, 0);
    private static final WidgetDetails PRSS_2_WHEEL_RIGHT = new WidgetDetails(510, 131, 0);
    private static final WidgetDetails PRSS_3_WHEEL_LEFT = new WidgetDetails(510, 132, 0);
    private static final WidgetDetails PRSS_3_WHEEL_RIGHT = new WidgetDetails(510, 133, 0);
    private static final WidgetDetails PRSS_4_WHEEL_LEFT = new WidgetDetails(510, 134, 0);
    private static final WidgetDetails PRSS_4_WHEEL_RIGHT = new WidgetDetails(510, 135, 0);
    private static final WidgetDetails PRSS_LEVER_LEFT = new WidgetDetails(510, 136, 0);
    private static final WidgetDetails PRSS_LEVER_RIGHT = new WidgetDetails(510, 141, 0);
    private static final int PRSS_VBIT_LL = 3356;
    private static final int PRSS_VBIT_LR = 3357;
    private static final int PRSS_VBIT_P1 = 3347;
    private static final int PRSS_VBIT_B1 = 3351;
    private static final int PRSS_VBIT_P2 = 3348;
    private static final int PRSS_VBIT_B2 = 3352;
    private static final int PRSS_VBIT_P3 = 3349;
    private static final int PRSS_VBIT_B3 = 3353;
    private static final int PRSS_VBIT_P4 = 3350;
    private static final int PRSS_VBIT_B4 = 3355;
    private boolean prss_3_passed = false;
    private boolean prss_4_passed = false;
    private static final WidgetDetails PIPE_CTRL_ROTATE = new WidgetDetails(511, 15, 0);
    private static final WidgetDetails PIPE_CTRL_LEFT = new WidgetDetails(511, 17, 0);
    private static final WidgetDetails PIPE_CTRL_RIGHT = new WidgetDetails(511, 19, 0);
    private static final WidgetDetails PIPE_CTRL_UP = new WidgetDetails(511, 21, 0);
    private static final WidgetDetails PIPE_CTRL_DOWN = new WidgetDetails(511, 23, 0);
    private static final WidgetDetails PIPE_PCE_1 = new WidgetDetails(511, 9, 0);
    private static final WidgetDetails PIPE_PCE_2 = new WidgetDetails(511, 10, 0);
    private static final WidgetDetails PIPE_PCE_3 = new WidgetDetails(511, 11, 0);
    private static final WidgetDetails PIPE_PCE_4 = new WidgetDetails(511, 12, 0);
    private static final WidgetDetails PIPE_PCE_5 = new WidgetDetails(511, 13, 0);
    private static final int PIPE_VBIT_1_SELECT = 3343;
    private static final int PIPE_VBIT_2_SELECT = 3341;
    private static final int PIPE_VBIT_3_SELECT = 3344;
    private static final int PIPE_VBIT_4_SELECT = 3345;
    private static final int PIPE_VBIT_5_SELECT = 3342;
    private static final int PIPE_PCE_1_ORIENTATION = 22547;
    private static final int PIPE_PCE_2_ORIENTATION = 22531;
    private static final int PIPE_PCE_3_ORIENTATION = 22555;
    private static final int PIPE_PCE_4_ORIENTATION = 22562;
    private static final int PIPE_PCE_5_ORIENTATION = 22539;
    private List<PipeSolverSolution> pipeSolverSolutions;
    private static final WidgetDetails CAGE_CTRL_LEFT = new WidgetDetails(509, 26, 0);
    private static final WidgetDetails CAGE_CTRL_RIGHT = new WidgetDetails(509, 29, 0);
    private static final WidgetDetails CAGE_CTRL_PLACE = new WidgetDetails(509, 32, 0);
    private static final WidgetDetails CAGE_CTRL_HORIZ = new WidgetDetails(509, 41, 0);
    private static final WidgetDetails CAGE_CTRL_VERT = new WidgetDetails(509, 44, 0);
    private static final WidgetDetails CAGE_CTRL_MINUS = new WidgetDetails(509, 49, 0);
    private static final WidgetDetails CAGE_CTRL_PLUS = new WidgetDetails(509, 52, 0);
    private static final WidgetDetails CAGE_INFO_SIZE = new WidgetDetails(509, 56, 0);
    private static final WidgetDetails CAGE_INFO_HORIZ = new WidgetDetails(509, 38, 0);
    private static final WidgetDetails CAGE_INFO_VERT = new WidgetDetails(509, 40, 0);
    private static final WidgetDetails CAGE_INFO_SIDE_1 = new WidgetDetails(509, 5, 0);
    private static final WidgetDetails CAGE_INFO_SIDE_2 = new WidgetDetails(509, 10, 0);
    private static final WidgetDetails CAGE_INFO_SIDE_3 = new WidgetDetails(509, 15, 0);
    private static final WidgetDetails CAGE_INFO_SIDE_4 = new WidgetDetails(509, 20, 0);
    private static final WidgetDetails CAGE_INFO_S1_P1 = new WidgetDetails(509, 7, 0);
    private static final WidgetDetails CAGE_INFO_S1_P2 = new WidgetDetails(509, 8, 0);
    private static final WidgetDetails CAGE_INFO_S1_P3 = new WidgetDetails(509, 9, 0);
    private static final WidgetDetails CAGE_INFO_S2_P1 = new WidgetDetails(509, 12, 0);
    private static final WidgetDetails CAGE_INFO_S2_P2 = new WidgetDetails(509, 13, 0);
    private static final WidgetDetails CAGE_INFO_S2_P3 = new WidgetDetails(509, 14, 0);
    private static final WidgetDetails CAGE_INFO_S3_P1 = new WidgetDetails(509, 17, 0);
    private static final WidgetDetails CAGE_INFO_S3_P2 = new WidgetDetails(509, 18, 0);
    private static final WidgetDetails CAGE_INFO_S3_P3 = new WidgetDetails(509, 19, 0);
    private static final WidgetDetails CAGE_INFO_S4_P1 = new WidgetDetails(509, 22, 0);
    private static final WidgetDetails CAGE_INFO_S4_P2 = new WidgetDetails(509, 23, 0);
    private static final WidgetDetails CAGE_INFO_S4_P3 = new WidgetDetails(509, 24, 0);
    private static final int CAGE_S1_P1_SOLVED = 22469;
    private static final int CAGE_S1_P2_SOLVED = 22472;
    private static final int CAGE_S1_P3_SOLVED = 22475;
    private static final int CAGE_S2_P1_SOLVED = 22480;
    private static final int CAGE_S2_P2_SOLVED = 22483;
    private static final int CAGE_S2_P3_SOLVED = 22486;
    private static final int CAGE_S3_P1_SOLVED = 22491;
    private static final int CAGE_S3_P2_SOLVED = 22494;
    private static final int CAGE_S3_P3_SOLVED = 22497;
    private static final int CAGE_S4_P1_SOLVED = 22502;
    private static final int CAGE_S4_P2_SOLVED = 22505;
    private static final int CAGE_S4_P3_SOLVED = 22508;
    private final HashSet<CageSideSolution> cage_solutions = new HashSet<CageSideSolution>(Arrays.asList(new CageSideSolution(CAGE_INFO_SIDE_1, new CageBarSolution(CAGE_INFO_S1_P1, true, 2, 22469), new CageBarSolution(CAGE_INFO_S1_P2, true, 2, 22472), new CageBarSolution(CAGE_INFO_S1_P3, false, 2, 22475)), new CageSideSolution(CAGE_INFO_SIDE_2, new CageBarSolution(CAGE_INFO_S2_P1, false, 2, 22480), new CageBarSolution(CAGE_INFO_S2_P2, true, 3, 22483), new CageBarSolution(CAGE_INFO_S2_P3, true, 2, 22486)), new CageSideSolution(CAGE_INFO_SIDE_3, new CageBarSolution(CAGE_INFO_S3_P1, false, 2, 22491), new CageBarSolution(CAGE_INFO_S3_P2, false, 4, 22494), new CageBarSolution(CAGE_INFO_S3_P3, true, 2, 22497)), new CageSideSolution(CAGE_INFO_SIDE_4, new CageBarSolution(CAGE_INFO_S4_P1, true, 4, 22502), new CageBarSolution(CAGE_INFO_S4_P2, false, 2, 22505), new CageBarSolution(CAGE_INFO_S4_P3, false, 3, 22508))));

    public PuzzleSolver(Client client) {
        this.client = client;
    }

    public HashSet<WidgetDetails> pressureSolver() {
        boolean prss_4_filled;
        boolean prss_3_filled;
        boolean prss_2_filled;
        boolean prss_1_filled;
        HashSet<WidgetDetails> highlights = new HashSet<WidgetDetails>();
        int ball1Pos = this.client.getVarbitValue(3351);
        boolean prss_1_locked = this.client.getVarbitValue(3356) != 0;
        boolean prss_1_plugged = this.client.getVarbitValue(3347) == 1;
        boolean bl = prss_1_filled = ball1Pos == 5;
        if (!prss_1_filled) {
            if (prss_1_locked) {
                highlights.add(PRSS_LEVER_LEFT);
            } else if (!prss_1_plugged) {
                highlights.add(PRSS_1_WHEEL_LEFT);
            } else {
                highlights.add(PRSS_1_WHEEL_RIGHT);
            }
            return highlights;
        }
        int ball2Pos = this.client.getVarbitValue(3352);
        boolean prss_2_locked = this.client.getVarbitValue(3356) != 1;
        boolean prss_2_plugged = this.client.getVarbitValue(3348) == 1;
        boolean bl2 = prss_2_filled = ball2Pos == 5;
        if (!prss_2_filled) {
            if (prss_2_locked) {
                highlights.add(PRSS_LEVER_LEFT);
            } else if (!prss_2_plugged) {
                highlights.add(PRSS_2_WHEEL_LEFT);
            } else {
                highlights.add(PRSS_2_WHEEL_RIGHT);
            }
            return highlights;
        }
        int ball3Pos = this.client.getVarbitValue(3353);
        boolean prss_3_locked = this.client.getVarbitValue(3357) != 0;
        boolean prss_3_plugged = this.client.getVarbitValue(3349) == 1;
        boolean bl3 = prss_3_filled = ball3Pos == 5;
        if (!prss_3_filled) {
            if (prss_3_locked) {
                highlights.add(PRSS_LEVER_RIGHT);
            } else if (!prss_3_plugged && ball3Pos >= 3) {
                highlights.add(PRSS_3_WHEEL_LEFT);
            } else if (!prss_3_plugged) {
                highlights.add(PRSS_3_WHEEL_RIGHT);
            } else {
                highlights.add(PRSS_3_WHEEL_RIGHT);
            }
            return highlights;
        }
        int ball4Pos = this.client.getVarbitValue(3355);
        boolean prss_4_locked = this.client.getVarbitValue(3357) != 1;
        boolean prss_4_plugged = this.client.getVarbitValue(3350) == 1;
        boolean bl4 = prss_4_filled = ball4Pos == 5;
        if (!prss_4_filled) {
            if (prss_4_locked) {
                highlights.add(PRSS_LEVER_RIGHT);
            } else if (!prss_4_plugged && ball4Pos >= 4) {
                highlights.add(PRSS_4_WHEEL_LEFT);
            } else if (!prss_4_plugged) {
                highlights.add(PRSS_4_WHEEL_RIGHT);
            } else {
                highlights.add(PRSS_4_WHEEL_RIGHT);
            }
            return highlights;
        }
        return highlights;
    }

    public HashSet<WidgetDetails> pipeSolver() {
        try {
            if (this.pipeSolverSolutions == null) {
                this.pipeSolverSolutions = Arrays.asList(new PipeSolverSolution(PIPE_PCE_1, 159, 69, 22547, 3343), new PipeSolverSolution(PIPE_PCE_2, 83, 80, 22531, 3341), new PipeSolverSolution(PIPE_PCE_3, 256, 60, 22555, 3344), new PipeSolverSolution(PIPE_PCE_4, 237, 155, 22562, 3345), new PipeSolverSolution(PIPE_PCE_5, 126, 64, 22539, 3342));
            }
            HashSet<WidgetDetails> highlights = new HashSet<WidgetDetails>();
            for (PipeSolverSolution soln : this.pipeSolverSolutions) {
                if (!soln.isSelected()) continue;
                if (!soln.isSelected()) {
                    highlights.add(soln.pieceInfo);
                } else if (!soln.isOriented()) {
                    highlights.add(PIPE_CTRL_ROTATE);
                } else if (soln.isRight()) {
                    highlights.add(PIPE_CTRL_LEFT);
                } else if (soln.isLeft()) {
                    highlights.add(PIPE_CTRL_RIGHT);
                } else if (soln.isBelow()) {
                    highlights.add(PIPE_CTRL_UP);
                } else if (soln.isAbove()) {
                    highlights.add(PIPE_CTRL_DOWN);
                }
                return highlights;
            }
            return highlights;
        }
        catch (WidgetNotFoundException e) {
            return new HashSet<WidgetDetails>();
        }
    }

    public HashSet<WidgetDetails> cageSolver() {
        HashSet<WidgetDetails> highlights = new HashSet<WidgetDetails>();
        for (CageSideSolution side : this.cage_solutions) {
            if (!side.isVisible()) continue;
            if (side.isSolved()) {
                highlights.add(CAGE_CTRL_RIGHT);
                break;
            }
            CageBarSolution curBar = side.getNext();
            if (!curBar.isCorrectOrientSelected()) {
                if (curBar.isHorizontal) {
                    highlights.add(CAGE_CTRL_HORIZ);
                    break;
                }
                highlights.add(CAGE_CTRL_VERT);
                break;
            }
            if (curBar.sizeTooBig()) {
                highlights.add(CAGE_CTRL_MINUS);
                break;
            }
            if (curBar.sizeTooSmall()) {
                highlights.add(CAGE_CTRL_PLUS);
                break;
            }
            highlights.add(CAGE_CTRL_PLACE);
            break;
        }
        return highlights;
    }

    protected Widget getWidget(WidgetDetails wi) {
        return this.client.getWidget(wi.getGroupID(), wi.getChildID());
    }

    private static class WidgetNotFoundException
    extends RuntimeException {
    }

    private class CageBarSolution {
        WidgetDetails target;
        boolean isHorizontal;
        int size;
        int solvedModel;

        public CageBarSolution(WidgetDetails target, boolean isHorizontal, int size, int solvedModelId) {
            this.target = target;
            this.isHorizontal = isHorizontal;
            this.size = size;
            this.solvedModel = solvedModelId;
        }

        public boolean isSolved() {
            return PuzzleSolver.this.getWidget(this.target).getModelId() == this.solvedModel;
        }

        public boolean isCorrectOrientSelected() {
            if (this.isHorizontal) {
                Widget w = PuzzleSolver.this.getWidget(CAGE_INFO_HORIZ);
                return w != null && !w.isHidden();
            }
            Widget w = PuzzleSolver.this.getWidget(CAGE_INFO_VERT);
            return w != null && !w.isHidden();
        }

        public boolean sizeTooSmall() {
            int curSize = Integer.parseInt(PuzzleSolver.this.getWidget(CAGE_INFO_SIZE).getText());
            return curSize < this.size;
        }

        public boolean sizeTooBig() {
            int curSize = Integer.parseInt(PuzzleSolver.this.getWidget(CAGE_INFO_SIZE).getText());
            return curSize > this.size;
        }
    }

    private class CageSideSolution {
        WidgetDetails side;
        CageBarSolution p1;
        CageBarSolution p2;
        CageBarSolution p3;

        public CageSideSolution(WidgetDetails side, CageBarSolution p1, CageBarSolution p2, CageBarSolution p3) {
            this.side = side;
            this.p1 = p1;
            this.p2 = p2;
            this.p3 = p3;
        }

        public boolean isVisible() {
            Widget w = PuzzleSolver.this.getWidget(this.side);
            return w != null && !w.isHidden();
        }

        public boolean isSolved() {
            return this.isVisible() && this.p1.isSolved() && this.p2.isSolved() && this.p3.isSolved();
        }

        public CageBarSolution getNext() {
            if (!this.p1.isSolved()) {
                return this.p1;
            }
            if (!this.p2.isSolved()) {
                return this.p2;
            }
            return this.p3;
        }
    }

    private class PipeSolverSolution {
        private final WidgetDetails pieceInfo;
        private final Widget piece;
        private final int correctOrientation;
        private final int selectedVBit;
        private final int targetX;
        private final int targetY;

        public PipeSolverSolution(WidgetDetails piece, int targetX, int targetY, int correctOrientation, int selectedVBit) {
            this(piece, targetX, targetY, correctOrientation, selectedVBit, Widget::getOriginalX, Widget::getOriginalY);
        }

        public PipeSolverSolution(WidgetDetails pieceDetails, int targetX, int targetY, int correctOrientation, int selectedVBit, Function<Widget, Integer> getPieceX, Function<Widget, Integer> getPieceY) {
            this.pieceInfo = pieceDetails;
            this.piece = PuzzleSolver.this.getWidget(this.pieceInfo);
            if (this.piece == null) {
                throw new WidgetNotFoundException();
            }
            this.targetX = targetX;
            this.targetY = targetY;
            this.correctOrientation = correctOrientation;
            this.selectedVBit = selectedVBit;
        }

        public boolean isSolved() {
            return !this.isSelected();
        }

        public boolean isSelected() {
            return PuzzleSolver.this.client.getVarbitValue(this.selectedVBit) == 1;
        }

        public boolean isLeft() {
            return this.piece.getOriginalX() < this.targetX - 4;
        }

        public boolean isRight() {
            return this.piece.getOriginalX() > this.targetX + 4;
        }

        public boolean isAbove() {
            return this.piece.getOriginalY() < this.targetY - 4;
        }

        public boolean isBelow() {
            return this.piece.getOriginalY() > this.targetY + 4;
        }

        public boolean isOriented() {
            return this.piece.getModelId() == this.correctOrientation;
        }
    }
}

