/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.throneofmiscellania;

import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.EmoteStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import com.questhelper.steps.emote.QuestEmote;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.THRONE_OF_MISCELLANIA)
public class ThroneOfMiscellania
extends BasicQuestHelper {
    ItemRequirement ironBar;
    ItemRequirement logs;
    ItemRequirement pickaxe;
    ItemRequirement rake;
    ItemRequirement axe;
    ItemRequirement harpoon;
    ItemRequirement lobsterPot;
    ItemRequirement reputationItems;
    ItemRequirement ring;
    ItemRequirement flowers;
    ItemRequirement cake;
    ItemRequirement bow;
    ItemRequirement giantNib;
    ItemRequirement giantPen;
    ItemRequirement goodAnthem;
    ItemRequirement awfulAnthem;
    ItemRequirement treaty;
    ItemRequirement runRestoreItems;
    ItemRequirement dramenStaff;
    ItemRequirement rellekkaTeleport;
    Requirement inIslands;
    Requirement inMiscCastleFirstFloor;
    Requirement inEtcCastleFirstFloor;
    Requirement inAstridRoom;
    Requirement inBrandRoom;
    Requirement talked1P1;
    Requirement talked1P2;
    Requirement talked1P3;
    Requirement givenFlowers;
    Requirement doneEmote;
    Requirement talked1P4;
    Requirement talked2P1;
    Requirement talked2P2;
    Requirement talked2P3;
    Requirement givenBowOrCake;
    Requirement talked2P4;
    Requirement talked3P1;
    Requirement talked3P2;
    Requirement talked3P3;
    Requirement blownKiss;
    Requirement diplomacyStep1;
    Requirement diplomacyStep2;
    Requirement diplomacyStep3;
    Requirement diplomacyStep4;
    Requirement diplomacyStep5;
    Requirement diplomacyStep6;
    Requirement hasCourted;
    Requirement has75Support;
    Requirement courtingBrand;
    DetailedQuestStep travelToMisc;
    DetailedQuestStep talkToVargas;
    DetailedQuestStep getFlowers;
    DetailedQuestStep goUpToVargas;
    DetailedQuestStep talkAstrid1;
    DetailedQuestStep talkAstrid2;
    DetailedQuestStep talkAstrid3;
    DetailedQuestStep talkBrand1;
    DetailedQuestStep talkBrand2;
    DetailedQuestStep talkBrand3;
    DetailedQuestStep giveFlowersToAstrid;
    DetailedQuestStep giveFlowersToBrand;
    DetailedQuestStep giveBowToAstrid;
    DetailedQuestStep giveCakeToBrand;
    DetailedQuestStep clapForBrand;
    DetailedQuestStep danceForAstrid;
    DetailedQuestStep goUpstairsToBrand;
    DetailedQuestStep blowKissToAstrid;
    DetailedQuestStep blowKissToBrand;
    DetailedQuestStep useRingOnAstrid;
    DetailedQuestStep useRingOnBrand;
    DetailedQuestStep goUpstairsToAstrid;
    DetailedQuestStep goUpEtcDip1;
    DetailedQuestStep talkToSigridDip1;
    DetailedQuestStep goDownEtcDip1;
    DetailedQuestStep goUpMiscDip1;
    DetailedQuestStep talkToVargasDip1;
    DetailedQuestStep goDownMiscDip1;
    DetailedQuestStep goUpEtcDip2;
    DetailedQuestStep talkToSigridDip2;
    DetailedQuestStep goDownEtcDip2;
    DetailedQuestStep goUpMiscDip2;
    DetailedQuestStep talkToBrandDip;
    DetailedQuestStep talkToGhrimDip;
    DetailedQuestStep goDownMiscDip2;
    DetailedQuestStep goUpEtcDip3;
    DetailedQuestStep talkToSigridDip3;
    DetailedQuestStep goDownEtcDip3;
    DetailedQuestStep goUpMiscDip3;
    DetailedQuestStep talkToVargasDip2;
    DetailedQuestStep goDownMiscDip3;
    DetailedQuestStep talkToDerrik;
    DetailedQuestStep makePen;
    DetailedQuestStep goUpMiscDip4;
    DetailedQuestStep giveVargasPen;
    DetailedQuestStep getAnotherAwfulAnthem;
    DetailedQuestStep get75Support;
    DetailedQuestStep goUpMiscForSupport;
    DetailedQuestStep goDownMiscForSupport;
    DetailedQuestStep finishQuest;
    ConditionalStep courtBrand;
    ConditionalStep courtAstrid;
    Zone islands;
    Zone miscCastleFirstFloor;
    Zone etcCastleFirstFloor;
    Zone brandRoom1;
    Zone brandRoom2;
    Zone astridRoom1;
    Zone astridRoom2;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        ConditionalStep startQuest = new ConditionalStep((QuestHelper)this, (QuestStep)this.travelToMisc, new Requirement[0]);
        startQuest.addStep(this.inMiscCastleFirstFloor, this.talkToVargas);
        startQuest.addStep(new Conditions(this.inIslands, this.flowers), this.goUpToVargas);
        startQuest.addStep(this.inIslands, this.getFlowers);
        steps.put(0, startQuest);
        this.courtAstrid = new ConditionalStep((QuestHelper)this, (QuestStep)this.travelToMisc, new Requirement[0]);
        this.courtAstrid.addStep(new Conditions(this.inMiscCastleFirstFloor, this.talked3P1, this.talked3P2, this.talked3P3, this.blownKiss), this.useRingOnAstrid);
        this.courtAstrid.addStep(new Conditions(this.inMiscCastleFirstFloor, this.talked3P1, this.talked3P2, this.talked3P3), this.blowKissToAstrid);
        this.courtAstrid.addStep(new Conditions(this.inMiscCastleFirstFloor, this.talked2P4), this.talkAstrid3);
        this.courtAstrid.addStep(new Conditions(this.inMiscCastleFirstFloor, this.talked2P1, this.talked2P2, this.talked2P3), this.giveBowToAstrid);
        this.courtAstrid.addStep(new Conditions(this.inMiscCastleFirstFloor, this.talked1P4), this.talkAstrid2);
        this.courtAstrid.addStep(new Conditions(this.inMiscCastleFirstFloor, this.talked1P3, this.talked1P2, this.talked1P3, this.givenFlowers), this.danceForAstrid);
        this.courtAstrid.addStep(new Conditions(this.inMiscCastleFirstFloor, this.talked1P1, this.talked1P2, this.talked1P3), this.giveFlowersToAstrid);
        this.courtAstrid.addStep(this.inMiscCastleFirstFloor, this.talkAstrid1);
        this.courtAstrid.addStep(this.inIslands, this.goUpstairsToAstrid);
        this.courtBrand = new ConditionalStep((QuestHelper)this, (QuestStep)this.travelToMisc, new Requirement[0]);
        this.courtBrand.addStep(new Conditions(this.inMiscCastleFirstFloor, this.talked3P1, this.talked3P2, this.talked3P3, this.blownKiss), this.useRingOnBrand);
        this.courtBrand.addStep(new Conditions(this.inMiscCastleFirstFloor, this.talked3P1, this.talked3P2, this.talked3P3), this.blowKissToBrand);
        this.courtBrand.addStep(new Conditions(this.inMiscCastleFirstFloor, this.talked2P4), this.talkBrand3);
        this.courtBrand.addStep(new Conditions(this.inMiscCastleFirstFloor, this.talked2P1, this.talked2P2, this.talked2P3), this.giveCakeToBrand);
        this.courtBrand.addStep(new Conditions(this.inMiscCastleFirstFloor, this.talked1P4), this.talkBrand2);
        this.courtBrand.addStep(new Conditions(this.inMiscCastleFirstFloor, this.talked1P3, this.talked1P2, this.talked1P3, this.givenFlowers), this.clapForBrand);
        this.courtBrand.addStep(new Conditions(this.inMiscCastleFirstFloor, this.talked1P1, this.talked1P2, this.talked1P3), this.giveFlowersToBrand);
        this.courtBrand.addStep(this.inMiscCastleFirstFloor, this.talkBrand1);
        this.courtBrand.addStep(this.inIslands, this.goUpstairsToBrand);
        ConditionalStep establishPeace1 = new ConditionalStep((QuestHelper)this, (QuestStep)this.goUpEtcDip1, new Requirement[0]);
        establishPeace1.addStep(this.inEtcCastleFirstFloor, this.talkToSigridDip1);
        ConditionalStep establishPeace2 = new ConditionalStep((QuestHelper)this, (QuestStep)this.goUpMiscDip1, new Requirement[0]);
        establishPeace2.addStep(this.inMiscCastleFirstFloor, this.talkToVargasDip1);
        establishPeace2.addStep(this.inEtcCastleFirstFloor, this.goDownEtcDip1);
        ConditionalStep establishPeace3 = new ConditionalStep((QuestHelper)this, (QuestStep)this.goUpEtcDip2, new Requirement[0]);
        establishPeace3.addStep(this.inEtcCastleFirstFloor, this.talkToSigridDip2);
        establishPeace3.addStep(this.inMiscCastleFirstFloor, this.goDownMiscDip1);
        ConditionalStep establishPeace4 = new ConditionalStep((QuestHelper)this, (QuestStep)this.goUpMiscDip2, new Requirement[0]);
        establishPeace4.addStep(this.inMiscCastleFirstFloor, this.talkToBrandDip);
        establishPeace4.addStep(this.inEtcCastleFirstFloor, this.goDownEtcDip2);
        ConditionalStep establishPeace5 = new ConditionalStep((QuestHelper)this, (QuestStep)this.goUpMiscDip2, new Requirement[0]);
        establishPeace5.addStep(new Conditions(this.inEtcCastleFirstFloor, this.goodAnthem), this.talkToSigridDip3);
        establishPeace5.addStep(new Conditions(this.inMiscCastleFirstFloor, this.goodAnthem), this.goDownMiscDip2);
        establishPeace5.addStep(this.goodAnthem, this.goUpEtcDip3);
        establishPeace5.addStep(new Conditions(this.awfulAnthem, this.inMiscCastleFirstFloor), this.talkToGhrimDip);
        establishPeace5.addStep(this.inMiscCastleFirstFloor, this.getAnotherAwfulAnthem);
        ConditionalStep establishPeace6 = new ConditionalStep((QuestHelper)this, (QuestStep)this.goUpMiscDip2, new Requirement[0]);
        establishPeace6.addStep(new Conditions(this.inEtcCastleFirstFloor, this.goodAnthem), this.talkToSigridDip3);
        establishPeace6.addStep(new Conditions(this.inMiscCastleFirstFloor, this.goodAnthem), this.goDownMiscDip2);
        establishPeace6.addStep(this.goodAnthem, this.goUpEtcDip3);
        establishPeace6.addStep(new Conditions(this.awfulAnthem, this.inMiscCastleFirstFloor), this.talkToGhrimDip);
        establishPeace6.addStep(this.inMiscCastleFirstFloor, this.getAnotherAwfulAnthem);
        ConditionalStep establishPeace7 = new ConditionalStep((QuestHelper)this, (QuestStep)this.goUpEtcDip3, new Requirement[0]);
        establishPeace7.addStep(new Conditions(this.treaty, this.inMiscCastleFirstFloor), this.talkToVargasDip2);
        establishPeace7.addStep(new Conditions(this.treaty, this.inEtcCastleFirstFloor), this.goDownEtcDip3);
        establishPeace7.addStep(this.treaty, this.goUpMiscDip3);
        establishPeace7.addStep(this.inEtcCastleFirstFloor, this.talkToSigridDip3);
        establishPeace7.addStep(this.inMiscCastleFirstFloor, this.goDownMiscDip2);
        ConditionalStep establishPeace8 = new ConditionalStep((QuestHelper)this, (QuestStep)this.talkToDerrik, new Requirement[0]);
        establishPeace8.addStep(new Conditions(this.giantPen, this.inMiscCastleFirstFloor), this.giveVargasPen);
        establishPeace8.addStep(this.giantPen, this.goUpMiscDip4);
        establishPeace8.addStep(this.giantNib, this.makePen);
        establishPeace8.addStep(this.inMiscCastleFirstFloor, this.goDownMiscDip3);
        ConditionalStep courting = new ConditionalStep((QuestHelper)this, (QuestStep)this.courtAstrid, new Requirement[0]);
        courting.addStep(this.courtingBrand, this.courtBrand);
        ConditionalStep becomeRoyalty1 = new ConditionalStep((QuestHelper)this, (QuestStep)courting, new Requirement[0]);
        ConditionalStep becomeRoyalty2 = new ConditionalStep((QuestHelper)this, (QuestStep)courting, new Requirement[0]);
        ConditionalStep becomeRoyalty3 = new ConditionalStep((QuestHelper)this, (QuestStep)courting, new Requirement[0]);
        ConditionalStep becomeRoyalty4 = new ConditionalStep((QuestHelper)this, (QuestStep)courting, new Requirement[0]);
        ConditionalStep becomeRoyalty5 = new ConditionalStep((QuestHelper)this, (QuestStep)courting, new Requirement[0]);
        ConditionalStep becomeRoyalty6 = new ConditionalStep((QuestHelper)this, (QuestStep)courting, new Requirement[0]);
        ConditionalStep becomeRoyalty7 = new ConditionalStep((QuestHelper)this, (QuestStep)courting, new Requirement[0]);
        ConditionalStep becomeRoyalty8 = new ConditionalStep((QuestHelper)this, (QuestStep)courting, new Requirement[0]);
        becomeRoyalty1.addStep(this.hasCourted, establishPeace1);
        becomeRoyalty2.addStep(this.hasCourted, establishPeace2);
        becomeRoyalty3.addStep(this.hasCourted, establishPeace3);
        becomeRoyalty4.addStep(this.hasCourted, establishPeace4);
        becomeRoyalty5.addStep(this.hasCourted, establishPeace5);
        becomeRoyalty6.addStep(this.hasCourted, establishPeace6);
        becomeRoyalty7.addStep(this.hasCourted, establishPeace7);
        becomeRoyalty8.addStep(this.hasCourted, establishPeace8);
        steps.put(10, becomeRoyalty1);
        steps.put(20, becomeRoyalty2);
        steps.put(30, becomeRoyalty3);
        steps.put(40, becomeRoyalty4);
        steps.put(50, becomeRoyalty5);
        steps.put(60, becomeRoyalty6);
        steps.put(70, becomeRoyalty7);
        steps.put(80, becomeRoyalty8);
        ConditionalStep finishOff = new ConditionalStep((QuestHelper)this, (QuestStep)this.get75Support, new Requirement[0]);
        finishOff.addStep(new Conditions(this.inMiscCastleFirstFloor, this.has75Support), this.finishQuest);
        finishOff.addStep(this.has75Support, this.goUpMiscForSupport);
        finishOff.addStep(this.inMiscCastleFirstFloor, this.goDownMiscForSupport);
        steps.put(90, finishOff);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.ironBar = new ItemRequirement("Iron bar", 2351);
        this.logs = new ItemRequirement("Logs", 1511);
        this.logs.setHighlightInInventory(true);
        this.pickaxe = new ItemRequirement("Any pickaxe", ItemCollections.PICKAXES).isNotConsumed();
        this.rake = new ItemRequirement("Rake", 5341).isNotConsumed();
        this.axe = new ItemRequirement("Any axe", ItemCollections.AXES).isNotConsumed();
        this.harpoon = new ItemRequirement("Harpoon", ItemCollections.HARPOONS).isNotConsumed();
        this.lobsterPot = new ItemRequirement("Lobster pot", 301).isNotConsumed();
        this.ring = new ItemRequirement("Any non-silver ring you are willing to lose", 1635);
        this.ring.addAlternates(1637, 1639, 1641, 1643);
        this.flowers = new ItemRequirement("Flowers", ItemCollections.FLOWERS);
        this.flowers.setTooltip("You can buy some from the Flower Girl on Miscellania for 15 coins");
        this.flowers.setHighlightInInventory(true);
        this.cake = new ItemRequirement("Cake (if courting Brand)", 1891);
        this.cake.addAlternates(1897);
        this.bow = new ItemRequirement("Any normal/oak/willow/maple/yew shortbow or longbow (if courting Astrid)", 841);
        this.bow.addAlternates(839, 843, 845, 849, 847, 853, 851, 857, 855);
        this.bow.setTooltip("You will lose this bow");
        this.bow.setHighlightInInventory(true);
        this.runRestoreItems = new ItemRequirement("Potions/Items to restore run energy", ItemCollections.RUN_RESTORE_ITEMS);
        this.dramenStaff = new ItemRequirement("Dramen staff if travelling via Fairy Ring CIP", ItemCollections.FAIRY_STAFF).isNotConsumed();
        this.rellekkaTeleport = new ItemRequirement("Miscellania teleport (Fairy Ring (CIP), tablet, lyre)", ItemCollections.FAIRY_STAFF);
        this.rellekkaTeleport.addAlternates(11744, 23458, 13079, 6127, 6126, 6125, 3691);
        this.giantNib = new ItemRequirement("Giant nib", 3897);
        this.giantNib.setHighlightInInventory(true);
        this.giantPen = new ItemRequirement("Giant pen", 3898);
        this.awfulAnthem = new ItemRequirement("Awful anthem", 3894);
        this.goodAnthem = new ItemRequirement("Good anthem", 3895);
        this.treaty = new ItemRequirement("Treaty", 3896);
        this.reputationItems = new ItemRequirement("One of: ", 301);
        if (this.client.getRealSkillLevel(Skill.FARMING) >= 10) {
            this.reputationItems.setName(this.reputationItems.getName() + "a rake, ");
            this.reputationItems.setId(5341);
        }
        if (this.client.getRealSkillLevel(Skill.MINING) >= 30) {
            this.reputationItems.setName(this.reputationItems.getName() + "a pickaxe, ");
            this.reputationItems.addAlternates(ItemCollections.PICKAXES);
        }
        if (this.client.getRealSkillLevel(Skill.WOODCUTTING) >= 45) {
            this.reputationItems.setName(this.reputationItems.getName() + "an axe, ");
            this.reputationItems.addAlternates(ItemCollections.AXES);
        }
        this.reputationItems.setName(this.reputationItems.getName() + "a harpoon or lobster pot.");
        this.reputationItems.addAlternates(311, 301);
    }

    public void loadZones() {
        this.islands = new Zone(new WorldPoint(2491, 3835, 0), new WorldPoint(2627, 3904, 3));
        this.miscCastleFirstFloor = new Zone(new WorldPoint(2497, 3845, 1), new WorldPoint(2511, 3875, 1));
        this.etcCastleFirstFloor = new Zone(new WorldPoint(2607, 3864, 1), new WorldPoint(2618, 3886, 1));
        this.brandRoom1 = new Zone(new WorldPoint(2498, 3849, 1), new WorldPoint(2502, 3854, 1));
        this.brandRoom2 = new Zone(new WorldPoint(2503, 3851, 1), new WorldPoint(2504, 3854, 1));
        this.astridRoom1 = new Zone(new WorldPoint(2498, 3866, 1), new WorldPoint(2502, 3871, 1));
        this.astridRoom2 = new Zone(new WorldPoint(2503, 3866, 1), new WorldPoint(2504, 3869, 1));
    }

    public void setupConditions() {
        this.inIslands = new ZoneRequirement(this.islands);
        this.inMiscCastleFirstFloor = new ZoneRequirement(this.miscCastleFirstFloor);
        this.inEtcCastleFirstFloor = new ZoneRequirement(this.etcCastleFirstFloor);
        this.inBrandRoom = new ZoneRequirement(this.brandRoom1, this.brandRoom2);
        this.inAstridRoom = new ZoneRequirement(this.astridRoom1, this.astridRoom2);
        this.courtingBrand = new VarbitRequirement(14607, 1);
        this.talked1P1 = new VarbitRequirement(85, 1);
        this.talked1P2 = new VarbitRequirement(86, 1);
        this.talked1P3 = new VarbitRequirement(87, 1);
        this.givenFlowers = new VarbitRequirement(94, 1);
        this.doneEmote = new VarbitRequirement(96, 1);
        this.talked1P4 = new VarbitRequirement(73, 15, Operation.GREATER_EQUAL);
        this.talked2P1 = new VarbitRequirement(88, 1);
        this.talked2P2 = new VarbitRequirement(89, 1);
        this.talked2P3 = new VarbitRequirement(90, 1);
        this.givenBowOrCake = new VarbitRequirement(95, 1);
        this.talked2P4 = new VarbitRequirement(73, 24, Operation.GREATER_EQUAL);
        this.talked3P1 = new VarbitRequirement(91, 1);
        this.talked3P2 = new VarbitRequirement(92, 1);
        this.talked3P3 = new VarbitRequirement(93, 1);
        this.blownKiss = new VarbitRequirement(97, 1);
        this.hasCourted = new VarbitRequirement(14606, 1);
        this.diplomacyStep1 = new VarplayerRequirement(359, 20);
        this.diplomacyStep2 = new VarplayerRequirement(359, 30);
        this.diplomacyStep3 = new VarplayerRequirement(359, 40);
        this.diplomacyStep4 = new VarplayerRequirement(359, 50);
        this.diplomacyStep5 = new VarplayerRequirement(359, 60);
        this.diplomacyStep6 = new VarplayerRequirement(359, 70);
        this.has75Support = new VarbitRequirement(72, 96, Operation.GREATER_EQUAL);
    }

    public void setupSteps() {
        String travelText = "Travel to Miscellania. You can take a boat from Rellekka. You can also use Fairy Rings to teleport there with the code CIP If you've unlocked them.";
        this.travelToMisc = new NpcStep((QuestHelper)this, 3936, new WorldPoint(2629, 3693, 0), travelText, new Requirement[0]);
        this.travelToMisc.addTeleport(this.rellekkaTeleport);
        this.getFlowers = new NpcStep((QuestHelper)this, 3673, new WorldPoint(2511, 3865, 0), "Buy some flowers from the Flower Girl for 15gp.", new Requirement[0]);
        this.getFlowers.addDialogStep("Yes, please.");
        this.goUpToVargas = new ObjectStep((QuestHelper)this, 16675, new WorldPoint(2506, 3849, 0), "Go upstairs in the Miscellania castle.", new Requirement[0]);
        this.talkToVargas = new NpcStep((QuestHelper)this, 3668, new WorldPoint(2501, 3860, 1), "Talk to King Vargas. You can choose whether to get Brand's or Astrid's approval", new Requirement[0]);
        this.talkToVargas.addDialogSteps("Yes.", "If I may be so bold...");
        this.talkToVargas.addSubSteps(this.goUpToVargas);
        this.talkAstrid1 = new NpcStep((QuestHelper)this, 3667, new WorldPoint(2502, 3867, 1), "Talk to Princess Astrid a few times.", new Requirement[0]);
        this.talkAstrid1.addDialogStep("Archery is a noble art!");
        this.talkAstrid1.addDialogStep("He's been very helpful.");
        this.talkAstrid1.addDialogStep("Hahahaha!");
        this.talkAstrid2 = new NpcStep((QuestHelper)this, 3667, new WorldPoint(2502, 3867, 1), "Keep talking to Princess Astrid.", new Requirement[0]);
        this.talkAstrid2.addDialogStep("What happened next?");
        this.talkAstrid2.addDialogStep("That sounds like a good idea.");
        this.talkAstrid2.addDialogStep("I'm quite fond of it myself.");
        this.talkAstrid3 = new NpcStep((QuestHelper)this, 3667, new WorldPoint(2502, 3867, 1), "Keep talking to Princess Astrid.", new Requirement[0]);
        this.talkAstrid3.addDialogStep("It's a lovely little country.");
        this.talkAstrid3.addDialogStep("I suppose you don't have much opportunity to.");
        this.talkAstrid3.addDialogStep("And what a great bard he makes!");
        this.giveFlowersToAstrid = new NpcStep((QuestHelper)this, 3667, new WorldPoint(2502, 3867, 1), "Use flowers on Astrid.", this.flowers);
        this.giveFlowersToAstrid.addIcon(2472);
        this.giveFlowersToAstrid.addDialogStep("Yes");
        this.giveBowToAstrid = new NpcStep((QuestHelper)this, 3667, new WorldPoint(2502, 3867, 1), "Use any bow on Astrid.", this.bow.highlighted());
        this.giveBowToAstrid.addIcon(841);
        this.giveBowToAstrid.addDialogStep("Yes");
        this.danceForAstrid = new EmoteStep((QuestHelper)this, QuestEmote.DANCE, "Dance in Princess Astrid's room.", new Requirement[0]);
        this.blowKissToAstrid = new EmoteStep((QuestHelper)this, QuestEmote.BLOW_KISS, "Blow kiss emote next to Princess Astrid.", new Requirement[0]);
        this.useRingOnAstrid = new NpcStep((QuestHelper)this, 3667, new WorldPoint(2502, 3867, 1), "Use a ring on Astrid.", this.ring.highlighted());
        this.useRingOnAstrid.addIcon(1635);
        this.useRingOnAstrid.addDialogStep("Yes");
        this.talkBrand1 = new NpcStep((QuestHelper)this, 3666, new WorldPoint(2502, 3852, 1), "Talk to Prince Brand a few times.", new Requirement[0]);
        this.talkBrand1.addDialogStep("Be still, my heart.");
        this.talkBrand1.addDialogStep("You will be the greatest bard!");
        this.talkBrand1.addDialogStep("They don't understand your poetry as I do.");
        this.talkBrand2 = new NpcStep((QuestHelper)this, 3666, new WorldPoint(2502, 3852, 1), "Talk to Prince Brand more.", new Requirement[0]);
        this.talkBrand2.addDialogStep("A much nobler pursuit, to be sure.");
        this.talkBrand2.addDialogStep("How inspiring!");
        this.talkBrand2.addDialogStep("How poetic.");
        this.talkBrand3 = new NpcStep((QuestHelper)this, 3666, new WorldPoint(2502, 3852, 1), "Talk to Prince Brand more.", new Requirement[0]);
        this.talkBrand3.addDialogStep("I'm glad to hear it.");
        this.talkBrand3.addDialogStep("I wouldn't presume to have the skill...");
        this.talkBrand3.addDialogStep("That was lovely. I'm touched!");
        this.giveCakeToBrand = new NpcStep((QuestHelper)this, 3666, new WorldPoint(2502, 3852, 1), "Give Prince Brand a cake.", this.cake.highlighted());
        this.giveCakeToBrand.addDialogStep("Yes");
        this.giveFlowersToBrand = new NpcStep((QuestHelper)this, 3666, new WorldPoint(2502, 3852, 1), "Use flowers on Prince Brand.", this.flowers);
        this.giveFlowersToBrand.addDialogStep("Yes");
        this.giveFlowersToBrand.addIcon(2472);
        this.blowKissToBrand = new EmoteStep((QuestHelper)this, QuestEmote.BLOW_KISS, "Use the blow kiss emote next to Prince Brand", new Requirement[0]);
        this.clapForBrand = new EmoteStep((QuestHelper)this, QuestEmote.CLAP, "Use the Clap emote next to Prince Brand", new Requirement[0]);
        this.useRingOnBrand = new NpcStep((QuestHelper)this, 3666, new WorldPoint(2502, 3852, 1), "Use a ring on Prince Brand.", this.ring.highlighted());
        this.useRingOnBrand.addDialogStep("Yes");
        this.useRingOnBrand.addIcon(1635);
        this.goUpstairsToBrand = new ObjectStep((QuestHelper)this, 16675, new WorldPoint(2506, 3849, 0), "Go upstairs in the Miscellania castle.", new Requirement[0]);
        this.goUpstairsToBrand.setShowInSidebar(false);
        this.goUpstairsToAstrid = new ObjectStep((QuestHelper)this, 16675, new WorldPoint(2506, 3872, 0), "Go upstairs in the Miscellania castle.", new Requirement[0]);
        this.goUpstairsToAstrid.setShowInSidebar(false);
        this.goUpEtcDip1 = new ObjectStep((QuestHelper)this, 16671, new WorldPoint(2614, 3868, 0), "Go upstairs in Etceteria castle, east of Miscellania.", new Requirement[0]);
        this.talkToSigridDip1 = new NpcStep((QuestHelper)this, 765, new WorldPoint(2612, 3875, 1), "Talk to Queen Sigrid in Etceteria castle.", new Requirement[0]);
        this.talkToSigridDip1.addSubSteps(this.goUpEtcDip1);
        this.goDownEtcDip1 = new ObjectStep((QuestHelper)this, 16673, new WorldPoint(2614, 3867, 1), "Return to King Vargas.", new Requirement[0]);
        this.goUpMiscDip1 = new ObjectStep((QuestHelper)this, 16675, new WorldPoint(2506, 3849, 0), "Return to King Vargas.", new Requirement[0]);
        this.talkToVargasDip1 = new NpcStep((QuestHelper)this, 3668, new WorldPoint(2501, 3860, 1), "Talk to King Vargas.", new Requirement[0]);
        this.talkToVargasDip1.addSubSteps(this.goDownEtcDip1, this.goUpMiscDip1);
        this.goDownMiscDip1 = new ObjectStep((QuestHelper)this, 16676, new WorldPoint(2506, 3849, 1), "Go downstairs then return to Queen Sigrid.", new Requirement[0]);
        this.goDownMiscDip1.addDialogStep("Climb down the stairs.");
        this.goUpEtcDip2 = new ObjectStep((QuestHelper)this, 16671, new WorldPoint(2614, 3868, 0), "Return to Queen Sigrid.", new Requirement[0]);
        this.talkToSigridDip2 = new NpcStep((QuestHelper)this, 765, new WorldPoint(2612, 3875, 1), "Talk to Queen Sigrid.", new Requirement[0]);
        this.talkToSigridDip2.addSubSteps(this.goDownMiscDip1, this.goUpEtcDip2);
        this.goDownEtcDip2 = new ObjectStep((QuestHelper)this, 16673, new WorldPoint(2614, 3867, 1), "Go talk to Prince Brand in Miscellania castle.", new Requirement[0]);
        this.goUpMiscDip2 = new ObjectStep((QuestHelper)this, 16675, new WorldPoint(2506, 3849, 0), "Go talk to Prince Brand in Miscellania castle.", new Requirement[0]);
        this.talkToBrandDip = new NpcStep((QuestHelper)this, 3666, new WorldPoint(2502, 3852, 1), "Talk to Prince Brand in Miscellania castle.", new Requirement[0]);
        this.getAnotherAwfulAnthem = new NpcStep((QuestHelper)this, 3666, new WorldPoint(2502, 3852, 1), "Talk to Prince Brand in Miscellania castle for another Awful Anthem.", this.awfulAnthem);
        this.talkToBrandDip.addSubSteps(this.goDownEtcDip2, this.goUpMiscDip2, this.getAnotherAwfulAnthem);
        this.talkToGhrimDip = new NpcStep((QuestHelper)this, 5447, new WorldPoint(2499, 3857, 1), "Talk to Advisor Ghrim.", new Requirement[0]);
        this.talkToGhrimDip.addDialogStep("How do I make peace with Etceteria?");
        this.goDownMiscDip2 = new ObjectStep((QuestHelper)this, 16676, new WorldPoint(2506, 3849, 1), "Go downstairs and return to Queen Sigrid.", new Requirement[0]);
        this.goDownMiscDip2.addDialogStep("Climb down the stairs.");
        this.goUpEtcDip3 = new ObjectStep((QuestHelper)this, 16671, new WorldPoint(2614, 3868, 0), "Return to Queen Sigrid.", new Requirement[0]);
        this.talkToSigridDip3 = new NpcStep((QuestHelper)this, 765, new WorldPoint(2612, 3875, 1), "Return to Queen Sigrid in Etceteria castle.", new Requirement[0]);
        this.talkToSigridDip3.addSubSteps(this.goDownMiscDip2, this.goUpEtcDip3);
        this.goDownEtcDip3 = new ObjectStep((QuestHelper)this, 16673, new WorldPoint(2614, 3867, 1), "Return to King Vargas.", new Requirement[0]);
        this.goUpMiscDip3 = new ObjectStep((QuestHelper)this, 16675, new WorldPoint(2506, 3849, 0), "Return to King Vargas.", new Requirement[0]);
        this.talkToVargasDip2 = new NpcStep((QuestHelper)this, 3668, new WorldPoint(2501, 3860, 1), "Return to King Vargas.", new Requirement[0]);
        this.talkToVargasDip2.addSubSteps(this.goDownEtcDip3, this.goUpMiscDip3);
        this.goDownMiscDip3 = new ObjectStep((QuestHelper)this, 16676, new WorldPoint(2506, 3849, 1), "Go downstairs then go talk to Derrik in the north of Miscellania.", this.ironBar);
        this.goDownMiscDip3.addDialogStep("Climb down the stairs.");
        this.talkToDerrik = new NpcStep((QuestHelper)this, 3671, new WorldPoint(2550, 3895, 0), "Talk to Derrik in the north of Miscellania.", this.ironBar);
        this.talkToDerrik.addSubSteps(this.goDownMiscDip3);
        this.talkToDerrik.addDialogStep("I have a slightly strange request...");
        this.makePen = new DetailedQuestStep((QuestHelper)this, "Use the giant nib on some logs. Cut a nearby evergreen if you don't have logs.", this.giantNib, this.logs);
        this.goUpMiscDip4 = new ObjectStep((QuestHelper)this, 16675, new WorldPoint(2506, 3849, 0), "Return to King Vargas with the giant pen.", this.giantPen);
        this.giveVargasPen = new NpcStep((QuestHelper)this, 3668, new WorldPoint(2501, 3860, 1), "Talk to King Vargas with the giant pen.", this.giantPen);
        this.giveVargasPen.addSubSteps(this.goUpMiscDip4);
        this.goUpMiscForSupport = new ObjectStep((QuestHelper)this, 16675, new WorldPoint(2506, 3849, 0), "Return to King Vargas to finish the quest.", new Requirement[0]);
        this.goDownMiscForSupport = new ObjectStep((QuestHelper)this, 16676, new WorldPoint(2506, 3849, 1), "Go downstairs and get support from the subjects.", new Requirement[0]);
        this.goDownMiscForSupport.addDialogStep("Climb down the stairs.");
        Object getSupport = "Reach 75% support. You can do any of the following with your current levels: ";
        String rakePatch = "Rake the farming patches. ";
        String mineCoal = "Mining coal. ";
        String cuttingMaples = "Cutting maple trees. ";
        String fishing = "Fish tuna with a harpoon or lobsters with a lobster pot.";
        if (this.client.getRealSkillLevel(Skill.FARMING) >= 10) {
            getSupport = (String)getSupport + rakePatch;
        }
        if (this.client.getRealSkillLevel(Skill.MINING) >= 30) {
            getSupport = (String)getSupport + mineCoal;
        }
        if (this.client.getRealSkillLevel(Skill.WOODCUTTING) >= 45) {
            getSupport = (String)getSupport + cuttingMaples;
        }
        getSupport = (String)getSupport + fishing;
        this.get75Support = new DetailedQuestStep((QuestHelper)this, (String)getSupport, this.axe, this.pickaxe, this.rake, this.harpoon, this.lobsterPot);
        this.get75Support.addSubSteps(this.goDownMiscForSupport);
        this.finishQuest = new NpcStep((QuestHelper)this, 3668, new WorldPoint(2501, 3860, 1), "Talk to King Vargas to finish the quest.", new Requirement[0]);
        this.finishQuest.addSubSteps(this.goUpMiscForSupport);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.ironBar);
        reqs.add(this.logs);
        reqs.add(this.ring);
        reqs.add(this.flowers);
        reqs.add(this.bow);
        reqs.add(this.cake);
        reqs.add(this.reputationItems);
        return reqs;
    }

    @Override
    public List<String> getNotes() {
        ArrayList<String> reqs = new ArrayList<String>();
        reqs.add("Currently this helper only shows you how to marry Astrid. If you'd like to be friends with her or choose to be with Brand, you can either follow an external guide for now, or simply talk to King Vargas after the quest to change.");
        return reqs;
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.dramenStaff);
        reqs.add(this.runRestoreItems);
        return reqs;
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new QuestRequirement(QuestHelperQuest.HEROES_QUEST, QuestState.FINISHED));
        req.add(new QuestRequirement(QuestHelperQuest.THE_FREMENNIK_TRIALS, QuestState.FINISHED));
        req.add(new SkillRequirement(Skill.WOODCUTTING, 45, false, "45 Woodcutting (or any of the other skill requirements)"));
        req.add(new SkillRequirement(Skill.FARMING, 10, false, "10 Farming (or any of the other skill requirements)"));
        req.add(new SkillRequirement(Skill.MINING, 30, false, "30 Mining (or any of the other skill requirements)"));
        req.add(new SkillRequirement(Skill.SMITHING, 35, false, "35 Smithing (or any of the other skill requirements)"));
        return req;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Ability to manage Miscellania."), new UnlockReward("Ability to teleport to Miscellania with the Ring of Wealth."));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Talk to King Vargas", Arrays.asList(this.travelToMisc, this.getFlowers, this.talkToVargas), this.flowers, this.bow, this.cake, this.ring, this.ironBar, this.logs, this.reputationItems));
        PanelDetails astridPanel = new PanelDetails("Win over Astrid", Arrays.asList(this.goUpstairsToAstrid, this.talkAstrid1, this.giveFlowersToAstrid, this.danceForAstrid, this.talkAstrid2, this.giveBowToAstrid, this.talkAstrid3, this.blowKissToAstrid, this.useRingOnAstrid), new Requirement[0]);
        PanelDetails brandPanel = new PanelDetails("Win over Brand", Arrays.asList(this.goUpstairsToBrand, this.talkBrand1, this.giveFlowersToBrand, this.clapForBrand, this.talkBrand2, this.giveCakeToBrand, this.talkBrand3, this.blowKissToBrand, this.useRingOnBrand), new Requirement[0]);
        allSteps.add(astridPanel);
        allSteps.add(brandPanel);
        allSteps.add(new PanelDetails("Establish peace", Arrays.asList(this.talkToSigridDip1, this.talkToVargasDip1, this.talkToSigridDip2, this.talkToBrandDip, this.talkToGhrimDip, this.talkToSigridDip3, this.talkToVargasDip2, this.talkToDerrik, this.makePen, this.giveVargasPen), new Requirement[0]));
        allSteps.add(new PanelDetails("Get support", Arrays.asList(this.get75Support, this.finishQuest), this.reputationItems));
        return allSteps;
    }
}

