/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.thetouristtrap;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.collections.KeyringCollection;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.ItemRequirements;
import com.questhelper.requirements.item.KeyringRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.widget.WidgetTextRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.THE_TOURIST_TRAP)
public class TheTouristTrap
extends BasicQuestHelper {
    ItemRequirement desertTop;
    ItemRequirement desertBottom;
    ItemRequirement desertBoot;
    ItemRequirement desertTopWorn;
    ItemRequirement desertBottomWorn;
    ItemRequirement desertBootWorn;
    ItemRequirement bronzeBar3;
    ItemRequirement hammer;
    ItemRequirement feather50;
    ItemRequirement metalKey;
    ItemRequirement slaveTop;
    ItemRequirement slaveRobe;
    ItemRequirement slaveBoot;
    ItemRequirement slaveTopWorn;
    ItemRequirement slaveRobeWorn;
    ItemRequirement slaveBootWorn;
    ItemRequirement bedabinKey;
    ItemRequirement technicalPlans;
    ItemRequirement prototypeDart;
    ItemRequirement prototypeDartTip;
    ItemRequirement bronzeBar;
    ItemRequirement tentiPineapple;
    ItemRequirement bronzeBarHighlighted;
    ItemRequirement barrel;
    ItemRequirement anaInABarrel;
    ItemRequirement anaInABarrelHighlighted;
    ItemRequirement barrelHighlighted;
    ItemRequirement waterskins;
    ItemRequirement knife;
    ItemRequirement pickaxe;
    ItemRequirement coins100;
    ItemRequirement combatGear;
    Requirement inJail;
    Requirement onSlope;
    Requirement inCamp;
    Requirement hasSlaveClothes;
    Requirement inUpstairs;
    Requirement onCliff;
    Requirement onSecondCliff;
    Requirement inJailEscape;
    Requirement inMine1;
    Requirement distractedSiad;
    Requirement searchedBookcase;
    Requirement inDeepMine;
    Requirement inDeepMineP1;
    Requirement inDeepMineP2;
    Requirement anaOnCart;
    Requirement anaOnSurfaceInBarrel;
    Requirement anaOnSurface;
    Requirement anaPlacedOnCartOfLift;
    Requirement inMiningRoom;
    Requirement anaFree;
    DetailedQuestStep talkToIrena;
    DetailedQuestStep talkToCaptain;
    DetailedQuestStep killCaptain;
    DetailedQuestStep enterCamp;
    DetailedQuestStep talkToSlave;
    DetailedQuestStep enterMine;
    DetailedQuestStep talkToGuard;
    DetailedQuestStep leaveCamp;
    DetailedQuestStep talkToShabim;
    DetailedQuestStep enterCampForTask;
    DetailedQuestStep goUpToSiad;
    DetailedQuestStep searchBookcase;
    DetailedQuestStep talkToSiad;
    DetailedQuestStep searchChest;
    DetailedQuestStep returnToShabim;
    DetailedQuestStep useAnvil;
    DetailedQuestStep bringPrototypeToShabim;
    DetailedQuestStep enterCampWithPineapple;
    DetailedQuestStep enterMineWithPineapple;
    DetailedQuestStep talkToGuardWithPineapple;
    DetailedQuestStep enterCampAfterPineapple;
    DetailedQuestStep enterMineAfterPineapple;
    DetailedQuestStep enterDeepMine;
    DetailedQuestStep getBarrel;
    DetailedQuestStep enterMineCart;
    DetailedQuestStep useBarrelOnAna;
    DetailedQuestStep useBarrelOnMineCart;
    DetailedQuestStep returnInMineCart;
    DetailedQuestStep searchBarrelsForAna;
    DetailedQuestStep sendAnaUp;
    DetailedQuestStep leaveDeepMine;
    DetailedQuestStep leaveMineForAna;
    DetailedQuestStep operateWinch;
    DetailedQuestStep searchWinchBarrel;
    DetailedQuestStep useBarrelOnCart;
    DetailedQuestStep talkToDriver;
    DetailedQuestStep returnToIrena;
    DetailedQuestStep useFeatherOnTip;
    DetailedQuestStep leaveMine;
    DetailedQuestStep mineRocks;
    DetailedQuestStep talkToAna;
    DetailedQuestStep talkToIrenaToFinish;
    DetailedQuestStep escapeJail;
    DetailedQuestStep climbSlope;
    DetailedQuestStep climbCliff;
    DetailedQuestStep climbDownCliff;
    Zone jail;
    Zone slope;
    Zone camp;
    Zone upstairs;
    Zone cliff;
    Zone secondCliff;
    Zone mine1;
    Zone deepMine;
    Zone deepMineP1;
    Zone deepMineP2P1;
    Zone deepMineP2P2;
    Zone miningRoom;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToIrena);
        steps.put(1, this.talkToCaptain);
        steps.put(2, this.talkToCaptain);
        steps.put(3, this.talkToCaptain);
        ConditionalStep escapeJailSteps = new ConditionalStep((QuestHelper)this, (QuestStep)this.escapeJail, new Requirement[0]);
        escapeJailSteps.addStep(this.onSecondCliff, this.climbDownCliff);
        escapeJailSteps.addStep(this.onCliff, this.climbCliff);
        escapeJailSteps.addStep(this.onSlope, this.climbSlope);
        ConditionalStep getSlaveClothes = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterCamp, new Requirement[0]);
        getSlaveClothes.addStep(this.inJailEscape, escapeJailSteps);
        getSlaveClothes.addStep(this.inCamp, this.talkToSlave);
        steps.put(4, getSlaveClothes);
        steps.put(5, getSlaveClothes);
        steps.put(6, getSlaveClothes);
        steps.put(7, getSlaveClothes);
        ConditionalStep goTalkToGuard = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterCamp, new Requirement[0]);
        goTalkToGuard.addStep(this.inJailEscape, escapeJailSteps);
        goTalkToGuard.addStep(this.inMine1, this.talkToGuard);
        goTalkToGuard.addStep(this.inCamp, this.enterMine);
        steps.put(8, goTalkToGuard);
        steps.put(9, goTalkToGuard);
        ConditionalStep goTalkToShabim = new ConditionalStep((QuestHelper)this, (QuestStep)this.talkToShabim, new Requirement[0]);
        goTalkToShabim.addStep(this.inJailEscape, escapeJailSteps);
        goTalkToShabim.addStep(this.inCamp, this.leaveCamp);
        goTalkToShabim.addStep(this.inMine1, this.leaveMine);
        steps.put(10, goTalkToShabim);
        ConditionalStep goGetPlans = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterCampForTask, new Requirement[0]);
        goGetPlans.addStep(this.inJailEscape, escapeJailSteps);
        goGetPlans.addStep(this.technicalPlans, this.returnToShabim);
        goGetPlans.addStep(new Conditions(this.inUpstairs, this.distractedSiad), this.searchChest);
        goGetPlans.addStep(new Conditions(this.inUpstairs, this.searchedBookcase), this.talkToSiad);
        goGetPlans.addStep(this.inUpstairs, this.searchBookcase);
        goGetPlans.addStep(this.inCamp, this.goUpToSiad);
        goGetPlans.addStep(this.inMine1, this.leaveMine);
        steps.put(11, goGetPlans);
        steps.put(12, goGetPlans);
        ConditionalStep makeDart = new ConditionalStep((QuestHelper)this, (QuestStep)this.useAnvil, new Requirement[0]);
        makeDart.addStep(this.inJailEscape, escapeJailSteps);
        makeDart.addStep(this.prototypeDart, this.bringPrototypeToShabim);
        makeDart.addStep(this.prototypeDartTip, this.useFeatherOnTip);
        steps.put(13, makeDart);
        steps.put(14, makeDart);
        steps.put(15, makeDart);
        ConditionalStep returnWithPineapple = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterCampWithPineapple, new Requirement[0]);
        returnWithPineapple.addStep(this.inJailEscape, escapeJailSteps);
        returnWithPineapple.addStep(this.inMine1, this.talkToGuardWithPineapple);
        returnWithPineapple.addStep(this.inCamp, this.enterMineWithPineapple);
        steps.put(16, returnWithPineapple);
        ConditionalStep captureAna = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterCampAfterPineapple, new Requirement[0]);
        captureAna.addStep(this.inJailEscape, escapeJailSteps);
        captureAna.addStep(new Conditions(this.anaFree), this.talkToAna);
        captureAna.addStep(new Conditions(this.inCamp, this.anaOnCart), this.talkToDriver);
        captureAna.addStep(new Conditions(this.inCamp, this.anaInABarrel), this.useBarrelOnCart);
        captureAna.addStep(new Conditions(this.inCamp, this.anaPlacedOnCartOfLift, this.anaOnSurfaceInBarrel), this.searchWinchBarrel);
        captureAna.addStep(new Conditions(this.inCamp, this.anaOnSurface, this.anaPlacedOnCartOfLift), this.operateWinch);
        captureAna.addStep(new Conditions(this.inMine1, this.anaOnSurface, this.anaPlacedOnCartOfLift), this.leaveMineForAna);
        captureAna.addStep(new Conditions(this.inDeepMineP1, this.anaInABarrel), this.sendAnaUp);
        captureAna.addStep(new Conditions(this.inDeepMineP1, this.anaOnSurface, this.anaPlacedOnCartOfLift), this.leaveDeepMine);
        captureAna.addStep(new Conditions(this.inDeepMineP1, this.anaPlacedOnCartOfLift), this.searchBarrelsForAna);
        captureAna.addStep(new Conditions(this.inDeepMineP2, this.anaInABarrel), this.useBarrelOnMineCart);
        captureAna.addStep(new Conditions(this.inDeepMineP2, this.anaPlacedOnCartOfLift), this.returnInMineCart);
        captureAna.addStep(new Conditions(this.inDeepMineP2, this.barrel), this.useBarrelOnAna);
        captureAna.addStep(new Conditions(this.inDeepMineP1, this.barrel), this.enterMineCart);
        captureAna.addStep(this.inMiningRoom, this.mineRocks);
        captureAna.addStep(this.anaInABarrel, this.returnToIrena);
        captureAna.addStep(this.inDeepMine, this.getBarrel);
        captureAna.addStep(this.inMine1, this.enterDeepMine);
        captureAna.addStep(this.inCamp, this.enterMineAfterPineapple);
        steps.put(17, captureAna);
        steps.put(18, captureAna);
        steps.put(19, captureAna);
        steps.put(20, captureAna);
        steps.put(21, captureAna);
        steps.put(22, captureAna);
        steps.put(23, captureAna);
        steps.put(24, captureAna);
        steps.put(25, captureAna);
        steps.put(26, captureAna);
        steps.put(27, this.talkToIrenaToFinish);
        steps.put(28, this.talkToIrenaToFinish);
        steps.put(29, this.talkToIrenaToFinish);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.combatGear = new ItemRequirement("Combat gear", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.desertTop = new ItemRequirement("Desert shirt", 1833);
        this.desertBottom = new ItemRequirement("Desert robe", 1835);
        this.desertBoot = new ItemRequirement("Desert boots", 1837);
        this.desertTopWorn = new ItemRequirement("Desert shirt", 1833, 1, true);
        this.desertBottomWorn = new ItemRequirement("Desert robe", 1835, 1, true);
        this.desertBootWorn = new ItemRequirement("Desert boots", 1837, 1, true);
        this.bronzeBar3 = new ItemRequirement("Bronze bars", 2349, 3);
        this.hammer = new ItemRequirement("Hammer", ItemCollections.HAMMER).isNotConsumed();
        this.metalKey = new KeyringRequirement("Metal key", this.configManager, KeyringCollection.METAL_KEY);
        this.metalKey.setTooltip("You can get another by killing the Mercenary Guard outside the Desert Mining Camp");
        this.slaveTop = new ItemRequirement("Slave shirt", 1844);
        this.slaveTop.setTooltip("You can trade in a desert robe set for slave clothes with the Male Slave");
        this.slaveTopWorn = new ItemRequirement("Slave shirt", 1844, 1, true);
        this.slaveTopWorn.setTooltip("You can trade in a desert robe set for slave clothes with the Male Slave");
        this.slaveRobe = new ItemRequirement("Slave robe", 1845);
        this.slaveRobe.setTooltip("You can trade in a desert robe set for slave clothes with the Male Slave");
        this.slaveRobeWorn = new ItemRequirement("Slave robe", 1845, 1, true);
        this.slaveRobeWorn.setTooltip("You can trade in a desert robe set for slave clothes with the Male Slave");
        this.slaveBoot = new ItemRequirement("Slave boots", 1846);
        this.slaveBoot.setTooltip("You can trade in a desert robe set for slave clothes with the Male Slave");
        this.slaveBootWorn = new ItemRequirement("Slave boots", 1846, 1, true);
        this.slaveBootWorn.setTooltip("You can trade in a desert robe set for slave clothes with the Male Slave");
        this.bedabinKey = new ItemRequirement("Bedabin key", 1852);
        this.bedabinKey.setTooltip("You can get another from Al Shabim in the Bedabin Camp");
        this.technicalPlans = new ItemRequirement("Technical plans", 1850);
        this.technicalPlans.setTooltip("You'll need to get another plan from Siad's chest");
        this.prototypeDart = new ItemRequirement("Prototype dart", 1849);
        this.prototypeDartTip = new ItemRequirement("Prototype dart tip", 1853);
        this.prototypeDartTip.setHighlightInInventory(true);
        this.feather50 = new ItemRequirement("Feather", 314, 50);
        this.bronzeBar = new ItemRequirement("Bronze bar", 2349);
        this.bronzeBarHighlighted = new ItemRequirement("Bronze bar", 2349);
        this.bronzeBarHighlighted.setHighlightInInventory(true);
        this.tentiPineapple = new ItemRequirement("Tenti pineapple", 1851);
        this.tentiPineapple.setTooltip("You can get another from Al Shabim in the Bedabin Camp");
        this.barrel = new ItemRequirement("Barrel", 1841);
        this.barrelHighlighted = new ItemRequirement("Barrel", 1841);
        this.barrelHighlighted.setHighlightInInventory(true);
        this.anaInABarrel = new ItemRequirement("Ana in a barrel", 1842);
        this.anaInABarrelHighlighted = new ItemRequirement("Ana in a barrel", 1842);
        this.anaInABarrelHighlighted.setHighlightInInventory(true);
        this.waterskins = new ItemRequirement("Waterskins", 1823, -1);
        this.knife = new ItemRequirement("Knife", 946).isNotConsumed();
        this.pickaxe = new ItemRequirement("Any pickaxe", ItemCollections.PICKAXES).isNotConsumed();
        this.coins100 = new ItemRequirement("Coins", ItemCollections.COINS, 100);
    }

    public void loadZones() {
        this.jail = new Zone(new WorldPoint(3284, 3031, 0), new WorldPoint(3287, 3037, 0));
        this.camp = new Zone(new WorldPoint(3274, 3014, 0), new WorldPoint(3305, 3037, 1));
        this.upstairs = new Zone(new WorldPoint(3284, 3031, 1), new WorldPoint(3293, 3037, 1));
        this.slope = new Zone(new WorldPoint(3282, 3032, 0), new WorldPoint(3283, 3037, 0));
        this.cliff = new Zone(new WorldPoint(3279, 3037, 0), new WorldPoint(3281, 3038, 0));
        this.secondCliff = new Zone(new WorldPoint(3273, 3035, 0), new WorldPoint(3278, 3039, 0));
        this.mine1 = new Zone(new WorldPoint(3266, 9410, 0), new WorldPoint(3282, 9466, 0));
        this.deepMine = new Zone(new WorldPoint(3282, 9408, 0), new WorldPoint(3326, 9470, 0));
        this.deepMineP1 = new Zone(new WorldPoint(3283, 9409, 0), new WorldPoint(3314, 9427, 0));
        this.deepMineP2P1 = new Zone(new WorldPoint(3315, 9416, 0), new WorldPoint(3326, 9470, 0));
        this.deepMineP2P2 = new Zone(new WorldPoint(3293, 9429, 0), new WorldPoint(3314, 9470, 0));
        this.miningRoom = new Zone(new WorldPoint(3283, 9427, 0), new WorldPoint(3292, 9454, 0));
    }

    public void setupConditions() {
        this.inJail = new ZoneRequirement(this.jail);
        this.inCamp = new ZoneRequirement(this.camp);
        this.inMine1 = new ZoneRequirement(this.mine1);
        this.inUpstairs = new ZoneRequirement(this.upstairs);
        this.inDeepMine = new ZoneRequirement(this.deepMine);
        this.inDeepMineP1 = new ZoneRequirement(this.deepMineP1);
        this.inDeepMineP2 = new ZoneRequirement(this.deepMineP2P1, this.deepMineP2P2);
        this.inMiningRoom = new ZoneRequirement(this.miningRoom);
        this.onSlope = new ZoneRequirement(this.slope);
        this.onCliff = new ZoneRequirement(this.cliff);
        this.onSecondCliff = new ZoneRequirement(this.secondCliff);
        this.inJailEscape = new ZoneRequirement(this.jail, this.slope, this.cliff, this.secondCliff);
        this.hasSlaveClothes = new ItemRequirements(this.slaveTop, this.slaveBoot, this.slaveRobe);
        this.searchedBookcase = new Conditions(true, new WidgetTextRequirement(12648450, "You notice several books on the subject of sailing."));
        this.distractedSiad = new Conditions(true, new WidgetTextRequirement(229, 1, "The captain starts rambling on about his days as a salty sea dog. He<br>looks quite distracted..."));
        this.anaPlacedOnCartOfLift = new VarbitRequirement(2805, 1);
        this.anaOnSurface = new VarplayerRequirement(197, 22, Operation.GREATER_EQUAL);
        this.anaOnSurfaceInBarrel = new VarbitRequirement(2808, 1);
        this.anaOnCart = new VarbitRequirement(2809, 1);
        this.anaFree = new VarbitRequirement(3733, 1);
    }

    public void setupSteps() {
        this.talkToIrena = new NpcStep((QuestHelper)this, 4640, new WorldPoint(3304, 3112, 0), "Talk to Irena south of the Shantay Pass.", new Requirement[0]);
        this.talkToIrena.addDialogSteps("What's the matter?", "Is there a reward if I get her back?", "I'll look for your daughter.", "Okay Irena, calm down. I'll get your daughter back for you.", "Yes, I'll go on this quest!");
        this.talkToCaptain = new NpcStep((QuestHelper)this, 4635, new WorldPoint(3271, 3029, 0), "Talk the Mercenary Captain outside the Desert Mining Camp. When he attacks you, kill him for a key.", this.combatGear);
        this.talkToCaptain.addDialogSteps("Wow! A real captain!", "I'd love to work for a tough guy like you!", "Can't I do something for a strong Captain like you?", "Sorry Sir, I don't think I can do that.", "It's a funny captain who can't fight his own battles!");
        this.killCaptain = new NpcStep((QuestHelper)this, 4635, new WorldPoint(3271, 3029, 0), "Kill the Mercenary Captain outside the Desert Mining Camp.", this.combatGear);
        this.escapeJail = new ObjectStep((QuestHelper)this, 2679, new WorldPoint(3283, 3034, 0), "Bend the cell window and escape through it.", new Requirement[0]);
        this.climbSlope = new ObjectStep((QuestHelper)this, 18871, new WorldPoint(3281, 3037, 0), "Climb the rocks to escape.", new Requirement[0]);
        this.climbCliff = new ObjectStep((QuestHelper)this, 18923, new WorldPoint(3278, 3037, 0), "Climb the cliff.", new Requirement[0]);
        this.climbDownCliff = new ObjectStep((QuestHelper)this, 18924, new WorldPoint(3273, 3039, 0), "Climb down the west of the cliff.", new Requirement[0]);
        this.enterCamp = new ObjectStep((QuestHelper)this, 2673, new WorldPoint(3273, 3029, 0), "UNEQUIP ALL COMBAT GEAR and enter the camp.", this.desertTop, this.desertBottom, this.desertBoot, this.metalKey);
        this.talkToSlave = new NpcStep((QuestHelper)this, 4632, new WorldPoint(3302, 3027, 0), "Talk to the Male Slave to the east to trade your desert robes for his slave robes.", this.desertTop, this.desertBottom, this.desertBoot);
        this.talkToSlave.addDialogSteps("I've just arrived.", "Okay, you caught me out.", "Oh yes, that sounds interesting.", "What's that then?", "I can try to undo them for you.", "It's funny you should say that...", "Yeah okay, let's give it a go.", "Yes, I'll trade.");
        this.enterMine = new ObjectStep((QuestHelper)this, 2675, new WorldPoint(3301, 3036, 0), "Equip the slave clothes, and enter the mine door in the north east of the camp.", this.slaveTopWorn, this.slaveRobeWorn, this.slaveBootWorn);
        this.talkToGuard = new NpcStep((QuestHelper)this, 4667, new WorldPoint(3278, 9415, 0), "Follow the cave around and talk to a guard guarding the deeper cave.", this.slaveTopWorn, this.slaveRobeWorn, this.slaveBootWorn);
        this.talkToGuard.addDialogSteps("I'd like to mine in a different area.", "Yes sir, you're quite right sir.", "Yes sir, we understand each other perfectly.");
        this.leaveMine = new ObjectStep((QuestHelper)this, 2690, new WorldPoint(3278, 9426, 0), "Return to the surface.", new Requirement[0]);
        this.leaveMine.addDialogStep("Yes sir, we understand each other perfectly.");
        this.leaveCamp = new ObjectStep((QuestHelper)this, 2673, new WorldPoint(3273, 3029, 0), "UNEQUIP THE SLAVE CLOTHES and leave the camp.", new Requirement[0]);
        this.talkToShabim = new NpcStep((QuestHelper)this, 4637, new WorldPoint(3171, 3028, 0), "Talk to Al Shabim in the Bedabin Camp.", new Requirement[0]);
        this.talkToShabim.addDialogSteps("I am looking for a pineapple.", "Yes, I'm interested.");
        this.talkToShabim.addSubSteps(this.leaveMine, this.leaveCamp);
        this.enterCampForTask = new ObjectStep((QuestHelper)this, 2673, new WorldPoint(3273, 3029, 0), "UNEQUIP ALL COMBAT GEAR and enter the camp.", this.metalKey, this.bedabinKey);
        this.goUpToSiad = new ObjectStep((QuestHelper)this, 18903, new WorldPoint(3290, 3036, 0), "Climb up the ladder in the building in the camp.", this.bedabinKey);
        this.searchBookcase = new ObjectStep((QuestHelper)this, 2678, new WorldPoint(3284, 3033, 1), "Search the south west bookcase.", new Requirement[0]);
        this.talkToSiad = new NpcStep((QuestHelper)this, 4636, new WorldPoint(3292, 3032, 1), "Talk to Captain Siad about sailing to distract him.", this.bedabinKey);
        this.talkToSiad.addDialogSteps("I wanted to have a chat?", "You seem to have a lot of books!", "So, you're interested in sailing?", "I could tell by the cut of your jib.");
        this.searchChest = new ObjectStep((QuestHelper)this, 2677, new WorldPoint(3292, 3033, 1), "Search the chest.", new Requirement[0]);
        this.searchChest.addDialogSteps("I wanted to have a chat?", "You seem to have a lot of books!", "So, you're interested in sailing?", "I could tell by the cut of your jib.");
        this.returnToShabim = new NpcStep((QuestHelper)this, 4637, new WorldPoint(3171, 3028, 0), "Return to Al Shabim in the Bedabin Camp with the plans.", this.technicalPlans, this.bronzeBar, this.hammer, this.feather50);
        this.returnToShabim.addDialogSteps("Yes, I'm very interested.", "Yes, I'm kind of curious.");
        this.useAnvil = new ObjectStep((QuestHelper)this, 2672, new WorldPoint(3171, 3048, 0), "Enter the north tent and attempt to make a prototype dart tip on the anvil. Bring all 3 bars with you for this.", this.technicalPlans, this.bronzeBarHighlighted, this.hammer, this.feather50);
        this.useAnvil.addDialogStep("Yes. I'd like to try.");
        this.useAnvil.addIcon(2349);
        this.useFeatherOnTip = new DetailedQuestStep((QuestHelper)this, "Add 10 feathers to the prototype dart tip.", this.prototypeDartTip, this.feather50.highlighted());
        this.bringPrototypeToShabim = new NpcStep((QuestHelper)this, 4637, new WorldPoint(3171, 3028, 0), "Bring the prototype dart to Al Shabim.", this.prototypeDart);
        this.enterCampWithPineapple = new ObjectStep((QuestHelper)this, 2673, new WorldPoint(3273, 3029, 0), "UNEQUIP ALL COMBAT GEAR and enter the camp.", this.metalKey, this.tentiPineapple, this.slaveTop, this.slaveRobe, this.slaveBoot);
        this.enterMineWithPineapple = new ObjectStep((QuestHelper)this, 2675, new WorldPoint(3301, 3036, 0), "Equip the slave clothes, and enter the mine door in the north east of the camp.", this.slaveTopWorn, this.slaveRobeWorn, this.slaveBootWorn, this.tentiPineapple);
        this.talkToGuardWithPineapple = new NpcStep((QuestHelper)this, 4667, new WorldPoint(3278, 9415, 0), "Follow the cave around and talk to a guard guarding the deeper cave.", this.slaveTopWorn, this.slaveRobeWorn, this.slaveBootWorn, this.tentiPineapple);
        this.enterCampAfterPineapple = new ObjectStep((QuestHelper)this, 2673, new WorldPoint(3273, 3029, 0), "UNEQUIP ALL COMBAT GEAR and enter the camp.", this.metalKey, this.slaveTop, this.slaveRobe, this.slaveBoot);
        this.enterMineAfterPineapple = new ObjectStep((QuestHelper)this, 2675, new WorldPoint(3301, 3036, 0), "Equip the slave clothes, and enter the mine door in the north east of the camp.", this.slaveTopWorn, this.slaveRobeWorn, this.slaveBootWorn);
        this.enterDeepMine = new ObjectStep((QuestHelper)this, 2698, new WorldPoint(3281, 9414, 0), "Enter the deeper mines.", new Requirement[0]);
        this.getBarrel = new ObjectStep((QuestHelper)this, 2681, new WorldPoint(3303, 9418, 0), "Right-click search the barrel next to the mine cart for a barrel.", new Requirement[0]);
        this.getBarrel.addDialogStep("Yeah, cool!");
        this.enterMineCart = new ObjectStep((QuestHelper)this, 2684, new WorldPoint(3303, 9417, 0), "Right-click search the mine cart to ride it to the next room.", this.barrel);
        this.enterMineCart.addDialogStep("Yes, of course.");
        this.useBarrelOnAna = new NpcStep((QuestHelper)this, 4629, new WorldPoint(3297, 9464, 0), "Follow the path west then north until you find Ana. Use the barrel on her.", this.barrelHighlighted);
        this.useBarrelOnAna.addIcon(1841);
        this.useBarrelOnMineCart = new ObjectStep((QuestHelper)this, 2684, new WorldPoint(3318, 9430, 0), "Use Ana on the mine cart you came in on.", this.anaInABarrelHighlighted);
        this.useBarrelOnMineCart.addIcon(1842);
        this.returnInMineCart = new ObjectStep((QuestHelper)this, 2684, new WorldPoint(3318, 9430, 0), "Return in the mine cart you came in on.", new Requirement[0]);
        this.returnInMineCart.addDialogStep("Yes, of course.");
        this.searchBarrelsForAna = new ObjectStep((QuestHelper)this, 2681, new WorldPoint(3303, 9418, 0), "Right-click search the barrel next to the mine cart for Ana.", new Requirement[0]);
        this.sendAnaUp = new ObjectStep((QuestHelper)this, 18951, new WorldPoint(3292, 9423, 0), "Right-click use the winch bucket to send Ana to the surface.", new Requirement[0]);
        this.sendAnaUp.addDialogSteps("Yes please.", "I said you were very gregarious!");
        this.leaveDeepMine = new ObjectStep((QuestHelper)this, 2698, new WorldPoint(3283, 9415, 0), "Return to the surface. If Ana was captured again, search the barrel next to the mine cart for her.", new Requirement[0]);
        this.leaveMineForAna = new ObjectStep((QuestHelper)this, 2690, new WorldPoint(3278, 9426, 0), "Return to the surface.", new Requirement[0]);
        this.leaveDeepMine.addSubSteps(this.leaveMineForAna);
        this.operateWinch = new ObjectStep((QuestHelper)this, 18888, new WorldPoint(3279, 3018, 0), "Right-click operate the winch in the south west of the camp.", new Requirement[0]);
        this.searchWinchBarrel = new ObjectStep((QuestHelper)this, 18963, new WorldPoint(3278, 3017, 0), "Right-click search the barrel west of the winch. If it's empty, operate the winch again.", new Requirement[0]);
        this.useBarrelOnCart = new ObjectStep((QuestHelper)this, 2682, new WorldPoint(3288, 3024, 0), "Use Ana on the cart in the middle of the camp.", this.anaInABarrelHighlighted);
        this.useBarrelOnCart.addIcon(1842);
        this.talkToDriver = new NpcStep((QuestHelper)this, 4653, new WorldPoint(3287, 3021, 0), "Talk to the Mine Cart Driver to escape. Once he's agreed to take you, right-click search the wooden cart to escape.", new Requirement[0]);
        this.talkToDriver.addDialogSteps("Nice cart.", "One wagon wheel says to the other, 'I'll see you around'.", "'One good turn deserves another'", "Fired... no, shot perhaps!", "In for a penny in for a pound.", "Well, you see, it's like this...", "Prison riot in ten minutes, get your cart out of here!", "You can't leave me here, I'll get killed!", "Yes, I'll get on.");
        this.returnToIrena = new NpcStep((QuestHelper)this, 4640, new WorldPoint(3304, 3112, 0), "Bring Ana to Irena south of the Shantay Pass.", this.anaInABarrel);
        this.talkToAna = new NpcStep((QuestHelper)this, 4629, new WorldPoint(3302, 3110, 0), "Talk to Ana outside the Shantay Pass.", new Requirement[0]);
        this.talkToIrenaToFinish = new NpcStep((QuestHelper)this, 4640, new WorldPoint(3304, 3112, 0), "Talk to Irena south of the Shantay Pass to finish the quest!", new Requirement[0]);
        this.mineRocks = new DetailedQuestStep((QuestHelper)this, "Mine 15 rocks to be able to leave.", new Requirement[0]);
    }

    @Override
    public List<String> getNotes() {
        return Collections.singletonList("Almost any deviation from the steps listed here will often result in you being thrown into jail, or to an inconvenient location. If you'd wish to avoid this, try to follow the helper to the letter.");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.desertTop, this.desertBottom, this.desertBoot, this.bronzeBar3, this.hammer, this.feather50);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.combatGear, this.waterskins, this.knife, this.pickaxe, this.coins100);
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("Mercenary Captain (level 47)");
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        return Arrays.asList(new SkillRequirement(Skill.FLETCHING, 10, true), new SkillRequirement(Skill.SMITHING, 20, true));
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(2);
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("4,650 Exp. Lamps (Agility, Fletching, Smithing or Thieving)", 4447, 2));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("Ability to smith darts."));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Investigating the trap", Arrays.asList(this.talkToIrena, this.talkToCaptain, this.enterCamp, this.talkToSlave, this.enterMine, this.talkToGuard), this.desertTop, this.desertBottom, this.desertBoot, this.bronzeBar3, this.hammer, this.feather50));
        allSteps.add(new PanelDetails("Helping out", Arrays.asList(this.talkToShabim, this.enterCampForTask, this.goUpToSiad, this.searchBookcase, this.talkToSiad, this.searchChest, this.returnToShabim, this.useAnvil, this.useFeatherOnTip, this.bringPrototypeToShabim), this.bronzeBar3, this.hammer, this.feather50));
        allSteps.add(new PanelDetails("Freeing Ana", Arrays.asList(this.enterCampWithPineapple, this.enterMineWithPineapple, this.talkToGuardWithPineapple, this.enterDeepMine, this.getBarrel, this.enterMineCart, this.useBarrelOnAna, this.useBarrelOnMineCart, this.returnInMineCart, this.searchBarrelsForAna, this.sendAnaUp, this.leaveDeepMine, this.operateWinch, this.searchWinchBarrel, this.useBarrelOnCart, this.talkToDriver, this.returnToIrena, this.talkToAna, this.talkToIrenaToFinish), this.slaveTop, this.slaveRobe, this.slaveBoot));
        return allSteps;
    }
}

