/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.theslugmenace;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.helpers.quests.theslugmenace.PuzzleStep;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.ItemRequirements;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.widget.WidgetPresenceRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.THE_SLUG_MENACE)
public class TheSlugMenace
extends BasicQuestHelper {
    ItemRequirement commorb;
    ItemRequirement commorb2;
    ItemRequirement deadSeaSlug;
    ItemRequirement swampPaste;
    ItemRequirement page1;
    ItemRequirement page2;
    ItemRequirement page3;
    ItemRequirement glue;
    ItemRequirement doorTranscript;
    ItemRequirement pageFragment1;
    ItemRequirement pageFragment2;
    ItemRequirement pageFragment3;
    ItemRequirement essence;
    ItemRequirement blankAir;
    ItemRequirement blankEarth;
    ItemRequirement blankWater;
    ItemRequirement blankFire;
    ItemRequirement blankMind;
    ItemRequirement chisel;
    ItemRequirement airRune;
    ItemRequirement waterRune;
    ItemRequirement earthRune;
    ItemRequirement fireRune;
    ItemRequirement mindRune;
    ItemRequirement meleeGear;
    ItemRequirement essence5;
    ItemRequirement accessToAltars;
    ItemRequirement ardougneTeleports;
    ItemRequirement necklaceOfPassage;
    ItemRequirement airAltarTeleport;
    ItemRequirement earthAltarTeleport;
    ItemRequirement fireAltarTeleport;
    ItemRequirement waterAltarTeleport;
    ItemRequirement mindAltarTeleport;
    Requirement talkedToMaledict;
    Requirement talkedToHobb;
    Requirement talkedToHolgart;
    Requirement talkedToAllImportantPeople;
    Requirement inHobgoblinDungeon;
    Requirement inSeaSlugDungeon;
    Requirement openedWall;
    Requirement receivedFragments;
    Requirement onPlatform;
    Requirement puzzleUp;
    Requirement repairedPage;
    Requirement pickedUpSlug;
    Requirement hasOrUsedAirRune;
    Requirement hasOrUsedWaterRune;
    Requirement hasOrUsedEarthRune;
    Requirement hasOrUsedFireRune;
    Requirement hasOrUsedMindRune;
    Requirement hasAllRunes;
    Requirement usedAirRune;
    Requirement usedWaterRune;
    Requirement usedEarthRune;
    Requirement usedFireRune;
    Requirement usedMindRune;
    Requirement usedAllRunes;
    QuestStep talkToTiffy;
    QuestStep talkToNiall;
    QuestStep talkToMaledict;
    QuestStep talkToHobb;
    QuestStep talkToHolgart;
    QuestStep talkToNiall2;
    QuestStep enterDungeon;
    QuestStep pushFalseWall;
    QuestStep enterWall;
    QuestStep tryToOpenImposingDoor;
    QuestStep scanWithComm;
    QuestStep pickUpDeadSlug;
    QuestStep talkToJorral;
    QuestStep talkToNiall3;
    QuestStep talkToMaledict2;
    QuestStep talkToMaledict3;
    QuestStep searchMayorsDesk;
    QuestStep talkToLovecraft;
    QuestStep talkToNiall4;
    QuestStep useSwampPasteOnFragments;
    QuestStep talkToJeb;
    QuestStep talkToBailey;
    QuestStep useGlueOnFragment;
    QuestStep solvePuzzle;
    QuestStep useEmptyRunes;
    QuestStep enterDungeonAgain;
    QuestStep enterWallAgain;
    QuestStep useEmptyRunesOnDoor;
    QuestStep killSlugPrince;
    QuestStep reportBackToTiffy;
    QuestStep enterDungeonAgainUsedRunes;
    Zone hobgoblinDungeon;
    Zone seaSlugDungeon;
    Zone platform;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToTiffy);
        steps.put(1, this.talkToNiall);
        ConditionalStep talkToThreePeople = new ConditionalStep((QuestHelper)this, this.talkToMaledict, new Requirement[0]);
        talkToThreePeople.addStep(this.talkedToAllImportantPeople, this.talkToNiall2);
        talkToThreePeople.addStep(new Conditions(this.talkedToMaledict, this.talkedToHobb), this.talkToHolgart);
        talkToThreePeople.addStep(this.talkedToMaledict, this.talkToHobb);
        steps.put(2, talkToThreePeople);
        ConditionalStep goToDungeon = new ConditionalStep((QuestHelper)this, this.enterDungeon, new Requirement[0]);
        goToDungeon.addStep(this.inSeaSlugDungeon, this.tryToOpenImposingDoor);
        goToDungeon.addStep(new Conditions(this.inHobgoblinDungeon, this.openedWall), this.enterWall);
        goToDungeon.addStep(this.inHobgoblinDungeon, this.pushFalseWall);
        steps.put(3, goToDungeon);
        ConditionalStep getSlugAndTalkJorral = new ConditionalStep((QuestHelper)this, this.pickUpDeadSlug, new Requirement[0]);
        getSlugAndTalkJorral.addStep(new Conditions(LogicType.OR, this.deadSeaSlug, this.pickedUpSlug), this.talkToJorral);
        steps.put(4, getSlugAndTalkJorral);
        steps.put(5, this.talkToNiall3);
        steps.put(6, this.talkToNiall3);
        steps.put(7, this.talkToMaledict2);
        steps.put(8, this.talkToMaledict3);
        ConditionalStep findPages = new ConditionalStep((QuestHelper)this, this.searchMayorsDesk, new Requirement[0]);
        findPages.addStep(this.receivedFragments, this.useSwampPasteOnFragments);
        findPages.addStep(new Conditions(this.page1, this.page2), this.talkToNiall4);
        findPages.addStep(this.page1, this.talkToLovecraft);
        steps.put(9, findPages);
        ConditionalStep goMakePaste = new ConditionalStep((QuestHelper)this, this.talkToJeb, new Requirement[0]);
        goMakePaste.addStep(this.onPlatform, this.talkToBailey);
        steps.put(10, goMakePaste);
        ConditionalStep glueTogether = new ConditionalStep((QuestHelper)this, this.useGlueOnFragment, new Requirement[0]);
        glueTogether.addStep(new Conditions(this.inSeaSlugDungeon, this.usedAllRunes), this.killSlugPrince);
        glueTogether.addStep(new Conditions(this.hasAllRunes, this.inSeaSlugDungeon), this.useEmptyRunesOnDoor);
        glueTogether.addStep(new Conditions(this.hasAllRunes, this.inHobgoblinDungeon), this.enterWallAgain);
        glueTogether.addStep(this.usedAllRunes, this.enterDungeonAgainUsedRunes);
        glueTogether.addStep(this.hasAllRunes, this.enterDungeonAgain);
        glueTogether.addStep(this.repairedPage, this.useEmptyRunes);
        glueTogether.addStep(this.puzzleUp, this.solvePuzzle);
        steps.put(11, glueTogether);
        steps.put(12, this.reportBackToTiffy);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.commorb = new ItemRequirement("Commorb (can get another from Sir Tiffy)", 6635).isNotConsumed();
        this.commorb.addAlternates(9681);
        this.commorb2 = new ItemRequirement("Commorb v2", 9681).isNotConsumed();
        this.commorb2.setHighlightInInventory(true);
        this.deadSeaSlug = new ItemRequirement("Dead sea slug", 9683);
        this.swampPaste = new ItemRequirement("Swamp paste", 1941);
        this.swampPaste.setHighlightInInventory(true);
        this.essence = new ItemRequirement("Rune or Pure Essence", 7936);
        this.essence.addAlternates(1436);
        this.page1 = new ItemRequirement("Page 1", 9684);
        this.page1.setHighlightInInventory(true);
        this.page2 = new ItemRequirement("Page 2", 9685);
        this.page2.setHighlightInInventory(true);
        this.page3 = new ItemRequirement("Page 3", 9686);
        this.page3.setHighlightInInventory(true);
        this.pageFragment1 = new ItemRequirement("Fragment 1", 9687);
        this.pageFragment1.setHighlightInInventory(true);
        this.pageFragment2 = new ItemRequirement("Fragment 2", 9688);
        this.pageFragment2.setHighlightInInventory(true);
        this.pageFragment3 = new ItemRequirement("Fragment 3", 9689);
        this.pageFragment3.setHighlightInInventory(true);
        this.receivedFragments = new VarbitRequirement(2619, 1);
        this.glue = new ItemRequirement("Sea slug glue", 9680);
        this.glue.setHighlightInInventory(true);
        this.blankAir = new ItemRequirement("Blank air rune", 9692);
        this.blankEarth = new ItemRequirement("Blank earth rune", 9694);
        this.blankWater = new ItemRequirement("Blank water rune", 9690);
        this.blankFire = new ItemRequirement("Blank fire rune", 9698);
        this.blankMind = new ItemRequirement("Blank mind rune", 9696);
        this.chisel = new ItemRequirement("Chisel", 1755).isNotConsumed();
        this.usedAirRune = new VarbitRequirement(2623, 1);
        this.usedEarthRune = new VarbitRequirement(2622, 1);
        this.usedWaterRune = new VarbitRequirement(2625, 1);
        this.usedFireRune = new VarbitRequirement(2624, 1);
        this.usedMindRune = new VarbitRequirement(2626, 1);
        this.airRune = new ItemRequirement("Air rune", 9693).hideConditioned(this.usedAirRune);
        this.earthRune = new ItemRequirement("Earth rune", 9695).hideConditioned(this.usedEarthRune);
        this.waterRune = new ItemRequirement("Water rune", 9691).hideConditioned(this.usedWaterRune);
        this.fireRune = new ItemRequirement("Fire rune", 9699).hideConditioned(this.usedFireRune);
        this.mindRune = new ItemRequirement("Mind rune", 9697).hideConditioned(this.usedMindRune);
        this.meleeGear = new ItemRequirement("Melee weapon to fight the Slug Prince", -1, -1).isNotConsumed();
        this.meleeGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.doorTranscript = new ItemRequirement("Door transcription", 9682);
        this.ardougneTeleports = new ItemRequirement("Ardougne teleports", 8011, 3);
        this.essence5 = new ItemRequirement("Rune/pure essence, 15 to be safe", 7936, 5);
        this.essence5.addAlternates(1436);
        ItemRequirement airTalisman = new ItemRequirement("Air talisman", 1438);
        airTalisman.addAlternates(5527);
        ItemRequirement waterTalisman = new ItemRequirement("Water talisman", 1444);
        waterTalisman.addAlternates(5531);
        ItemRequirement earthTalisman = new ItemRequirement("Air talisman", 1440);
        earthTalisman.addAlternates(5535);
        ItemRequirement fireTalisman = new ItemRequirement("Fire talisman", 1442);
        fireTalisman.addAlternates(5537);
        ItemRequirement mindTalisman = new ItemRequirement("Mind talisman", 1448);
        mindTalisman.addAlternates(5529);
        this.accessToAltars = new ItemRequirements("Access to air, water, earth, fire, and mind runecrafting altars", airTalisman, waterTalisman, earthTalisman, fireTalisman, mindTalisman).isNotConsumed();
        this.necklaceOfPassage = new ItemRequirement("Necklace of Passage", ItemCollections.NECKLACE_OF_PASSAGES);
        this.airAltarTeleport = new ItemRequirement("Teleport near Air Altar", ItemCollections.SKILLS_NECKLACES);
        this.airAltarTeleport.addAlternates(8009, 11741);
        this.airAltarTeleport.setDisplayMatchedItemName(true);
        this.airAltarTeleport.setTooltip("The best items for this are (in order):");
        this.airAltarTeleport.appendToTooltip("Ring Of The Elements");
        this.airAltarTeleport.appendToTooltip("Skills Necklace (to Crafting Guild)");
        this.airAltarTeleport.appendToTooltip("Falador Teleport");
        this.airAltarTeleport.appendToTooltip("Rimmington/House Teleport");
        this.earthAltarTeleport = new ItemRequirement("Teleport near Earth Altar", ItemCollections.DIGSITE_PENDANTS);
        this.earthAltarTeleport.addAlternates(8007, 12642, 12403);
        this.earthAltarTeleport.setDisplayMatchedItemName(true);
        this.earthAltarTeleport.setTooltip("The best items for this are (in order):");
        this.earthAltarTeleport.appendToTooltip("Ring Of The Elements");
        this.earthAltarTeleport.appendToTooltip("Lumberyard Teleport");
        this.earthAltarTeleport.appendToTooltip("Digsite Pendant(s)");
        this.earthAltarTeleport.appendToTooltip("Digsite Teleport");
        this.earthAltarTeleport.appendToTooltip("Varrock Teleports");
        this.fireAltarTeleport = new ItemRequirement("Teleport near Fire Altar", ItemCollections.RING_OF_DUELINGS);
        this.fireAltarTeleport.addAlternates(ItemCollections.AMULET_OF_GLORIES);
        this.fireAltarTeleport.setTooltip("The best items for this are (in order):");
        this.fireAltarTeleport.appendToTooltip("Ring Of The Elements");
        this.fireAltarTeleport.appendToTooltip("Ring of Dueling");
        this.fireAltarTeleport.appendToTooltip("Amulet of Glory (to Al Kharid)");
        this.waterAltarTeleport = new ItemRequirement("Teleport near Water Altar", 8008);
        this.waterAltarTeleport.setTooltip("The best items for this are (in order):");
        this.waterAltarTeleport.appendToTooltip("Ring Of The Elements");
        this.waterAltarTeleport.appendToTooltip("Lumbridge Teleport");
        this.mindAltarTeleport = new ItemRequirement("Teleport near Mind Altar", 19617);
        this.mindAltarTeleport.addAlternates(8009, 12780, 11742);
        this.mindAltarTeleport.addAlternates(ItemCollections.COMBAT_BRACELETS);
        this.mindAltarTeleport.setTooltip("The best items for this are (in order):");
        this.mindAltarTeleport.appendToTooltip("Mind Altar Teleport (highly recommended)");
        this.mindAltarTeleport.appendToTooltip("Lassar Teleport (Ice Mountain)");
        this.mindAltarTeleport.appendToTooltip("Combat Bracelet to Monastery");
        this.mindAltarTeleport.appendToTooltip("Falador Teleport");
        this.mindAltarTeleport.appendToTooltip("Taverley Teleport");
    }

    public void loadZones() {
        this.hobgoblinDungeon = new Zone(new WorldPoint(2691, 9665, 0), new WorldPoint(2749, 9720, 0));
        this.seaSlugDungeon = new Zone(new WorldPoint(2304, 5059, 0), new WorldPoint(2377, 5124, 0));
        this.platform = new Zone(new WorldPoint(2760, 3271, 0), new WorldPoint(2795, 3293, 1));
    }

    public void setupConditions() {
        this.talkedToHolgart = new VarbitRequirement(2614, 1);
        this.talkedToHobb = new VarbitRequirement(2615, 1);
        this.talkedToMaledict = new VarbitRequirement(2616, 1);
        this.talkedToAllImportantPeople = new VarbitRequirement(2617, 7);
        this.inHobgoblinDungeon = new ZoneRequirement(this.hobgoblinDungeon);
        this.inSeaSlugDungeon = new ZoneRequirement(this.seaSlugDungeon);
        this.openedWall = new VarbitRequirement(2618, 1);
        this.onPlatform = new ZoneRequirement(this.platform);
        this.puzzleUp = new WidgetPresenceRequirement(460, 8);
        this.repairedPage = new VarbitRequirement(2611, 1);
        this.pickedUpSlug = new VarbitRequirement(2631, 1);
        this.hasOrUsedAirRune = new Conditions(LogicType.OR, this.airRune.alsoCheckBank(this.questBank), this.usedAirRune);
        this.hasOrUsedWaterRune = new Conditions(LogicType.OR, this.waterRune.alsoCheckBank(this.questBank), this.usedWaterRune);
        this.hasOrUsedEarthRune = new Conditions(LogicType.OR, this.earthRune.alsoCheckBank(this.questBank), this.usedEarthRune);
        this.hasOrUsedFireRune = new Conditions(LogicType.OR, this.fireRune.alsoCheckBank(this.questBank), this.usedFireRune);
        this.hasOrUsedMindRune = new Conditions(LogicType.OR, this.mindRune.alsoCheckBank(this.questBank), this.usedMindRune);
        this.hasAllRunes = new Conditions(this.hasOrUsedAirRune, this.hasOrUsedEarthRune, this.hasOrUsedFireRune, this.hasOrUsedMindRune, this.hasOrUsedWaterRune);
        this.usedAllRunes = new VarbitRequirement(2627, 31);
    }

    public void setupSteps() {
        this.talkToTiffy = new NpcStep((QuestHelper)this, 4687, new WorldPoint(2996, 3373, 0), "Talk to Sir Tiffy Cashien in Falador Park.", this.commorb);
        this.talkToTiffy.addDialogStep("Do you have any jobs for me yet?");
        this.talkToNiall = new NpcStep((QuestHelper)this, 4781, new WorldPoint(2739, 3311, 0), "Talk to Col. O'Niall on the pier in Witchaven, east of Ardougne.", new Requirement[0]);
        this.talkToNiall.addDialogStep("Who are the important people in Witchaven?");
        this.talkToNiall.addDialogStep("Nothing at the moment thanks.");
        this.talkToMaledict = new NpcStep((QuestHelper)this, 4787, new WorldPoint(2724, 3283, 0), "Talk to Brother Maledict in the church.", new Requirement[0]);
        this.talkToMaledict.addDialogStep("That's enough for now.");
        this.talkToHobb = new NpcStep((QuestHelper)this, 4783, new WorldPoint(2709, 3291, 0), "Talk to Mayor Hobb in north west Witchaven.", new Requirement[0]);
        this.talkToHobb.addDialogStep("I'm just looking around.");
        this.talkToHobb.addDialogStep("Nothing at the moment thanks.");
        this.talkToHolgart = new NpcStep((QuestHelper)this, 7789, new WorldPoint(2721, 3304, 0), "Talk to Holgart north of Witchaven.", new Requirement[0]);
        this.talkToHolgart.addDialogStep("Nothing at the moment thanks.");
        this.talkToNiall2 = new NpcStep((QuestHelper)this, 4781, new WorldPoint(2739, 3311, 0), "Return to Col. O'Niall on the pier in Witchaven.", new Requirement[0]);
        this.enterDungeon = new ObjectStep((QuestHelper)this, 18270, new WorldPoint(2696, 3283, 0), "Enter the old ruin entrance west of Witchaven.", new Requirement[0]);
        this.enterDungeon.addDialogStep("That's enough for now.");
        this.pushFalseWall = new ObjectStep((QuestHelper)this, 19124, new WorldPoint(2701, 9688, 0), "Push the wall just east of where you come down.", new Requirement[0]);
        this.enterWall = new ObjectStep((QuestHelper)this, 19124, new WorldPoint(2701, 9688, 0), "Enter the secret room.", new Requirement[0]);
        this.tryToOpenImposingDoor = new ObjectStep((QuestHelper)this, 18413, new WorldPoint(2351, 5093, 0), "Follow the path until you reach an imposing door, and try opening it. After, try scanning with the commorb v2.", this.commorb2);
        this.scanWithComm = new DetailedQuestStep((QuestHelper)this, "Try scanning with the commorb.", this.commorb);
        this.pickUpDeadSlug = new ItemStep((QuestHelper)this, "Pick up the dead sea slug next to the imposing door.", this.deadSeaSlug);
        this.talkToJorral = new NpcStep((QuestHelper)this, 3490, new WorldPoint(2436, 3347, 0), "Talk to Jorral north of West Ardougne.", Collections.singletonList(this.doorTranscript), Collections.singletonList(this.necklaceOfPassage));
        this.talkToJorral.addDialogStep("Translations");
        this.talkToNiall3 = new NpcStep((QuestHelper)this, 4781, new WorldPoint(2739, 3311, 0), "Return to Col. O'Niall on the pier in Witchaven.", new Requirement[0]);
        this.talkToMaledict2 = new NpcStep((QuestHelper)this, 4787, new WorldPoint(2724, 3283, 0), "Talk to Brother Maledict in the church.", new Requirement[0]);
        this.talkToMaledict3 = new NpcStep((QuestHelper)this, 4788, new WorldPoint(2724, 3283, 0), "Talk to Brother Maledict in the church.", new Requirement[0]);
        this.searchMayorsDesk = new ObjectStep((QuestHelper)this, 18224, new WorldPoint(2709, 3294, 0), "Search the study desk in the Mayor's house for a page.", new Requirement[0]);
        this.talkToLovecraft = new NpcStep((QuestHelper)this, 4789, new WorldPoint(2734, 3291, 0), "Talk to Ezekial Lovecraft in the fishing shop in east Witchaven for a page.", new Requirement[0]);
        this.talkToNiall4 = new NpcStep((QuestHelper)this, 4782, new WorldPoint(2739, 3311, 0), "Talk to Col. O'Niall on the pier in Witchaven for a page.", new Requirement[0]);
        this.useSwampPasteOnFragments = new DetailedQuestStep((QuestHelper)this, "Use some swamp paste on one of the page fragments.", this.swampPaste, this.pageFragment1, this.pageFragment2, this.pageFragment3);
        this.talkToJeb = new NpcStep((QuestHelper)this, 4803, new WorldPoint(2721, 3304, 0), "Talk to Jeb north of Witchaven to travel to the Fishing Platform.", this.deadSeaSlug);
        this.talkToBailey = new NpcStep((QuestHelper)this, 5066, new WorldPoint(2764, 3275, 0), "Talk to Bailey on the Fishing Platform.", this.deadSeaSlug);
        this.useGlueOnFragment = new DetailedQuestStep((QuestHelper)this, "Use the slug glue on one of the fragments.", this.glue, this.pageFragment1);
        this.solvePuzzle = new PuzzleStep(this);
        this.useEmptyRunes = new DetailedQuestStep((QuestHelper)this, "Right-click each page to turn rune/pure essence into empty runes. Take each empty rune and use it on its respective Runecrafting Altar. Bring extra essence (~10 extra) as it is possible to accidentally destroy the essence upon creation.", this.page1, this.page2, this.page3, this.essence, this.chisel);
        this.enterDungeonAgain = new ObjectStep((QuestHelper)this, 18270, new WorldPoint(2696, 3283, 0), "Prepare to fight the Slug Prince (level 62). Only melee can hurt it. Then, enter the old ruin entrance west of Witchaven.", this.meleeGear, this.airRune, this.waterRune, this.earthRune, this.fireRune, this.mindRune);
        this.enterDungeonAgainUsedRunes = new ObjectStep((QuestHelper)this, 18270, new WorldPoint(2696, 3283, 0), "Prepare to fight the Slug Prince (level 62). Only melee can hurt it. Then, enter the old ruin entrance west of Witchaven.", this.meleeGear);
        this.enterWallAgain = new ObjectStep((QuestHelper)this, 19124, new WorldPoint(2701, 9688, 0), "Enter the wall just east of where you come down.", new Requirement[0]);
        this.useEmptyRunesOnDoor = new ObjectStep((QuestHelper)this, 18413, new WorldPoint(2351, 5093, 0), "Use the runes on the imposing doors at the end of the path.", this.airRune, this.waterRune, this.earthRune, this.fireRune, this.mindRune);
        this.killSlugPrince = new NpcStep((QuestHelper)this, 4797, new WorldPoint(2351, 5093, 0), "Kill the Slug Prince. Only melee can hurt it.", new Requirement[0]);
        this.reportBackToTiffy = new NpcStep((QuestHelper)this, 4687, new WorldPoint(2996, 3373, 0), "Report back to Sir Tiffy Cashien in Falador Park.", new Requirement[0]);
        this.reportBackToTiffy.addDialogStep("Slug Menace.");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.commorb);
        reqs.add(this.swampPaste);
        reqs.add(this.essence5);
        reqs.add(this.chisel);
        reqs.add(this.accessToAltars);
        return reqs;
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.ardougneTeleports);
        reqs.add(this.necklaceOfPassage);
        reqs.addAll(Arrays.asList(this.airAltarTeleport, this.earthAltarTeleport, this.fireAltarTeleport, this.waterAltarTeleport, this.mindAltarTeleport));
        return reqs;
    }

    @Override
    public List<String> getCombatRequirements() {
        ArrayList<String> reqs = new ArrayList<String>();
        reqs.add("Slug Prince (level 62) (can only be hurt by melee)");
        return reqs;
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new QuestRequirement(QuestHelperQuest.WANTED, QuestState.FINISHED));
        req.add(new QuestRequirement(QuestHelperQuest.SEA_SLUG, QuestState.FINISHED));
        req.add(new SkillRequirement(Skill.CRAFTING, 30));
        req.add(new SkillRequirement(Skill.RUNECRAFT, 30));
        req.add(new SkillRequirement(Skill.SLAYER, 30));
        req.add(new SkillRequirement(Skill.THIEVING, 30));
        return req;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.RUNECRAFT, 3500), new ExperienceReward(Skill.CRAFTING, 3500), new ExperienceReward(Skill.THIEVING, 3500));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("Ability to purchase and equip Proselyte equipment."));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Collections.singletonList(this.talkToTiffy), this.commorb));
        allSteps.add(new PanelDetails("Investigating", Arrays.asList(this.talkToNiall, this.talkToMaledict, this.talkToHobb, this.talkToHolgart, this.talkToNiall2, this.enterDungeon, this.pushFalseWall, this.tryToOpenImposingDoor, this.scanWithComm, this.pickUpDeadSlug), this.commorb2));
        allSteps.add(new PanelDetails("Uncovering the truth", Arrays.asList(this.talkToJorral, this.talkToNiall3, this.talkToMaledict2, this.searchMayorsDesk, this.talkToLovecraft, this.talkToNiall4, this.useSwampPasteOnFragments, this.talkToJeb, this.talkToBailey, this.useGlueOnFragment, this.solvePuzzle, this.useEmptyRunes), this.doorTranscript, this.commorb2, this.deadSeaSlug, this.swampPaste, this.chisel, this.essence5, this.accessToAltars));
        allSteps.add(new PanelDetails("Facing the prince", Arrays.asList(this.enterDungeonAgain, this.enterWallAgain, this.useEmptyRunesOnDoor, this.killSlugPrince, this.reportBackToTiffy), this.meleeGear, this.airRune, this.waterRune, this.earthRune, this.fireRune, this.mindRune, this.commorb2));
        return allSteps;
    }
}

