/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.theslugmenace;

import com.questhelper.QuestHelperPlugin;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.steps.QuestStep;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.client.eventbus.Subscribe;

public class PuzzleStep
extends QuestStep {
    private final int FLIP_BUTTON = 8;
    private final int DOWN_BUTTON = 7;
    private final int LEFT_BUTTON = 6;
    private final int RIGHT_BUTTON = 5;
    private final int UP_BUTTON = 4;
    private final int ROTATE_BUTTON = 3;
    private final int HORIZONTAL = 0;
    private final int VERTICAL = 1;
    private final int FLIP = 2;
    private final int ROTATE = 3;
    private final int SELECTED = 4;
    private final int SELECT_BUTTON = 5;
    private HashMap<Integer, Integer> highlightButtons = new HashMap();
    private HashMap<Integer, Integer> highlightButtonSelection = new HashMap();
    private final HashMap<Integer, Integer>[] pieces = new HashMap[3];
    private final HashMap<Integer, Integer>[] solvedPieces = new HashMap[3];

    public PuzzleStep(QuestHelper questHelper) {
        super(questHelper, "Click the highlighted boxes to move the pieces to the correct spots.");
        int SELECT_1_BUTTON = 13;
        int SELECT_2_BUTTON = 14;
        int SELECT_3_BUTTON = 15;
        this.pieces[0] = new HashMap();
        this.pieces[0].put(0, 876);
        this.pieces[0].put(1, 877);
        this.pieces[0].put(2, 878);
        this.pieces[0].put(3, 879);
        this.pieces[0].put(4, 12155);
        this.pieces[0].put(5, 13);
        this.solvedPieces[0] = new HashMap();
        this.solvedPieces[0].put(0, 33);
        this.solvedPieces[0].put(1, 33);
        this.solvedPieces[0].put(2, 1);
        this.solvedPieces[0].put(3, 1);
        this.pieces[1] = new HashMap();
        this.pieces[1].put(0, 880);
        this.pieces[1].put(1, 881);
        this.pieces[1].put(2, 882);
        this.pieces[1].put(3, 883);
        this.pieces[1].put(4, 12157);
        this.pieces[1].put(5, 14);
        this.solvedPieces[1] = new HashMap();
        this.solvedPieces[1].put(0, 33);
        this.solvedPieces[1].put(1, 33);
        this.solvedPieces[1].put(2, 1);
        this.solvedPieces[1].put(3, 1);
        this.pieces[2] = new HashMap();
        this.pieces[2].put(0, 884);
        this.pieces[2].put(1, 885);
        this.pieces[2].put(2, 886);
        this.pieces[2].put(3, 887);
        this.pieces[2].put(4, 12159);
        this.pieces[2].put(5, 15);
        this.solvedPieces[2] = new HashMap();
        this.solvedPieces[2].put(0, 33);
        this.solvedPieces[2].put(1, 33);
        this.solvedPieces[2].put(2, 1);
        this.solvedPieces[2].put(3, 1);
        this.highlightButtons.put(8, 0);
        this.highlightButtons.put(7, 0);
        this.highlightButtons.put(6, 0);
        this.highlightButtons.put(5, 0);
        this.highlightButtons.put(4, 0);
        this.highlightButtons.put(3, 0);
        this.highlightButtons.put(13, 0);
        this.highlightButtons.put(14, 0);
        this.highlightButtons.put(15, 0);
    }

    @Override
    public void startUp() {
        this.updateSolvedPositionState();
    }

    @Override
    @Subscribe
    public void onVarbitChanged(VarbitChanged varbitChanged) {
        this.updateSolvedPositionState();
    }

    private void updateSolvedPositionState() {
        HashMap[] piecesCurrentState = new HashMap[3];
        HashMap<Integer, Integer> highlightButtonsTmp = new HashMap<Integer, Integer>();
        piecesCurrentState[0] = new HashMap();
        piecesCurrentState[0].put(0, this.client.getVarpValue(this.pieces[0].get(0).intValue()));
        piecesCurrentState[0].put(1, this.client.getVarpValue(this.pieces[0].get(1).intValue()));
        piecesCurrentState[0].put(2, this.client.getVarpValue(this.pieces[0].get(2).intValue()));
        piecesCurrentState[0].put(3, this.client.getVarpValue(this.pieces[0].get(3).intValue()));
        piecesCurrentState[1] = new HashMap();
        piecesCurrentState[1].put(0, this.client.getVarpValue(this.pieces[1].get(0).intValue()));
        piecesCurrentState[1].put(1, this.client.getVarpValue(this.pieces[1].get(1).intValue()));
        piecesCurrentState[1].put(2, this.client.getVarpValue(this.pieces[1].get(2).intValue()));
        piecesCurrentState[1].put(3, this.client.getVarpValue(this.pieces[1].get(3).intValue()));
        piecesCurrentState[2] = new HashMap();
        piecesCurrentState[2].put(0, this.client.getVarpValue(this.pieces[2].get(0).intValue()));
        piecesCurrentState[2].put(1, this.client.getVarpValue(this.pieces[2].get(1).intValue()));
        piecesCurrentState[2].put(2, this.client.getVarpValue(this.pieces[2].get(2).intValue()));
        piecesCurrentState[2].put(3, this.client.getVarpValue(this.pieces[2].get(3).intValue()));
        int goalH = (Integer)piecesCurrentState[0].get(0);
        int goalV = (Integer)piecesCurrentState[0].get(1);
        int[] goalRangeH = new int[5];
        int[] goalRangeV = new int[5];
        for (int i = 0; i < 5; ++i) {
            goalRangeH[i] = goalH - 2 + i;
            goalRangeV[i] = goalV - 2 + i;
        }
        int currentPiece = (Integer)piecesCurrentState[0].get(2) != 1 || (Integer)piecesCurrentState[0].get(3) != 1 ? 0 : ((Integer)piecesCurrentState[1].get(3) != 1 || (Integer)piecesCurrentState[1].get(2) != 1 || !Arrays.stream(goalRangeH).anyMatch(h -> h == (Integer)piecesCurrentState[1].get(0)) || !Arrays.stream(goalRangeV).anyMatch(v -> v == (Integer)piecesCurrentState[1].get(1)) ? 1 : 2);
        boolean onlyCurrentSelected = true;
        if (this.client.getVarbitValue(this.pieces[currentPiece].get(4).intValue()) == 0) {
            highlightButtonsTmp.put(this.pieces[currentPiece].get(5), 1);
            onlyCurrentSelected = false;
        }
        if (this.client.getVarbitValue(this.pieces[(currentPiece + 1) % 3].get(4).intValue()) == 1) {
            highlightButtonsTmp.put(this.pieces[(currentPiece + 1) % 3].get(5), 1);
            onlyCurrentSelected = false;
        }
        if (this.client.getVarbitValue(this.pieces[Math.floorMod(currentPiece - 1, 3)].get(4).intValue()) == 1) {
            highlightButtonsTmp.put(this.pieces[Math.floorMod(currentPiece - 1, 3)].get(5), 1);
            onlyCurrentSelected = false;
        }
        if (!onlyCurrentSelected) {
            this.highlightButtonSelection = highlightButtonsTmp;
            this.highlightButtons = new HashMap();
            return;
        }
        if (!((Integer)piecesCurrentState[currentPiece].get(2)).equals(1)) {
            highlightButtonsTmp.put(8, 1);
        } else if (!((Integer)piecesCurrentState[currentPiece].get(3)).equals(1)) {
            highlightButtonsTmp.put(3, 1);
        } else if ((Integer)piecesCurrentState[currentPiece].get(0) < goalH - 2) {
            highlightButtonsTmp.put(5, 1);
        } else if ((Integer)piecesCurrentState[currentPiece].get(0) > goalH + 2) {
            highlightButtonsTmp.put(6, 1);
        } else if ((Integer)piecesCurrentState[currentPiece].get(1) > goalV + 2) {
            highlightButtonsTmp.put(4, 1);
        } else if ((Integer)piecesCurrentState[currentPiece].get(1) < goalV - 2) {
            highlightButtonsTmp.put(7, 1);
        }
        this.highlightButtonSelection = new HashMap();
        this.highlightButtons = highlightButtonsTmp;
    }

    @Override
    public void makeWidgetOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
        Widget widget;
        super.makeWidgetOverlayHint(graphics, plugin);
        for (Map.Entry<Integer, Integer> entry : this.highlightButtons.entrySet()) {
            if (entry.getValue() == 0 || (widget = this.client.getWidget(462, entry.getKey().intValue())) == null) continue;
            graphics.setColor(new Color(this.questHelper.getConfig().targetOverlayColor().getRed(), this.questHelper.getConfig().targetOverlayColor().getGreen(), this.questHelper.getConfig().targetOverlayColor().getBlue(), 65));
            graphics.fill(widget.getBounds());
            graphics.setColor(this.questHelper.getConfig().targetOverlayColor());
            graphics.draw(widget.getBounds());
        }
        for (Map.Entry<Integer, Integer> entry : this.highlightButtonSelection.entrySet()) {
            Widget widgetSelectionButton;
            if (entry.getValue() == 0 || (widget = this.client.getWidget(462, entry.getKey().intValue())) == null || (widgetSelectionButton = widget.getChild(3)) == null) continue;
            graphics.setColor(new Color(this.questHelper.getConfig().targetOverlayColor().getRed(), this.questHelper.getConfig().targetOverlayColor().getGreen(), this.questHelper.getConfig().targetOverlayColor().getBlue(), 65));
            graphics.fill(widgetSelectionButton.getBounds());
            graphics.setColor(this.questHelper.getConfig().targetOverlayColor());
            graphics.draw(widgetSelectionButton.getBounds());
        }
    }
}

