/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.therestlessghost;

import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.conditional.NpcCondition;
import com.questhelper.requirements.conditional.ObjectCondition;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.THE_RESTLESS_GHOST)
public class TheRestlessGhost
extends BasicQuestHelper {
    private ItemRequirement ghostspeakAmulet;
    private ItemRequirement skull;
    private ItemRequirement lumbridgeTeleports;
    private ItemRequirement passage;
    private Requirement ghostSpawned;
    private Requirement coffinOpened;
    private Requirement inBasement;
    private Requirement hasSkull;
    private QuestStep talkToAereck;
    private QuestStep talkToUrhney;
    private QuestStep speakToGhost;
    private QuestStep openCoffin;
    private QuestStep searchCoffin;
    private QuestStep enterWizardsTowerBasement;
    private QuestStep searchAltarAndRun;
    private QuestStep exitWizardsTowerBasement;
    private QuestStep openCoffinToPutSkullIn;
    private QuestStep putSkullInCoffin;
    private Zone basement;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupRequirements();
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToAereck);
        steps.put(1, this.talkToUrhney);
        ConditionalStep talkToGhost = new ConditionalStep((QuestHelper)this, this.openCoffin, new Requirement[0]);
        talkToGhost.addStep(this.ghostSpawned, this.speakToGhost);
        talkToGhost.addStep(this.coffinOpened, this.searchCoffin);
        steps.put(2, talkToGhost);
        ConditionalStep getSkullForGhost = new ConditionalStep((QuestHelper)this, this.enterWizardsTowerBasement, new Requirement[0]);
        getSkullForGhost.addStep(this.inBasement, this.searchAltarAndRun);
        steps.put(3, getSkullForGhost);
        ConditionalStep returnSkullToGhost = new ConditionalStep((QuestHelper)this, this.enterWizardsTowerBasement, new Requirement[0]);
        returnSkullToGhost.addStep(new Conditions(this.inBasement, this.hasSkull), this.exitWizardsTowerBasement);
        returnSkullToGhost.addStep(new Conditions(this.hasSkull, this.coffinOpened), this.putSkullInCoffin);
        returnSkullToGhost.addStep(this.hasSkull, this.openCoffinToPutSkullIn);
        returnSkullToGhost.addStep(this.inBasement, this.searchAltarAndRun);
        steps.put(4, returnSkullToGhost);
        return steps;
    }

    public void setupZones() {
        this.basement = new Zone(new WorldPoint(3094, 9553, 0), new WorldPoint(3125, 9582, 0));
    }

    public void setupConditions() {
        this.ghostSpawned = new NpcCondition(922);
        this.coffinOpened = new ObjectCondition(15061);
        this.inBasement = new ZoneRequirement(this.basement);
        this.hasSkull = new VarbitRequirement(2130, 1);
    }

    @Override
    public void setupRequirements() {
        this.lumbridgeTeleports = new ItemRequirement("Lumbridge teleports", 8008, 2);
        this.ghostspeakAmulet = new ItemRequirement("Ghostspeak amulet", 552, 1, true).isNotConsumed();
        this.ghostspeakAmulet.setTooltip("If you've lost it you can get another from Father Urhney in his hut in the south east of Lumbridge Swamp");
        this.skull = new ItemRequirement("Ghost's skull", 553);
        this.skull.setTooltip("Check your bank if you don't have this item on you.");
        this.passage = new ItemRequirement("Necklace of passage", 21146);
        this.passage.addAlternates(21155, 21153, 21151, 21149);
    }

    public void setupSteps() {
        this.talkToAereck = new NpcStep((QuestHelper)this, 2812, new WorldPoint(3243, 3206, 0), "Talk to Father Aereck in the Lumbridge Church.", new Requirement[0]);
        this.talkToAereck.addDialogStep("I'm looking for a quest!");
        this.talkToAereck.addDialogStep("Ok, let me help then.");
        this.talkToUrhney = new NpcStep((QuestHelper)this, 923, new WorldPoint(3147, 3175, 0), "Talk to Father Urhney in the south west of Lumbridge Swamp.", new Requirement[0]);
        this.talkToUrhney.addDialogStep("Father Aereck sent me to talk to you.");
        this.talkToUrhney.addDialogStep("He's got a ghost haunting his graveyard.");
        this.openCoffin = new ObjectStep((QuestHelper)this, 2145, new WorldPoint(3250, 3193, 0), "Open the coffin in the Lumbridge Graveyard to spawn the ghost.", this.ghostspeakAmulet);
        this.openCoffin.addDialogStep("Yep, now tell me what the problem is.");
        this.openCoffin.addDialogStep("Yep, clever aren't I?.");
        this.openCoffin.addDialogStep("Yes, ok. Do you know WHY you're a ghost?");
        this.openCoffin.addDialogStep("Yes, ok. Do you know why you're a ghost?");
        this.searchCoffin = new ObjectStep((QuestHelper)this, 15061, new WorldPoint(3250, 3193, 0), "Search the coffin in the Lumbridge Graveyard to spawn the ghost.", this.ghostspeakAmulet);
        this.searchCoffin.addDialogStep("Yep, now tell me what the problem is.");
        this.searchCoffin.addDialogStep("Yep, clever aren't I?.");
        this.searchCoffin.addDialogStep("Yes, ok. Do you know WHY you're a ghost?");
        this.searchCoffin.addDialogStep("Yes, ok. Do you know why you're a ghost?");
        this.speakToGhost = new NpcStep((QuestHelper)this, 922, new WorldPoint(3250, 3195, 0), "Speak to the Ghost that appears whilst wearing your Ghostspeak Amulet.", this.ghostspeakAmulet);
        this.speakToGhost.addDialogStep("Yep, now tell me what the problem is.");
        this.speakToGhost.addDialogStep("Yep, clever aren't I?.");
        this.speakToGhost.addDialogStep("Yes, ok. Do you know WHY you're a ghost?");
        this.speakToGhost.addDialogStep("Yes, ok. Do you know why you're a ghost?");
        this.enterWizardsTowerBasement = new ObjectStep((QuestHelper)this, 2147, new WorldPoint(3104, 3162, 0), "Enter the Wizards' Tower basement.", new Requirement[0]);
        this.searchAltarAndRun = new ObjectStep((QuestHelper)this, 2146, new WorldPoint(3120, 9567, 0), "Search the Altar. A skeleton (level 13) will appear and attack you, but you can just run away.", new Requirement[0]);
        this.exitWizardsTowerBasement = new ObjectStep((QuestHelper)this, 2148, new WorldPoint(3103, 9576, 0), "Leave the basement.", this.skull);
        this.openCoffinToPutSkullIn = new ObjectStep((QuestHelper)this, 2145, new WorldPoint(3250, 3193, 0), "Open the ghost's coffin in Lumbridge graveyard.", this.skull);
        this.putSkullInCoffin = new ObjectStep((QuestHelper)this, 15061, new WorldPoint(3250, 3193, 0), "Search the coffin.", this.skull);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        ArrayList<ItemRequirement> recommended = new ArrayList<ItemRequirement>();
        recommended.add(this.lumbridgeTeleports);
        recommended.add(this.passage);
        return recommended;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.PRAYER, 1125));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("Ghostspeak Amulet", 552, 1));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Talk to Father Aereck", Collections.singletonList(this.talkToAereck), new Requirement[0]));
        allSteps.add(new PanelDetails("Get a ghostspeak amulet", Collections.singletonList(this.talkToUrhney), new Requirement[0]));
        allSteps.add(new PanelDetails("Talk to the ghost", Arrays.asList(this.openCoffin, this.speakToGhost), new Requirement[0]));
        allSteps.add(new PanelDetails("Return the ghost's skull", Arrays.asList(this.enterWizardsTowerBasement, this.searchAltarAndRun, this.exitWizardsTowerBasement, this.openCoffinToPutSkullIn, this.putSkullInCoffin), new Requirement[0]));
        return allSteps;
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("A skeleton (level 13) you can run away from");
    }
}

