/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.thequeenofthieves;

import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.Favour;
import com.questhelper.requirements.player.FavourRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.THE_QUEEN_OF_THIEVES)
public class TheQueenOfThieves
extends BasicQuestHelper {
    ItemRequirement stew;
    ItemRequirement hughesLetter;
    QuestStep talkToLawry;
    QuestStep talkToPoorLookingPerson;
    QuestStep talkToOReilly;
    QuestStep talkToDevan;
    QuestStep exitWarrens;
    QuestStep killConrad;
    QuestStep tellDevanAboutConrad;
    QuestStep exitWarrens2;
    QuestStep goToKingstown;
    QuestStep openChest;
    QuestStep leaveKingstown;
    QuestStep talkToLawry2;
    QuestStep talkToShauna;
    ObjectStep enterWarrens;
    ObjectStep enterWarrens2;
    ObjectStep enterWarrens3;
    ObjectStep enterWarrens4;
    NpcStep talkToQueenOfThieves;
    ZoneRequirement inWarrens;
    ZoneRequirement inUpstairsHughesHouse;
    Zone warrens;
    Zone kingstown;
    Zone upstairsHughesHouse;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        ConditionalStep searchHughesChest = new ConditionalStep((QuestHelper)this, this.goToKingstown, new Requirement[0]);
        searchHughesChest.addStep(this.inWarrens, this.exitWarrens);
        searchHughesChest.addStep(this.inUpstairsHughesHouse, this.openChest);
        steps.put(0, this.talkToLawry);
        steps.put(1, this.talkToPoorLookingPerson);
        steps.put(2, this.talkToOReilly);
        steps.put(3, this.talkToOReilly);
        ConditionalStep findDevan = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterWarrens, new Requirement[0]);
        findDevan.addStep(this.inWarrens, this.talkToDevan);
        steps.put(4, findDevan);
        steps.put(5, findDevan);
        ConditionalStep killConradConditional = new ConditionalStep((QuestHelper)this, this.killConrad, new Requirement[0]);
        killConradConditional.addStep(this.inWarrens, this.exitWarrens);
        steps.put(6, killConradConditional);
        ConditionalStep tellDevanAboutConradConditional = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterWarrens2, new Requirement[0]);
        tellDevanAboutConradConditional.addStep(this.inWarrens, this.tellDevanAboutConrad);
        steps.put(7, tellDevanAboutConradConditional);
        ConditionalStep talkToQueenOfThievesConditional = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterWarrens3, new Requirement[0]);
        talkToQueenOfThievesConditional.addStep(this.inWarrens, this.talkToQueenOfThieves);
        steps.put(8, talkToQueenOfThievesConditional);
        steps.put(9, talkToQueenOfThievesConditional);
        ConditionalStep exposeHughes = new ConditionalStep((QuestHelper)this, this.goToKingstown, new Requirement[0]);
        exposeHughes.addStep(this.inWarrens, this.exitWarrens2);
        exposeHughes.addStep(this.inUpstairsHughesHouse, this.openChest);
        steps.put(10, exposeHughes);
        ConditionalStep talkToLawry2Conditional = new ConditionalStep((QuestHelper)this, this.talkToLawry2, new Requirement[0]);
        talkToLawry2Conditional.addStep(this.inUpstairsHughesHouse, this.leaveKingstown);
        steps.put(11, talkToLawry2Conditional);
        ConditionalStep talkToShaunaConditional = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterWarrens4, new Requirement[0]);
        talkToShaunaConditional.addStep(this.inWarrens, this.talkToShauna);
        steps.put(12, talkToShaunaConditional);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.stew = new ItemRequirement("Stew", 2003);
        this.hughesLetter = new ItemRequirement("Letter", 21774);
        this.hughesLetter.setTooltip("You can get another letter by searching the chest upstairs in Hughes' house in Kingstown.");
    }

    public void loadZones() {
        this.warrens = new Zone(new WorldPoint(1728, 10115, 0), new WorldPoint(1814, 10177, 0));
        this.kingstown = new Zone(new WorldPoint(1668, 3675, 1), new WorldPoint(1685, 3684, 1));
        this.upstairsHughesHouse = new Zone(new WorldPoint(1668, 3675, 1), new WorldPoint(1685, 3684, 1));
    }

    public void setupConditions() {
        this.inWarrens = new ZoneRequirement(this.warrens);
        this.inUpstairsHughesHouse = new ZoneRequirement(this.upstairsHughesHouse);
    }

    public void setupSteps() {
        WorldPoint tomasPoint = new WorldPoint(1796, 3781, 0);
        WorldPoint manholePoint = new WorldPoint(1813, 3745, 0);
        WorldPoint ladderPoint = new WorldPoint(1813, 10145, 0);
        WorldPoint devanPoint = new WorldPoint(1767, 10146, 0);
        WorldPoint queenOfThievesPoint = new WorldPoint(1764, 10158, 0);
        this.talkToLawry = new NpcStep((QuestHelper)this, 7904, tomasPoint, "Speak to Tomas Lawry in Port Piscarilius.", new Requirement[0]);
        this.talkToLawry.addDialogStep("I'm looking for a quest.");
        this.talkToLawry.addDialogStep("What are you investigating?");
        this.talkToLawry.addDialogStep("Yes.");
        this.talkToPoorLookingPerson = new NpcStep((QuestHelper)this, 7923, new WorldPoint(1803, 3738, 0), "Speak to the poor looking woman.", new Requirement[0]);
        this.talkToOReilly = new NpcStep((QuestHelper)this, 7905, new WorldPoint(1794, 3757, 0), "Speak to Robert O'Reilly, and give him the bowl of stew.", this.stew);
        this.talkToOReilly.addDialogStep("Okay.");
        this.enterWarrens = new ObjectStep((QuestHelper)this, 31706, manholePoint, "Enter the Warrens.", new Requirement[0]);
        this.enterWarrens.addAlternateObjects(31707);
        this.talkToDevan = new NpcStep((QuestHelper)this, 7906, devanPoint, "Speak to Devan Rutter.", new Requirement[0]);
        this.talkToDevan.addDialogStep("Nope, sounds good to me.");
        this.exitWarrens = new ObjectStep((QuestHelper)this, 31708, ladderPoint, "Exit the Warrens.", new Requirement[0]);
        this.killConrad = new NpcStep((QuestHelper)this, 7907, new WorldPoint(1847, 3734, 0), "Murder Conrad King.", new Requirement[0]);
        this.enterWarrens2 = new ObjectStep((QuestHelper)this, 31706, manholePoint, "Enter the Warrens.", new Requirement[0]);
        this.enterWarrens2.addAlternateObjects(31707);
        this.tellDevanAboutConrad = new NpcStep((QuestHelper)this, 7906, devanPoint, "Tell Devan Rutter about the murder.", new Requirement[0]);
        this.enterWarrens3 = new ObjectStep((QuestHelper)this, 31706, manholePoint, "Enter the Warrens.", new Requirement[0]);
        this.enterWarrens3.addAlternateObjects(31707);
        this.talkToQueenOfThieves = new NpcStep((QuestHelper)this, 7908, queenOfThievesPoint, "Talk to the Queen of Thieves.", new Requirement[0]);
        this.talkToQueenOfThieves.addAlternateNpcs(7909);
        this.exitWarrens2 = new ObjectStep((QuestHelper)this, 31708, ladderPoint, "Exit the Warrens.", new Requirement[0]);
        this.goToKingstown = new ObjectStep((QuestHelper)this, 11796, new WorldPoint(1672, 3681, 0), "Go up the stairs in Councillor Hughes' home in Kingstown.", new Requirement[0]);
        this.openChest = new ObjectStep((QuestHelper)this, 10084, new WorldPoint(1681, 3677, 1), "Pick the locked chest.", new Requirement[0]);
        this.leaveKingstown = new ObjectStep((QuestHelper)this, 11799, new WorldPoint(1672, 3682, 1), "Go downstairs.", new Requirement[0]);
        this.talkToLawry2 = new NpcStep((QuestHelper)this, 7904, tomasPoint, "Speak to Tomas Lawry in Port Piscarilius.", this.hughesLetter);
        this.talkToLawry2.addDialogStep("Let's talk about my quest.");
        this.enterWarrens4 = new ObjectStep((QuestHelper)this, 31706, manholePoint, "Enter the Warrens.", new Requirement[0]);
        this.enterWarrens4.addAlternateObjects(31707);
        this.talkToShauna = new NpcStep((QuestHelper)this, 7909, queenOfThievesPoint, "Talk to Lady Shauna Piscarilius.", new Requirement[0]);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Collections.singletonList(this.stew);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        return Arrays.asList(new SkillRequirement(Skill.THIEVING, 20), new FavourRequirement(Favour.PISCARILIUS, 20), new QuestRequirement(QuestHelperQuest.CLIENT_OF_KOUREND, QuestState.FINISHED), new QuestRequirement(QuestHelperQuest.X_MARKS_THE_SPOT, QuestState.FINISHED));
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.THIEVING, 1000));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Coins", 995, 2000), new ItemReward("A Piscarilius Favour Certificate", 21775, 1), new ItemReward("A page for Kharedst's Memoirs", 21760, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("Access to The Warrens."));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Investigation", Arrays.asList(this.talkToLawry, this.talkToPoorLookingPerson, this.talkToOReilly), this.stew));
        allSteps.add(new PanelDetails("Gaining Trust", Arrays.asList(this.enterWarrens, this.talkToDevan, this.exitWarrens, this.killConrad, this.enterWarrens2, this.tellDevanAboutConrad), new Requirement[0]));
        allSteps.add(new PanelDetails("Exposing Hughes", Arrays.asList(this.enterWarrens3, this.talkToQueenOfThieves, this.exitWarrens2, this.goToKingstown, this.openChest, this.leaveKingstown, this.talkToLawry2, this.enterWarrens4, this.talkToShauna), new Requirement[0]));
        return allSteps;
    }
}

