/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.thepathofglouphrie.sections;

import com.questhelper.helpers.quests.thepathofglouphrie.MonolithPuzzle;
import com.questhelper.helpers.quests.thepathofglouphrie.ThePathOfGlouphrie;
import com.questhelper.helpers.quests.thepathofglouphrie.YewnocksPuzzle;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import com.questhelper.steps.WidgetStep;
import java.util.List;
import net.runelite.api.coords.WorldPoint;

public class UnveilEvil {
    public ConditionalStep enterStoreroom;
    public ConditionalStep solveMonolithPuzzleStep;
    public ConditionalStep solveYewnocksMachinePuzzleStep;
    public ConditionalStep learnLoreStep;
    public DetailedQuestStep watchCutscene;
    private MonolithPuzzle solveMonolithPuzzle;
    private ConditionalStep learnLore;
    private YewnocksPuzzle solveYewnocksMachinePuzzle;

    public void setup(ThePathOfGlouphrie quest) {
        ObjectStep squeezeThroughRailing = quest.enterTreeGnomeVillageMazeFromMiddle.copy();
        ObjectStep climbIntoDungeon = quest.climbDownIntoTreeGnomeVillageDungeon.copy();
        ObjectStep enter = new ObjectStep((QuestHelper)quest, 49620, new WorldPoint(2608, 4451, 0), "", new Requirement[0]);
        enter.addSubSteps(squeezeThroughRailing, climbIntoDungeon);
        this.enterStoreroom = new ConditionalStep((QuestHelper)quest, (QuestStep)climbIntoDungeon, "Enter the storeroom to the east in the Tree Gnome Village dungeon.", new Requirement[0]);
        this.enterStoreroom.addStep(quest.inTreeGnomeVillageDungeon, enter);
        this.enterStoreroom.addStep(quest.inTreeGnomeVillageMiddle, squeezeThroughRailing);
        this.solveMonolithPuzzle = new MonolithPuzzle(quest);
        this.solveMonolithPuzzleStep = new ConditionalStep((QuestHelper)quest, (QuestStep)this.enterStoreroom, new Requirement[0]);
        this.solveMonolithPuzzleStep.addStep(quest.inStoreroom, this.solveMonolithPuzzle);
        ObjectStep clickLectern = new ObjectStep((QuestHelper)quest, 49673, YewnocksPuzzle.regionPoint(24, 28), "Click the lectern.", new Requirement[0]);
        WidgetStep clickChapter1 = new WidgetStep((QuestHelper)quest, "Click Chapter 1 to learn about the mysterious stranger.", 854, 5);
        WidgetStep clickChapter2 = new WidgetStep((QuestHelper)quest, "Click Chapter 2 to learn about the great king's death.", 854, 9);
        WidgetStep clickChapter3 = new WidgetStep((QuestHelper)quest, "Click Chapter 3 to learn about the old foe.", 854, 13);
        DetailedQuestStep watchLoreCutscene = new DetailedQuestStep((QuestHelper)quest, "Watch the cutscene.", new Requirement[0]);
        this.learnLore = new ConditionalStep((QuestHelper)quest, (QuestStep)clickLectern, "Learn about the lore. All items left on the ground are lost.", new Requirement[0]);
        this.learnLore.addStep(new Conditions(quest.lecternWidgetActive, quest.learnedAboutChapter1, quest.learnedAboutChapter2), clickChapter3);
        this.learnLore.addStep(new Conditions(quest.lecternWidgetActive, quest.learnedAboutChapter1), clickChapter2);
        this.learnLore.addStep(quest.lecternWidgetActive, clickChapter1);
        this.learnLore.addSubSteps(watchLoreCutscene);
        this.learnLoreStep = new ConditionalStep((QuestHelper)quest, (QuestStep)this.enterStoreroom, new Requirement[0]);
        this.learnLoreStep.addStep(quest.inCutscene, watchLoreCutscene);
        this.learnLoreStep.addStep(quest.inStoreroom, this.learnLore);
        ObjectStep squeezeThroughRailing2 = quest.enterTreeGnomeVillageMazeFromMiddle.copy();
        squeezeThroughRailing2.setText("Squeeze through the loose railing.");
        ObjectStep climbIntoDungeon2 = quest.climbDownIntoTreeGnomeVillageDungeon.copy();
        climbIntoDungeon2.setText("Climb down the ladder to the Tree Gnome Village dungeon.");
        ObjectStep enterStoreroom = new ObjectStep((QuestHelper)quest, 49620, new WorldPoint(2608, 4451, 0), "Enter the storeroom to the east in the Tree Gnome Village dungeon.", new Requirement[0]);
        ConditionalStep enterStoreroomPuzzle = new ConditionalStep((QuestHelper)quest, (QuestStep)climbIntoDungeon2, "Get to Yewnock's storeroom.", new Requirement[0]);
        enterStoreroomPuzzle.addStep(quest.inTreeGnomeVillageDungeon, enterStoreroom);
        enterStoreroomPuzzle.addStep(quest.inTreeGnomeVillageMiddle, squeezeThroughRailing2);
        this.solveYewnocksMachinePuzzle = new YewnocksPuzzle(quest);
        this.solveYewnocksMachinePuzzle.addSubSteps(enterStoreroomPuzzle);
        this.solveYewnocksMachinePuzzle.addSubSteps(enterStoreroomPuzzle.getSteps());
        this.solveYewnocksMachinePuzzleStep = new ConditionalStep((QuestHelper)quest, (QuestStep)enterStoreroomPuzzle, new Requirement[0]);
        this.solveYewnocksMachinePuzzleStep.addStep(quest.inStoreroom, this.solveYewnocksMachinePuzzle);
        this.watchCutscene = new DetailedQuestStep((QuestHelper)quest, "Watch the cutscene.", new Requirement[0]);
    }

    public List<QuestStep> getSteps() {
        return List.of(this.enterStoreroom, this.solveMonolithPuzzle, this.learnLore, this.solveYewnocksMachinePuzzle, this.watchCutscene);
    }
}

