/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.thepathofglouphrie;

import com.questhelper.helpers.quests.thepathofglouphrie.DiscInsertionStep;
import com.questhelper.helpers.quests.thepathofglouphrie.Solution;
import com.questhelper.helpers.quests.thepathofglouphrie.ThePathOfGlouphrie;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.ItemRequirements;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.widget.WidgetPresenceRequirement;
import com.questhelper.steps.DetailedOwnerStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import com.questhelper.steps.WidgetDetails;
import com.questhelper.steps.WidgetStep;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.client.eventbus.Subscribe;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YewnocksPuzzle
extends DetailedOwnerStep {
    private static final Logger log = LoggerFactory.getLogger(YewnocksPuzzle.class);
    private static final int STOREROOM_REGION = 11074;
    private static final int PUZZLE1_INSERTED_DISC_VARP_ID = 3994;
    private static final int PUZZLE2_UPPER_INSERTED_DISC_VARP_ID = 3995;
    private static final int PUZZLE2_LOWER_INSERTED_DISC_VARP_ID = 3996;
    private static final int PUZZLE1_LEFT_VARP_ID = 3997;
    private static final int PUZZLE1_RIGHT_VARP_ID = 3998;
    private static final int PUZZLE2_VARP_ID = 3999;
    private final HashMap<Integer, ItemRequirement> discs = new HashMap();
    private final HashMap<Integer, ItemRequirement> valueToRequirement = new HashMap();
    private final HashMap<Integer, Integer> discToValue = new HashMap();
    private final HashMap<Integer, List<ItemRequirements>> valueToDoubleDiscRequirement = new HashMap();
    private final HashMap<Integer, List<ItemRequirement>> valuePossibleSingleDiscExchangesRequirements = new HashMap();
    private final Solution solution = new Solution();
    private int puzzle1LeftItemID = -1;
    private int puzzle1RightItemID = -1;
    private int puzzle2ItemID = -1;
    private ObjectStep getMoreDiscs;
    private ObjectStep clickMachine;
    private ObjectStep clickMachineOnce;
    private ObjectStep useExchanger;
    private ItemStep machineInsertDisc;
    private WidgetStep machineReset;
    private WidgetStep machineSubmit;
    private ItemStep exchangerInsertDisc;
    private WidgetStep exchangerExchange;
    private DetailedQuestStep exchangerConfirm;
    private WidgetStep exchangerReset;
    private WidgetPresenceRequirement machineOpen;
    private WidgetPresenceRequirement exchangerOpen;

    public YewnocksPuzzle(ThePathOfGlouphrie pog) {
        super((QuestHelper)pog, "Operate Yewnock's machine & solve the puzzle. All items left on the ground are lost.", new Requirement[0]);
        YewnocksPuzzle.loadDiscs(this.discs);
        YewnocksPuzzle.loadValueToRequirement(this.discs, this.valueToRequirement);
        YewnocksPuzzle.loadDiscToValue(this.discToValue);
        YewnocksPuzzle.loadValueToDoubleDiscRequirement(this.valueToRequirement, this.valueToDoubleDiscRequirement);
        YewnocksPuzzle.loadValuePossibleExchanges(this.discs, this.discToValue, this.valueToRequirement, this.valuePossibleSingleDiscExchangesRequirements);
    }

    public static void loadValuePossibleExchanges(HashMap<Integer, ItemRequirement> discs, HashMap<Integer, Integer> discToValue, HashMap<Integer, ItemRequirement> valueToRequirement, HashMap<Integer, List<ItemRequirement>> valuePossibleSingleDiscExchangesRequirements) {
        HashMap<Integer, HashSet<List<Integer>>> validExchangesForDisc = new HashMap<Integer, HashSet<List<Integer>>>();
        validExchangesForDisc.put(9600, new HashSet<List<Integer>>(List.of(List.of(Integer.valueOf(9609), Integer.valueOf(9597)), List.of(Integer.valueOf(9599), Integer.valueOf(9597)), List.of(Integer.valueOf(9613)), List.of(Integer.valueOf(9600)))));
        validExchangesForDisc.put(9601, new HashSet<List<Integer>>(List.of(List.of(Integer.valueOf(9601)))));
        validExchangesForDisc.put(9602, new HashSet<List<Integer>>(List.of(List.of(Integer.valueOf(9617)), List.of(Integer.valueOf(9602)), List.of(Integer.valueOf(9613), Integer.valueOf(9597)), List.of(Integer.valueOf(9599), Integer.valueOf(9601)), List.of(Integer.valueOf(9600), Integer.valueOf(9597)), List.of(Integer.valueOf(9609), Integer.valueOf(9601)))));
        validExchangesForDisc.put(9603, new HashSet<List<Integer>>(List.of(List.of(Integer.valueOf(9603)), List.of(Integer.valueOf(9602), Integer.valueOf(9601)), List.of(Integer.valueOf(9617), Integer.valueOf(9601)), List.of(Integer.valueOf(9613), Integer.valueOf(9598)), List.of(Integer.valueOf(9600), Integer.valueOf(9598)), List.of(Integer.valueOf(9621), Integer.valueOf(9597)))));
        validExchangesForDisc.put(9604, new HashSet<List<Integer>>(List.of(List.of(Integer.valueOf(9604)), List.of(Integer.valueOf(9603), Integer.valueOf(9601)), List.of(Integer.valueOf(9606), Integer.valueOf(9597)), List.of(Integer.valueOf(9602), Integer.valueOf(9609)), List.of(Integer.valueOf(9617), Integer.valueOf(9609)), List.of(Integer.valueOf(9621), Integer.valueOf(9598)))));
        validExchangesForDisc.put(9606, new HashSet<List<Integer>>(List.of(List.of(Integer.valueOf(9606)), List.of(Integer.valueOf(9621), Integer.valueOf(9601)), List.of(Integer.valueOf(9602), Integer.valueOf(9598)), List.of(Integer.valueOf(9617), Integer.valueOf(9598)), List.of(Integer.valueOf(9603), Integer.valueOf(9597)))));
        validExchangesForDisc.put(9607, new HashSet<List<Integer>>(List.of(List.of(Integer.valueOf(9621), Integer.valueOf(9599), Integer.valueOf(9597)), List.of(Integer.valueOf(9603), Integer.valueOf(9609)), List.of(Integer.valueOf(9607)), List.of(Integer.valueOf(9621), Integer.valueOf(9600)), List.of(Integer.valueOf(9610)), List.of(Integer.valueOf(9604), Integer.valueOf(9601)), List.of(Integer.valueOf(9621), Integer.valueOf(9609), Integer.valueOf(9597)), List.of(Integer.valueOf(9621), Integer.valueOf(9613)), List.of(Integer.valueOf(9606), Integer.valueOf(9598)))));
        validExchangesForDisc.put(9608, new HashSet<List>(List.of(List.of(Integer.valueOf(9604), Integer.valueOf(9609), Integer.valueOf(9597)), List.of(Integer.valueOf(9606), Integer.valueOf(9613), Integer.valueOf(9597)), List.of(Integer.valueOf(9608)), List.of(Integer.valueOf(9606), Integer.valueOf(9617)), List.of(Integer.valueOf(9614)), List.of(Integer.valueOf(9604), Integer.valueOf(9613)), List.of(Integer.valueOf(9606), Integer.valueOf(9609), Integer.valueOf(9601)), List.of(Integer.valueOf(9606), Integer.valueOf(9600), Integer.valueOf(9597)), List.of(Integer.valueOf(9604), Integer.valueOf(9599), Integer.valueOf(9597)), List.of(Integer.valueOf(9610), Integer.valueOf(9598)), List.of(Integer.valueOf(9606), Integer.valueOf(9599), Integer.valueOf(9601)), List.of(Integer.valueOf(9604), Integer.valueOf(9600)), List.of(Integer.valueOf(9606), Integer.valueOf(9602)), List.of(Integer.valueOf(9607), Integer.valueOf(9598)))));
        validExchangesForDisc.put(9609, new HashSet<List<Integer>>(List.of(List.of(Integer.valueOf(9609)))));
        validExchangesForDisc.put(9610, new HashSet<List<Integer>>(List.of(List.of(Integer.valueOf(9621), Integer.valueOf(9599), Integer.valueOf(9597)), List.of(Integer.valueOf(9603), Integer.valueOf(9609)), List.of(Integer.valueOf(9607)), List.of(Integer.valueOf(9621), Integer.valueOf(9600)), List.of(Integer.valueOf(9610)), List.of(Integer.valueOf(9604), Integer.valueOf(9601)), List.of(Integer.valueOf(9621), Integer.valueOf(9609), Integer.valueOf(9597)), List.of(Integer.valueOf(9606), Integer.valueOf(9598)), List.of(Integer.valueOf(9621), Integer.valueOf(9613)))));
        validExchangesForDisc.put(9611, new HashSet<List>(List.of(List.of(Integer.valueOf(9604), Integer.valueOf(9613), Integer.valueOf(9597)), List.of(Integer.valueOf(9606), Integer.valueOf(9617), Integer.valueOf(9597)), List.of(Integer.valueOf(9610), Integer.valueOf(9609)), List.of(Integer.valueOf(9607), Integer.valueOf(9609)), List.of(Integer.valueOf(9604), Integer.valueOf(9617)), List.of(Integer.valueOf(9611)), List.of(Integer.valueOf(9604), Integer.valueOf(9609), Integer.valueOf(9601)), List.of(Integer.valueOf(9606), Integer.valueOf(9613), Integer.valueOf(9601)), List.of(Integer.valueOf(9604), Integer.valueOf(9600), Integer.valueOf(9597)), List.of(Integer.valueOf(9608), Integer.valueOf(9597)), List.of(Integer.valueOf(9606), Integer.valueOf(9602), Integer.valueOf(9597)), List.of(Integer.valueOf(9614), Integer.valueOf(9597)), List.of(Integer.valueOf(9606), Integer.valueOf(9621)), List.of(Integer.valueOf(9606), Integer.valueOf(9600), Integer.valueOf(9601)), List.of(Integer.valueOf(9604), Integer.valueOf(9599), Integer.valueOf(9601)), List.of(Integer.valueOf(9604), Integer.valueOf(9602)))));
        validExchangesForDisc.put(9612, new HashSet<List>(List.of(List.of(Integer.valueOf(9608), Integer.valueOf(9613)), List.of(Integer.valueOf(9610), Integer.valueOf(9621), Integer.valueOf(9597)), List.of(Integer.valueOf(9614), Integer.valueOf(9613)), List.of(Integer.valueOf(9607), Integer.valueOf(9617), Integer.valueOf(9601)), List.of(Integer.valueOf(9607), Integer.valueOf(9613), Integer.valueOf(9598)), List.of(Integer.valueOf(9610), Integer.valueOf(9613), Integer.valueOf(9598)), List.of(Integer.valueOf(9608), Integer.valueOf(9609), Integer.valueOf(9597)), List.of(Integer.valueOf(9612)), List.of(Integer.valueOf(9610), Integer.valueOf(9617), Integer.valueOf(9601)), List.of(Integer.valueOf(9614), Integer.valueOf(9609), Integer.valueOf(9597)), List.of(Integer.valueOf(9618), Integer.valueOf(9601)), List.of(Integer.valueOf(9610), Integer.valueOf(9600), Integer.valueOf(9598)), List.of(Integer.valueOf(9607), Integer.valueOf(9600), Integer.valueOf(9598)), List.of(Integer.valueOf(9608), Integer.valueOf(9599), Integer.valueOf(9597)), List.of(Integer.valueOf(9614), Integer.valueOf(9600)), List.of(Integer.valueOf(9607), Integer.valueOf(9602), Integer.valueOf(9601)), List.of(Integer.valueOf(9607), Integer.valueOf(9603)), List.of(Integer.valueOf(9614), Integer.valueOf(9599), Integer.valueOf(9597)), List.of(Integer.valueOf(9610), Integer.valueOf(9602), Integer.valueOf(9601)), List.of(Integer.valueOf(9611), Integer.valueOf(9609)), List.of(Integer.valueOf(9607), Integer.valueOf(9621), Integer.valueOf(9597)), List.of(Integer.valueOf(9608), Integer.valueOf(9600)), List.of(Integer.valueOf(9610), Integer.valueOf(9603)))));
        validExchangesForDisc.put(9613, new HashSet<List<Integer>>(List.of(List.of(Integer.valueOf(9609), Integer.valueOf(9597)), List.of(Integer.valueOf(9599), Integer.valueOf(9597)), List.of(Integer.valueOf(9613)), List.of(Integer.valueOf(9600)))));
        validExchangesForDisc.put(9614, new HashSet<List>(List.of(List.of(Integer.valueOf(9604), Integer.valueOf(9609), Integer.valueOf(9597)), List.of(Integer.valueOf(9608)), List.of(Integer.valueOf(9606), Integer.valueOf(9613), Integer.valueOf(9597)), List.of(Integer.valueOf(9606), Integer.valueOf(9617)), List.of(Integer.valueOf(9614)), List.of(Integer.valueOf(9604), Integer.valueOf(9613)), List.of(Integer.valueOf(9606), Integer.valueOf(9609), Integer.valueOf(9601)), List.of(Integer.valueOf(9604), Integer.valueOf(9599), Integer.valueOf(9597)), List.of(Integer.valueOf(9606), Integer.valueOf(9600), Integer.valueOf(9597)), List.of(Integer.valueOf(9610), Integer.valueOf(9598)), List.of(Integer.valueOf(9606), Integer.valueOf(9599), Integer.valueOf(9601)), List.of(Integer.valueOf(9606), Integer.valueOf(9602)), List.of(Integer.valueOf(9604), Integer.valueOf(9600)), List.of(Integer.valueOf(9607), Integer.valueOf(9598)))));
        validExchangesForDisc.put(9615, new HashSet<List>(List.of(List.of(Integer.valueOf(9608), Integer.valueOf(9613)), List.of(Integer.valueOf(9610), Integer.valueOf(9621), Integer.valueOf(9597)), List.of(Integer.valueOf(9607), Integer.valueOf(9617), Integer.valueOf(9601)), List.of(Integer.valueOf(9614), Integer.valueOf(9613)), List.of(Integer.valueOf(9607), Integer.valueOf(9613), Integer.valueOf(9598)), List.of(Integer.valueOf(9610), Integer.valueOf(9613), Integer.valueOf(9598)), List.of(Integer.valueOf(9608), Integer.valueOf(9609), Integer.valueOf(9597)), List.of(Integer.valueOf(9612)), List.of(Integer.valueOf(9610), Integer.valueOf(9617), Integer.valueOf(9601)), List.of(Integer.valueOf(9614), Integer.valueOf(9609), Integer.valueOf(9597)), List.of(Integer.valueOf(9618), Integer.valueOf(9601)), List.of(Integer.valueOf(9610), Integer.valueOf(9600), Integer.valueOf(9598)), List.of(Integer.valueOf(9607), Integer.valueOf(9600), Integer.valueOf(9598)), List.of(Integer.valueOf(9614), Integer.valueOf(9600)), List.of(Integer.valueOf(9608), Integer.valueOf(9599), Integer.valueOf(9597)), List.of(Integer.valueOf(9607), Integer.valueOf(9602), Integer.valueOf(9601)), List.of(Integer.valueOf(9607), Integer.valueOf(9603)), List.of(Integer.valueOf(9614), Integer.valueOf(9599), Integer.valueOf(9597)), List.of(Integer.valueOf(9610), Integer.valueOf(9602), Integer.valueOf(9601)), List.of(Integer.valueOf(9611), Integer.valueOf(9609)), List.of(Integer.valueOf(9607), Integer.valueOf(9621), Integer.valueOf(9597)), List.of(Integer.valueOf(9608), Integer.valueOf(9600)), List.of(Integer.valueOf(9610), Integer.valueOf(9603)))));
        validExchangesForDisc.put(9616, new HashSet<List>(List.of(List.of(Integer.valueOf(9618), Integer.valueOf(9621)), List.of(Integer.valueOf(9612), Integer.valueOf(9613)), List.of(Integer.valueOf(9608), Integer.valueOf(9606), Integer.valueOf(9597)), List.of(Integer.valueOf(9619), Integer.valueOf(9597)), List.of(Integer.valueOf(9611), Integer.valueOf(9603), Integer.valueOf(9597)), List.of(Integer.valueOf(9608), Integer.valueOf(9603), Integer.valueOf(9601)), List.of(Integer.valueOf(9618), Integer.valueOf(9613), Integer.valueOf(9601)), List.of(Integer.valueOf(9614), Integer.valueOf(9617), Integer.valueOf(9609)), List.of(Integer.valueOf(9611), Integer.valueOf(9606)), List.of(Integer.valueOf(9614), Integer.valueOf(9603), Integer.valueOf(9601)), List.of(Integer.valueOf(9612), Integer.valueOf(9599), Integer.valueOf(9597)), List.of(Integer.valueOf(9618), Integer.valueOf(9600), Integer.valueOf(9601)), List.of(Integer.valueOf(9608), Integer.valueOf(9621), Integer.valueOf(9598)), List.of(Integer.valueOf(9611), Integer.valueOf(9621), Integer.valueOf(9601)), List.of(Integer.valueOf(9614), Integer.valueOf(9621), Integer.valueOf(9598)), List.of(Integer.valueOf(9611), Integer.valueOf(9617), Integer.valueOf(9598)), List.of(Integer.valueOf(9614), Integer.valueOf(9602), Integer.valueOf(9609)), List.of(Integer.valueOf(9612), Integer.valueOf(9609), Integer.valueOf(9597)), List.of(Integer.valueOf(9608), Integer.valueOf(9617), Integer.valueOf(9609)), List.of(Integer.valueOf(9616)), List.of(Integer.valueOf(9618), Integer.valueOf(9617), Integer.valueOf(9597)), List.of(Integer.valueOf(9622), Integer.valueOf(9609)), List.of(Integer.valueOf(9612), Integer.valueOf(9600)), List.of(Integer.valueOf(9614), Integer.valueOf(9604)), List.of(Integer.valueOf(9611), Integer.valueOf(9602), Integer.valueOf(9598)), List.of(Integer.valueOf(9614), Integer.valueOf(9606), Integer.valueOf(9597)), List.of(Integer.valueOf(9608), Integer.valueOf(9604)), List.of(Integer.valueOf(9608), Integer.valueOf(9602), Integer.valueOf(9609)), List.of(Integer.valueOf(9618), Integer.valueOf(9602), Integer.valueOf(9597)))));
        validExchangesForDisc.put(9617, new HashSet<List<Integer>>(List.of(List.of(Integer.valueOf(9617)), List.of(Integer.valueOf(9602)), List.of(Integer.valueOf(9613), Integer.valueOf(9597)), List.of(Integer.valueOf(9599), Integer.valueOf(9601)), List.of(Integer.valueOf(9600), Integer.valueOf(9597)), List.of(Integer.valueOf(9609), Integer.valueOf(9601)))));
        validExchangesForDisc.put(9618, new HashSet<List>(List.of(List.of(Integer.valueOf(9604), Integer.valueOf(9617), Integer.valueOf(9601)), List.of(Integer.valueOf(9604), Integer.valueOf(9603)), List.of(Integer.valueOf(9607), Integer.valueOf(9613), Integer.valueOf(9597)), List.of(Integer.valueOf(9604), Integer.valueOf(9613), Integer.valueOf(9598)), List.of(Integer.valueOf(9610), Integer.valueOf(9613), Integer.valueOf(9597)), List.of(Integer.valueOf(9610), Integer.valueOf(9617)), List.of(Integer.valueOf(9607), Integer.valueOf(9609), Integer.valueOf(9601)), List.of(Integer.valueOf(9607), Integer.valueOf(9617)), List.of(Integer.valueOf(9604), Integer.valueOf(9600), Integer.valueOf(9598)), List.of(Integer.valueOf(9618)), List.of(Integer.valueOf(9607), Integer.valueOf(9600), Integer.valueOf(9597)), List.of(Integer.valueOf(9611), Integer.valueOf(9601)), List.of(Integer.valueOf(9608), Integer.valueOf(9598)), List.of(Integer.valueOf(9610), Integer.valueOf(9609), Integer.valueOf(9601)), List.of(Integer.valueOf(9604), Integer.valueOf(9602), Integer.valueOf(9601)), List.of(Integer.valueOf(9610), Integer.valueOf(9600), Integer.valueOf(9597)), List.of(Integer.valueOf(9614), Integer.valueOf(9598)), List.of(Integer.valueOf(9607), Integer.valueOf(9602)), List.of(Integer.valueOf(9610), Integer.valueOf(9599), Integer.valueOf(9601)), List.of(Integer.valueOf(9604), Integer.valueOf(9621), Integer.valueOf(9597)), List.of(Integer.valueOf(9607), Integer.valueOf(9599), Integer.valueOf(9601)), List.of(Integer.valueOf(9610), Integer.valueOf(9602)))));
        validExchangesForDisc.put(9619, new HashSet<List>(List.of(List.of(Integer.valueOf(9618), Integer.valueOf(9599), Integer.valueOf(9601)), List.of(Integer.valueOf(9618), Integer.valueOf(9617)), List.of(Integer.valueOf(9618), Integer.valueOf(9613), Integer.valueOf(9597)), List.of(Integer.valueOf(9608), Integer.valueOf(9603), Integer.valueOf(9597)), List.of(Integer.valueOf(9614), Integer.valueOf(9603), Integer.valueOf(9597)), List.of(Integer.valueOf(9618), Integer.valueOf(9609), Integer.valueOf(9601)), List.of(Integer.valueOf(9611), Integer.valueOf(9603)), List.of(Integer.valueOf(9611), Integer.valueOf(9621), Integer.valueOf(9597)), List.of(Integer.valueOf(9608), Integer.valueOf(9621), Integer.valueOf(9601)), List.of(Integer.valueOf(9608), Integer.valueOf(9617), Integer.valueOf(9598)), List.of(Integer.valueOf(9611), Integer.valueOf(9617), Integer.valueOf(9601)), List.of(Integer.valueOf(9614), Integer.valueOf(9617), Integer.valueOf(9598)), List.of(Integer.valueOf(9611), Integer.valueOf(9613), Integer.valueOf(9598)), List.of(Integer.valueOf(9614), Integer.valueOf(9621), Integer.valueOf(9601)), List.of(Integer.valueOf(9622), Integer.valueOf(9598)), List.of(Integer.valueOf(9608), Integer.valueOf(9602), Integer.valueOf(9598)), List.of(Integer.valueOf(9619)), List.of(Integer.valueOf(9618), Integer.valueOf(9602)), List.of(Integer.valueOf(9611), Integer.valueOf(9600), Integer.valueOf(9598)), List.of(Integer.valueOf(9612), Integer.valueOf(9609)), List.of(Integer.valueOf(9611), Integer.valueOf(9602), Integer.valueOf(9601)), List.of(Integer.valueOf(9608), Integer.valueOf(9606)), List.of(Integer.valueOf(9614), Integer.valueOf(9602), Integer.valueOf(9598)), List.of(Integer.valueOf(9618), Integer.valueOf(9600), Integer.valueOf(9597)), List.of(Integer.valueOf(9614), Integer.valueOf(9606)))));
        validExchangesForDisc.put(9620, new HashSet<List>(List.of(List.of(Integer.valueOf(9611), Integer.valueOf(9606), Integer.valueOf(9609), Integer.valueOf(9597)), List.of(Integer.valueOf(9611), Integer.valueOf(9603), Integer.valueOf(9609), Integer.valueOf(9601)), List.of(Integer.valueOf(9618), Integer.valueOf(9603), Integer.valueOf(9609)), List.of(Integer.valueOf(9619), Integer.valueOf(9599), Integer.valueOf(9601)), List.of(Integer.valueOf(9611), Integer.valueOf(9606), Integer.valueOf(9599), Integer.valueOf(9597)), List.of(Integer.valueOf(9611), Integer.valueOf(9603), Integer.valueOf(9617)), List.of(Integer.valueOf(9611), Integer.valueOf(9603), Integer.valueOf(9599), Integer.valueOf(9601)), List.of(Integer.valueOf(9623), Integer.valueOf(9601)), List.of(Integer.valueOf(9622), Integer.valueOf(9617), Integer.valueOf(9598)), List.of(Integer.valueOf(9619), Integer.valueOf(9613), Integer.valueOf(9597)), List.of(Integer.valueOf(9616), Integer.valueOf(9609), Integer.valueOf(9597)), List.of(Integer.valueOf(9618), Integer.valueOf(9621), Integer.valueOf(9599), Integer.valueOf(9597)), List.of(Integer.valueOf(9612), Integer.valueOf(9617), Integer.valueOf(9609)), List.of(Integer.valueOf(9622), Integer.valueOf(9621), Integer.valueOf(9601)), List.of(Integer.valueOf(9619), Integer.valueOf(9602)), List.of(Integer.valueOf(9611), Integer.valueOf(9607), Integer.valueOf(9601)), List.of(Integer.valueOf(9619), Integer.valueOf(9609), Integer.valueOf(9601)), List.of(Integer.valueOf(9611), Integer.valueOf(9603), Integer.valueOf(9613), Integer.valueOf(9597)), List.of(Integer.valueOf(9612), Integer.valueOf(9603), Integer.valueOf(9601)), List.of(Integer.valueOf(9611), Integer.valueOf(9603), Integer.valueOf(9602)), List.of(Integer.valueOf(9619), Integer.valueOf(9617)), List.of(Integer.valueOf(9618), Integer.valueOf(9621), Integer.valueOf(9613)), List.of(Integer.valueOf(9622), Integer.valueOf(9603), Integer.valueOf(9597)), List.of(Integer.valueOf(9616), Integer.valueOf(9599), Integer.valueOf(9597)), List.of(Integer.valueOf(9612), Integer.valueOf(9602), Integer.valueOf(9609)), List.of(Integer.valueOf(9622), Integer.valueOf(9602), Integer.valueOf(9598)), List.of(Integer.valueOf(9611), Integer.valueOf(9606), Integer.valueOf(9613)), List.of(Integer.valueOf(9612), Integer.valueOf(9621), Integer.valueOf(9598)), List.of(Integer.valueOf(9611), Integer.valueOf(9603), Integer.valueOf(9600), Integer.valueOf(9597)), List.of(Integer.valueOf(9618), Integer.valueOf(9621), Integer.valueOf(9609), Integer.valueOf(9597)), List.of(Integer.valueOf(9618), Integer.valueOf(9621), Integer.valueOf(9600)), List.of(Integer.valueOf(9612), Integer.valueOf(9606), Integer.valueOf(9597)), List.of(Integer.valueOf(9618), Integer.valueOf(9607)), List.of(Integer.valueOf(9620)), List.of(Integer.valueOf(9611), Integer.valueOf(9610), Integer.valueOf(9601)), List.of(Integer.valueOf(9616), Integer.valueOf(9600)), List.of(Integer.valueOf(9622), Integer.valueOf(9606)), List.of(Integer.valueOf(9611), Integer.valueOf(9606), Integer.valueOf(9600)), List.of(Integer.valueOf(9616), Integer.valueOf(9613)), List.of(Integer.valueOf(9618), Integer.valueOf(9606), Integer.valueOf(9598)), List.of(Integer.valueOf(9618), Integer.valueOf(9604), Integer.valueOf(9601)), List.of(Integer.valueOf(9612), Integer.valueOf(9604)), List.of(Integer.valueOf(9611), Integer.valueOf(9604), Integer.valueOf(9609)), List.of(Integer.valueOf(9618), Integer.valueOf(9610)), List.of(Integer.valueOf(9619), Integer.valueOf(9600), Integer.valueOf(9597)))));
        validExchangesForDisc.put(9621, new HashSet<List<Integer>>(List.of(List.of(Integer.valueOf(9613), Integer.valueOf(9601)), List.of(Integer.valueOf(9621)), List.of(Integer.valueOf(9600), Integer.valueOf(9601)), List.of(Integer.valueOf(9602), Integer.valueOf(9597)), List.of(Integer.valueOf(9617), Integer.valueOf(9597)))));
        validExchangesForDisc.put(9622, new HashSet<List>(List.of(List.of(Integer.valueOf(9614), Integer.valueOf(9617)), List.of(Integer.valueOf(9608), Integer.valueOf(9617)), List.of(Integer.valueOf(9610), Integer.valueOf(9603), Integer.valueOf(9597)), List.of(Integer.valueOf(9607), Integer.valueOf(9603), Integer.valueOf(9597)), List.of(Integer.valueOf(9611), Integer.valueOf(9600)), List.of(Integer.valueOf(9614), Integer.valueOf(9609), Integer.valueOf(9601)), List.of(Integer.valueOf(9611), Integer.valueOf(9599), Integer.valueOf(9597)), List.of(Integer.valueOf(9608), Integer.valueOf(9599), Integer.valueOf(9601)), List.of(Integer.valueOf(9614), Integer.valueOf(9599), Integer.valueOf(9601)), List.of(Integer.valueOf(9607), Integer.valueOf(9621), Integer.valueOf(9601)), List.of(Integer.valueOf(9607), Integer.valueOf(9617), Integer.valueOf(9598)), List.of(Integer.valueOf(9610), Integer.valueOf(9617), Integer.valueOf(9598)), List.of(Integer.valueOf(9607), Integer.valueOf(9606)), List.of(Integer.valueOf(9608), Integer.valueOf(9613), Integer.valueOf(9597)), List.of(Integer.valueOf(9611), Integer.valueOf(9613)), List.of(Integer.valueOf(9610), Integer.valueOf(9621), Integer.valueOf(9601)), List.of(Integer.valueOf(9618), Integer.valueOf(9598)), List.of(Integer.valueOf(9611), Integer.valueOf(9609), Integer.valueOf(9597)), List.of(Integer.valueOf(9608), Integer.valueOf(9609), Integer.valueOf(9601)), List.of(Integer.valueOf(9614), Integer.valueOf(9613), Integer.valueOf(9597)), List.of(Integer.valueOf(9607), Integer.valueOf(9602), Integer.valueOf(9598)), List.of(Integer.valueOf(9614), Integer.valueOf(9602)), List.of(Integer.valueOf(9622)), List.of(Integer.valueOf(9612), Integer.valueOf(9597)), List.of(Integer.valueOf(9608), Integer.valueOf(9600), Integer.valueOf(9597)), List.of(Integer.valueOf(9610), Integer.valueOf(9602), Integer.valueOf(9598)), List.of(Integer.valueOf(9614), Integer.valueOf(9600), Integer.valueOf(9597)), List.of(Integer.valueOf(9610), Integer.valueOf(9606)), List.of(Integer.valueOf(9608), Integer.valueOf(9602)))));
        validExchangesForDisc.put(9623, new HashSet<List>(List.of(List.of(Integer.valueOf(9611), Integer.valueOf(9603), Integer.valueOf(9609)), List.of(Integer.valueOf(9608), Integer.valueOf(9603), Integer.valueOf(9613)), List.of(Integer.valueOf(9622), Integer.valueOf(9621)), List.of(Integer.valueOf(9614), Integer.valueOf(9603), Integer.valueOf(9613)), List.of(Integer.valueOf(9608), Integer.valueOf(9610), Integer.valueOf(9597)), List.of(Integer.valueOf(9611), Integer.valueOf(9621), Integer.valueOf(9609), Integer.valueOf(9597)), List.of(Integer.valueOf(9611), Integer.valueOf(9621), Integer.valueOf(9613)), List.of(Integer.valueOf(9614), Integer.valueOf(9607), Integer.valueOf(9597)), List.of(Integer.valueOf(9619), Integer.valueOf(9609)), List.of(Integer.valueOf(9622), Integer.valueOf(9617), Integer.valueOf(9597)), List.of(Integer.valueOf(9608), Integer.valueOf(9603), Integer.valueOf(9600)), List.of(Integer.valueOf(9614), Integer.valueOf(9603), Integer.valueOf(9600)), List.of(Integer.valueOf(9611), Integer.valueOf(9607)), List.of(Integer.valueOf(9622), Integer.valueOf(9613), Integer.valueOf(9601)), List.of(Integer.valueOf(9618), Integer.valueOf(9617), Integer.valueOf(9609)), List.of(Integer.valueOf(9618), Integer.valueOf(9603), Integer.valueOf(9601)), List.of(Integer.valueOf(9612), Integer.valueOf(9621), Integer.valueOf(9597)), List.of(Integer.valueOf(9614), Integer.valueOf(9606), Integer.valueOf(9609)), List.of(Integer.valueOf(9622), Integer.valueOf(9602), Integer.valueOf(9597)), List.of(Integer.valueOf(9622), Integer.valueOf(9600), Integer.valueOf(9601)), List.of(Integer.valueOf(9611), Integer.valueOf(9610)), List.of(Integer.valueOf(9614), Integer.valueOf(9603), Integer.valueOf(9599), Integer.valueOf(9597)), List.of(Integer.valueOf(9611), Integer.valueOf(9621), Integer.valueOf(9600)), List.of(Integer.valueOf(9618), Integer.valueOf(9621), Integer.valueOf(9598)), List.of(Integer.valueOf(9612), Integer.valueOf(9617), Integer.valueOf(9601)), List.of(Integer.valueOf(9618), Integer.valueOf(9602), Integer.valueOf(9609)), List.of(Integer.valueOf(9616), Integer.valueOf(9598)), List.of(Integer.valueOf(9612), Integer.valueOf(9613), Integer.valueOf(9598)), List.of(Integer.valueOf(9608), Integer.valueOf(9607), Integer.valueOf(9597)), List.of(Integer.valueOf(9611), Integer.valueOf(9606), Integer.valueOf(9598)), List.of(Integer.valueOf(9614), Integer.valueOf(9610), Integer.valueOf(9597)), List.of(Integer.valueOf(9608), Integer.valueOf(9604), Integer.valueOf(9598)), List.of(Integer.valueOf(9611), Integer.valueOf(9604), Integer.valueOf(9601)), List.of(Integer.valueOf(9614), Integer.valueOf(9604), Integer.valueOf(9598)), List.of(Integer.valueOf(9608), Integer.valueOf(9603), Integer.valueOf(9599), Integer.valueOf(9597)), List.of(Integer.valueOf(9623)), List.of(Integer.valueOf(9618), Integer.valueOf(9604)), List.of(Integer.valueOf(9612), Integer.valueOf(9602), Integer.valueOf(9601)), List.of(Integer.valueOf(9608), Integer.valueOf(9606), Integer.valueOf(9609)), List.of(Integer.valueOf(9611), Integer.valueOf(9621), Integer.valueOf(9599), Integer.valueOf(9597)), List.of(Integer.valueOf(9618), Integer.valueOf(9606), Integer.valueOf(9597)), List.of(Integer.valueOf(9612), Integer.valueOf(9600), Integer.valueOf(9598)), List.of(Integer.valueOf(9614), Integer.valueOf(9603), Integer.valueOf(9609), Integer.valueOf(9597)), List.of(Integer.valueOf(9612), Integer.valueOf(9603)), List.of(Integer.valueOf(9608), Integer.valueOf(9603), Integer.valueOf(9609), Integer.valueOf(9597)))));
        validExchangesForDisc.put(9597, new HashSet<List<Integer>>(List.of(List.of(Integer.valueOf(9597)))));
        validExchangesForDisc.put(9598, new HashSet<List<Integer>>(List.of(List.of(Integer.valueOf(9598)))));
        validExchangesForDisc.put(9599, new HashSet<List<Integer>>(List.of(List.of(Integer.valueOf(9609)))));
        validExchangesForDisc.put(9624, new HashSet<List>(List.of(List.of(Integer.valueOf(9620), Integer.valueOf(9599), Integer.valueOf(9597)), List.of(Integer.valueOf(9622), Integer.valueOf(9603), Integer.valueOf(9602)), List.of(Integer.valueOf(9612), Integer.valueOf(9614)), List.of(Integer.valueOf(9612), Integer.valueOf(9606), Integer.valueOf(9600), Integer.valueOf(9597)), List.of(Integer.valueOf(9622), Integer.valueOf(9603), Integer.valueOf(9613), Integer.valueOf(9597)), List.of(Integer.valueOf(9612), Integer.valueOf(9610), Integer.valueOf(9598)), List.of(Integer.valueOf(9612), Integer.valueOf(9607), Integer.valueOf(9598)), List.of(Integer.valueOf(9623), Integer.valueOf(9617), Integer.valueOf(9597)), List.of(Integer.valueOf(9619), Integer.valueOf(9621), Integer.valueOf(9609)), List.of(Integer.valueOf(9620), Integer.valueOf(9609), Integer.valueOf(9597)), List.of(Integer.valueOf(9616), Integer.valueOf(9617), Integer.valueOf(9609)), List.of(Integer.valueOf(9623), Integer.valueOf(9613), Integer.valueOf(9601)), List.of(Integer.valueOf(9623), Integer.valueOf(9621)), List.of(Integer.valueOf(9622), Integer.valueOf(9607), Integer.valueOf(9601)), List.of(Integer.valueOf(9622), Integer.valueOf(9603), Integer.valueOf(9600), Integer.valueOf(9597)), List.of(Integer.valueOf(9619), Integer.valueOf(9603), Integer.valueOf(9598)), List.of(Integer.valueOf(9616), Integer.valueOf(9603), Integer.valueOf(9601)), List.of(Integer.valueOf(9623), Integer.valueOf(9602), Integer.valueOf(9597)), List.of(Integer.valueOf(9612), Integer.valueOf(9606), Integer.valueOf(9617)), List.of(Integer.valueOf(9616), Integer.valueOf(9602), Integer.valueOf(9609)), List.of(Integer.valueOf(9623), Integer.valueOf(9600), Integer.valueOf(9601)), List.of(Integer.valueOf(9622), Integer.valueOf(9603), Integer.valueOf(9599), Integer.valueOf(9601)), List.of(Integer.valueOf(9612), Integer.valueOf(9604), Integer.valueOf(9613)), List.of(Integer.valueOf(9612), Integer.valueOf(9604), Integer.valueOf(9599), Integer.valueOf(9597)), List.of(Integer.valueOf(9622), Integer.valueOf(9604), Integer.valueOf(9609)), List.of(Integer.valueOf(9620), Integer.valueOf(9600)), List.of(Integer.valueOf(9616), Integer.valueOf(9621), Integer.valueOf(9598)), List.of(Integer.valueOf(9612), Integer.valueOf(9606), Integer.valueOf(9599), Integer.valueOf(9601)), List.of(Integer.valueOf(9622), Integer.valueOf(9606), Integer.valueOf(9613)), List.of(Integer.valueOf(9622), Integer.valueOf(9606), Integer.valueOf(9609), Integer.valueOf(9597)), List.of(Integer.valueOf(9616), Integer.valueOf(9604)), List.of(Integer.valueOf(9622), Integer.valueOf(9603), Integer.valueOf(9617)), List.of(Integer.valueOf(9622), Integer.valueOf(9603), Integer.valueOf(9609), Integer.valueOf(9601)), List.of(Integer.valueOf(9616), Integer.valueOf(9606), Integer.valueOf(9597)), List.of(Integer.valueOf(9612), Integer.valueOf(9606), Integer.valueOf(9602)), List.of(Integer.valueOf(9624)), List.of(Integer.valueOf(9612), Integer.valueOf(9608)), List.of(Integer.valueOf(9619), Integer.valueOf(9604), Integer.valueOf(9597)), List.of(Integer.valueOf(9622), Integer.valueOf(9606), Integer.valueOf(9599), Integer.valueOf(9597)), List.of(Integer.valueOf(9612), Integer.valueOf(9606), Integer.valueOf(9613), Integer.valueOf(9597)), List.of(Integer.valueOf(9612), Integer.valueOf(9604), Integer.valueOf(9609), Integer.valueOf(9597)), List.of(Integer.valueOf(9622), Integer.valueOf(9606), Integer.valueOf(9600)), List.of(Integer.valueOf(9620), Integer.valueOf(9613)), List.of(Integer.valueOf(9622), Integer.valueOf(9610), Integer.valueOf(9601)), List.of(Integer.valueOf(9619), Integer.valueOf(9606), Integer.valueOf(9601)))));
        for (Map.Entry entry : validExchangesForDisc.entrySet()) {
            Integer discID = (Integer)entry.getKey();
            Integer discValue = discToValue.get(discID);
            ItemRequirement discRequirement = discs.get(discID);
            for (List exchanges : (HashSet)entry.getValue()) {
                for (Integer exchangedDiscID : exchanges) {
                    Integer exchangedDiscValue;
                    if (Objects.equals(exchangedDiscID, discID) || Objects.equals(exchangedDiscValue = discToValue.get(exchangedDiscID), discValue)) continue;
                    valuePossibleSingleDiscExchangesRequirements.computeIfAbsent(exchangedDiscValue, sv2 -> new ArrayList());
                    List<ItemRequirement> v = valuePossibleSingleDiscExchangesRequirements.get(exchangedDiscValue);
                    if (v.contains(discRequirement)) continue;
                    v.add(discRequirement);
                }
            }
        }
    }

    public static void loadValueToDoubleDiscRequirement(HashMap<Integer, ItemRequirement> valueToRequirement, HashMap<Integer, List<ItemRequirements>> valueToDoubleDiscRequirement) {
        for (int i = 0; i < 35; ++i) {
            ItemRequirement shape1 = valueToRequirement.get(i);
            for (int j = 0; j < 35; ++j) {
                ItemRequirement shape2 = valueToRequirement.get(j);
                if (shape1 == null || shape2 == null) continue;
                valueToDoubleDiscRequirement.computeIfAbsent(i + j, sv2 -> new ArrayList());
                if (shape1.getId() == shape2.getId()) {
                    valueToDoubleDiscRequirement.get(i + j).add(new ItemRequirements(shape1.quantity(2)));
                    continue;
                }
                valueToDoubleDiscRequirement.get(i + j).add(new ItemRequirements(LogicType.AND, shape1, shape2));
            }
        }
    }

    public static void loadDiscs(HashMap<Integer, ItemRequirement> discs) {
        discs.put(9597, new ItemRequirement("Red circle", 9597).highlighted());
        discs.put(9601, new ItemRequirement("Orange circle", 9601).highlighted());
        discs.put(9605, new ItemRequirement("Yellow circle", 9605).highlighted());
        discs.put(9609, new ItemRequirement("Green circle", 9609).highlighted());
        discs.put(9613, new ItemRequirement("Blue circle", 9613).highlighted());
        discs.put(9617, new ItemRequirement("Indigo circle", 9617).highlighted());
        discs.put(9621, new ItemRequirement("Violet circle", 9621).highlighted());
        discs.put(9598, new ItemRequirement("Red triangle", 9598).highlighted());
        discs.put(9602, new ItemRequirement("Orange triangle", 9602).highlighted());
        discs.put(9606, new ItemRequirement("Yellow triangle", 9606).highlighted());
        discs.put(9610, new ItemRequirement("Green triangle", 9610).highlighted());
        discs.put(9614, new ItemRequirement("Blue triangle", 9614).highlighted());
        discs.put(9618, new ItemRequirement("Indigo triangle", 9618).highlighted());
        discs.put(9622, new ItemRequirement("Violet triangle", 9622).highlighted());
        discs.put(9599, new ItemRequirement("Red square", 9599).highlighted());
        discs.put(9603, new ItemRequirement("Orange square", 9603).highlighted());
        discs.put(9607, new ItemRequirement("Yellow square", 9607).highlighted());
        discs.put(9611, new ItemRequirement("Green square", 9611).highlighted());
        discs.put(9615, new ItemRequirement("Blue square", 9615).highlighted());
        discs.put(9619, new ItemRequirement("Indigo square", 9619).highlighted());
        discs.put(9623, new ItemRequirement("Violet square", 9623).highlighted());
        discs.put(9600, new ItemRequirement("Red pentagon", 9600).highlighted());
        discs.put(9604, new ItemRequirement("Orange pentagon", 9604).highlighted());
        discs.put(9608, new ItemRequirement("Yellow pentagon", 9608).highlighted());
        discs.put(9612, new ItemRequirement("Green pentagon", 9612).highlighted());
        discs.put(9616, new ItemRequirement("Blue pentagon", 9616).highlighted());
        discs.put(9620, new ItemRequirement("Indigo pentagon", 9620).highlighted());
        discs.put(9624, new ItemRequirement("Violet pentagon", 9624).highlighted());
    }

    public static void loadValueToRequirement(HashMap<Integer, ItemRequirement> discs, HashMap<Integer, ItemRequirement> valueToRequirement) {
        ItemRequirement yellowCircleRedTri = new ItemRequirement("Yellow circle/red triangle", 9598).highlighted();
        yellowCircleRedTri.addAlternates(9605);
        ItemRequirement greenCircleRedSquare = new ItemRequirement("Green circle/red square", 9609).highlighted();
        greenCircleRedSquare.addAlternates(9599);
        ItemRequirement blueCircleRedPentagon = new ItemRequirement("Blue circle/red pentagon", 9613).highlighted();
        blueCircleRedPentagon.addAlternates(9600);
        ItemRequirement indigoCircleOrangeTriangle = new ItemRequirement("Indigo circle/orange triangle", 9617).highlighted();
        indigoCircleOrangeTriangle.addAlternates(9602);
        ItemRequirement yellowSquareGreenTriangle = new ItemRequirement("Yellow square/green triangle", 9607).highlighted();
        yellowSquareGreenTriangle.addAlternates(9610);
        ItemRequirement yellowPentagonBlueTriangle = new ItemRequirement("Yellow pentagon/blue triangle", 9608).highlighted();
        yellowPentagonBlueTriangle.addAlternates(9614);
        ItemRequirement blueSquareGreenPentagon = new ItemRequirement("Blue square/green pentagon", 9615).highlighted();
        blueSquareGreenPentagon.addAlternates(9612);
        valueToRequirement.put(1, discs.get(9597));
        valueToRequirement.put(2, discs.get(9601));
        valueToRequirement.put(3, yellowCircleRedTri);
        valueToRequirement.put(4, greenCircleRedSquare);
        valueToRequirement.put(5, blueCircleRedPentagon);
        valueToRequirement.put(6, indigoCircleOrangeTriangle);
        valueToRequirement.put(7, discs.get(9621));
        valueToRequirement.put(8, discs.get(9603));
        valueToRequirement.put(9, discs.get(9606));
        valueToRequirement.put(10, discs.get(9604));
        valueToRequirement.put(12, yellowSquareGreenTriangle);
        valueToRequirement.put(15, yellowPentagonBlueTriangle);
        valueToRequirement.put(16, discs.get(9611));
        valueToRequirement.put(18, discs.get(9618));
        valueToRequirement.put(20, blueSquareGreenPentagon);
        valueToRequirement.put(21, discs.get(9622));
        valueToRequirement.put(24, discs.get(9619));
        valueToRequirement.put(25, discs.get(9616));
        valueToRequirement.put(28, discs.get(9623));
        valueToRequirement.put(30, discs.get(9620));
        valueToRequirement.put(35, discs.get(9624));
    }

    public static void loadDiscToValue(HashMap<Integer, Integer> discToValue) {
        discToValue.put(9597, 1);
        discToValue.put(9598, 3);
        discToValue.put(9599, 4);
        discToValue.put(9600, 5);
        discToValue.put(9601, 2);
        discToValue.put(9602, 6);
        discToValue.put(9603, 8);
        discToValue.put(9604, 10);
        discToValue.put(9605, 3);
        discToValue.put(9606, 9);
        discToValue.put(9607, 12);
        discToValue.put(9608, 15);
        discToValue.put(9609, 4);
        discToValue.put(9610, 12);
        discToValue.put(9611, 16);
        discToValue.put(9612, 20);
        discToValue.put(9613, 5);
        discToValue.put(9614, 15);
        discToValue.put(9615, 20);
        discToValue.put(9616, 25);
        discToValue.put(9617, 6);
        discToValue.put(9618, 18);
        discToValue.put(9619, 24);
        discToValue.put(9620, 30);
        discToValue.put(9621, 7);
        discToValue.put(9622, 21);
        discToValue.put(9623, 28);
        discToValue.put(9624, 35);
    }

    public static WorldPoint regionPoint(int regionX, int regionY) {
        return WorldPoint.fromRegion((int)11074, (int)regionX, (int)regionY, (int)0);
    }

    @Override
    public void startUp() {
        this.puzzle1LeftItemID = this.client.getVarpValue(3997);
        this.puzzle1RightItemID = this.client.getVarpValue(3998);
        this.puzzle2ItemID = this.client.getVarpValue(3999);
        this.updateSteps();
    }

    @Override
    protected void setupSteps() {
        this.getMoreDiscs = new ObjectStep(this.getQuestHelper(), 49617, YewnocksPuzzle.regionPoint(34, 31), "Get more discs from the chests outside. You can drop discs before you get more. You can also use the exchanger next to Yewnock's machine.", true, new Requirement[0]);
        this.useExchanger = new ObjectStep(this.getQuestHelper(), 49663, YewnocksPuzzle.regionPoint(22, 33), "A solution has been calculated, exit the machine interface & click Yewnock's exchanger.", new Requirement[0]);
        this.useExchanger.addWidgetHighlight(848, 27);
        this.clickMachine = new ObjectStep(this.getQuestHelper(), 49662, YewnocksPuzzle.regionPoint(22, 32), "A solution has been found, click Yewnock's machine and insert the discs as prompted.", new Requirement[0]);
        this.clickMachine.addWidgetHighlight(849, 41);
        this.clickMachineOnce = new ObjectStep(this.getQuestHelper(), 49662, YewnocksPuzzle.regionPoint(22, 32), "Operate Yewnock's machine to calculate a solution.", new Requirement[0]);
        this.machineInsertDisc = new DiscInsertionStep(this.getQuestHelper(), "Insert the highlighted disc into the highlighted slot.", new Requirement[0]);
        this.machineReset = new WidgetStep(this.getQuestHelper(), "An incorrect disc has been inserted into the machine, click the reset button & follow the instructions.", 848, 25);
        this.machineSubmit = new WidgetStep(this.getQuestHelper(), "Click the submit button.", 848, 26);
        this.exchangerInsertDisc = new DiscInsertionStep(this.getQuestHelper(), "Insert the highlighted disc into the highlighted slot.", new Requirement[0]);
        this.exchangerExchange = new WidgetStep(this.getQuestHelper(), "", 849, 40);
        this.exchangerConfirm = new DetailedQuestStep(this.getQuestHelper(), "Click the confirm button.", new Requirement[0]);
        this.exchangerConfirm.addWidgetHighlight(849, 36);
        this.exchangerReset = new WidgetStep(this.getQuestHelper(), "Found unexpected disc(s) in the exchange input, reset & follow the instructions.", new WidgetDetails[0]);
        this.exchangerReset.addWidgetHighlight(849, 34);
        this.machineOpen = new WidgetPresenceRequirement(848, 0);
        this.exchangerOpen = new WidgetPresenceRequirement(849, 0);
    }

    @Override
    @Subscribe
    public void onVarbitChanged(VarbitChanged varbitChanged) {
        if (varbitChanged.getVarbitId() == -1) {
            if (varbitChanged.getVarpId() == 3997) {
                this.puzzle1LeftItemID = varbitChanged.getValue();
            } else if (varbitChanged.getVarpId() == 3998) {
                this.puzzle1RightItemID = varbitChanged.getValue();
            } else if (varbitChanged.getVarpId() == 3999) {
                this.puzzle2ItemID = varbitChanged.getValue();
            } else {
                return;
            }
            this.updateSteps();
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged ignoredEvent) {
        this.updateSteps();
    }

    @Subscribe
    public void onGameTick(GameTick ignoredEvent) {
        this.updateSteps();
    }

    @Override
    public void shutDown() {
        super.shutDown();
        this.puzzle1LeftItemID = -1;
        this.puzzle1RightItemID = -1;
        this.puzzle2ItemID = -1;
        this.solution.reset();
    }

    private int getWidgetItemId(int groupId, int childId) {
        Widget widget = this.client.getWidget(groupId, childId);
        if (widget == null) {
            return -1;
        }
        return widget.getItemId();
    }

    private Optional<Pair<Integer, Integer>> findGoodExchange() {
        int exchangeResultTL = this.getWidgetItemId(849, 21);
        int exchangeResultTR = this.getWidgetItemId(849, 24);
        int exchangeResultBL = this.getWidgetItemId(849, 27);
        int exchangeResultBR = this.getWidgetItemId(849, 30);
        for (ItemRequirement puzzleNeed : this.solution.puzzleNeeds) {
            if (puzzleNeed.getAllIds().contains(exchangeResultTL)) {
                return Optional.of(Pair.of((Object)849, (Object)21));
            }
            if (puzzleNeed.getAllIds().contains(exchangeResultTR)) {
                return Optional.of(Pair.of((Object)849, (Object)24));
            }
            if (puzzleNeed.getAllIds().contains(exchangeResultBL)) {
                return Optional.of(Pair.of((Object)849, (Object)27));
            }
            if (!puzzleNeed.getAllIds().contains(exchangeResultBR)) continue;
            return Optional.of(Pair.of((Object)849, (Object)30));
        }
        return Optional.empty();
    }

    private boolean hasOpenedMachine() {
        return this.puzzle1LeftItemID > 0 && this.puzzle1RightItemID > 0 && this.puzzle2ItemID > 0;
    }

    @Nonnull
    private List<Item> getDiscs(InventoryID inventoryId) {
        ItemContainer itemContainer = this.client.getItemContainer(inventoryId);
        if (itemContainer == null) {
            return List.of();
        }
        return Stream.of(itemContainer.getItems()).filter(i -> this.discs.containsKey(i.getId())).collect(Collectors.toUnmodifiableList());
    }

    private void refreshSolution() {
        if (this.puzzle1LeftItemID <= 0 || this.puzzle1RightItemID <= 0 || this.puzzle2ItemID <= 0) {
            return;
        }
        Integer puzzle2SolutionValue = this.discToValue.get(this.puzzle2ItemID);
        if (puzzle2SolutionValue == null) {
            return;
        }
        Integer puzzle1SolutionValue1 = this.discToValue.get(this.puzzle1LeftItemID);
        Integer puzzle1SolutionValue2 = this.discToValue.get(this.puzzle1RightItemID);
        if (puzzle1SolutionValue1 == null || puzzle1SolutionValue2 == null) {
            return;
        }
        List<Item> items = this.getDiscs(InventoryID.INVENTORY);
        int puzzle1SolutionValue = puzzle1SolutionValue1 + puzzle1SolutionValue2;
        this.solution.load(this.client, items, puzzle1SolutionValue, puzzle2SolutionValue, this.discs, this.valueToRequirement, this.valueToDoubleDiscRequirement, this.discToValue, this.valuePossibleSingleDiscExchangesRequirements);
    }

    @Override
    protected void updateSteps() {
        int numDiscs = this.getDiscs(InventoryID.INVENTORY).stream().mapToInt(Item::getQuantity).sum();
        if (numDiscs < 3) {
            this.startUpStep(this.getMoreDiscs);
            return;
        }
        if (!this.hasOpenedMachine()) {
            this.startUpStep(this.clickMachineOnce);
            return;
        }
        if (!this.solution.isGood()) {
            this.solution.reset();
            this.refreshSolution();
        }
        if (this.solution.isGood()) {
            if (!this.machineOpen.check(this.client)) {
                this.startUpStep(this.clickMachine);
                return;
            }
            int puzzle1InsertedDisc = this.client.getVarpValue(3994);
            int puzzle2UpperInsertedDisc = this.client.getVarpValue(3995);
            int puzzle2LowerInsertedDisc = this.client.getVarpValue(3996);
            if (!this.solution.puzzle1Requirement.getAllIds().contains(puzzle1InsertedDisc)) {
                if (puzzle1InsertedDisc > 0) {
                    this.startUpStep(this.machineReset);
                    return;
                }
                this.machineInsertDisc.setRequirements(List.of(this.solution.puzzle1Requirement));
                this.machineInsertDisc.clearWidgetHighlights();
                this.machineInsertDisc.addWidgetHighlight(848, 19);
                this.startUpStep(this.machineInsertDisc);
                return;
            }
            if (!this.solution.puzzle2UpperRequirement.getAllIds().contains(puzzle2UpperInsertedDisc)) {
                if (puzzle2UpperInsertedDisc > 0) {
                    this.startUpStep(this.machineReset);
                    return;
                }
                this.machineInsertDisc.setRequirements(List.of(this.solution.puzzle2UpperRequirement));
                this.machineInsertDisc.clearWidgetHighlights();
                this.machineInsertDisc.addWidgetHighlight(848, 20);
                this.startUpStep(this.machineInsertDisc);
                return;
            }
            if (!this.solution.puzzle2LowerRequirement.getAllIds().contains(puzzle2LowerInsertedDisc)) {
                if (puzzle2LowerInsertedDisc > 0) {
                    this.startUpStep(this.machineReset);
                    return;
                }
                this.machineInsertDisc.setRequirements(List.of(this.solution.puzzle2LowerRequirement));
                this.machineInsertDisc.clearWidgetHighlights();
                this.machineInsertDisc.addWidgetHighlight(848, 21);
                this.startUpStep(this.machineInsertDisc);
                return;
            }
            this.startUpStep(this.machineSubmit);
            return;
        }
        this.getMoreDiscs.setRequirements(this.solution.puzzleNeeds);
        if (this.solution.puzzleNeeds.isEmpty()) {
            log.warn("No solution found for this puzzle at all, no clue how to proceed.");
            this.startUpStep(this.getMoreDiscs);
            return;
        }
        if (this.exchangerOpen.check(this.client)) {
            Integer idInExchanger;
            Optional<Pair<Integer, Integer>> goodExchange = this.findGoodExchange();
            if (goodExchange.isPresent()) {
                Pair<Integer, Integer> goodExchangeWidget = goodExchange.get();
                this.exchangerConfirm.clearWidgetHighlights();
                this.exchangerConfirm.addWidgetHighlight(849, 36);
                this.exchangerConfirm.addWidgetHighlight((Integer)goodExchangeWidget.getLeft(), (Integer)goodExchangeWidget.getRight());
                this.startUpStep(this.exchangerConfirm);
                return;
            }
            this.exchangerInsertDisc.setRequirements(this.solution.toExchange);
            int exchangeInput1 = this.getWidgetItemId(849, 8);
            int exchangeInput2 = this.getWidgetItemId(849, 13);
            int exchangeInput3 = this.getWidgetItemId(849, 18);
            List exchangeInputs = Stream.of(exchangeInput1, exchangeInput2, exchangeInput3).filter(itemId -> itemId > 0).collect(Collectors.toUnmodifiableList());
            ItemRequirement firstExchange = this.solution.toExchange.get(0);
            List<Integer> firstExchangeIds = firstExchange.getAllIds();
            if (exchangeInputs.isEmpty()) {
                this.exchangerInsertDisc.clearWidgetHighlights();
                this.exchangerInsertDisc.addWidgetHighlight(849, 8);
                this.startUpStep(this.exchangerInsertDisc);
                return;
            }
            if (exchangeInputs.size() == 1 && firstExchangeIds.contains(idInExchanger = (Integer)exchangeInputs.get(0))) {
                String discWeAreLookingFor = this.solution.puzzleNeeds.stream().map(ItemRequirement::getName).collect(Collectors.joining(" or "));
                this.exchangerExchange.setText(String.format("Click the exchange button until a %s appears.", discWeAreLookingFor));
                this.startUpStep(this.exchangerExchange);
                return;
            }
            this.startUpStep(this.exchangerReset);
            return;
        }
        if (this.solution.toExchange.isEmpty()) {
            this.startUpStep(this.getMoreDiscs);
            return;
        }
        if (this.machineOpen.check(this.client)) {
            if (this.solution.puzzle1Requirement == null) {
                this.useExchanger.setText("A partial solution has been calculated, exit the machine interface & click Yewnock's exchanger.");
            } else {
                this.useExchanger.setText("A solution has been calculated, exit the machine interface & click Yewnock's exchanger.");
            }
            this.startUpStep(this.useExchanger);
            return;
        }
        if (this.solution.puzzle1Requirement == null) {
            this.useExchanger.setText("A partial solution has been calculated, click Yewnock's exchanger to start exchanging discs.");
        } else {
            this.useExchanger.setText("A solution has been calculated, click Yewnock's exchanger to start exchanging discs.");
        }
        this.startUpStep(this.useExchanger);
    }

    public List<QuestStep> getSteps() {
        return List.of(this.getMoreDiscs, this.clickMachine, this.clickMachineOnce, this.useExchanger, this.machineInsertDisc, this.machineReset, this.machineSubmit, this.exchangerInsertDisc, this.exchangerExchange, this.exchangerConfirm, this.exchangerReset);
    }

    public static class SubsetSum {
        public static List<List<Integer>> findSubsetsWithSum(int[] numbers, int targetSum) {
            ArrayList<List<Integer>> allSubsets = new ArrayList<List<Integer>>();
            ArrayList<Integer> currentSubset = new ArrayList<Integer>();
            boolean[] used = new boolean[numbers.length];
            SubsetSum.findSubsets(numbers, targetSum, 0, currentSubset, allSubsets, 3, used);
            return allSubsets;
        }

        private static void findSubsets(int[] numbers, int targetSum, int currentIndex, List<Integer> currentSubset, List<List<Integer>> allSubsets, int maxValues, boolean[] used) {
            if (targetSum == 0 && currentSubset.size() <= maxValues) {
                allSubsets.add(new ArrayList<Integer>(currentSubset));
                return;
            }
            if (currentIndex >= numbers.length || targetSum < 0 || currentSubset.size() >= maxValues) {
                return;
            }
            if (!used[currentIndex]) {
                currentSubset.add(numbers[currentIndex]);
                used[currentIndex] = true;
                SubsetSum.findSubsets(numbers, targetSum - numbers[currentIndex], currentIndex, currentSubset, allSubsets, maxValues, used);
                used[currentIndex] = false;
                currentSubset.remove(currentSubset.size() - 1);
            }
            SubsetSum.findSubsets(numbers, targetSum, currentIndex + 1, currentSubset, allSubsets, maxValues, used);
        }
    }
}

