/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.thepathofglouphrie;

import com.google.common.collect.ImmutableMap;
import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.helpers.quests.thepathofglouphrie.sections.FindLongramble;
import com.questhelper.helpers.quests.thepathofglouphrie.sections.InformKingBolren;
import com.questhelper.helpers.quests.thepathofglouphrie.sections.StartingOff;
import com.questhelper.helpers.quests.thepathofglouphrie.sections.TheWarpedDepths;
import com.questhelper.helpers.quests.thepathofglouphrie.sections.UnveilEvil;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.TeleportItemRequirement;
import com.questhelper.requirements.player.FreeInventorySlotRequirement;
import com.questhelper.requirements.player.PrayerRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.widget.WidgetTextRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.runelite.api.Prayer;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.THE_PATH_OF_GLOUPHRIE)
public class ThePathOfGlouphrie
extends BasicQuestHelper {
    private final StartingOff startingOff = new StartingOff();
    private final UnveilEvil unveilEvil = new UnveilEvil();
    private final InformKingBolren informKingBolren = new InformKingBolren();
    private final FindLongramble findLongramble = new FindLongramble();
    private final TheWarpedDepths theWarpedDepths = new TheWarpedDepths();
    public Zone treeGnomeVillageMiddle1;
    public Zone treeGnomeVillageMiddle2;
    public Zone treeGnomeVillageMiddle3;
    public Zone treeGnomeVillageDungeon;
    public Zone storeroomZone;
    public Zone gnomeStrongholdFloor1;
    public Zone gnomeStrongholdFloor2;
    public Zone gnomeStrongholdFloor3;
    public Zone longrambleZone;
    public Zone sewer1;
    public Zone sewer2;
    public Zone sewer3;
    public Zone sewer4Section1;
    public Zone sewer4Section2;
    public Zone sewer5;
    public Zone sewer6Section1;
    public Zone sewer6Section2;
    public Zone bossRoom;
    public ItemRequirement crossbow;
    public ItemRequirement mithGrapple;
    public ItemRequirement treeGnomeVillageDungeonKey;
    public ItemRequirement combatGear;
    public ItemRequirement prayerPotions;
    public ItemRequirement food;
    public FreeInventorySlotRequirement freeInventorySlots;
    public TeleportItemRequirement fairyRingOrCastleWars;
    public ItemRequirement runRestoreItems;
    public ItemRequirement earmuffsOrSlayerHelmet;
    public ItemRequirement earmuffsOrSlayerHelmetEquipped;
    public TeleportItemRequirement teleToBolren;
    public ItemRequirement crystalChime;
    public ZoneRequirement inTreeGnomeVillageMiddle;
    public ZoneRequirement inTreeGnomeVillageDungeon;
    public ZoneRequirement inStoreroom;
    public ZoneRequirement nearLongramble;
    public Requirement inSewer1;
    public Requirement inSewer2;
    public Requirement inSewer3;
    public Requirement inSewer4;
    public Requirement inSewer5;
    public Requirement inSewer6;
    public Requirement inBossRoom;
    public Conditions inCutscene;
    public VarbitRequirement learnedAboutChapter1;
    public VarbitRequirement learnedAboutChapter2;
    public ObjectStep enterTreeGnomeVillageMazeFromMiddle;
    public ObjectStep climbDownIntoTreeGnomeVillageDungeon;
    public ZoneRequirement inGnomeStrongholdFloor1;
    public ZoneRequirement inGnomeStrongholdFloor2;
    public ZoneRequirement inGnomeStrongholdFloor3;
    public WidgetTextRequirement lecternWidgetActive;
    public PrayerRequirement protectMissiles;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        return new ImmutableMap.Builder().put((Object)0, (Object)this.startingOff.talkToKingBolren).put((Object)2, (Object)this.startingOff.talkToKingBolrenAgain).put((Object)4, (Object)this.startingOff.golrie).put((Object)6, (Object)this.unveilEvil.enterStoreroom).put((Object)8, (Object)this.unveilEvil.solveMonolithPuzzleStep).put((Object)10, (Object)this.unveilEvil.solveMonolithPuzzleStep).put((Object)12, (Object)this.unveilEvil.solveMonolithPuzzleStep).put((Object)14, (Object)this.unveilEvil.learnLoreStep).put((Object)16, (Object)this.unveilEvil.solveYewnocksMachinePuzzleStep).put((Object)18, (Object)this.unveilEvil.watchCutscene).put((Object)20, (Object)this.informKingBolren.killEvilCreature).put((Object)22, (Object)this.informKingBolren.informKingBolren).put((Object)24, (Object)this.informKingBolren.talkToGianneJnrStep).put((Object)26, (Object)this.findLongramble.talkToLongramble).put((Object)28, (Object)this.findLongramble.talkToLongramble).put((Object)30, (Object)this.findLongramble.talkToSpiritTree).put((Object)32, (Object)this.findLongramble.talkToSpiritTree).put((Object)34, (Object)this.findLongramble.talkToSpiritTree).put((Object)36, (Object)this.findLongramble.useCrystalChime).put((Object)38, (Object)this.findLongramble.talkToSpiritTreeAgain).put((Object)40, (Object)this.theWarpedDepths.enterSewerStep).put((Object)42, (Object)this.theWarpedDepths.enterSewerStep).put((Object)44, (Object)this.theWarpedDepths.enterSewerStep).put((Object)46, (Object)this.theWarpedDepths.watchFinalCutsceneStep).put((Object)48, (Object)this.theWarpedDepths.talkToHazelmere).build();
    }

    public void setupZones() {
        this.treeGnomeVillageMiddle1 = new Zone(new WorldPoint(2514, 3161, 0), new WorldPoint(2542, 3175, 0));
        this.treeGnomeVillageMiddle2 = new Zone(new WorldPoint(2543, 3167, 0), new WorldPoint(2547, 3172, 0));
        this.treeGnomeVillageMiddle3 = new Zone(new WorldPoint(2522, 3158, 0), new WorldPoint(2542, 3160, 0));
        this.treeGnomeVillageDungeon = new Zone(new WorldPoint(2560, 4426, 0), new WorldPoint(2627, 4477, 0));
        this.storeroomZone = new Zone(11074);
        this.gnomeStrongholdFloor1 = new Zone(new WorldPoint(2437, 3474, 1), new WorldPoint(2493, 3511, 1));
        this.gnomeStrongholdFloor2 = new Zone(new WorldPoint(2437, 3474, 2), new WorldPoint(2493, 3511, 2));
        this.gnomeStrongholdFloor3 = new Zone(new WorldPoint(2437, 3474, 3), new WorldPoint(2493, 3511, 3));
        this.longrambleZone = new Zone(new WorldPoint(2328, 3082, 0), new WorldPoint(2346, 3103, 0));
        this.sewer1 = new Zone(new WorldPoint(1472, 4236, 0), new WorldPoint(1480, 4239, 0));
        this.sewer2 = new Zone(new WorldPoint(1472, 4226, 1), new WorldPoint(1534, 4247, 1));
        this.sewer3 = new Zone(new WorldPoint(1526, 4235, 0), new WorldPoint(1529, 4254, 0));
        this.sewer4Section1 = new Zone(new WorldPoint(1472, 4245, 1), new WorldPoint(1534, 4273, 1));
        this.sewer4Section2 = new Zone(new WorldPoint(1479, 4273, 1), new WorldPoint(1489, 4285, 1));
        this.sewer5 = new Zone(new WorldPoint(1484, 4279, 0), new WorldPoint(1501, 4282, 0));
        this.sewer6Section1 = new Zone(new WorldPoint(1496, 4276, 1), new WorldPoint(1513, 4288, 1));
        this.sewer6Section2 = new Zone(5955, 1);
        this.bossRoom = new Zone(WorldPoint.fromRegion((int)5955, (int)35, (int)24, (int)1), WorldPoint.fromRegion((int)5955, (int)48, (int)44, (int)1));
    }

    @Override
    public void setupRequirements() {
        QuestRequirement rovingElvesNotStarted = new QuestRequirement(QuestHelperQuest.ROVING_ELVES, QuestState.NOT_STARTED);
        this.crossbow = new ItemRequirement("Any crossbow", 837).isNotConsumed();
        this.crossbow.addAlternates(9174, 9177, 9179, 9181, 9183, 9185, 21902, 9176, 8880, 11785, 26374);
        this.mithGrapple = new ItemRequirement("Mith grapple", 9419).isNotConsumed();
        this.treeGnomeVillageDungeonKey = new ItemRequirement("Tree Gnome Village dungeon key", 293).showConditioned(rovingElvesNotStarted);
        this.treeGnomeVillageDungeonKey.canBeObtainedDuringQuest();
        this.combatGear = new ItemRequirement("Combat equipment", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.prayerPotions = new ItemRequirement("Prayer potions", ItemCollections.PRAYER_POTIONS, -1);
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        this.freeInventorySlots = new FreeInventorySlotRequirement(11);
        QuestRequirement lumbridgeEliteComplete = new QuestRequirement(QuestHelperQuest.LUMBRIDGE_ELITE, QuestState.FINISHED);
        this.earmuffsOrSlayerHelmet = new ItemRequirement("Earmuffs or a Slayer helmet", ItemCollections.EAR_PROTECTION, 1, true).highlighted();
        this.earmuffsOrSlayerHelmet.setTooltip("You will take a lot more damage without these");
        this.earmuffsOrSlayerHelmetEquipped = this.earmuffsOrSlayerHelmet.equipped();
        this.fairyRingOrCastleWars = new TeleportItemRequirement("Teleport to Castle Wars (Fairy Ring BKP or Ring of Dueling [2])", ItemCollections.FAIRY_STAFF, 1);
        this.fairyRingOrCastleWars.addAlternates(ItemCollections.RING_OF_DUELINGS);
        this.fairyRingOrCastleWars.setConditionToHide(lumbridgeEliteComplete);
        this.runRestoreItems = new ItemRequirement("Several run restore items", ItemCollections.RUN_RESTORE_ITEMS, -1);
        this.teleToBolren = new TeleportItemRequirement("Spirit tree to Tree Gnome Village [1]", -1, -1);
        this.crystalChime = new ItemRequirement("Crystal chime", 28577, 1);
        this.crystalChime.setTooltip("You can get a new one by going back to the storeroom in the Tree Gnome Village dungeon");
    }

    private void setupConditions() {
        this.inTreeGnomeVillageMiddle = new ZoneRequirement(this.treeGnomeVillageMiddle1, this.treeGnomeVillageMiddle2, this.treeGnomeVillageMiddle3);
        this.inTreeGnomeVillageDungeon = new ZoneRequirement(this.treeGnomeVillageDungeon);
        this.inStoreroom = new ZoneRequirement(this.storeroomZone);
        this.inGnomeStrongholdFloor1 = new ZoneRequirement(this.gnomeStrongholdFloor1);
        this.inGnomeStrongholdFloor2 = new ZoneRequirement(this.gnomeStrongholdFloor2);
        this.inGnomeStrongholdFloor3 = new ZoneRequirement(this.gnomeStrongholdFloor3);
        this.nearLongramble = new ZoneRequirement(this.longrambleZone);
        this.inCutscene = new Conditions(LogicType.OR, new VarbitRequirement(4606, 3), new VarbitRequirement(12139, 1));
        this.learnedAboutChapter1 = new VarbitRequirement(15291, 1);
        this.learnedAboutChapter2 = new VarbitRequirement(15292, 1);
        this.inSewer1 = new ZoneRequirement(this.sewer1);
        this.inSewer2 = new ZoneRequirement(this.sewer2);
        this.inSewer3 = new ZoneRequirement(this.sewer3);
        this.inSewer4 = new Conditions(LogicType.OR, new ZoneRequirement(this.sewer4Section1), new ZoneRequirement(this.sewer4Section2));
        this.inSewer5 = new ZoneRequirement(this.sewer5);
        this.inSewer6 = new Conditions(LogicType.OR, new ZoneRequirement(this.sewer6Section1), new ZoneRequirement(this.sewer6Section2));
        this.inBossRoom = new ZoneRequirement(this.bossRoom);
        this.lecternWidgetActive = new WidgetTextRequirement(854, 5, "Chapter 1. Bad advice");
        this.protectMissiles = new PrayerRequirement("Protect from Missiles to reduce damage taken by the Terrorbirds", Prayer.PROTECT_FROM_MISSILES);
    }

    private void setupSteps() {
        this.enterTreeGnomeVillageMazeFromMiddle = new ObjectStep((QuestHelper)this, 2186, new WorldPoint(2515, 3161, 0), "", new Requirement[0]);
        this.climbDownIntoTreeGnomeVillageDungeon = new ObjectStep((QuestHelper)this, 5250, new WorldPoint(2533, 3155, 0), "", new Requirement[0]);
        this.startingOff.setup(this);
        this.unveilEvil.setup(this);
        this.informKingBolren.setup(this);
        this.findLongramble.setup(this);
        this.theWarpedDepths.setup(this);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.crossbow, this.mithGrapple, this.treeGnomeVillageDungeonKey, this.combatGear, this.prayerPotions, this.food);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.earmuffsOrSlayerHelmet, this.fairyRingOrCastleWars, this.runRestoreItems);
    }

    @Override
    public List<String> getCombatRequirements() {
        return Arrays.asList("3 Warped Terrorbirds (level 138)", "Evil Creature (level 1)");
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(2);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return List.of(new ExperienceReward(Skill.STRENGTH, 30000, true), new ExperienceReward(Skill.SLAYER, 20000, true), new ExperienceReward(Skill.THIEVING, 5000, true), new ExperienceReward(Skill.MAGIC, 5000, true));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Access to the Poison Waste Dungeon"), new UnlockReward("Ability to unlock warped creatures as a Slayer task"), new UnlockReward("Access to a new spirit tree destination in the Poison Waste"));
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new QuestRequirement(QuestHelperQuest.THE_EYES_OF_GLOUPHRIE, QuestState.FINISHED));
        req.add(new QuestRequirement(QuestHelperQuest.WATERFALL_QUEST, QuestState.FINISHED));
        req.add(new QuestRequirement(QuestHelperQuest.TREE_GNOME_VILLAGE, QuestState.FINISHED));
        req.add(new SkillRequirement(Skill.STRENGTH, 60));
        req.add(new SkillRequirement(Skill.SLAYER, 56));
        req.add(new SkillRequirement(Skill.THIEVING, 56));
        req.add(new SkillRequirement(Skill.RANGED, 47));
        req.add(new SkillRequirement(Skill.AGILITY, 45));
        return req;
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> panels = new ArrayList<PanelDetails>();
        PanelDetails startingOffPanel = new PanelDetails("Starting off", this.startingOff.getSteps(), List.of(this.freeInventorySlots, this.treeGnomeVillageDungeonKey));
        PanelDetails unveilTheEvilCreature = new PanelDetails("Unveil the Evil creature", this.unveilEvil.getSteps(), List.of(this.freeInventorySlots));
        PanelDetails informKingBolrenPanel = new PanelDetails("Inform King Bolren", this.informKingBolren.getSteps(), new Requirement[0]);
        PanelDetails findLongramblePanel = new PanelDetails("Find Longramble", this.findLongramble.getSteps(), List.of(this.crossbow, this.mithGrapple, this.combatGear, this.food, this.crystalChime), List.of(this.earmuffsOrSlayerHelmet, this.runRestoreItems));
        PanelDetails theWarpedDepthsPanel = new PanelDetails("The Warped Depths", this.theWarpedDepths.getSteps(), List.of(this.crossbow, this.mithGrapple, this.combatGear, this.food, this.crystalChime), List.of(this.earmuffsOrSlayerHelmet, this.runRestoreItems));
        panels.add(startingOffPanel);
        panels.add(unveilTheEvilCreature);
        panels.add(informKingBolrenPanel);
        panels.add(findLongramblePanel);
        panels.add(theWarpedDepthsPanel);
        return panels;
    }
}

