/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.thepathofglouphrie;

import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.ItemRequirements;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.runelite.api.Client;
import net.runelite.api.Item;

public class Solution {
    @Nonnull
    public List<ItemRequirement> puzzleNeeds = new ArrayList<ItemRequirement>();
    @Nonnull
    public List<ItemRequirement> toExchange = new ArrayList<ItemRequirement>();
    public ItemRequirement puzzle1Requirement;
    public ItemRequirement puzzle2UpperRequirement;
    public ItemRequirement puzzle2LowerRequirement;

    public static boolean inventoryHas(List<Item> haystack, int needle) {
        for (Item item : haystack) {
            if (item.getId() != needle) continue;
            return true;
        }
        return false;
    }

    public void load(Client client, List<Item> items, int puzzle1SolutionValue, int puzzle2SolutionValue, HashMap<Integer, ItemRequirement> discs, HashMap<Integer, ItemRequirement> valueToRequirement, HashMap<Integer, List<ItemRequirements>> valueToDoubleDiscRequirement, HashMap<Integer, Integer> discToValue, HashMap<Integer, List<ItemRequirement>> valuePossibleSingleDiscExchangesRequirements) {
        this.reset();
        ItemRequirement puzzle1Requirement = valueToRequirement.get(puzzle1SolutionValue);
        if (puzzle1Requirement == null) {
            return;
        }
        this.puzzleNeeds.clear();
        this.toExchange.clear();
        if (!puzzle1Requirement.check(client, false, items)) {
            this.puzzleNeeds.add(puzzle1Requirement);
            List singleDiscExchange = valuePossibleSingleDiscExchangesRequirements.get(puzzle1SolutionValue).stream().filter(requirement -> Solution.inventoryHas(items, requirement.getId())).collect(Collectors.toUnmodifiableList());
            if (!singleDiscExchange.isEmpty()) {
                this.toExchange.add((ItemRequirement)singleDiscExchange.get(0));
            }
            return;
        }
        this.puzzle1Requirement = puzzle1Requirement;
        ArrayList<Item> itemsAfterPuzzle1 = new ArrayList<Item>();
        for (Item item : items) {
            if (item.getId() == this.puzzle1Requirement.getId()) {
                if (item.getQuantity() <= 1) continue;
                Item newItem = new Item(item.getId(), item.getQuantity() - 1);
                itemsAfterPuzzle1.add(newItem);
                continue;
            }
            itemsAfterPuzzle1.add(item);
        }
        this.puzzleNeeds.clear();
        List<ItemRequirements> possiblePuzzle2Solutions = valueToDoubleDiscRequirement.get(puzzle2SolutionValue);
        ItemRequirements partialPuzzle2Solution = null;
        ItemRequirement findExchangeFor = null;
        ItemRequirement consumed = null;
        for (ItemRequirements itemRequirements : possiblePuzzle2Solutions) {
            if (itemRequirements.check(client, false, itemsAfterPuzzle1)) {
                this.puzzle2UpperRequirement = itemRequirements.getItemRequirements().get(0);
                this.puzzle2LowerRequirement = itemRequirements.getItemRequirements().get(1);
                return;
            }
            if (itemRequirements.getItemRequirements().get(0).check(client, false, itemsAfterPuzzle1)) {
                partialPuzzle2Solution = itemRequirements;
                consumed = itemRequirements.getItemRequirements().get(0);
                findExchangeFor = itemRequirements.getItemRequirements().get(1);
                break;
            }
            if (!itemRequirements.getItemRequirements().get(1).check(client, false, itemsAfterPuzzle1)) continue;
            partialPuzzle2Solution = itemRequirements;
            consumed = itemRequirements.getItemRequirements().get(1);
            findExchangeFor = itemRequirements.getItemRequirements().get(0);
            break;
        }
        if (partialPuzzle2Solution != null) {
            List singleDiscExchange;
            Integer requiredValue;
            ArrayList<Item> itemsAfterPuzzle2 = new ArrayList<Item>();
            for (Item item : itemsAfterPuzzle1) {
                if (consumed != null && consumed.getAllIds().contains(item.getId())) {
                    if (item.getQuantity() <= 1) continue;
                    itemsAfterPuzzle2.add(new Item(item.getId(), 1));
                    continue;
                }
                itemsAfterPuzzle2.add(new Item(item.getId(), 1));
            }
            this.puzzleNeeds.addAll(partialPuzzle2Solution.getItemRequirements());
            ItemRequirement itemRequirement = findExchangeFor;
            if (findExchangeFor != null && (requiredValue = discToValue.get(findExchangeFor.getId())) != null && !(singleDiscExchange = valuePossibleSingleDiscExchangesRequirements.get(requiredValue).stream().filter(requirement -> requirement.getId() != finalFindExchangeFor.getId()).filter(requirement -> itemsAfterPuzzle2.contains(new Item(requirement.getId(), 1))).collect(Collectors.toUnmodifiableList())).isEmpty()) {
                this.toExchange.add((ItemRequirement)singleDiscExchange.get(0));
                return;
            }
        }
        if (partialPuzzle2Solution == null) {
            HashSet<Integer> looseNeeds = new HashSet<Integer>();
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (ItemRequirements possiblePuzzle2Solution : possiblePuzzle2Solutions) {
                Integer req2Value;
                ItemRequirement req1 = possiblePuzzle2Solution.getItemRequirements().get(0);
                ItemRequirement req2 = possiblePuzzle2Solution.getItemRequirements().get(1);
                Integer req1Value = discToValue.get(req1.getId());
                List singleDiscExchange = valuePossibleSingleDiscExchangesRequirements.get(req1Value).stream().filter(requirement -> !req2.getAllIds().contains(requirement.getId())).filter(requirement -> Solution.inventoryHas(items, requirement.getId())).collect(Collectors.toUnmodifiableList());
                if (!singleDiscExchange.isEmpty()) {
                    looseNeeds.addAll(req1.getAllIds());
                    for (ItemRequirement ex : singleDiscExchange) {
                        hashSet.addAll(ex.getAllIds());
                    }
                }
                if ((singleDiscExchange = valuePossibleSingleDiscExchangesRequirements.get(req2Value = discToValue.get(req2.getId())).stream().filter(requirement -> !req1.getAllIds().contains(requirement.getId())).filter(requirement -> Solution.inventoryHas(items, requirement.getId())).collect(Collectors.toUnmodifiableList())).isEmpty()) continue;
                looseNeeds.addAll(req2.getAllIds());
                for (ItemRequirement ex : singleDiscExchange) {
                    hashSet.addAll(ex.getAllIds());
                }
            }
            if (!looseNeeds.isEmpty() && !hashSet.isEmpty()) {
                ItemRequirement itemReq;
                this.toExchange.clear();
                for (Integer id : hashSet) {
                    itemReq = discs.get(id);
                    if (itemReq == null) continue;
                    this.toExchange.add(itemReq);
                }
                this.puzzleNeeds.clear();
                for (Integer id : looseNeeds) {
                    itemReq = discs.get(id);
                    if (itemReq == null) continue;
                    this.puzzleNeeds.add(itemReq);
                }
            }
        }
    }

    public void reset() {
        this.puzzle1Requirement = null;
        this.puzzle2UpperRequirement = null;
        this.puzzle2LowerRequirement = null;
        this.puzzleNeeds.clear();
        this.toExchange.clear();
    }

    public boolean isGood() {
        return this.puzzle1Requirement != null & this.puzzle2UpperRequirement != null & this.puzzle2LowerRequirement != null;
    }
}

