/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.thepathofglouphrie;

import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.steps.DetailedOwnerStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.HashMap;
import java.util.List;
import net.runelite.api.GameObject;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.Tile;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.eventbus.Subscribe;

public class MonolithPuzzle
extends DetailedOwnerStep {
    private static final int STOREROOM_REGION = 11074;
    private static final int BIG_MONOLITH = 49584;
    private static final int SMALL_MONOLITH = 49586;
    private ObjectStep getFirstShapes;
    private HashMap<Integer, ItemRequirement> shapes;
    private NpcStep pushSouthernMonolithUp;
    private NpcStep pushSWMonolithNorth;
    private ZoneRequirement inStartZone;
    private ObjectStep getSecondShapes;
    private ObjectStep picklockChestForFirstKey;
    private NpcStep pushNWMonolithEast;
    private ObjectStep getThirdShapes;
    private NpcStep pushSmallMonolithSouth;
    private ObjectStep inspectSingingBowl;
    private ObjectStep openChestForCrystalChimeSeed;
    private NpcStep pushNWMonolithWest;
    private ItemRequirement crystalChime;
    private NpcStep pushSEMonolithWest;
    private ObjectStep unlockTheGate;

    public MonolithPuzzle(QuestHelper questHelper) {
        super(questHelper, "Unlock Yewnock's machine room in the Tree Gnome Village dungeon.", new Requirement[0]);
    }

    @Override
    public void startUp() {
        this.updateSteps();
    }

    private WorldPoint regionPoint(int regionX, int regionY) {
        return WorldPoint.fromRegion((int)11074, (int)regionX, (int)regionY, (int)0);
    }

    @Override
    protected void setupSteps() {
        this.shapes = new HashMap();
        this.shapes.put(9597, new ItemRequirement("Red circle", 9597));
        this.shapes.put(9601, new ItemRequirement("Orange circle", 9601));
        this.shapes.put(9605, new ItemRequirement("Yellow circle", 9605));
        this.shapes.put(9609, new ItemRequirement("Green circle", 9609));
        this.shapes.put(9613, new ItemRequirement("Blue circle", 9613));
        this.shapes.put(9617, new ItemRequirement("Indigo circle", 9617));
        this.shapes.put(9621, new ItemRequirement("Violet circle", 9621));
        this.shapes.put(9598, new ItemRequirement("Red triangle", 9598));
        this.shapes.put(9602, new ItemRequirement("Orange triangle", 9602));
        this.shapes.put(9606, new ItemRequirement("Yellow triangle", 9606));
        this.shapes.put(9610, new ItemRequirement("Green triangle", 9610));
        this.shapes.put(9614, new ItemRequirement("Blue triangle", 9614));
        this.shapes.put(9618, new ItemRequirement("Indigo triangle", 9618));
        this.shapes.put(9622, new ItemRequirement("Violet triangle", 9622));
        this.shapes.put(9599, new ItemRequirement("Red square", 9599));
        this.shapes.put(9603, new ItemRequirement("Orange square", 9603));
        this.shapes.put(9607, new ItemRequirement("Yellow square", 9607));
        this.shapes.put(9611, new ItemRequirement("Green square", 9611));
        this.shapes.put(9615, new ItemRequirement("Blue square", 9615));
        this.shapes.put(9619, new ItemRequirement("Indigo square", 9619));
        this.shapes.put(9623, new ItemRequirement("Violet square", 9623));
        this.shapes.put(9600, new ItemRequirement("Red pentagon", 9600));
        this.shapes.put(9604, new ItemRequirement("Orange pentagon", 9604));
        this.shapes.put(9608, new ItemRequirement("Yellow pentagon", 9608));
        this.shapes.put(9612, new ItemRequirement("Green pentagon", 9612));
        this.shapes.put(9616, new ItemRequirement("Blue pentagon", 9616));
        this.shapes.put(9620, new ItemRequirement("Indigo pentagon", 9620));
        this.shapes.put(9624, new ItemRequirement("Violet pentagon", 9624));
        this.inStartZone = new ZoneRequirement(new Zone(this.regionPoint(34, 17), this.regionPoint(39, 25)));
        this.pushSouthernMonolithUp = new NpcStep(this.getQuestHelper(), 12486, this.regionPoint(37, 21), "Push the monolith north once.", new Requirement[0]);
        this.pushSouthernMonolithUp.setMaxRoamRange(3);
        this.getFirstShapes = new ObjectStep(this.getQuestHelper(), 49617, this.regionPoint(39, 25), "Open the chest for some shapes.", new Requirement[0]);
        this.getFirstShapes.addSubSteps(this.pushSouthernMonolithUp);
        this.pushSWMonolithNorth = new NpcStep(this.getQuestHelper(), 12486, this.regionPoint(35, 29), "Push the south-west monolith north once.", new Requirement[0]);
        this.pushSWMonolithNorth.setMaxRoamRange(2);
        this.pushNWMonolithEast = new NpcStep(this.getQuestHelper(), 12486, this.regionPoint(35, 33), "Push the north-west monolith east once.", new Requirement[0]);
        this.pushNWMonolithEast.setMaxRoamRange(2);
        this.getSecondShapes = new ObjectStep(this.getQuestHelper(), 49617, this.regionPoint(36, 38), "Open the chest for some more shapes. If the chest doesn't give you any shapes, drop the shapes in your inventory first, then click the chest, then pick up the shapes from the ground.", new Requirement[0]);
        this.getSecondShapes.addSubSteps(this.pushSWMonolithNorth, this.pushNWMonolithEast);
        this.picklockChestForFirstKey = new ObjectStep(this.getQuestHelper(), 49614, this.regionPoint(33, 37), "Picklock the chest for a key.", new Requirement[0]);
        this.picklockChestForFirstKey.addAlternateObjects(49615);
        this.picklockChestForFirstKey.addSubSteps(this.pushSWMonolithNorth, this.pushNWMonolithEast);
        this.pushSmallMonolithSouth = new NpcStep(this.getQuestHelper(), 12487, this.regionPoint(39, 33), "Push the small monolith south once.", new Requirement[0]);
        this.pushSmallMonolithSouth.setMaxRoamRange(2);
        this.pushNWMonolithWest = new NpcStep(this.getQuestHelper(), 12486, this.regionPoint(36, 33), "Push the north-west monolith west once.", new Requirement[0]);
        this.pushNWMonolithWest.setMaxRoamRange(2);
        this.openChestForCrystalChimeSeed = new ObjectStep(this.getQuestHelper(), 49612, this.regionPoint(37, 34), "Search the chest for the strongroom key and crystal chime seed.", new Requirement[0]);
        this.openChestForCrystalChimeSeed.addSubSteps(this.pushSmallMonolithSouth, this.pushNWMonolithWest);
        this.getThirdShapes = new ObjectStep(this.getQuestHelper(), 49617, this.regionPoint(41, 29), "Open the chest for some more shapes. If the chest doesn't give you any shapes, drop the shapes in your inventory first, then click the chest, then pick up the shapes from the ground.", new Requirement[0]);
        ItemRequirement crystalChimeSeed = new ItemRequirement("Crystal chime seed", 28575, 1);
        crystalChimeSeed.setTooltip("You can get another one from the golden chest in Yewnock's storeroom");
        this.crystalChime = new ItemRequirement("Crystal chime", 28577, 1);
        ItemRequirement machineRoomKey = new ItemRequirement("Strongroom key", 28574, 1);
        this.inspectSingingBowl = new ObjectStep(this.getQuestHelper(), 49610, this.regionPoint(41, 32), "Inspect the Singing bowl, then click it again to create the Crystal chime.", crystalChimeSeed);
        this.inspectSingingBowl.addAlternateObjects(49611);
        this.inspectSingingBowl.addDialogStep("Yes.");
        this.pushSEMonolithWest = new NpcStep(this.getQuestHelper(), 12486, this.regionPoint(39, 29), "Push the south-east monolith west once.", new Requirement[0]);
        this.pushSEMonolithWest.setMaxRoamRange(2);
        this.unlockTheGate = new ObjectStep(this.getQuestHelper(), 49657, this.regionPoint(30, 31), "Unlock the gate to Yewnock's machine room.", this.crystalChime, machineRoomKey);
    }

    @Override
    @Subscribe
    public void onVarbitChanged(VarbitChanged varbitChanged) {
        this.updateSteps();
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.updateSteps();
    }

    private int countShapes() {
        ItemContainer itemContainer = this.client.getItemContainer(InventoryID.INVENTORY);
        if (itemContainer == null) {
            return 0;
        }
        int count = 0;
        for (Item item : itemContainer.getItems()) {
            ItemRequirement shape = this.shapes.get(item.getId());
            if (shape == null) continue;
            count += item.getQuantity();
        }
        return count;
    }

    private boolean hasFirstChestKey() {
        ItemContainer itemContainer = this.client.getItemContainer(InventoryID.INVENTORY);
        if (itemContainer == null) {
            return false;
        }
        return itemContainer.contains(28573);
    }

    private boolean hasMachineRoomKey() {
        ItemContainer itemContainer = this.client.getItemContainer(InventoryID.INVENTORY);
        if (itemContainer == null) {
            return false;
        }
        return itemContainer.contains(28574);
    }

    private boolean tileHasBigMonolith(Tile[][] tiles, int sceneX, int sceneY) {
        Tile tile = tiles[sceneX][sceneY];
        for (GameObject gameObject : tile.getGameObjects()) {
            if (gameObject == null || gameObject.getId() != 49584) continue;
            return true;
        }
        return false;
    }

    private boolean tileHasSmallMonolith(Tile[][] tiles, int sceneX, int sceneY) {
        Tile tile = tiles[sceneX][sceneY];
        for (GameObject gameObject : tile.getGameObjects()) {
            if (gameObject == null || gameObject.getId() != 49586) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void updateSteps() {
        Tile[][] tiles = this.client.getScene().getTiles()[this.client.getPlane()];
        if (this.tileHasBigMonolith(tiles, 53, 53) && this.inStartZone.check(this.client)) {
            this.startUpStep(this.pushSouthernMonolithUp);
            return;
        }
        int shapeCount = this.countShapes();
        if (shapeCount < 3) {
            this.startUpStep(this.getFirstShapes);
            return;
        }
        if (this.hasFirstChestKey()) {
            if (this.tileHasBigMonolith(tiles, 51, 61)) {
                this.startUpStep(this.pushSWMonolithNorth);
                return;
            }
            if (this.tileHasSmallMonolith(tiles, 55, 65)) {
                if (this.tileHasBigMonolith(tiles, 51, 64)) {
                    this.startUpStep(this.pushNWMonolithEast);
                    return;
                }
                this.startUpStep(this.pushSmallMonolithSouth);
                return;
            }
            if (this.tileHasBigMonolith(tiles, 53, 65)) {
                this.startUpStep(this.pushNWMonolithWest);
                return;
            }
            this.startUpStep(this.openChestForCrystalChimeSeed);
            return;
        }
        if (this.hasMachineRoomKey()) {
            if (shapeCount < 9) {
                this.startUpStep(this.getThirdShapes);
                return;
            }
            if (!this.crystalChime.check(this.client)) {
                this.startUpStep(this.inspectSingingBowl);
                return;
            }
            if (this.tileHasBigMonolith(tiles, 55, 61)) {
                this.startUpStep(this.pushSEMonolithWest);
                return;
            }
            if (this.crystalChime.check(this.client)) {
                this.startUpStep(this.unlockTheGate);
                return;
            }
        }
        if (this.tileHasBigMonolith(tiles, 51, 61)) {
            this.startUpStep(this.pushSWMonolithNorth);
            return;
        }
        if (this.tileHasBigMonolith(tiles, 51, 64)) {
            this.startUpStep(this.pushNWMonolithEast);
            return;
        }
        if (shapeCount < 6) {
            this.startUpStep(this.getSecondShapes);
            return;
        }
        this.startUpStep(this.picklockChestForFirstKey);
    }

    public List<QuestStep> getSteps() {
        return List.of(this.pushSouthernMonolithUp, this.getFirstShapes, this.pushSWMonolithNorth, this.pushNWMonolithEast, this.getSecondShapes, this.picklockChestForFirstKey, this.pushSmallMonolithSouth, this.pushNWMonolithWest, this.openChestForCrystalChimeSeed, this.getThirdShapes, this.inspectSingingBowl, this.pushSEMonolithWest, this.unlockTheGate);
    }
}

