/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.thelosttribe;

import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcEmoteStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import com.questhelper.steps.emote.QuestEmote;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.THE_LOST_TRIBE)
public class TheLostTribe
extends BasicQuestHelper {
    ItemRequirement pickaxe;
    ItemRequirement lightSource;
    ItemRequirement brooch;
    ItemRequirement book;
    ItemRequirement key;
    ItemRequirement silverware;
    ItemRequirement treaty;
    ItemRequirement varrockTeleport;
    ItemRequirement faladorTeleport;
    ItemRequirement lumbridgeTeleports;
    Requirement inBasement;
    Requirement inLumbridgeF0;
    Requirement inLumbridgeF1;
    Requirement inLumbridgeF2;
    Requirement inTunnels;
    Requirement inMines;
    Requirement foundRobes;
    Requirement inHamBase;
    Requirement foundSilverware;
    Requirement bobKnows;
    Requirement hansKnows;
    DetailedQuestStep goDownFromF2;
    DetailedQuestStep talkToSigmund;
    DetailedQuestStep talkToDuke;
    DetailedQuestStep goDownFromF1;
    DetailedQuestStep talkToHans;
    DetailedQuestStep goUpToF1;
    DetailedQuestStep goDownIntoBasement;
    DetailedQuestStep usePickaxeOnRubble;
    DetailedQuestStep climbThroughHole;
    DetailedQuestStep grabBrooch;
    DetailedQuestStep climbOutThroughHole;
    DetailedQuestStep goUpFromBasement;
    DetailedQuestStep showBroochToDuke;
    DetailedQuestStep searchBookcase;
    DetailedQuestStep readBook;
    DetailedQuestStep talkToGenerals;
    DetailedQuestStep walkToMistag;
    DetailedQuestStep emoteAtMistag;
    DetailedQuestStep pickpocketSigmund;
    DetailedQuestStep unlockChest;
    DetailedQuestStep enterHamLair;
    DetailedQuestStep searchHamCrates;
    DetailedQuestStep talkToKazgar;
    DetailedQuestStep talkToMistagForEnd;
    DetailedQuestStep talkToBob;
    DetailedQuestStep talkToAllAboutCellar;
    ConditionalStep goToF1Steps;
    ConditionalStep goDownToBasement;
    ConditionalStep goTalkToSigmundToStart;
    ConditionalStep findGoblinWitnessSteps;
    ConditionalStep goTalkToDukeAfterHans;
    ConditionalStep goMineRubble;
    ConditionalStep enterTunnels;
    ConditionalStep goShowBroochToDuke;
    ConditionalStep goTalkToDukeAfterEmote;
    ConditionalStep goTravelToMistag;
    ConditionalStep goGetKey;
    ConditionalStep goOpenRobeChest;
    ConditionalStep goIntoHamLair;
    ConditionalStep goToDukeWithSilverware;
    ConditionalStep travelToMakePeace;
    Zone basement;
    Zone lumbridgeF0;
    Zone lumbridgeF1;
    Zone lumbridgeF2;
    Zone tunnels;
    Zone mines;
    Zone hamBase;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        this.setupConditionalSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.goTalkToSigmundToStart);
        steps.put(1, this.findGoblinWitnessSteps);
        steps.put(2, this.goTalkToDukeAfterHans);
        steps.put(3, this.goMineRubble);
        ConditionalStep goGrabBrooch = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterTunnels, new Requirement[0]);
        goGrabBrooch.addStep(this.brooch, this.goShowBroochToDuke);
        goGrabBrooch.addStep(this.inTunnels, this.grabBrooch);
        steps.put(4, goGrabBrooch);
        ConditionalStep getBook = new ConditionalStep((QuestHelper)this, (QuestStep)this.searchBookcase, new Requirement[0]);
        getBook.addStep(this.book, this.readBook);
        steps.put(5, getBook);
        steps.put(6, this.talkToGenerals);
        ConditionalStep makeContactSteps = new ConditionalStep((QuestHelper)this, (QuestStep)this.goTravelToMistag, new Requirement[0]);
        makeContactSteps.addStep(this.inMines, this.emoteAtMistag);
        makeContactSteps.addStep(this.inTunnels, this.walkToMistag);
        steps.put(7, makeContactSteps);
        steps.put(8, this.goTalkToDukeAfterEmote);
        ConditionalStep revealSigmund = new ConditionalStep((QuestHelper)this, (QuestStep)this.goGetKey, new Requirement[0]);
        revealSigmund.addStep(this.foundSilverware, this.goToDukeWithSilverware);
        revealSigmund.addStep(this.foundRobes, this.goIntoHamLair);
        revealSigmund.addStep(this.key, this.goOpenRobeChest);
        steps.put(9, revealSigmund);
        steps.put(10, this.travelToMakePeace);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.pickaxe = new ItemRequirement("Any pickaxe", ItemCollections.PICKAXES).isNotConsumed();
        this.lightSource = new ItemRequirement("A light source", ItemCollections.LIGHT_SOURCES).isNotConsumed();
        this.brooch = new ItemRequirement("Brooch", 5008);
        this.book = new ItemRequirement("Goblin symbol book", 5009);
        this.book.setHighlightInInventory(true);
        this.key = new ItemRequirement("Key", 5010);
        this.silverware = new ItemRequirement("Silverware", 5011);
        this.silverware.setTooltip("You can get another from the crate in the entrance of the H.A.M. hideout");
        this.treaty = new ItemRequirement("Peace treaty", 5012);
        this.treaty.setTooltip("You can get another from Duke Horacio");
        this.varrockTeleport = new ItemRequirement("Varrock teleport", 8007);
        this.lumbridgeTeleports = new ItemRequirement("Lumbridge teleports", 8008, 3);
        this.faladorTeleport = new ItemRequirement("Falador teleport", 8009);
    }

    public void loadZones() {
        this.basement = new Zone(new WorldPoint(3208, 9614, 0), new WorldPoint(3219, 9625, 0));
        this.lumbridgeF0 = new Zone(new WorldPoint(3136, 3136, 0), new WorldPoint(3328, 3328, 0));
        this.lumbridgeF1 = new Zone(new WorldPoint(3203, 3206, 1), new WorldPoint(3217, 3231, 1));
        this.lumbridgeF2 = new Zone(new WorldPoint(3203, 3206, 2), new WorldPoint(3217, 3231, 2));
        this.tunnels = new Zone(new WorldPoint(3221, 9602, 0), new WorldPoint(3308, 9661, 0));
        this.mines = new Zone(new WorldPoint(3309, 9600, 0), new WorldPoint(3327, 9655, 0));
        this.hamBase = new Zone(new WorldPoint(3140, 9600, 0), new WorldPoint(3190, 9655, 0));
    }

    public void setupConditions() {
        this.inBasement = new ZoneRequirement(this.basement);
        this.inLumbridgeF0 = new ZoneRequirement(this.lumbridgeF0);
        this.inLumbridgeF1 = new ZoneRequirement(this.lumbridgeF1);
        this.inLumbridgeF2 = new ZoneRequirement(this.lumbridgeF2);
        this.inTunnels = new ZoneRequirement(this.tunnels);
        this.inMines = new ZoneRequirement(this.mines);
        this.inHamBase = new ZoneRequirement(this.hamBase);
        this.foundRobes = new VarbitRequirement(534, 1, Operation.GREATER_EQUAL);
        this.foundSilverware = new VarbitRequirement(534, 3, Operation.GREATER_EQUAL);
        this.hansKnows = new VarbitRequirement(537, 0);
        this.bobKnows = new VarbitRequirement(537, 1);
    }

    public void setupSteps() {
        this.goDownIntoBasement = new ObjectStep((QuestHelper)this, 14880, new WorldPoint(3209, 3216, 0), "Enter the Lumbridge Castle basement.", new Requirement[0]);
        this.goDownFromF1 = new ObjectStep((QuestHelper)this, 16672, new WorldPoint(3205, 3208, 1), "Go down the staircase.", new Requirement[0]);
        this.goDownFromF1.addDialogStep("Climb down the stairs.");
        this.goUpToF1 = new ObjectStep((QuestHelper)this, 16671, new WorldPoint(3205, 3208, 0), "Go up to the first floor of Lumbridge Castle.", new Requirement[0]);
        this.goUpFromBasement = new ObjectStep((QuestHelper)this, 17385, new WorldPoint(3209, 9616, 0), "Go up to the surface.", new Requirement[0]);
        this.goDownFromF2 = new ObjectStep((QuestHelper)this, 16673, new WorldPoint(3205, 3208, 2), "Go downstairs.", new Requirement[0]);
        this.talkToSigmund = new NpcStep((QuestHelper)this, 5322, new WorldPoint(3210, 3222, 1), "", new Requirement[0]);
        this.talkToSigmund.addDialogSteps("Do you have any quests for me?", "Yes.");
        this.talkToHans = new NpcStep((QuestHelper)this, 3105, new WorldPoint(3222, 3218, 0), "Talk to Hans who is roaming around the castle.", new Requirement[0]);
        this.talkToHans.addDialogStep("Do you know what happened in the cellar?");
        this.talkToBob = new NpcStep((QuestHelper)this, 10619, new WorldPoint(3231, 3203, 0), "Talk to Bob in the south of Lumbridge.", new Requirement[0]);
        this.talkToBob.addDialogStep("Do you know what happened in the castle cellar?");
        this.talkToAllAboutCellar = new NpcStep((QuestHelper)this, 4626, "Talk to the Cook, Hans, Father Aereck, and Bob in Lumbridge until one tells you about seeing a goblin.", new Requirement[0]);
        ((NpcStep)this.talkToAllAboutCellar).addAlternateNpcs(2812);
        this.talkToAllAboutCellar.addDialogSteps("Do you know what happened in the castle cellar?");
        this.talkToAllAboutCellar.addSubSteps(this.talkToHans, this.talkToBob);
        this.talkToDuke = new NpcStep((QuestHelper)this, 815, new WorldPoint(3210, 3222, 1), "", new Requirement[0]);
        this.usePickaxeOnRubble = new ObjectStep((QuestHelper)this, 6898, new WorldPoint(3219, 9618, 0), "", new Requirement[0]);
        this.usePickaxeOnRubble.addIcon(1265);
        this.climbThroughHole = new ObjectStep((QuestHelper)this, 6898, new WorldPoint(3219, 9618, 0), "", new Requirement[0]);
        this.grabBrooch = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3230, 9610, 0), "Pick up the brooch on the floor.", this.brooch);
        this.climbOutThroughHole = new ObjectStep((QuestHelper)this, 6905, new WorldPoint(3221, 9618, 0), "", new Requirement[0]);
        this.showBroochToDuke = new NpcStep((QuestHelper)this, 815, new WorldPoint(3210, 3222, 1), "", new Requirement[0]);
        this.showBroochToDuke.addDialogStep("I dug through the rubble...");
        this.searchBookcase = new ObjectStep((QuestHelper)this, 6916, new WorldPoint(3207, 3496, 0), "Search the north west bookcase in the Varrock Castle Library.", new Requirement[0]);
        this.readBook = new DetailedQuestStep((QuestHelper)this, "Read the entire goblin symbol book.", this.book);
        this.talkToGenerals = new NpcStep((QuestHelper)this, 670, new WorldPoint(2957, 3512, 0), "Talk to the Goblin Generals in the Goblin Village.", new Requirement[0]);
        this.talkToGenerals.addDialogSteps("Have you ever heard of the Dorgeshuun?", "It doesn't really matter", "Well either way they refused to fight", "Well I found a brooch underground...", "Well why not show me both greetings?");
        List<WorldPoint> travelLine = Arrays.asList(new WorldPoint(3222, 9618, 0), new WorldPoint(3224, 9618, 0), new WorldPoint(3229, 9610, 0), new WorldPoint(3238, 9610, 0), new WorldPoint(3241, 9612, 0), new WorldPoint(3246, 9612, 0), new WorldPoint(3249, 9619, 0), new WorldPoint(3254, 9625, 0), new WorldPoint(3252, 9631, 0), new WorldPoint(3234, 9631, 0), new WorldPoint(3230, 9634, 0), new WorldPoint(3230, 9643, 0), new WorldPoint(3237, 9648, 0), new WorldPoint(3244, 9648, 0), new WorldPoint(3246, 9645, 0), new WorldPoint(3240, 9641, 0), new WorldPoint(3244, 9637, 0), new WorldPoint(3252, 9642, 0), new WorldPoint(3252, 9646, 0), new WorldPoint(3257, 9656, 0), new WorldPoint(3269, 9656, 0), new WorldPoint(3277, 9652, 0), new WorldPoint(3277, 9647, 0), new WorldPoint(3267, 9643, 0), new WorldPoint(3267, 9638, 0), new WorldPoint(3276, 9637, 0), new WorldPoint(3290, 9645, 0), new WorldPoint(3300, 9641, 0), new WorldPoint(3307, 9631, 0), new WorldPoint(3297, 9627, 0), new WorldPoint(3295, 9622, 0), new WorldPoint(3290, 9617, 0), new WorldPoint(3297, 9606, 0), new WorldPoint(3303, 9606, 0), new WorldPoint(3309, 9612, 0), new WorldPoint(3317, 9612, 0));
        this.walkToMistag = new NpcEmoteStep((QuestHelper)this, 7297, QuestEmote.GOBLIN_BOW, new WorldPoint(3319, 9615, 0), "Travel through the tunnels. Make sure you follow the marked path, or you'll be dropped into a hole and your light source extinguished!", this.lightSource);
        this.walkToMistag.setLinePoints(travelLine);
        this.emoteAtMistag = new NpcEmoteStep((QuestHelper)this, 7297, QuestEmote.GOBLIN_BOW, new WorldPoint(3319, 9615, 0), "Perform the Goblin Bow emote next to Mistag and talk to him.", this.lightSource);
        this.pickpocketSigmund = new NpcStep((QuestHelper)this, 5322, new WorldPoint(3210, 3222, 1), "", new Requirement[0]);
        this.unlockChest = new ObjectStep((QuestHelper)this, 6910, new WorldPoint(3209, 3217, 1), "", new Requirement[0]);
        this.enterHamLair = new ObjectStep((QuestHelper)this, 5492, new WorldPoint(3166, 3252, 0), "", new Requirement[0]);
        this.searchHamCrates = new ObjectStep((QuestHelper)this, 6911, new WorldPoint(3152, 9645, 0), "", new Requirement[0]);
        this.talkToKazgar = new NpcStep((QuestHelper)this, 7300, new WorldPoint(3230, 9610, 0), "Travel with Kazgar to shortcut to Mistag.", new Requirement[0]);
        this.talkToMistagForEnd = new NpcStep((QuestHelper)this, 7298, new WorldPoint(3319, 9615, 0), "", new Requirement[0]);
    }

    private void setupConditionalSteps() {
        this.goToF1Steps = new ConditionalStep((QuestHelper)this, (QuestStep)this.goUpToF1, new Requirement[0]);
        this.goToF1Steps.addStep(this.inLumbridgeF2, this.goDownFromF2);
        this.goToF1Steps.addStep(this.inBasement, this.goUpFromBasement);
        this.goToF1Steps.addStep(this.inTunnels, this.climbOutThroughHole);
        this.goDownToBasement = new ConditionalStep((QuestHelper)this, (QuestStep)this.goDownIntoBasement, new Requirement[0]);
        this.goDownToBasement.addStep(this.inLumbridgeF2, this.goDownFromF2);
        this.goDownToBasement.addStep(this.inLumbridgeF1, this.goDownFromF1);
        this.goTalkToSigmundToStart = new ConditionalStep((QuestHelper)this, (QuestStep)this.goToF1Steps, "Talk to Sigmund in Lumbridge Castle.", new Requirement[0]);
        this.goTalkToSigmundToStart.addStep(this.inLumbridgeF1, this.talkToSigmund);
        this.findGoblinWitnessSteps = new ConditionalStep((QuestHelper)this, (QuestStep)this.talkToAllAboutCellar, new Requirement[0]);
        this.findGoblinWitnessSteps.addStep(this.inLumbridgeF2, this.goDownFromF2);
        this.findGoblinWitnessSteps.addStep(this.inLumbridgeF1, this.goDownFromF1);
        this.findGoblinWitnessSteps.addStep(this.inBasement, this.goUpFromBasement);
        this.findGoblinWitnessSteps.addStep(this.hansKnows, this.talkToHans);
        this.findGoblinWitnessSteps.addStep(this.bobKnows, this.talkToBob);
        this.goTalkToDukeAfterHans = new ConditionalStep((QuestHelper)this, (QuestStep)this.goToF1Steps, "Talk to Duke Horacio in Lumbridge Castle.", new Requirement[0]);
        this.goTalkToDukeAfterHans.addDialogSteps("Hans says he saw something in the cellar", "Bob says he saw something in the cellar", "Father Aereck says he saw something in the cellar", "The cook says he saw something in the cellar");
        this.goTalkToDukeAfterHans.addStep(this.inLumbridgeF1, this.talkToDuke);
        this.goMineRubble = new ConditionalStep((QuestHelper)this, (QuestStep)this.goDownToBasement, "Go use a pickaxe on the rubble in the Lumbridge Castle basement.", this.pickaxe, this.lightSource);
        this.goMineRubble.addStep(this.inBasement, this.usePickaxeOnRubble);
        this.enterTunnels = new ConditionalStep((QuestHelper)this, (QuestStep)this.goDownToBasement, "Enter the hole in Lumbridge Castle's basement.", this.lightSource);
        this.enterTunnels.addStep(this.inBasement, this.climbThroughHole);
        this.goShowBroochToDuke = new ConditionalStep((QuestHelper)this, (QuestStep)this.goToF1Steps, "Show the brooch to Duke Horacio in Lumbridge Castle.", this.brooch);
        this.goShowBroochToDuke.addStep(this.inLumbridgeF1, this.showBroochToDuke);
        this.goTravelToMistag = new ConditionalStep((QuestHelper)this, (QuestStep)this.goDownToBasement, "Travel through the tunnels under Lumbridge until you reach Mistag.", this.lightSource);
        this.goTravelToMistag.addStep(this.inBasement, this.climbThroughHole);
        this.goTravelToMistag.addSubSteps(this.walkToMistag);
        this.goTalkToDukeAfterEmote = new ConditionalStep((QuestHelper)this, (QuestStep)this.goToF1Steps, "Talk to Duke Horacio in Lumbridge Castle. You can fast-travel with Mistag back to Lumbridge.", new Requirement[0]);
        this.goTalkToDukeAfterEmote.addDialogSteps("I've made contact with the cave goblins...");
        this.goTalkToDukeAfterEmote.addStep(this.inLumbridgeF1, this.talkToDuke);
        this.goGetKey = new ConditionalStep((QuestHelper)this, (QuestStep)this.goToF1Steps, "Pickpocket Sigmund for a key.", new Requirement[0]);
        this.goGetKey.addStep(this.inLumbridgeF1, this.pickpocketSigmund);
        this.goOpenRobeChest = new ConditionalStep((QuestHelper)this, (QuestStep)this.goToF1Steps, "Open the chest in the room next to the Duke's room.", this.key);
        this.goOpenRobeChest.addStep(this.inLumbridgeF1, this.unlockChest);
        this.goIntoHamLair = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterHamLair, "Enter the H.A.M lair west of Lumbridge and search a crate in its entrance for the silverware.", new Requirement[0]);
        this.goIntoHamLair.addStep(this.inHamBase, this.searchHamCrates);
        this.goIntoHamLair.addStep(this.inLumbridgeF2, this.goDownFromF2);
        this.goIntoHamLair.addStep(this.inLumbridgeF1, this.goDownFromF1);
        this.goIntoHamLair.addStep(this.inBasement, this.goUpFromBasement);
        this.goToDukeWithSilverware = new ConditionalStep((QuestHelper)this, (QuestStep)this.goToF1Steps, "Take the silverware to Duke Horacio.", this.silverware);
        this.goToDukeWithSilverware.addDialogStep("I found the missing silverware in the HAM cave!");
        this.goToDukeWithSilverware.addStep(this.inLumbridgeF1, this.talkToDuke);
        this.travelToMakePeace = new ConditionalStep((QuestHelper)this, (QuestStep)this.goDownToBasement, "Travel through the tunnels until you reach Mistag, and give him the treaty.", this.lightSource, this.treaty);
        this.travelToMakePeace.addStep(this.inMines, this.talkToMistagForEnd);
        this.travelToMakePeace.addStep(this.inTunnels, this.talkToKazgar);
        this.travelToMakePeace.addStep(this.inBasement, this.climbThroughHole);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.pickaxe, this.lightSource);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.lumbridgeTeleports, this.varrockTeleport, this.faladorTeleport);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new QuestRequirement(QuestHelperQuest.GOBLIN_DIPLOMACY, QuestState.FINISHED));
        req.add(new QuestRequirement(QuestHelperQuest.RUNE_MYSTERIES, QuestState.FINISHED));
        req.add(new SkillRequirement(Skill.AGILITY, 13, true));
        req.add(new SkillRequirement(Skill.THIEVING, 13, true));
        req.add(new SkillRequirement(Skill.MINING, 17, true));
        return req;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.MINING, 3000));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("Ring of Life", 2570, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Access to the Dorgesh-Kann mine."), new UnlockReward("Access to Nardok's Bone Weapon Store"), new UnlockReward("2 new goblin emotes."));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Arrays.asList(this.goTalkToSigmundToStart, this.talkToAllAboutCellar, this.goTalkToDukeAfterHans), new Requirement[0]));
        allSteps.add(new PanelDetails("Investigating", Arrays.asList(this.goMineRubble, this.enterTunnels, this.grabBrooch, this.goShowBroochToDuke), this.pickaxe, this.lightSource));
        allSteps.add(new PanelDetails("Learning about goblins", Arrays.asList(this.searchBookcase, this.readBook, this.talkToGenerals), new Requirement[0]));
        allSteps.add(new PanelDetails("Making contact", Arrays.asList(this.goTravelToMistag, this.emoteAtMistag, this.goTalkToDukeAfterEmote), this.lightSource));
        allSteps.add(new PanelDetails("Resolving tensions", Arrays.asList(this.goGetKey, this.goOpenRobeChest, this.goIntoHamLair, this.goToDukeWithSilverware, this.travelToMakePeace), this.lightSource));
        return allSteps;
    }
}

