/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.theknightssword;

import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.ComplexRequirement;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.NpcCondition;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.npc.NpcRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.THE_KNIGHTS_SWORD)
public class TheKnightsSword
extends BasicQuestHelper {
    ItemRequirement pickaxe;
    ItemRequirement redberryPie;
    ItemRequirement ironBars;
    ItemRequirement bluriteOre;
    ItemRequirement bluriteSword;
    ItemRequirement portrait;
    ItemRequirement varrockTeleport;
    ItemRequirement faladorTeleports;
    ItemRequirement homeTele;
    ComplexRequirement searchCupboardReq;
    Requirement inDungeon;
    Requirement inFaladorCastle1;
    Requirement inFaladorCastle2;
    Requirement inFaladorCastle2Bedroom;
    Requirement sirVyinNotInRoom;
    QuestStep talkToSquire;
    QuestStep talkToReldo;
    QuestStep talkToThurgo;
    QuestStep talkToThurgoAgain;
    QuestStep talkToSquire2;
    QuestStep goUpCastle1;
    QuestStep goUpCastle2;
    QuestStep searchCupboard;
    QuestStep enterDungeon;
    QuestStep mineBlurite;
    QuestStep givePortraitToThurgo;
    QuestStep bringThurgoOre;
    QuestStep finishQuest;
    Zone dungeon;
    Zone faladorCastle1;
    Zone faladorCastle2;
    Zone faladorCastle2Bedroom;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupRequirements();
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToSquire);
        steps.put(1, this.talkToReldo);
        steps.put(2, this.talkToThurgo);
        steps.put(3, this.talkToThurgoAgain);
        steps.put(4, this.talkToSquire2);
        ConditionalStep getPortrait = new ConditionalStep((QuestHelper)this, this.goUpCastle1, new Requirement[0]);
        getPortrait.addStep(this.portrait.alsoCheckBank(this.questBank), this.givePortraitToThurgo);
        getPortrait.addStep(this.inFaladorCastle2, this.searchCupboard);
        getPortrait.addStep(this.inFaladorCastle1, this.goUpCastle2);
        steps.put(5, getPortrait);
        ConditionalStep returnSwordToSquire = new ConditionalStep((QuestHelper)this, this.enterDungeon, new Requirement[0]);
        returnSwordToSquire.addStep(this.bluriteSword.alsoCheckBank(this.questBank), this.finishQuest);
        returnSwordToSquire.addStep(this.bluriteOre.alsoCheckBank(this.questBank), this.bringThurgoOre);
        returnSwordToSquire.addStep(this.inDungeon, this.mineBlurite);
        steps.put(6, returnSwordToSquire);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.redberryPie = new ItemRequirement("Redberry pie", 2325);
        this.ironBars = new ItemRequirement("Iron bar", 2351, 2);
        this.bluriteOre = new ItemRequirement("Blurite ore", 668);
        this.bluriteSword = new ItemRequirement("Blurite sword", 667);
        this.pickaxe = new ItemRequirement("Any pickaxe", ItemCollections.PICKAXES).isNotConsumed();
        this.varrockTeleport = new ItemRequirement("A teleport to Varrock", 8007);
        this.faladorTeleports = new ItemRequirement("Teleports to Falador", 8009, 4);
        this.homeTele = new ItemRequirement("A teleport near Mudskipper Point, such as POH teleport or Fairy Ring to AIQ", 11741, 2);
        this.portrait = new ItemRequirement("Portrait", 666);
    }

    public void setupConditions() {
        this.inDungeon = new ZoneRequirement(this.dungeon);
        this.inFaladorCastle1 = new ZoneRequirement(this.faladorCastle1);
        this.inFaladorCastle2 = new ZoneRequirement(this.faladorCastle2);
        this.inFaladorCastle2Bedroom = new ZoneRequirement(this.faladorCastle2Bedroom);
        this.sirVyinNotInRoom = new NpcCondition(4736, this.faladorCastle2Bedroom);
        NpcRequirement sirVyinNotInRoom = new NpcRequirement("Sir Vyin not in the bedroom.", 4736, true, this.faladorCastle2Bedroom);
        ZoneRequirement playerIsUpstairs = new ZoneRequirement("Upstairs", this.faladorCastle2);
        this.searchCupboardReq = new ComplexRequirement(LogicType.AND, "Sir Vyin not in the bedroom.", playerIsUpstairs, sirVyinNotInRoom);
    }

    public void setupZones() {
        this.dungeon = new Zone(new WorldPoint(2979, 9538, 0), new WorldPoint(3069, 9602, 0));
        this.faladorCastle1 = new Zone(new WorldPoint(2954, 3328, 1), new WorldPoint(2997, 3353, 1));
        this.faladorCastle2 = new Zone(new WorldPoint(2980, 3331, 2), new WorldPoint(2986, 3346, 2));
        this.faladorCastle2Bedroom = new Zone(new WorldPoint(2981, 3336, 2), new WorldPoint(2986, 3331, 2));
    }

    public void setupSteps() {
        this.talkToSquire = new NpcStep((QuestHelper)this, 4737, new WorldPoint(2978, 3341, 0), "Talk to the Squire in Falador Castle's courtyard.", new Requirement[0]);
        this.talkToSquire.addDialogStep("And how is life as a squire?");
        this.talkToSquire.addDialogStep("I can make a new sword if you like...");
        this.talkToSquire.addDialogStep("So would these dwarves make another one?");
        this.talkToSquire.addDialogStep("Ok, I'll give it a go.");
        this.talkToReldo = new NpcStep((QuestHelper)this, 4243, new WorldPoint(3211, 3494, 0), "Talk to Reldo in Varrock Castle's library.", new Requirement[0]);
        this.talkToReldo.addDialogStep("What do you know about the Imcando dwarves?");
        this.talkToThurgo = new NpcStep((QuestHelper)this, 4733, new WorldPoint(3000, 3145, 0), "Talk to Thurgo south of Port Sarim and give him a redberry pie.", this.redberryPie);
        this.talkToThurgo.addDialogStep("Would you like a redberry pie?");
        this.talkToThurgoAgain = new NpcStep((QuestHelper)this, 4733, new WorldPoint(3000, 3145, 0), "Talk to Thurgo again.", new Requirement[0]);
        this.talkToThurgoAgain.addDialogStep("Can you make a special sword for me?");
        this.talkToSquire2 = new NpcStep((QuestHelper)this, 4737, new WorldPoint(2978, 3341, 0), "Talk to the Squire in Falador Castle's courtyard.", new Requirement[0]);
        this.goUpCastle1 = new ObjectStep((QuestHelper)this, 24070, new WorldPoint(2994, 3341, 0), "Climb up the east ladder in Falador Castle.", new Requirement[0]);
        this.goUpCastle2 = new ObjectStep((QuestHelper)this, 24077, new WorldPoint(2985, 3338, 1), "Go up the staircase west of the ladder on the 1st floor.", new Requirement[0]);
        this.searchCupboard = new ObjectStep((QuestHelper)this, 2272, new WorldPoint(2985, 3336, 2), "Search the cupboard in the room south of the staircase. You'll need Sir Vyvin to be in the other room.", this.searchCupboardReq);
        ((ObjectStep)this.searchCupboard).addAlternateObjects(2271);
        this.givePortraitToThurgo = new NpcStep((QuestHelper)this, 4733, new WorldPoint(3000, 3145, 0), "Bring Thurgo the portrait.", this.ironBars, this.portrait);
        this.givePortraitToThurgo.addDialogStep("About that sword...");
        this.enterDungeon = new ObjectStep((QuestHelper)this, 1738, new WorldPoint(3008, 3150, 0), "Go down the ladder south of Port Sarim. Be prepared for ice giants and ice warriors to attack you.", this.pickaxe, this.ironBars);
        this.mineBlurite = new ObjectStep((QuestHelper)this, 11378, new WorldPoint(3049, 9566, 0), "Mine a blurite ore in the eastern cavern.", this.pickaxe);
        this.bringThurgoOre = new NpcStep((QuestHelper)this, 4733, new WorldPoint(3000, 3145, 0), "Return to Thurgo with a blurite ore and two iron bars.", this.bluriteOre, this.ironBars);
        this.bringThurgoOre.addDialogStep("Can you make that replacement sword now?");
        this.finishQuest = new NpcStep((QuestHelper)this, 4737, new WorldPoint(2978, 3341, 0), "Return to the Squire with the sword to finish the quest.", this.bluriteSword);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.redberryPie);
        reqs.add(this.ironBars);
        reqs.add(this.pickaxe);
        return reqs;
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.varrockTeleport);
        reqs.add(this.faladorTeleports);
        reqs.add(this.homeTele);
        return reqs;
    }

    @Override
    public List<String> getCombatRequirements() {
        ArrayList<String> reqs = new ArrayList<String>();
        reqs.add("Able to survive attacks from Ice Warriors (level 57) and Ice Giants (level 53)");
        return reqs;
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        return Collections.singletonList(new SkillRequirement(Skill.MINING, 10, true));
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.SMITHING, 12725));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("The ability to smelt Blurite ore."), new UnlockReward("The ability to smith Blurite bars."));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Arrays.asList(this.talkToSquire, this.talkToReldo), new Requirement[0]));
        allSteps.add(new PanelDetails("Finding an Imcando", Arrays.asList(this.talkToThurgo, this.talkToThurgoAgain), this.redberryPie));
        allSteps.add(new PanelDetails("Find the portrait", Arrays.asList(this.talkToSquire2, this.goUpCastle1, this.goUpCastle2, this.searchCupboard, this.givePortraitToThurgo), new Requirement[0]));
        allSteps.add(new PanelDetails("Making the sword", Arrays.asList(this.enterDungeon, this.mineBlurite, this.bringThurgoOre), this.pickaxe, this.portrait, this.ironBars));
        allSteps.add(new PanelDetails("Return the sword", Collections.singletonList(this.finishQuest), new Requirement[0]));
        return allSteps;
    }
}

