/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.thehandinthesand;

import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.THE_HAND_IN_THE_SAND)
public class TheHandInTheSand
extends BasicQuestHelper {
    ItemRequirement truthSerum;
    ItemRequirement beer;
    ItemRequirement redberries;
    ItemRequirement whiteberries;
    ItemRequirement pinkDye;
    ItemRequirement roseLens;
    ItemRequirement lanternLens;
    ItemRequirement magicalOrb;
    ItemRequirement redberryJuice;
    ItemRequirement bottledWater;
    ItemRequirement hand;
    ItemRequirement beerHand;
    ItemRequirement bertsRota;
    ItemRequirement sandysRota;
    ItemRequirement magicScroll;
    ItemRequirement vial;
    ItemRequirement vial2;
    ItemRequirement sand;
    ItemRequirement wizardsHead;
    ItemRequirement beerOr2Coins;
    ItemRequirement earthRunes5;
    ItemRequirement coins;
    ItemRequirement bucketOfSand;
    ItemRequirement truthSerumHighlight;
    ItemRequirement activatedOrb;
    ItemRequirement teleportsToYanille;
    ItemRequirement teleportsToBrimhaven;
    Requirement notTeleportedToSarim;
    Requirement inYanille;
    Requirement inLightSpot;
    Requirement receivedBottledWater;
    Requirement vialPlaced;
    Requirement madeTruthSerum;
    DetailedQuestStep talkToBert;
    DetailedQuestStep talkToBertAboutRota;
    DetailedQuestStep talkToBertAboutScroll;
    DetailedQuestStep talkToBetty;
    DetailedQuestStep talkToBettyOnceMore;
    DetailedQuestStep talkToBettyAgain;
    DetailedQuestStep talkToRarveAgain;
    DetailedQuestStep talkToSandyWithPotion;
    DetailedQuestStep giveCaptainABeer;
    DetailedQuestStep useLensOnCounter;
    DetailedQuestStep useDyeOnLanternLens;
    DetailedQuestStep useSerumOnCoffee;
    DetailedQuestStep searchSandysDesk;
    DetailedQuestStep standInDoorway;
    DetailedQuestStep ringBell;
    DetailedQuestStep ringBellAgain;
    DetailedQuestStep pickpocketSandy;
    DetailedQuestStep addWhiteberries;
    DetailedQuestStep addRedberries;
    DetailedQuestStep activateMagicalOrb;
    DetailedQuestStep interrogateSandy;
    DetailedQuestStep ringBellAfterInterrogation;
    DetailedQuestStep ringBellWithItems;
    DetailedQuestStep talkToMazion;
    DetailedQuestStep ringBellEnd;
    Zone yanille;
    Zone lightSpot;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToBert);
        steps.put(10, this.giveCaptainABeer);
        steps.put(20, this.ringBell);
        steps.put(30, this.talkToBertAboutRota);
        steps.put(40, this.searchSandysDesk);
        ConditionalStep goGetScroll = new ConditionalStep((QuestHelper)this, (QuestStep)this.pickpocketSandy, new Requirement[0]);
        goGetScroll.addStep(this.sand, this.talkToBertAboutScroll);
        steps.put(50, goGetScroll);
        steps.put(60, this.ringBellAgain);
        ConditionalStep goToBetty = new ConditionalStep((QuestHelper)this, (QuestStep)this.talkToBetty, new Requirement[0]);
        goToBetty.addStep(this.madeTruthSerum, this.talkToBettyOnceMore);
        goToBetty.addStep(new Conditions(this.roseLens, this.vialPlaced, this.inLightSpot), this.useLensOnCounter);
        goToBetty.addStep(new Conditions(this.roseLens, this.vialPlaced), this.standInDoorway);
        goToBetty.addStep(this.roseLens, this.talkToBettyAgain);
        goToBetty.addStep(this.pinkDye, this.useDyeOnLanternLens);
        goToBetty.addStep(this.redberryJuice, this.addWhiteberries);
        goToBetty.addStep(this.receivedBottledWater, this.addRedberries);
        goToBetty.addStep(new Conditions(this.inYanille, this.notTeleportedToSarim), this.talkToRarveAgain);
        steps.put(70, goToBetty);
        steps.put(80, this.talkToSandyWithPotion);
        steps.put(90, this.useSerumOnCoffee);
        steps.put(100, this.activateMagicalOrb);
        steps.put(110, this.interrogateSandy);
        steps.put(120, this.ringBellAfterInterrogation);
        steps.put(130, this.ringBellWithItems);
        steps.put(140, this.talkToMazion);
        steps.put(150, this.ringBellEnd);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.beer = new ItemRequirement("Beer", 1917);
        this.bottledWater = new ItemRequirement("Bottled water", 6953);
        this.bottledWater.setTooltip("You can get another from Betty");
        this.bottledWater.setHighlightInInventory(true);
        this.redberries = new ItemRequirement("Redberries", 1951);
        this.redberries.setHighlightInInventory(true);
        this.whiteberries = new ItemRequirement("White berries", 239);
        this.whiteberries.setHighlightInInventory(true);
        this.redberryJuice = new ItemRequirement("Red dye", 6954);
        this.redberryJuice.setHighlightInInventory(true);
        this.pinkDye = new ItemRequirement("Pink dye", 6955);
        this.pinkDye.setHighlightInInventory(true);
        this.truthSerum = new ItemRequirement("Truth serum", 6952);
        this.truthSerum.setTooltip("You can get another from Betty in Port Sarim");
        this.truthSerumHighlight = new ItemRequirement("Truth serum", 6952);
        this.truthSerumHighlight.setTooltip("You can get another from Betty in Port Sarim");
        this.truthSerumHighlight.setHighlightInInventory(true);
        this.lanternLens = new ItemRequirement("Lantern lens", 4542);
        this.lanternLens.setHighlightInInventory(true);
        this.roseLens = new ItemRequirement("Rose-tinted lens", 6956);
        this.roseLens.setHighlightInInventory(true);
        this.hand = new ItemRequirement("Sandy hand", 6945);
        this.hand.setTooltip("You can get another from Bert");
        this.beerHand = new ItemRequirement("Beer soaked hand", 6946);
        this.beerHand.setTooltip("You can get another from Bert");
        this.bertsRota = new ItemRequirement("Bert's rota", 6947);
        this.bertsRota.setTooltip("You can get another from Bert");
        this.sandysRota = new ItemRequirement("Sandy's rota", 6948);
        this.sandysRota.setTooltip("You can get another by searching Sandy's desk");
        this.magicalOrb = new ItemRequirement("Magical orb", 6950);
        this.magicalOrb.setTooltip("You can get another from Zavistic Rarve in Yanille");
        this.magicalOrb.setHighlightInInventory(true);
        this.activatedOrb = new ItemRequirement("Magical orb", 6951);
        this.activatedOrb.setTooltip("You can get another from Zavistic Rarve in Yanille");
        this.vial = new ItemRequirement("Vial", 229);
        this.vial2 = new ItemRequirement("Vial", 229, 2);
        this.magicScroll = new ItemRequirement("A magic scroll", 6949);
        this.magicScroll.setTooltip("You can get another from Bert");
        this.sand = new ItemRequirement("Sand", 6958);
        this.sand.setTooltip("You can get more by pickpocketing Sandy in Brimhaven");
        this.beerOr2Coins = new ItemRequirement("Beer or 2 gp", 1917);
        this.earthRunes5 = new ItemRequirement("Earth runes", 557, 5);
        this.coins = new ItemRequirement("Coins or more for boat travel", ItemCollections.COINS, 150);
        this.bucketOfSand = new ItemRequirement("Bucket of sand", 1783);
        this.wizardsHead = new ItemRequirement("Wizard's head", 6957);
        this.wizardsHead.setTooltip("You can get another from Mazion on Entrana");
        this.teleportsToBrimhaven = new ItemRequirement("Teleports to Brimhaven, or to near a boat to Brimhaven", 11745, 2);
        this.teleportsToYanille = new ItemRequirement("Teleports to Yanille, such as dueling ring or minigame teleport", 11746, 3);
    }

    public void loadZones() {
        this.yanille = new Zone(new WorldPoint(2528, 3063, 0), new WorldPoint(2628, 3122, 0));
        this.lightSpot = new Zone(new WorldPoint(3016, 3259, 0), new WorldPoint(3016, 3259, 0));
    }

    public void setupConditions() {
        this.notTeleportedToSarim = new VarbitRequirement(1531, 0);
        this.inYanille = new ZoneRequirement(this.yanille);
        this.inLightSpot = new ZoneRequirement(this.lightSpot);
        this.receivedBottledWater = new VarbitRequirement(1532, 1);
        this.vialPlaced = new VarbitRequirement(1537, 1);
        this.madeTruthSerum = new VarbitRequirement(1532, 5);
    }

    public void setupSteps() {
        this.talkToBert = new NpcStep((QuestHelper)this, 5815, new WorldPoint(2551, 3099, 0), "Talk to Bert in west Yanille.", new Requirement[0]);
        this.talkToBert.addDialogStep("Eww a hand, in the sand! Why haven't you told the authorities?");
        this.talkToBert.addDialogStep("Sure, I'll give you a hand.");
        this.giveCaptainABeer = new NpcStep((QuestHelper)this, 5383, new WorldPoint(2552, 3080, 0), "Give the Guard Captain in the pub south of Bert a beer. You can buy one for 2gp from the pub.", this.beer);
        this.ringBell = new ObjectStep((QuestHelper)this, 6847, new WorldPoint(2598, 3085, 0), "Ring the bell outside the Wizards' Guild in Yanille. Talk to Zavistic Rarve when he appears.", this.beerHand);
        this.ringBell.addDialogStep("I have a rather sandy problem that I'd like to palm off on you.");
        this.talkToBertAboutRota = new NpcStep((QuestHelper)this, 5815, new WorldPoint(2551, 3099, 0), "Return to Bert in west Yanille.", new Requirement[0]);
        this.searchSandysDesk = new ObjectStep((QuestHelper)this, 10805, new WorldPoint(2789, 3174, 0), "Travel to Brimhaven, then enter Sandy's building south of the restaurant. Search Sandy's desk for Sandy's rota.", new Requirement[0]);
        this.pickpocketSandy = new NpcStep((QuestHelper)this, 5384, new WorldPoint(2790, 3175, 0), "Pickpocket Sandy for some sand.", new Requirement[0]);
        this.talkToBertAboutScroll = new NpcStep((QuestHelper)this, 5815, new WorldPoint(2551, 3099, 0), "Return to Bert in west Yanille with the rota and sand.", this.bertsRota, this.sandysRota);
        this.ringBellAgain = new ObjectStep((QuestHelper)this, 6847, new WorldPoint(2598, 3085, 0), "Ring the bell outside the Wizards' Guild in Yanille. Talk to Zavistic Rarve when he appears.", this.magicScroll);
        this.ringBellAgain.addDialogStep("I have a rather sandy problem that I'd like to palm off on you.");
        this.talkToRarveAgain = new ObjectStep((QuestHelper)this, 6847, new WorldPoint(2598, 3085, 0), "Talk to Zavistic Rarve again to get teleported to Port Sarim.", this.vial);
        this.talkToRarveAgain.addDialogSteps("Can you help me more?", "Yes, that would be great!", "I have a rather sandy problem that I'd like to palm off on you.");
        this.talkToBetty = new NpcStep((QuestHelper)this, 5905, new WorldPoint(3014, 3258, 0), "Travel to Port Sarim, and talk to Betty in the magic shop.", this.vial);
        this.talkToBetty.addDialogStep("Talk to Betty about the Hand in the Sand.");
        this.addRedberries = new DetailedQuestStep((QuestHelper)this, "Use redberries on the bottled water.", this.bottledWater, this.redberries);
        this.addWhiteberries = new DetailedQuestStep((QuestHelper)this, "Use whiteberries on the red bottled water", this.redberryJuice, this.whiteberries);
        this.useDyeOnLanternLens = new DetailedQuestStep((QuestHelper)this, "Use the pink dye on a lantern lens.", this.pinkDye, this.lanternLens);
        this.talkToBettyAgain = new NpcStep((QuestHelper)this, 5905, new WorldPoint(3014, 3258, 0), "Talk to Betty with the pink lens.", new Requirement[0]);
        this.talkToBettyAgain.addDialogStep("Talk to Betty about the Hand in the Sand.");
        this.standInDoorway = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3016, 3259, 0), "Stand in Betty's doorway and use the rose-tinted lens on the counter.", new Requirement[0]);
        this.useLensOnCounter = new ObjectStep((QuestHelper)this, 10812, new WorldPoint(3013, 3258, 0), "Stand in Betty's doorway and use the rose-tinted lens on the counter.", this.roseLens);
        this.useLensOnCounter.addIcon(6956);
        this.useLensOnCounter.addSubSteps(this.standInDoorway);
        this.talkToBettyOnceMore = new NpcStep((QuestHelper)this, 5905, new WorldPoint(3014, 3258, 0), "Talk to Betty again.", this.truthSerum, this.sand);
        this.talkToBettyOnceMore.addDialogStep("Talk to Betty about the Hand in the Sand.");
        this.talkToSandyWithPotion = new NpcStep((QuestHelper)this, 5384, new WorldPoint(2790, 3175, 0), "Talk to Sandy in Brimhaven again with the truth serum. Select distractions until one works.", this.truthSerum);
        this.useSerumOnCoffee = new ObjectStep((QuestHelper)this, 10806, new WorldPoint(2789, 3176, 0), "Use the truth serum on Sandy's coffee mug.", this.truthSerum.highlighted());
        this.useSerumOnCoffee.addIcon(6952);
        this.activateMagicalOrb = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2789, 3175, 0), "Activate the magical orb next to Sandy.", this.magicalOrb);
        this.interrogateSandy = new NpcStep((QuestHelper)this, 5384, new WorldPoint(2790, 3175, 0), "Ask Sandy all questions available with the Magical orb (a) in your inventory.", this.activatedOrb);
        this.interrogateSandy.addDialogSteps("Why is Bert's rota different from the original?", "Why doesn't Bert remember the change in his hours?", "What happened to the wizard?");
        this.ringBellAfterInterrogation = new ObjectStep((QuestHelper)this, 6847, new WorldPoint(2598, 3085, 0), "Return to the Wizards' Guild in Yanille and ring the bell outside. Talk to Zavistic Rarve when he appears.", this.activatedOrb, this.earthRunes5, this.bucketOfSand);
        this.ringBellAfterInterrogation.addDialogStep("I have a rather sandy problem that I'd like to palm off on you.");
        this.ringBellWithItems = new ObjectStep((QuestHelper)this, 6847, new WorldPoint(2598, 3085, 0), "Give Zavistic Rarve 5 earth runes and a bucket of sand.", this.earthRunes5, this.bucketOfSand);
        this.ringBellWithItems.addDialogStep("I have a rather sandy problem that I'd like to palm off on you.");
        this.talkToMazion = new NpcStep((QuestHelper)this, 5386, new WorldPoint(2815, 3340, 0), "Travel to Entrana (bank all combat gear), and talk to Mazion at the sand pit.", new Requirement[0]);
        this.ringBellEnd = new ObjectStep((QuestHelper)this, 6847, new WorldPoint(2598, 3085, 0), "Return to the Wizards' Guild in Yanille and ring the bell outside. Talk to Zavistic Rarve when he appears to finish the quest.", this.wizardsHead);
        this.ringBellEnd.addDialogStep("I have a rather sandy problem that I'd like to palm off on you.");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.beerOr2Coins);
        reqs.add(this.coins);
        reqs.add(this.vial2);
        reqs.add(this.redberries);
        reqs.add(this.whiteberries);
        reqs.add(this.lanternLens);
        reqs.add(this.earthRunes5);
        reqs.add(this.bucketOfSand);
        return reqs;
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.teleportsToYanille);
        reqs.add(this.teleportsToBrimhaven);
        return reqs;
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        return Arrays.asList(new SkillRequirement(Skill.THIEVING, 17), new SkillRequirement(Skill.CRAFTING, 49));
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.THIEVING, 1000), new ExperienceReward(Skill.CRAFTING, 9000));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Daily sand from Bert in Yanille."), new UnlockReward("Access to the Wizards Guild rune store."));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Collections.singletonList(this.talkToBert), new Requirement[0]));
        allSteps.add(new PanelDetails("Investigating", Arrays.asList(this.giveCaptainABeer, this.ringBell, this.talkToBertAboutRota, this.searchSandysDesk, this.pickpocketSandy), this.beerOr2Coins));
        allSteps.add(new PanelDetails("Making a truth serum", Arrays.asList(this.talkToBertAboutScroll, this.ringBellAgain, this.talkToRarveAgain, this.talkToBetty, this.addRedberries, this.addWhiteberries, this.useDyeOnLanternLens, this.talkToBettyAgain, this.useLensOnCounter, this.talkToBettyOnceMore), this.vial2, this.lanternLens, this.redberries, this.whiteberries));
        allSteps.add(new PanelDetails("Uncover the truth", Arrays.asList(this.talkToSandyWithPotion, this.useSerumOnCoffee, this.activateMagicalOrb, this.interrogateSandy), this.truthSerum, this.magicalOrb));
        allSteps.add(new PanelDetails("Finishing off", Arrays.asList(this.ringBellAfterInterrogation, this.ringBellWithItems, this.talkToMazion, this.ringBellEnd), this.earthRunes5, this.bucketOfSand));
        return allSteps;
    }
}

