/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.thegreatbrainrobbery;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.questinfo.QuestVarbits;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemOnTileRequirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.ItemRequirements;
import com.questhelper.requirements.item.TeleportItemRequirement;
import com.questhelper.requirements.player.InInstanceRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntUnaryOperator;
import net.runelite.api.GameState;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.client.eventbus.Subscribe;

@QuestDescriptor(quest=QuestHelperQuest.THE_GREAT_BRAIN_ROBBERY)
public class TheGreatBrainRobbery
extends BasicQuestHelper {
    ItemRequirement fishbowlHelmet;
    ItemRequirement divingApparatus;
    ItemRequirement woodenCats;
    ItemRequirement oakPlank;
    ItemRequirement saw;
    ItemRequirement plank;
    ItemRequirement fur;
    ItemRequirement hammer;
    ItemRequirement nails;
    ItemRequirement holySymbol;
    ItemRequirement ringOfCharos;
    ItemRequirement catsOrResources;
    ItemRequirement tinderbox;
    ItemRequirement noPet;
    ItemRequirement ectophial;
    ItemRequirement edgevilleTeleport;
    ItemRequirement fenkenstrainTeleport;
    ItemRequirement watermelonSeeds;
    ItemRequirement combatGearForSafespotting;
    ItemRequirement food;
    ItemRequirement prayerPotions;
    ItemRequirement prayerBook;
    ItemRequirement wolfWhistle;
    ItemRequirement shippingOrder;
    ItemRequirement cratePart;
    ItemRequirement keg;
    ItemRequirement fuse;
    ItemRequirement cranialClamp;
    ItemRequirement brainTongs;
    ItemRequirement bellJars;
    ItemRequirement skullStaples;
    ItemRequirement neededJars;
    ItemRequirement neededStaples;
    ItemRequirement anchor;
    Zone harmony;
    Zone waterEntrance;
    Zone water;
    Zone waterExit;
    Zone peepRoom;
    Zone fenkF2;
    Zone fenkF1;
    Zone harmonyBasement;
    Zone boat;
    Zone boatToMos;
    Zone mos;
    Requirement inHarmony;
    Requirement inWaterEntrance;
    Requirement inWater;
    Requirement inWaterExit;
    Requirement inPeepRoom;
    Requirement inFenkF2;
    Requirement inFenkF1;
    Requirement inHarmonyBasement;
    Requirement onBoat;
    Requirement repairedStairs;
    Requirement hasReadPrayerBook;
    Requirement talkedToFenk;
    Requirement talkedToRufus;
    Requirement madeCrateWalls;
    Requirement madeCrateBottom;
    Requirement addedCats;
    Requirement addedCatsOrHas10;
    Requirement fenkInCrate;
    Requirement placedKeg;
    Requirement addedFuse;
    Requirement litFuse;
    Requirement churchDoorGone;
    Requirement hasKeg;
    Requirement hasFuse;
    Requirement hasTinderbox;
    Requirement givenClamp;
    Requirement givenStaples;
    Requirement givenBells;
    Requirement givenTongs;
    Requirement hadClamp;
    Requirement hadStaples;
    Requirement hadBells;
    Requirement hadTongs;
    Requirement givenHammer;
    Requirement barrelchestAppeared;
    Requirement inBoatToMos;
    Requirement inMos;
    QuestStep talkToTranquility;
    QuestStep talkToTranquilityOnIsland;
    QuestStep pullStatue;
    QuestStep enterWater;
    QuestStep repairWaterStairs;
    QuestStep climbFromWater;
    QuestStep climbFromWaterCaveToPeep;
    QuestStep peerThroughHole;
    QuestStep goFromHoleToWater;
    QuestStep leaveWaterBack;
    QuestStep enterWaterReturn;
    QuestStep leaveWaterEntranceReturn;
    QuestStep talkToTranquilityAfterPeeping;
    QuestStep talkToTranquilityMosAfterPeeping;
    QuestStep moveToMos;
    QuestStep moveToCapt;
    QuestStep searchBookcase;
    QuestStep readBook;
    ConditionalStep returnToTranquility;
    QuestStep recitePrayer;
    QuestStep returnToHarmonyAfterPrayer;
    QuestStep talkToTranquilityAfterPrayer;
    QuestStep goToF1Fenk;
    QuestStep goToF2Fenk;
    QuestStep talkToFenk;
    QuestStep talkToRufus;
    QuestStep makeOrGetWoodenCats;
    QuestStep goToF1FenkForCrate;
    QuestStep goToF2FenkForCrate;
    QuestStep buildCrate;
    QuestStep addBottomToCrate;
    QuestStep fillCrate;
    QuestStep blowWhistle;
    QuestStep goF1WithOrder;
    QuestStep goF2WithOrder;
    QuestStep putOrderOnCrate;
    QuestStep goToHarmonyAfterFenk;
    QuestStep goDownToFenk;
    QuestStep talkToFenkOnHarmony;
    QuestStep leaveWindmillBasement;
    QuestStep goToHarmonyForBrainItems;
    QuestStep getFuse;
    QuestStep climbShipLadder;
    QuestStep getTinderbox;
    QuestStep getKeg;
    QuestStep climbDownFromShip;
    QuestStep useKegOnDoor;
    QuestStep useFuseOnDoor;
    QuestStep lightFuse;
    QuestStep killSorebones;
    QuestStep goBackDownToFenk;
    QuestStep talkToFenkWithItems;
    QuestStep goUpFromFenkAfterItems;
    QuestStep talkToTranquilityAfterHelping;
    QuestStep enterChurchForFight;
    QuestStep confrontMigor;
    QuestStep defeatBarrelchest;
    QuestStep pickupAnchor;
    QuestStep talkToTranquilityToFinish;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupRequirements();
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        ConditionalStep goStart = new ConditionalStep((QuestHelper)this, this.moveToCapt, new Requirement[0]);
        goStart.addStep(this.inBoatToMos, this.moveToMos);
        goStart.addStep(this.inMos, this.talkToTranquility);
        goStart.addStep(this.inHarmony, this.talkToTranquilityOnIsland);
        steps.put(0, goStart);
        ConditionalStep goPeep = new ConditionalStep((QuestHelper)this, (QuestStep)goStart, new Requirement[0]);
        goPeep.addStep(this.inPeepRoom, this.peerThroughHole);
        goPeep.addStep(this.inWaterExit, this.climbFromWaterCaveToPeep);
        goPeep.addStep(new Conditions(this.inWater, this.repairedStairs), this.climbFromWater);
        goPeep.addStep(this.inWater, this.repairWaterStairs);
        goPeep.addStep(this.inWaterEntrance, this.enterWater);
        goPeep.addStep(this.inHarmony, this.pullStatue);
        steps.put(10, goPeep);
        ConditionalStep returnAfterPeep = new ConditionalStep((QuestHelper)this, this.talkToTranquilityMosAfterPeeping, new Requirement[0]);
        returnAfterPeep.addStep(this.inPeepRoom, this.goFromHoleToWater);
        returnAfterPeep.addStep(this.inWaterExit, this.enterWaterReturn);
        returnAfterPeep.addStep(this.inWater, this.leaveWaterEntranceReturn);
        returnAfterPeep.addStep(this.inWaterEntrance, this.leaveWaterBack);
        returnAfterPeep.addStep(this.inHarmony, this.talkToTranquilityAfterPeeping);
        steps.put(20, returnAfterPeep);
        ConditionalStep goGetBook = new ConditionalStep((QuestHelper)this, this.searchBookcase, new Requirement[0]);
        goGetBook.addStep(new Conditions(this.prayerBook.alsoCheckBank(this.questBank), this.hasReadPrayerBook, this.inHarmony), this.recitePrayer);
        goGetBook.addStep(new Conditions(this.prayerBook.alsoCheckBank(this.questBank), this.hasReadPrayerBook), this.returnToTranquility);
        goGetBook.addStep(this.prayerBook.alsoCheckBank(this.questBank), this.readBook);
        steps.put(30, goGetBook);
        steps.put(40, goGetBook);
        ConditionalStep goAfterPrayer = new ConditionalStep((QuestHelper)this, this.returnToHarmonyAfterPrayer, new Requirement[0]);
        goAfterPrayer.addStep(this.inHarmony, this.talkToTranquilityAfterPrayer);
        steps.put(50, goAfterPrayer);
        ConditionalStep goSortCrate = new ConditionalStep((QuestHelper)this, this.makeOrGetWoodenCats, new Requirement[0]);
        goSortCrate.addStep(new Conditions(this.inFenkF2, this.addedCats), this.blowWhistle);
        goSortCrate.addStep(new Conditions(this.addedCatsOrHas10, this.inFenkF2, this.madeCrateBottom), this.fillCrate);
        goSortCrate.addStep(new Conditions(this.addedCatsOrHas10, this.inFenkF2, this.madeCrateWalls), this.addBottomToCrate);
        goSortCrate.addStep(new Conditions(this.addedCatsOrHas10, this.inFenkF2), this.buildCrate);
        goSortCrate.addStep(new Conditions(this.addedCatsOrHas10, this.inFenkF1), this.goToF2FenkForCrate);
        goSortCrate.addStep(new Conditions(this.addedCatsOrHas10), this.goToF1FenkForCrate);
        ConditionalStep goTalkFenk = new ConditionalStep((QuestHelper)this, this.goToF1Fenk, new Requirement[0]);
        goTalkFenk.addStep(new Conditions(this.fenkInCrate, this.inFenkF2), this.putOrderOnCrate);
        goTalkFenk.addStep(new Conditions(this.fenkInCrate, this.inFenkF1), this.goF2WithOrder);
        goTalkFenk.addStep(this.fenkInCrate, this.goF1WithOrder);
        goTalkFenk.addStep(this.talkedToRufus, goSortCrate);
        goTalkFenk.addStep(this.talkedToFenk, this.talkToRufus);
        goTalkFenk.addStep(this.inFenkF1, this.goToF2Fenk);
        goTalkFenk.addStep(this.inFenkF2, this.talkToFenk);
        steps.put(60, goTalkFenk);
        ConditionalStep goTalkFenkHarmony = new ConditionalStep((QuestHelper)this, this.goToHarmonyAfterFenk, new Requirement[0]);
        goTalkFenkHarmony.addStep(this.inHarmonyBasement, this.talkToFenkOnHarmony);
        goTalkFenkHarmony.addStep(this.inHarmony, this.goDownToFenk);
        steps.put(70, goTalkFenkHarmony);
        ConditionalStep goBlowTheDoor = new ConditionalStep((QuestHelper)this, this.goToHarmonyForBrainItems, new Requirement[0]);
        goBlowTheDoor.addStep(new Conditions(this.inHarmonyBasement, this.hadClamp, this.hadTongs, this.hadBells, this.hadStaples), this.talkToFenkWithItems);
        goBlowTheDoor.addStep(new Conditions(this.hadClamp, this.hadTongs, this.hadBells, this.hadStaples), this.goBackDownToFenk);
        goBlowTheDoor.addStep(new Conditions(this.onBoat, this.hasFuse, this.hasTinderbox, this.hasKeg), this.climbDownFromShip);
        goBlowTheDoor.addStep(new Conditions(this.inHarmony, this.churchDoorGone), this.killSorebones);
        goBlowTheDoor.addStep(new Conditions(this.inHarmony, this.addedFuse, this.hasTinderbox), this.lightFuse);
        goBlowTheDoor.addStep(new Conditions(this.inHarmony, this.hasFuse, this.hasTinderbox, this.placedKeg), this.useFuseOnDoor);
        goBlowTheDoor.addStep(new Conditions(this.inHarmony, this.hasFuse, this.hasTinderbox, this.hasKeg), this.useKegOnDoor);
        goBlowTheDoor.addStep(new Conditions(this.onBoat, this.hasFuse, this.hasTinderbox), this.getKeg);
        goBlowTheDoor.addStep(new Conditions(this.onBoat, this.hasFuse), this.getTinderbox);
        goBlowTheDoor.addStep(new Conditions(this.inHarmony, this.hasFuse), this.climbShipLadder);
        goBlowTheDoor.addStep(this.onBoat, this.climbDownFromShip);
        goBlowTheDoor.addStep(this.inHarmonyBasement, this.leaveWindmillBasement);
        goBlowTheDoor.addStep(this.inHarmony, this.getFuse);
        steps.put(80, goBlowTheDoor);
        steps.put(90, goBlowTheDoor);
        ConditionalStep goTalkToTranqAfterHelping = new ConditionalStep((QuestHelper)this, this.talkToTranquilityAfterHelping, new Requirement[0]);
        goTalkToTranqAfterHelping.addStep(this.inHarmonyBasement, this.goUpFromFenkAfterItems);
        steps.put(100, goTalkToTranqAfterHelping);
        ConditionalStep goConfront = new ConditionalStep((QuestHelper)this, this.enterChurchForFight, new Requirement[0]);
        goConfront.addStep(new Conditions(this.inHarmony, new InInstanceRequirement(), this.barrelchestAppeared), this.defeatBarrelchest);
        goConfront.addStep(new Conditions(this.inHarmony, new InInstanceRequirement()), this.confrontMigor);
        steps.put(110, goConfront);
        ConditionalStep goFinish = new ConditionalStep((QuestHelper)this, this.talkToTranquilityToFinish, new Requirement[0]);
        goFinish.addStep(new ItemOnTileRequirement(this.anchor), this.pickupAnchor);
        steps.put(120, goFinish);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.fishbowlHelmet = new ItemRequirement("Fishbowl helmet", 7534).isNotConsumed();
        this.fishbowlHelmet.setTooltip("You can get another from Murphy in Port Khazard");
        this.divingApparatus = new ItemRequirement("Diving apparatus", 7535).isNotConsumed();
        this.divingApparatus.setTooltip("You can get another from Murphy in Port Khazard");
        this.woodenCats = new ItemRequirement("Wooden cat", 10891);
        this.oakPlank = new ItemRequirement("Oak plank", 8778);
        this.saw = new ItemRequirement("Saw", ItemCollections.SAW).isNotConsumed();
        this.plank = new ItemRequirement("Plank", 960);
        this.fur = new ItemRequirement("Fur", 6814);
        this.fur.addAlternates(948, 958);
        this.hammer = new ItemRequirement("Hammer", ItemCollections.HAMMER).isNotConsumed();
        this.hammer.setTooltip("a standard hammer, NOT Imcando Hammer, as it will be given to Dr. Fenkenstrain");
        this.nails = new ItemRequirement("Nails", ItemCollections.NAILS);
        this.holySymbol = new ItemRequirement("Holy symbol", 1718).isNotConsumed();
        this.ringOfCharos = new ItemRequirement("Ring of Charos", 4202).isNotConsumed();
        this.ringOfCharos.addAlternates(6465);
        this.ringOfCharos.setDisplayMatchedItemName(true);
        this.catsOrResources = new ItemRequirements(LogicType.OR, "10 Wooden cats, or 10 planks and 10 furs to make them", this.woodenCats.quantity(10), new ItemRequirements(this.plank.quantity(10), this.fur.quantity(10)));
        this.tinderbox = new ItemRequirement("Tinderbox", 590).isNotConsumed();
        this.tinderbox.addAlternates(7156);
        this.noPet = new ItemRequirement("No pet following you or in your inventory", -1, -1);
        this.ectophial = new TeleportItemRequirement("Ectophial or Mos le'harmless teleport", 4251, 3);
        this.edgevilleTeleport = new ItemRequirement("Monastery teleport", ItemCollections.COMBAT_BRACELETS);
        this.edgevilleTeleport.addAlternates(ItemCollections.AMULET_OF_GLORIES);
        this.fenkenstrainTeleport = new ItemRequirement("Fenkenstrain's Castle teleport", 19621);
        this.watermelonSeeds = new ItemRequirement("Watermelon seeds to plant on Harmony for Hard Morytania Diary", 5321);
        this.combatGearForSafespotting = new ItemRequirement("Combat gear for safespotting", -1, -1);
        this.combatGearForSafespotting.setDisplayItemId(BankSlotIcons.getMagicCombatGear());
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD);
        this.prayerPotions = new ItemRequirement("Prayer potion", ItemCollections.PRAYER_POTIONS);
        this.prayerBook = new ItemRequirement("Prayer book", 10886);
        this.prayerBook.addAlternates(10890);
        this.wolfWhistle = new ItemRequirement("Wolf whistle", 10896);
        this.wolfWhistle.setTooltip("You can get another from Rufus in Canifis");
        this.shippingOrder = new ItemRequirement("Shipping order", 10897);
        this.shippingOrder.setTooltip("You can get another from Rufus in Canifis");
        this.cratePart = new ItemRequirement("Crate part", 10899);
        this.cratePart.setTooltip("You can get more from Rufus in Canifis");
        this.keg = new ItemRequirement("Keg", 10898);
        this.keg.addAlternates(10885);
        this.fuse = new ItemRequirement("Fuse", 10884);
        this.cranialClamp = new ItemRequirement("Cranial clamp", 10893);
        this.brainTongs = new ItemRequirement("Brain tongs", 10894);
        this.bellJars = new ItemRequirement("Bell jar", 10895);
        this.skullStaples = new ItemRequirement("Skull staple", 10904);
        this.anchor = new ItemRequirement("Barrelchest anchor", 10888);
        IntUnaryOperator varbit = id -> this.client.getGameState() == GameState.LOGGED_IN ? this.client.getVarbitValue(id) : 0;
        this.neededJars = this.bellJars.quantity(3 - varbit.applyAsInt(3399));
        this.neededStaples = this.skullStaples.quantity(30 - varbit.applyAsInt(3400));
    }

    public void setupZones() {
        this.harmony = new Zone(new WorldPoint(3771, 2813, 0), new WorldPoint(3840, 2881, 3));
        this.waterEntrance = new Zone(new WorldPoint(3782, 9250, 0), new WorldPoint(3795, 9259, 0));
        this.water = new Zone(new WorldPoint(3777, 9242, 1), new WorldPoint(3835, 9267, 1));
        this.waterExit = new Zone(new WorldPoint(3822, 9251, 0), new WorldPoint(3833, 9258, 0));
        this.peepRoom = new Zone(new WorldPoint(3817, 2842, 0), new WorldPoint(3821, 2846, 0));
        this.fenkF1 = new Zone(new WorldPoint(3526, 3574, 1), new WorldPoint(3566, 3531, 1));
        this.fenkF2 = new Zone(new WorldPoint(3544, 3558, 2), new WorldPoint(3553, 3551, 2));
        this.harmonyBasement = new Zone(new WorldPoint(3778, 9219, 0), new WorldPoint(3792, 9232, 0));
        this.boat = new Zone(new WorldPoint(3790, 2870, 1), new WorldPoint(3810, 2876, 2));
        this.boatToMos = new Zone(new WorldPoint(3709, 3508, 1), new WorldPoint(3721, 3489, 1));
        this.mos = new Zone(new WorldPoint(3642, 3077, 0), new WorldPoint(3855, 2924, 1));
    }

    public void setupConditions() {
        this.inHarmony = new ZoneRequirement(this.harmony);
        this.inWater = new ZoneRequirement(this.water);
        this.inWaterEntrance = new ZoneRequirement(this.waterEntrance);
        this.inWaterExit = new ZoneRequirement(this.waterExit);
        this.inPeepRoom = new ZoneRequirement(this.peepRoom);
        this.inFenkF2 = new ZoneRequirement(this.fenkF2);
        this.inFenkF1 = new ZoneRequirement(this.fenkF1);
        this.inHarmonyBasement = new ZoneRequirement(this.harmonyBasement);
        this.onBoat = new ZoneRequirement(this.boat);
        this.inBoatToMos = new ZoneRequirement(this.boatToMos);
        this.inMos = new ZoneRequirement(this.mos);
        this.repairedStairs = new VarbitRequirement(3385, 1);
        this.hasReadPrayerBook = new VarbitRequirement(3386, 1);
        this.talkedToFenk = new VarbitRequirement(3388, 2, Operation.GREATER_EQUAL);
        this.talkedToRufus = new VarbitRequirement(3388, 3, Operation.GREATER_EQUAL);
        this.madeCrateWalls = new VarbitRequirement(3390, 2, Operation.GREATER_EQUAL);
        this.madeCrateBottom = new VarbitRequirement(3390, 3, Operation.GREATER_EQUAL);
        this.addedCats = new VarbitRequirement(3390, 4, Operation.GREATER_EQUAL);
        this.fenkInCrate = new VarbitRequirement(3390, 5, Operation.GREATER_EQUAL);
        this.addedCatsOrHas10 = new Conditions(LogicType.OR, this.addedCats, this.woodenCats.quantity(10).alsoCheckBank(this.questBank));
        this.placedKeg = new VarbitRequirement(3393, 2, Operation.GREATER_EQUAL);
        this.addedFuse = new VarbitRequirement(3393, 3, Operation.GREATER_EQUAL);
        this.litFuse = new VarbitRequirement(3393, 4, Operation.GREATER_EQUAL);
        this.churchDoorGone = new VarbitRequirement(3393, 5, Operation.GREATER_EQUAL);
        this.hasKeg = new Conditions(LogicType.OR, this.keg, this.placedKeg);
        this.hasFuse = new Conditions(LogicType.OR, this.fuse, this.addedFuse);
        this.hasTinderbox = new Conditions(LogicType.OR, this.tinderbox, this.litFuse);
        this.givenClamp = new VarbitRequirement(3396, 1);
        this.givenTongs = new VarbitRequirement(3397, 1);
        this.givenHammer = new VarbitRequirement(3398, 1);
        this.givenBells = new VarbitRequirement(3399, 3);
        this.givenStaples = new VarbitRequirement(3400, 30);
        this.hadClamp = new Conditions(LogicType.OR, this.givenClamp, this.cranialClamp);
        this.hadStaples = new Conditions(LogicType.OR, this.givenStaples, this.neededStaples);
        this.hadBells = new Conditions(LogicType.OR, this.givenBells, this.neededJars);
        this.hadTongs = new Conditions(LogicType.OR, this.givenTongs, this.brainTongs);
        this.barrelchestAppeared = new VarbitRequirement(3410, 1);
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        int staplesNeeded = 30;
        int bellsNeeded = 3;
        this.neededStaples.quantity(staplesNeeded - this.client.getVarbitValue(3400));
        this.neededJars.quantity(bellsNeeded - this.client.getVarbitValue(3399));
    }

    public void setupSteps() {
        this.moveToCapt = new ObjectStep((QuestHelper)this, 11209, new WorldPoint(3710, 3496, 0), "Cross the gangplank to Bill Teach's ship.", new Requirement[0]);
        ((ObjectStep)this.moveToCapt).addTeleport(this.ectophial.quantity(1));
        this.moveToMos = new NpcStep((QuestHelper)this, 4016, new WorldPoint(3714, 3497, 1), "Talk to Bill Teach to travel to Mos Le'Harmless.", new Requirement[0]);
        this.talkToTranquility = new NpcStep((QuestHelper)this, 550, new WorldPoint(3681, 2963, 0), "Talk to Brother Tranquility on Mos Le'Harmless.", new Requirement[0]);
        this.talkToTranquility.addDialogSteps("Yes.", "Yes, please.");
        this.talkToTranquility.addSubSteps(this.moveToCapt);
        this.talkToTranquility.addSubSteps(this.moveToMos);
        this.talkToTranquilityOnIsland = new NpcStep((QuestHelper)this, 550, new WorldPoint(3787, 2825, 0), "Talk to Brother Tranquility on Harmony.", new Requirement[0]);
        this.talkToTranquility.addSubSteps(this.talkToTranquilityOnIsland);
        ItemRequirement conditionalPlanks = this.plank.quantity(4).hideConditioned(this.repairedStairs);
        ItemRequirement conditionalNails = this.nails.quantity(60).hideConditioned(this.repairedStairs);
        ItemRequirement conditionalHammer = this.hammer.hideConditioned(this.repairedStairs);
        this.pullStatue = new ObjectStep((QuestHelper)this, 22355, new WorldPoint(3795, 2844, 0), "Pull the saradomin statue on Harmony, then enter it.\nPlant the watermelon seeds in the patch first if you brought them for the Hard Morytania Diary.", this.fishbowlHelmet.highlighted().equipped(), this.divingApparatus.highlighted().equipped(), conditionalHammer, conditionalPlanks, conditionalNails);
        this.enterWater = new ObjectStep((QuestHelper)this, 22365, new WorldPoint(3788, 9254, 0), "Enter the water.", new Requirement[0]);
        this.repairWaterStairs = new ObjectStep((QuestHelper)this, 22370, new WorldPoint(3829, 9254, 1), "Repair the stairs to the east.", this.hammer, this.plank.quantity(4), this.nails.quantity(100));
        this.climbFromWater = new ObjectStep((QuestHelper)this, 22370, new WorldPoint(3829, 9254, 1), "Climb up the stairs to the east.", new Requirement[0]);
        this.climbFromWaterCaveToPeep = new ObjectStep((QuestHelper)this, 22372, new WorldPoint(3831, 9254, 0), "Climb up the ladder.", new Requirement[0]);
        this.peerThroughHole = new ObjectStep((QuestHelper)this, 22097, new WorldPoint(3817, 2844, 0), "Peer through the nearby peephole.", new Requirement[0]);
        this.goFromHoleToWater = new ObjectStep((QuestHelper)this, 22164, new WorldPoint(3819, 2843, 0), "Return to Brother Tranquility on Harmony.", new Requirement[0]);
        this.enterWaterReturn = new ObjectStep((QuestHelper)this, 22366, new WorldPoint(3827, 9254, 0), "Return to Brother Tranquility on Harmony.", new Requirement[0]);
        this.leaveWaterEntranceReturn = new ObjectStep((QuestHelper)this, 22367, new WorldPoint(3785, 9254, 1), "Return to Brother Tranquility on Harmony.", new Requirement[0]);
        this.leaveWaterBack = new ObjectStep((QuestHelper)this, 22371, new WorldPoint(3784, 9254, 0), "Return to Brother Tranquility on Harmony.", new Requirement[0]);
        this.talkToTranquilityMosAfterPeeping = new NpcStep((QuestHelper)this, 550, new WorldPoint(3681, 2963, 0), "Return to Brother Tranquility on Harmony.", new Requirement[0]);
        this.talkToTranquilityMosAfterPeeping.addDialogStep("Yes, please.");
        this.talkToTranquilityAfterPeeping = new NpcStep((QuestHelper)this, 550, new WorldPoint(3787, 2825, 0), "Return to Brother Tranquility.", new Requirement[0]);
        this.talkToTranquilityAfterPeeping.addSubSteps(this.goFromHoleToWater, this.enterWaterReturn, this.leaveWaterEntranceReturn, this.leaveWaterBack, this.talkToTranquilityMosAfterPeeping);
        this.searchBookcase = new ObjectStep((QuestHelper)this, 380, new WorldPoint(3049, 3484, 0), "Search the south west bookcase in the Edgeville Monastery.", this.holySymbol);
        this.searchBookcase.addDialogStep("Monastery");
        ((ObjectStep)this.searchBookcase).addTeleport(this.edgevilleTeleport);
        this.readBook = new DetailedQuestStep((QuestHelper)this, "Read the prayer book.", this.prayerBook.highlighted());
        ObjectStep moveToCapt2 = ((ObjectStep)this.moveToCapt).copy();
        NpcStep moveToMos2 = ((NpcStep)this.moveToMos).copy();
        NpcStep speakToTranquilityToTeleportBack = new NpcStep((QuestHelper)this, 550, new WorldPoint(3681, 2963, 0), "Speak to Brother Tranquility to transport to Harmony.", new Requirement[0]);
        this.returnToTranquility = new ConditionalStep((QuestHelper)this, (QuestStep)moveToCapt2, "Return to Harmony", new Requirement[0]);
        this.returnToTranquility.addStep(this.inMos, speakToTranquilityToTeleportBack);
        this.returnToTranquility.addStep(this.inBoatToMos, moveToMos2);
        this.returnToTranquility.addRequirement(this.prayerBook);
        this.returnToTranquility.addRequirement(this.holySymbol.equipped().highlighted());
        this.recitePrayer = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3787, 2825, 0), "Right-click recite the prayer book on Harmony.", this.prayerBook.highlighted(), this.holySymbol.equipped().highlighted());
        this.returnToHarmonyAfterPrayer = new NpcStep((QuestHelper)this, 550, new WorldPoint(3681, 2963, 0), "Return to Brother Tranquility on Harmony.", new Requirement[0]);
        this.returnToHarmonyAfterPrayer.addDialogStep("Yes, please.");
        this.talkToTranquilityAfterPrayer = new NpcStep((QuestHelper)this, 550, new WorldPoint(3787, 2825, 0), "Talk to Brother Tranquility again.", new Requirement[0]);
        this.talkToTranquilityAfterPrayer.addSubSteps(this.returnToHarmonyAfterPrayer);
        this.goToF1Fenk = new ObjectStep((QuestHelper)this, 5206, new WorldPoint(3538, 3552, 0), "Go up to the second floor of Fenkenstrain's Castle and talk to Dr. Fenkenstrain.", new Requirement[0]);
        ((ObjectStep)this.goToF1Fenk).addTeleport(this.fenkenstrainTeleport);
        this.goToF1Fenk.addDialogStep("Yes, please.");
        this.goToF2Fenk = new ObjectStep((QuestHelper)this, 16683, new WorldPoint(3548, 3554, 1), "Go up to the second floor of Fenkenstrain's Castle and talk to Dr. Fenkenstrain.", new Requirement[0]);
        this.talkToFenk = new NpcStep((QuestHelper)this, 1269, new WorldPoint(3548, 3554, 2), "Go up to the second floor of Fenkenstrain's Castle and talk to Dr. Fenkenstrain.", new Requirement[0]);
        this.talkToFenk.addSubSteps(this.goToF1Fenk, this.goToF2Fenk);
        this.talkToRufus = new NpcStep((QuestHelper)this, 6478, new WorldPoint(3507, 3494, 0), "Talk to Rufus in Canifis' food store.", this.ringOfCharos.equipped().highlighted());
        this.talkToRufus.addDialogStep("Talk about the meat shipment");
        this.makeOrGetWoodenCats = new DetailedQuestStep((QuestHelper)this, "Either buy 10 wooden cats from the G.E., or make them on a clockmaker's bench in your POH.", this.catsOrResources);
        this.makeOrGetWoodenCats.addDialogStep("Wooden cat");
        this.goToF1FenkForCrate = new ObjectStep((QuestHelper)this, 5206, new WorldPoint(3538, 3552, 0), "Return to Dr. Fenkenstrain.", this.ringOfCharos.equipped(), this.plank.quantity(4).hideConditioned(this.madeCrateBottom), this.nails.quantity(100).hideConditioned(this.madeCrateBottom), this.hammer.hideConditioned(this.madeCrateBottom), this.woodenCats.quantity(10).hideConditioned(this.addedCats), this.cratePart.quantity(6).hideConditioned(this.madeCrateWalls), this.wolfWhistle);
        this.goToF2FenkForCrate = new ObjectStep((QuestHelper)this, 16683, new WorldPoint(3548, 3554, 1), "Return to Dr. Fenkenstrain.", this.ringOfCharos.equipped(), this.plank.quantity(4).hideConditioned(this.madeCrateBottom), this.nails.quantity(100).hideConditioned(this.madeCrateBottom), this.hammer.hideConditioned(this.madeCrateBottom), this.woodenCats.quantity(10).hideConditioned(this.addedCats), this.cratePart.quantity(6).hideConditioned(this.madeCrateWalls), this.wolfWhistle);
        this.buildCrate = new ObjectStep((QuestHelper)this, 22489, new WorldPoint(3550, 3554, 2), "Return to Dr. Fenkenstrain and build the crate next to him.", this.ringOfCharos.equipped(), this.plank.quantity(4), this.nails.quantity(100), this.hammer, this.woodenCats.quantity(10), this.cratePart.quantity(6), this.wolfWhistle);
        this.buildCrate.addSubSteps(this.goToF1FenkForCrate, this.goToF2FenkForCrate);
        this.addBottomToCrate = new ObjectStep((QuestHelper)this, 22489, new WorldPoint(3550, 3554, 2), "Add a bottom to the crate.", this.plank.quantity(4), this.nails.quantity(100), this.hammer);
        this.fillCrate = new ObjectStep((QuestHelper)this, 22489, new WorldPoint(3550, 3554, 2), "Fill the crate next to Fenkenstrain with wooden cats.", this.woodenCats.quantity(10).highlighted());
        this.fillCrate.addIcon(10891);
        this.blowWhistle = new DetailedQuestStep((QuestHelper)this, "Blow the wolf whistle.", this.wolfWhistle.highlighted(), this.ringOfCharos.equipped());
        this.goF1WithOrder = new ObjectStep((QuestHelper)this, 5206, new WorldPoint(3538, 3552, 0), "Return to Dr. Fenkenstrain and place the shipping order on the crate.", this.shippingOrder);
        this.goF2WithOrder = new ObjectStep((QuestHelper)this, 16683, new WorldPoint(3548, 3554, 1), "Return to Dr. Fenkenstrain and place the shipping order on the crate.", this.shippingOrder);
        this.putOrderOnCrate = new ObjectStep((QuestHelper)this, 22489, new WorldPoint(3550, 3554, 2), "Return to Dr. Fenkenstrain and place the shipping order on the crate..", this.shippingOrder.highlighted());
        this.putOrderOnCrate.addIcon(10897);
        this.putOrderOnCrate.addSubSteps(this.goF1WithOrder, this.goF2WithOrder);
        ObjectStep moveToCapt3 = moveToCapt2.copy();
        NpcStep moveToMos3 = moveToMos2.copy();
        NpcStep tranqTpToHarmony3 = speakToTranquilityToTeleportBack.copy();
        NpcStep savingTheMonksTalkToFenk = new NpcStep((QuestHelper)this, 550, new WorldPoint(3681, 2963, 0), "Talk to Fenkenstrain in the windmill's basement.", new Requirement[0]);
        this.goToHarmonyAfterFenk = new ConditionalStep((QuestHelper)this, (QuestStep)moveToCapt3, "Talk to Dr. Fenkenstrain in the Harmony Windmill basement.", new Requirement[0]);
        ((ConditionalStep)this.goToHarmonyAfterFenk).addStep(this.inMos, tranqTpToHarmony3);
        ((ConditionalStep)this.goToHarmonyAfterFenk).addStep(this.inBoatToMos, moveToMos3);
        ((ConditionalStep)this.goToHarmonyAfterFenk).addStep(this.inHarmony, savingTheMonksTalkToFenk);
        this.goDownToFenk = new ObjectStep((QuestHelper)this, 22173, new WorldPoint(3789, 2826, 0), "Talk to Dr. Fenkenstrain in the Harmony Windmill basement.", new Requirement[0]);
        this.talkToFenkOnHarmony = new NpcStep((QuestHelper)this, 1269, new WorldPoint(3785, 9225, 0), "Talk to Dr. Fenkenstrain in the Harmony Windmill basement.", new Requirement[0]);
        this.talkToFenkOnHarmony.addSubSteps(this.goToHarmonyAfterFenk, this.goDownToFenk);
        this.leaveWindmillBasement = new ObjectStep((QuestHelper)this, 22172, new WorldPoint(3789, 9226, 0), "Leave the basement.", new Requirement[0]);
        this.goToHarmonyForBrainItems = new NpcStep((QuestHelper)this, 550, new WorldPoint(3681, 2963, 0), "Return to Harmony.", new Requirement[0]);
        this.getFuse = new ObjectStep((QuestHelper)this, 22298, new WorldPoint(3791, 2873, 0), "Search the locker on the ship on the north of Harmony.", this.fishbowlHelmet.highlighted().equipped(), this.divingApparatus.highlighted().equipped());
        ((ObjectStep)this.getFuse).addAlternateObjects(22299);
        this.getFuse.addSubSteps(this.goToHarmonyForBrainItems, this.leaveWindmillBasement);
        this.climbShipLadder = new ObjectStep((QuestHelper)this, 22274, new WorldPoint(3802, 2873, 0), "Climb the ship's ladder.", new Requirement[0]);
        this.getTinderbox = new ItemStep((QuestHelper)this, "Take a tinderbox.", this.tinderbox);
        this.getKeg = new ItemStep((QuestHelper)this, "Take a keg.", this.keg);
        this.climbDownFromShip = new ObjectStep((QuestHelper)this, 22275, new WorldPoint(3802, 2873, 1), "Climb down the ship's ladder.", new Requirement[0]);
        this.useKegOnDoor = new ObjectStep((QuestHelper)this, 22119, new WorldPoint(3805, 2844, 0), "Use the keg on the church's door.", this.keg.highlighted());
        this.useKegOnDoor.addIcon(10898);
        this.useFuseOnDoor = new ObjectStep((QuestHelper)this, 22119, new WorldPoint(3805, 2844, 0), "Use the fuse on the keg.", this.fuse.highlighted());
        this.useFuseOnDoor.addIcon(10884);
        this.lightFuse = new ObjectStep((QuestHelper)this, 22492, new WorldPoint(3803, 2844, 0), "Light the fuse.", this.tinderbox.highlighted());
        this.lightFuse.addIcon(590);
        this.killSorebones = new NpcStep((QuestHelper)this, 561, new WorldPoint(3815, 2843, 0), "Kill sorebones in the church for items.", true, this.cranialClamp.hideConditioned(this.givenClamp), this.brainTongs.hideConditioned(this.givenTongs), this.neededJars.hideConditioned(this.givenBells), this.neededStaples.hideConditioned(this.givenStaples));
        ((NpcStep)this.killSorebones).addAlternateNpcs(562);
        this.goBackDownToFenk = new ObjectStep((QuestHelper)this, 22173, new WorldPoint(3789, 2826, 0), "Return to Dr. Fenkenstrain in the Harmony Windmill basement.", this.hammer.hideConditioned(this.givenHammer), this.cranialClamp.hideConditioned(this.givenClamp), this.brainTongs.hideConditioned(this.givenTongs), this.neededJars.hideConditioned(this.givenBells), this.neededStaples.hideConditioned(this.givenStaples));
        this.talkToFenkWithItems = new NpcStep((QuestHelper)this, 1269, new WorldPoint(3785, 9225, 0), "Return to Dr. Fenkenstrain in the Harmony Windmill basement.", this.hammer.hideConditioned(this.givenHammer), this.cranialClamp.hideConditioned(this.givenClamp), this.brainTongs.hideConditioned(this.givenTongs), this.neededJars.hideConditioned(this.givenBells), this.neededStaples.hideConditioned(this.givenStaples));
        this.talkToFenkWithItems.addSubSteps(this.goBackDownToFenk);
        this.goUpFromFenkAfterItems = new ObjectStep((QuestHelper)this, 22172, new WorldPoint(3789, 9226, 0), "Talk to Brother Tranquility on Harmony.", new Requirement[0]);
        this.talkToTranquilityAfterHelping = new NpcStep((QuestHelper)this, 551, new WorldPoint(3787, 2825, 0), "Talk to Brother Tranquility on Harmony.", new Requirement[0]);
        this.talkToTranquilityAfterHelping.addSubSteps(this.goUpFromFenkAfterItems);
        this.enterChurchForFight = new ObjectStep((QuestHelper)this, 22119, new WorldPoint(3805, 2844, 0), "Enter the church, ready to fight Barrelchest. If after initially entering you leave then re-enter, the Barrelchest will get stuck and you can safespot it from the door.", this.fishbowlHelmet.equipped(), this.divingApparatus.equipped(), this.combatGearForSafespotting);
        this.confrontMigor = new NpcStep((QuestHelper)this, 547, new WorldPoint(3815, 2844, 0), "Confront Migor.", new Requirement[0]);
        this.defeatBarrelchest = new NpcStep((QuestHelper)this, 600, new WorldPoint(3815, 2844, 0), "Defeat the barrelchest. You can safespot it from the door if you leave and re-enter the instance.", new Requirement[0]);
        ((NpcStep)this.defeatBarrelchest).addSafeSpots(new WorldPoint(3806, 2844, 0));
        this.pickupAnchor = new ItemStep((QuestHelper)this, "Pickup the anchor.", this.anchor);
        this.talkToTranquilityToFinish = new NpcStep((QuestHelper)this, 551, new WorldPoint(3787, 2825, 0), "Talk to Brother Tranquility on Harmony to complete the quest.", new Requirement[0]);
        this.talkToTranquilityToFinish.addSubSteps(this.pickupAnchor);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.fishbowlHelmet, this.divingApparatus, this.catsOrResources, this.plank.quantity(8), this.hammer, this.nails.quantity(100), this.holySymbol, this.ringOfCharos, this.noPet);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.ectophial, this.edgevilleTeleport, this.fenkenstrainTeleport, this.watermelonSeeds.quantity(3), this.combatGearForSafespotting, this.food, this.prayerPotions);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        reqs.add(new QuestRequirement(QuestHelperQuest.CREATURE_OF_FENKENSTRAIN, QuestState.FINISHED));
        reqs.add(new VarbitRequirement(QuestVarbits.QUEST_RECIPE_FOR_DISASTER_PIRATE_PETE.getId(), Operation.GREATER_EQUAL, 110, "Finished RFD - Pirate Pete"));
        reqs.add(new QuestRequirement(QuestHelperQuest.RUM_DEAL, QuestState.FINISHED));
        reqs.add(new QuestRequirement(QuestHelperQuest.CABIN_FEVER, QuestState.FINISHED));
        reqs.add(new SkillRequirement(Skill.CRAFTING, 16));
        reqs.add(new SkillRequirement(Skill.CONSTRUCTION, 30));
        reqs.add(new SkillRequirement(Skill.PRAYER, 50));
        return reqs;
    }

    @Override
    public List<String> getCombatRequirements() {
        return Arrays.asList("Barrelchest (level 190, safespottable)", "4 Sorebones (level 57)");
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(2);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.PRAYER, 6000), new ExperienceReward(Skill.CRAFTING, 2000), new ExperienceReward(Skill.CONSTRUCTION, 2000));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Barrelchest Anchor", 10887, 1), new ItemReward("5,000 Exp Reward Lamp (Any skill above 30)", 4447, 1), new ItemReward("Prayer Book", 10886, 1));
    }

    public ArrayList<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Arrays.asList(this.talkToTranquility, this.pullStatue, this.enterWater, this.repairWaterStairs, this.climbFromWater, this.climbFromWaterCaveToPeep, this.peerThroughHole, this.talkToTranquilityAfterPeeping), Arrays.asList(this.plank.quantity(4), this.nails.quantity(60), this.hammer, this.fishbowlHelmet, this.divingApparatus, this.holySymbol, this.noPet)));
        allSteps.add(new PanelDetails("Protecting the windmill", Arrays.asList(this.searchBookcase, this.readBook, this.returnToTranquility, this.recitePrayer, this.talkToTranquilityAfterPrayer), this.holySymbol));
        allSteps.add(new PanelDetails("Finding a Doctor", Arrays.asList(this.talkToFenk, this.talkToRufus, this.makeOrGetWoodenCats, this.buildCrate, this.addBottomToCrate, this.fillCrate, this.blowWhistle, this.putOrderOnCrate), this.ringOfCharos, this.catsOrResources, this.plank.quantity(4), this.nails.quantity(100), this.hammer));
        allSteps.add(new PanelDetails("Saving the Monks", Arrays.asList(this.talkToFenkOnHarmony, this.getFuse, this.climbShipLadder, this.getTinderbox, this.getKeg, this.climbDownFromShip, this.useKegOnDoor, this.useFuseOnDoor, this.lightFuse, this.killSorebones, this.talkToFenkWithItems, this.talkToTranquilityAfterHelping), this.hammer, this.fishbowlHelmet, this.divingApparatus, this.combatGearForSafespotting));
        allSteps.add(new PanelDetails("Defeating a Barrelchest", Arrays.asList(this.enterChurchForFight, this.confrontMigor, this.defeatBarrelchest, this.talkToTranquilityToFinish), this.fishbowlHelmet, this.divingApparatus, this.combatGearForSafespotting));
        return allSteps;
    }
}

