/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.thegrandtree;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.conditional.NpcCondition;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.npc.NpcInteractingRequirement;
import com.questhelper.requirements.player.FreeInventorySlotRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.THE_GRAND_TREE)
public class TheGrandTree
extends BasicQuestHelper {
    ItemRequirement accessToFairyRings;
    ItemRequirement energyOrStaminaPotions;
    ItemRequirement transportToGrandTree;
    ItemRequirement oneThousandCoins;
    ItemRequirement combatGear;
    ItemRequirement food;
    ItemRequirement prayerPotions;
    ItemRequirement translationBook;
    ItemRequirement barkSample;
    ItemRequirement lumberOrder;
    ItemRequirement gloughsKey;
    ItemRequirement highlightedGloughsKey;
    ItemRequirement invasionPlans;
    ItemRequirement twigsT;
    ItemRequirement twigsU;
    ItemRequirement twigsZ;
    ItemRequirement twigsO;
    ItemRequirement highlightedTwigsT;
    ItemRequirement highlightedTwigsU;
    ItemRequirement highlightedTwigsZ;
    ItemRequirement highlightedTwigsO;
    ItemRequirement daconiaStone;
    FreeInventorySlotRequirement fourFreeInventorySlots;
    Zone grandTreeF1;
    Zone grandTreeF2;
    Zone topOfGrandTree;
    Zone hazelmereHouseFirstFloor;
    Zone gloughHouse;
    Zone shipyard;
    Zone anitaHouse;
    Zone watchtower;
    Zone grandTreeTunnels;
    Zone cell;
    Requirement isInGrandTreeF1;
    Requirement isInGrandTreeF2;
    Requirement isInGrandTreeTop;
    Requirement isInGrandTree;
    Requirement isNearHazelmere;
    Requirement isInCell;
    Requirement isInGloughsHouse;
    Requirement isInShipyard;
    Requirement isInAnitasHouse;
    Requirement isInWatchtower;
    Requirement blackDemonVisible;
    Requirement isInGrandTreeTunnels;
    Requirement narnodeNearby;
    QuestStep talkToKingNarnode;
    QuestStep talkToKingNarnodeCaves;
    QuestStep climbUpToHazelmere;
    QuestStep talkToHazelmere;
    QuestStep bringScrollToKingNarnode;
    QuestStep climbUpToGlough;
    QuestStep talkToGlough;
    QuestStep talkToKingNarnodeAfterGlough;
    QuestStep talkToCharlie;
    QuestStep returnToGlough;
    QuestStep findGloughJournal;
    QuestStep talkToGloughAgain;
    QuestStep goToStronghold;
    QuestStep talkToCharlieFromCell;
    QuestStep talkToKingNarnodeBeforeEscape;
    QuestStep escapeByGlider;
    QuestStep enterTheShipyard;
    QuestStep talkToForeman;
    QuestStep climbUpToAnita;
    QuestStep talkToAnita;
    QuestStep climbUpToGloughAgain;
    QuestStep findInvasionPlans;
    QuestStep takeInvasionPlansToKing;
    QuestStep climbUpToGloughForWatchtower;
    QuestStep climbUpToWatchtower;
    QuestStep placeTwigsT;
    QuestStep placeTwigsU;
    QuestStep placeTwigsZ;
    QuestStep placeTwigsO;
    QuestStep placeTwigs;
    QuestStep climbDownTrapDoor;
    QuestStep talkToGloughBeforeFight;
    QuestStep killBlackDemon;
    QuestStep climbDownTrapDoorAfterFight;
    QuestStep talkToKingAfterFight;
    QuestStep findDaconiaStone;
    QuestStep giveDaconiaStoneToKingNarnode;
    QuestStep climbGrandTreeF0ToF1;
    QuestStep climbGrandTreeF1ToF2;
    QuestStep climbGrandTreeF2ToF3;
    QuestStep climbGrandTreeF3ToF2;
    QuestStep climbGrandTreeF2ToF1;
    QuestStep climbGrandTreeF1ToF0;
    ConditionalStep climbToTopOfGrandTree;
    ConditionalStep climbToBottomOfGrandTree;
    ConditionalStep goTalkToCharlie;
    ConditionalStep goFindGloughJournal;
    ConditionalStep goConfrontGlough;
    ConditionalStep goTalkToCharlie3;
    ConditionalStep goGetAnitaKey;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupRequirements();
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        ConditionalStep startQuest = new ConditionalStep((QuestHelper)this, this.talkToKingNarnode, new Requirement[0]);
        startQuest.addStep(this.isInGrandTreeTunnels, this.talkToKingNarnodeCaves);
        steps.put(0, startQuest);
        ConditionalStep goTalkToHazelmere = new ConditionalStep((QuestHelper)this, this.climbUpToHazelmere, new Requirement[0]);
        goTalkToHazelmere.addStep(this.isNearHazelmere, this.talkToHazelmere);
        steps.put(10, goTalkToHazelmere);
        steps.put(20, this.bringScrollToKingNarnode);
        ConditionalStep goTalkToGlough = new ConditionalStep((QuestHelper)this, this.climbUpToGlough, new Requirement[0]);
        goTalkToGlough.addStep(this.isInGloughsHouse, this.talkToGlough);
        steps.put(30, goTalkToGlough);
        steps.put(40, this.talkToKingNarnodeAfterGlough);
        this.goTalkToCharlie = new ConditionalStep((QuestHelper)this, (QuestStep)this.climbToTopOfGrandTree, "Talk to Charlie on the top floor of the Grand Tree.", new Requirement[0]);
        this.goTalkToCharlie.addStep(this.isInGrandTreeTop, this.talkToCharlie);
        steps.put(50, this.goTalkToCharlie);
        this.goFindGloughJournal = new ConditionalStep((QuestHelper)this, this.returnToGlough, "Return to Glough's house and search the cupboard for Glough's Journal.", new Requirement[0]);
        this.goFindGloughJournal.addStep(this.isInGrandTree, this.climbToBottomOfGrandTree);
        this.goFindGloughJournal.addStep(this.isInGloughsHouse, this.findGloughJournal);
        steps.put(60, this.goFindGloughJournal);
        this.goConfrontGlough = new ConditionalStep((QuestHelper)this, this.returnToGlough, "Confront Glough about his journal.", new Requirement[0]);
        this.goConfrontGlough.addStep(this.isInGrandTree, this.climbToBottomOfGrandTree);
        this.goConfrontGlough.addStep(this.isInGloughsHouse, this.talkToGloughAgain);
        ConditionalStep goLearnOfDock = new ConditionalStep((QuestHelper)this, (QuestStep)this.goConfrontGlough, new Requirement[0]);
        goLearnOfDock.addStep(this.isInCell, this.talkToCharlieFromCell);
        goLearnOfDock.addStep(new Conditions(this.isInGrandTreeTop, this.narnodeNearby), this.talkToKingNarnodeBeforeEscape);
        steps.put(70, goLearnOfDock);
        ConditionalStep goTalkToForeman = new ConditionalStep((QuestHelper)this, this.enterTheShipyard, new Requirement[0]);
        goTalkToForeman.addStep(this.isInGrandTreeTop, this.escapeByGlider);
        goTalkToForeman.addStep(this.isInShipyard, this.talkToForeman);
        steps.put(80, goTalkToForeman);
        this.goTalkToCharlie3 = this.goTalkToCharlie.copy();
        if (QuestHelperQuest.TREE_GNOME_VILLAGE.getState(this.client, this.configManager) == QuestState.FINISHED) {
            this.goTalkToCharlie3.setText("Return to Charlie. You won't be able to enter through the main entrance, so speak to Femi outside the main gate to be snuck in, or make use of a Spirit Tree to enter the Tree Gnome Stronghold.The easiest Spirit Tree to use is the one in the Grand Exchange.");
        } else {
            this.goTalkToCharlie3.setText("Return to Charlie. If entering the Stronghold through the south entrance you'll need to talk to Femi there. If you didn't help them previously you'll need to pay them 1k.");
        }
        this.goTalkToCharlie3.addRequirement(this.lumberOrder);
        this.goTalkToCharlie3.addRequirement(this.oneThousandCoins);
        steps.put(90, this.goTalkToCharlie3);
        this.goGetAnitaKey = new ConditionalStep((QuestHelper)this, this.climbUpToAnita, "Talk to Anita in her house west of the Grand Tree.", new Requirement[0]);
        this.goGetAnitaKey.addStep(this.isInAnitasHouse, this.talkToAnita);
        this.goGetAnitaKey.addStep(this.isInGrandTree, this.climbToBottomOfGrandTree);
        ConditionalStep goFindInvasionPlans = new ConditionalStep((QuestHelper)this, (QuestStep)this.goGetAnitaKey, new Requirement[0]);
        goFindInvasionPlans.addStep(new Conditions(this.gloughsKey, this.isInGloughsHouse), this.findInvasionPlans);
        goFindInvasionPlans.addStep(this.gloughsKey, this.climbUpToGloughAgain);
        steps.put(100, goFindInvasionPlans);
        steps.put(110, this.takeInvasionPlansToKing);
        ConditionalStep goUpToWatchtower = new ConditionalStep((QuestHelper)this, this.climbUpToGloughForWatchtower, new Requirement[0]);
        goUpToWatchtower.addStep(this.isInGloughsHouse, this.climbUpToWatchtower);
        ConditionalStep goPlaceTuzoTwigs = new ConditionalStep((QuestHelper)this, (QuestStep)goUpToWatchtower, new Requirement[0]);
        goPlaceTuzoTwigs.addStep(new Conditions(this.isInWatchtower, this.twigsT), this.placeTwigsT);
        goPlaceTuzoTwigs.addStep(new Conditions(this.isInWatchtower, this.twigsU), this.placeTwigsU);
        goPlaceTuzoTwigs.addStep(new Conditions(this.isInWatchtower, this.twigsZ), this.placeTwigsZ);
        goPlaceTuzoTwigs.addStep(new Conditions(this.isInWatchtower, this.twigsO), this.placeTwigsO);
        goPlaceTuzoTwigs.addStep(this.isInWatchtower, this.placeTwigs);
        steps.put(120, goPlaceTuzoTwigs);
        ConditionalStep fightBlackDemonStep = new ConditionalStep((QuestHelper)this, (QuestStep)goUpToWatchtower, new Requirement[0]);
        fightBlackDemonStep.addStep(this.blackDemonVisible, this.killBlackDemon);
        fightBlackDemonStep.addStep(this.isInWatchtower, this.climbDownTrapDoor);
        steps.put(130, fightBlackDemonStep);
        ConditionalStep returnToGrandTreeTunnels = new ConditionalStep((QuestHelper)this, (QuestStep)goUpToWatchtower, new Requirement[0]);
        returnToGrandTreeTunnels.addStep(this.isInWatchtower, this.climbDownTrapDoorAfterFight);
        ConditionalStep goTalkToKingAfterFight = new ConditionalStep((QuestHelper)this, (QuestStep)returnToGrandTreeTunnels, new Requirement[0]);
        goTalkToKingAfterFight.addStep(this.isInGrandTreeTunnels, this.talkToKingAfterFight);
        steps.put(140, goTalkToKingAfterFight);
        ConditionalStep bringDaconiaStoneToKing = new ConditionalStep((QuestHelper)this, (QuestStep)returnToGrandTreeTunnels, new Requirement[0]);
        bringDaconiaStoneToKing.addStep(this.daconiaStone, this.giveDaconiaStoneToKingNarnode);
        bringDaconiaStoneToKing.addStep(this.isInGrandTreeTunnels, this.findDaconiaStone);
        steps.put(150, bringDaconiaStoneToKing);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.oneThousandCoins = new ItemRequirement("Coins to enter the Stronghold if you didn't help Femi previously", ItemCollections.COINS, 1000).hideConditioned(new QuestRequirement(QuestHelperQuest.TREE_GNOME_VILLAGE, QuestState.FINISHED));
        this.accessToFairyRings = new ItemRequirement("Access to Fairy Rings", ItemCollections.FAIRY_STAFF).isNotConsumed();
        this.energyOrStaminaPotions = new ItemRequirement("Energy restoration", ItemCollections.RUN_RESTORE_ITEMS, -1);
        this.combatGear = new ItemRequirement("Combat gear. Safespotting is possible.", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        this.prayerPotions = new ItemRequirement("Prayer potions", ItemCollections.PRAYER_POTIONS, -1);
        this.transportToGrandTree = new ItemRequirement("Transport to the Grand Tree", ItemCollections.NECKLACE_OF_PASSAGES);
        this.translationBook = new ItemRequirement("Translation Book", 784);
        this.translationBook.setTooltip("You can get another from Narnode");
        this.barkSample = new ItemRequirement("Bark Sample", 783);
        this.barkSample.setTooltip("You can get another from Narnode");
        this.lumberOrder = new ItemRequirement("Lumber order", 787);
        this.gloughsKey = new ItemRequirement("Glough's key", 788);
        this.highlightedGloughsKey = new ItemRequirement("Glough's key", 788);
        this.highlightedGloughsKey.setHighlightInInventory(true);
        this.invasionPlans = new ItemRequirement("Invasion plans", 794);
        this.invasionPlans.setTooltip("You can get another from Glough's house in a chest");
        this.fourFreeInventorySlots = new FreeInventorySlotRequirement(4);
        this.daconiaStone = new ItemRequirement("Daconia stone", 793);
        this.twigsT = new ItemRequirement("Twigs (T)", 789);
        this.twigsU = new ItemRequirement("Twigs (U)", 790);
        this.twigsZ = new ItemRequirement("Twigs (Z)", 791);
        this.twigsO = new ItemRequirement("Twigs (O)", 792);
        this.highlightedTwigsT = new ItemRequirement("Twigs (T)", 789);
        this.highlightedTwigsT.setHighlightInInventory(true);
        this.highlightedTwigsU = new ItemRequirement("Twigs (U)", 790);
        this.highlightedTwigsU.setHighlightInInventory(true);
        this.highlightedTwigsZ = new ItemRequirement("Twigs (Z)", 791);
        this.highlightedTwigsZ.setHighlightInInventory(true);
        this.highlightedTwigsO = new ItemRequirement("Twigs (O)", 792);
        this.highlightedTwigsO.setHighlightInInventory(true);
    }

    public void setupZones() {
        this.grandTreeF1 = new Zone(new WorldPoint(2437, 3474, 1), new WorldPoint(2493, 3511, 1));
        this.grandTreeF2 = new Zone(new WorldPoint(2437, 3474, 2), new WorldPoint(2493, 3511, 2));
        this.topOfGrandTree = new Zone(new WorldPoint(2438, 3511, 3), new WorldPoint(2493, 3478, 3));
        this.cell = new Zone(new WorldPoint(2464, 3496, 3));
        this.hazelmereHouseFirstFloor = new Zone(new WorldPoint(2674, 3089, 1), new WorldPoint(2680, 3085, 1));
        this.gloughHouse = new Zone(new WorldPoint(2474, 3466, 1), new WorldPoint(2488, 3461, 1));
        this.shipyard = new Zone(new WorldPoint(2945, 3070, 0), new WorldPoint(3007, 3015, 0));
        this.anitaHouse = new Zone(new WorldPoint(2386, 3517, 1), new WorldPoint(2392, 3512, 1));
        this.watchtower = new Zone(new WorldPoint(2482, 3469, 2), new WorldPoint(2491, 3459, 2));
        this.grandTreeTunnels = new Zone(new WorldPoint(2431, 9920, 0), new WorldPoint(2500, 9856, 0));
    }

    public void setupConditions() {
        this.isInGrandTreeF1 = new ZoneRequirement(this.grandTreeF1);
        this.isInGrandTreeF2 = new ZoneRequirement(this.grandTreeF2);
        this.isInGrandTreeTop = new ZoneRequirement(this.topOfGrandTree);
        this.isInCell = new ZoneRequirement(this.cell);
        this.isInGrandTree = new ZoneRequirement(this.grandTreeF1, this.grandTreeF2, this.topOfGrandTree);
        this.isNearHazelmere = new ZoneRequirement(this.hazelmereHouseFirstFloor);
        this.isInGloughsHouse = new ZoneRequirement(this.gloughHouse);
        this.isInShipyard = new ZoneRequirement(this.shipyard);
        this.isInAnitasHouse = new ZoneRequirement(this.anitaHouse);
        this.isInWatchtower = new ZoneRequirement(this.watchtower);
        this.isInGrandTreeTunnels = new ZoneRequirement(this.grandTreeTunnels);
        this.narnodeNearby = new NpcCondition(8019);
        this.blackDemonVisible = new NpcInteractingRequirement(1432);
    }

    public void setupSteps() {
        WorldPoint locationBottomOfGrandTree = new WorldPoint(2466, 3495, 0);
        WorldPoint locationTopOfGrandTree = new WorldPoint(2466, 3495, 3);
        this.goToStronghold = new DetailedQuestStep((QuestHelper)this, locationBottomOfGrandTree, "Travel to the Tree Gnome Stronghold.", new Requirement[0]);
        this.talkToKingNarnode = new NpcStep((QuestHelper)this, 8019, locationBottomOfGrandTree, "Talk to King Narnode Shareen in the Grand Tree(Make sure to have two empty inventory slots to start the quest).", new Requirement[0]);
        this.talkToKingNarnode.addDialogSteps("You seem worried, what's up?", "I'd be happy to help!");
        this.talkToKingNarnodeCaves = new NpcStep((QuestHelper)this, 8019, new WorldPoint(2465, 9895, 0), "Talk to King Narnode.", new Requirement[0]);
        this.talkToKingNarnodeCaves.addDialogStep("I'd be happy to help!");
        this.talkToKingNarnode.addSubSteps(this.talkToKingNarnodeCaves);
        this.climbUpToHazelmere = new ObjectStep((QuestHelper)this, 16683, new WorldPoint(2677, 3087, 0), "Go up to Hazelmere, on the island east of Yanille. Fairy ring CLS or minigame teleport near Yanille.", this.translationBook, this.barkSample);
        this.talkToHazelmere = new NpcStep((QuestHelper)this, 1422, "Talk to Hazelmere.", this.translationBook, this.barkSample);
        this.bringScrollToKingNarnode = new NpcStep((QuestHelper)this, 8019, locationBottomOfGrandTree, "Return to King Narnode in the Grand Tree.", new Requirement[0]);
        this.bringScrollToKingNarnode.addDialogStep("I think so!");
        this.bringScrollToKingNarnode.addDialogStepWithExclusions("None of the above.", "A man came to me with the King's seal.", "I gave the man Daconia rocks.");
        this.bringScrollToKingNarnode.addDialogStep("A man came to me with the King's seal.");
        this.bringScrollToKingNarnode.addDialogStep("I gave the man Daconia rocks.");
        this.bringScrollToKingNarnode.addDialogStep("And Daconia rocks will kill the tree!");
        this.climbUpToGlough = new ObjectStep((QuestHelper)this, 16683, new WorldPoint(2476, 3463, 0), "Go up to Glough in the Tree Gnome Stronghold.", new Requirement[0]);
        this.talkToGlough = new NpcStep((QuestHelper)this, 2061, "Talk to Glough.", new Requirement[0]);
        this.talkToGlough.addSubSteps(this.climbUpToGlough);
        this.talkToKingNarnodeAfterGlough = new NpcStep((QuestHelper)this, 8019, locationBottomOfGrandTree, "Talk to King Narnode again in the Grand Tree.", new Requirement[0]);
        this.talkToCharlie = new NpcStep((QuestHelper)this, 1428, new WorldPoint(2464, 3495, 3), "", new Requirement[0]);
        this.returnToGlough = new ObjectStep((QuestHelper)this, 16683, new WorldPoint(2476, 3463, 0), "", new Requirement[0]);
        this.findGloughJournal = new ObjectStep((QuestHelper)this, 2434, "", new Requirement[0]);
        ((ObjectStep)this.findGloughJournal).addAlternateObjects(2435);
        this.talkToGloughAgain = new NpcStep((QuestHelper)this, 2061, "", new Requirement[0]);
        this.climbGrandTreeF0ToF1 = new ObjectStep((QuestHelper)this, 16683, new WorldPoint(2466, 3495, 0), "", new Requirement[0]);
        this.climbGrandTreeF1ToF2 = new ObjectStep((QuestHelper)this, 16684, new WorldPoint(2466, 3495, 1), "", new Requirement[0]);
        this.climbGrandTreeF1ToF2.addDialogStep("Climb Up.");
        this.climbGrandTreeF2ToF3 = new ObjectStep((QuestHelper)this, 2884, new WorldPoint(2466, 3495, 2), "", new Requirement[0]);
        this.climbGrandTreeF2ToF3.addDialogStep("Climb Up.");
        this.climbToTopOfGrandTree = new ConditionalStep((QuestHelper)this, this.climbGrandTreeF0ToF1, new Requirement[0]);
        this.climbToTopOfGrandTree.addStep(this.isInGrandTreeF2, this.climbGrandTreeF2ToF3);
        this.climbToTopOfGrandTree.addStep(this.isInGrandTreeF1, this.climbGrandTreeF1ToF2);
        this.climbGrandTreeF3ToF2 = new ObjectStep((QuestHelper)this, 16679, new WorldPoint(2466, 3495, 3), "", new Requirement[0]);
        this.climbGrandTreeF2ToF1 = new ObjectStep((QuestHelper)this, 2884, new WorldPoint(2466, 3495, 2), "", new Requirement[0]);
        this.climbGrandTreeF2ToF1.addDialogStep("Climb Down.");
        this.climbGrandTreeF1ToF0 = new ObjectStep((QuestHelper)this, 16684, new WorldPoint(2466, 3495, 1), "", new Requirement[0]);
        this.climbGrandTreeF1ToF0.addDialogStep("Climb Down.");
        this.climbToBottomOfGrandTree = new ConditionalStep((QuestHelper)this, this.goToStronghold, new Requirement[0]);
        this.climbToBottomOfGrandTree.addStep(this.isInGrandTreeTop, this.climbGrandTreeF3ToF2);
        this.climbToBottomOfGrandTree.addStep(this.isInGrandTreeF2, this.climbGrandTreeF2ToF1);
        this.climbToBottomOfGrandTree.addStep(this.isInGrandTreeF1, this.climbGrandTreeF1ToF0);
        this.talkToCharlieFromCell = new NpcStep((QuestHelper)this, 1428, new WorldPoint(2464, 3495, 3), "Talk to Charlie.", new Requirement[0]);
        this.talkToKingNarnodeBeforeEscape = new NpcStep((QuestHelper)this, 8019, "Talk to King Narnode outside Charlie's cell.", new Requirement[0]);
        this.escapeByGlider = new NpcStep((QuestHelper)this, 10467, locationTopOfGrandTree, "Travel with the glider to escape.", new Requirement[0]);
        this.escapeByGlider.addDialogStep("Take me to Karamja please!");
        this.enterTheShipyard = new ObjectStep((QuestHelper)this, 2438, new WorldPoint(2945, 3041, 0), "Enter the shipyard on Karamja.", new Requirement[0]);
        this.enterTheShipyard.addDialogSteps("Glough sent me.", "Ka.", "Lu.", "Min.");
        this.talkToForeman = new NpcStep((QuestHelper)this, 1429, new WorldPoint(3000, 3044, 0), "Get the Lumber order from the Foreman on the southern docks. You can either kill him or talk to him.", new Requirement[0]);
        this.talkToForeman.addDialogSteps("Sadly his wife is no longer with us!", "He loves worm holes.", "Anita.");
        this.climbUpToAnita = new ObjectStep((QuestHelper)this, 16675, new WorldPoint(2390, 3513, 0), "", new Requirement[0]);
        this.talkToAnita = new NpcStep((QuestHelper)this, 7156, "", new Requirement[0]);
        this.talkToAnita.addDialogStep("I suppose so.");
        this.climbUpToGloughAgain = new ObjectStep((QuestHelper)this, 16683, new WorldPoint(2476, 3463, 0), "Go up to Glough's house again.", new Requirement[0]);
        this.findInvasionPlans = new ObjectStep((QuestHelper)this, 2436, "Search the chest in Glough's house.", this.highlightedGloughsKey);
        this.findInvasionPlans.addSubSteps(this.climbUpToGloughAgain);
        this.findInvasionPlans.addIcon(788);
        this.takeInvasionPlansToKing = new NpcStep((QuestHelper)this, 8019, new WorldPoint(2465, 3496, 0), "Take the invasion plans to King Narnode in the Grand Tree.", this.invasionPlans, this.fourFreeInventorySlots);
        this.climbUpToGloughForWatchtower = new ObjectStep((QuestHelper)this, 16683, new WorldPoint(2476, 3463, 0), "Go up to Glough's house again.", new Requirement[0]);
        this.climbUpToWatchtower = new ObjectStep((QuestHelper)this, 2447, "Climb up the tree to the watchtower in Glough's house.", new Requirement[0]);
        this.placeTwigsT = new ObjectStep((QuestHelper)this, 2440, "Place the twigs (T). Return to King Narnode if you lost them.", this.highlightedTwigsT);
        this.placeTwigsT.addIcon(789);
        this.placeTwigsU = new ObjectStep((QuestHelper)this, 2441, "Place the twigs (U). Return to King Narnode if you lost them.", this.highlightedTwigsU);
        this.placeTwigsU.addIcon(790);
        this.placeTwigsZ = new ObjectStep((QuestHelper)this, 2442, "Place the twigs (Z). Return to King Narnode if you lost them.", this.highlightedTwigsZ);
        this.placeTwigsZ.addIcon(791);
        this.placeTwigsO = new ObjectStep((QuestHelper)this, 2443, "Place the twigs (O). Return to King Narnode if you lost them.", this.highlightedTwigsO);
        this.placeTwigsO.addIcon(792);
        this.placeTwigs = new DetailedQuestStep((QuestHelper)this, "Place the twigs to spell 'TUZO' in the watchtower in Glough's house. Return to King Narnode if you lost any.", this.twigsT, this.twigsU, this.twigsZ, this.twigsO);
        this.placeTwigs.addSubSteps(this.climbUpToGloughForWatchtower, this.climbUpToWatchtower, this.placeTwigsT, this.placeTwigsU, this.placeTwigsZ, this.placeTwigsO);
        this.climbDownTrapDoor = new ObjectStep((QuestHelper)this, 26243, "Go down the trap door. Be prepared for the fight against a Black Demon (level 172).", new Requirement[0]);
        this.talkToGloughBeforeFight = new NpcStep((QuestHelper)this, 1425, "Talk to Glough. You can safespot the Demon from where he stands.", new Requirement[0]);
        this.killBlackDemon = new NpcStep((QuestHelper)this, 1432, "Kill the black Demon. You can safespot from where Glough stands.", new Requirement[0]);
        ((NpcStep)this.killBlackDemon).addSafeSpots(new WorldPoint(2492, 9865, 0));
        this.climbDownTrapDoorAfterFight = new ObjectStep((QuestHelper)this, 26243, "Go down the trap door again.", new Requirement[0]);
        this.talkToKingAfterFight = new NpcStep((QuestHelper)this, 8019, new WorldPoint(2465, 9895, 0), "Talk to King Narnode deeper in the cave.", new Requirement[0]);
        this.talkToKingAfterFight.addSubSteps(this.climbDownTrapDoorAfterFight);
        this.giveDaconiaStoneToKingNarnode = new NpcStep((QuestHelper)this, 8019, new WorldPoint(2465, 9895, 0), "Give the Daconia stone to King Narnode under the Grand Tree.", this.daconiaStone);
        this.findDaconiaStone = new ObjectStep((QuestHelper)this, 1985, "Search the roots under the Grand Tree until you find the Daconia stone. If you lose the rock, it will be in the same root again.", new Requirement[0]);
        ((ObjectStep)this.findDaconiaStone).addAlternateObjects(1986);
        ((ObjectStep)this.findDaconiaStone).setHideWorldArrow(true);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Collections.singletonList(this.oneThousandCoins);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.combatGear, this.food, this.prayerPotions, this.energyOrStaminaPotions, this.accessToFairyRings, this.transportToGrandTree);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        return Collections.singletonList(new SkillRequirement(Skill.AGILITY, 25, true));
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("Black demon (level 172) (can be safespotted)");
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(5);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.ATTACK, 18400), new ExperienceReward(Skill.AGILITY, 7900), new ExperienceReward(Skill.MAGIC, 2150));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("Ability to use the Spirit Tree in the Tree Gnome Stronghold."));
    }

    public ArrayList<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Getting started", Collections.singletonList(this.talkToKingNarnode), new Requirement[0]));
        allSteps.add(new PanelDetails("Hazelmere", Arrays.asList(this.climbUpToHazelmere, this.talkToHazelmere), this.barkSample, this.translationBook));
        allSteps.add(new PanelDetails("Investigation", Arrays.asList(this.bringScrollToKingNarnode, this.climbUpToGlough, this.talkToGlough, this.talkToKingNarnodeAfterGlough, this.goTalkToCharlie, this.goFindGloughJournal, this.goConfrontGlough, this.talkToCharlieFromCell, this.talkToKingNarnodeBeforeEscape, this.escapeByGlider), new Requirement[0]));
        allSteps.add(new PanelDetails("Karamja", Arrays.asList(this.enterTheShipyard, this.talkToForeman), this.oneThousandCoins));
        allSteps.add(new PanelDetails("Tuzo", Arrays.asList(this.goTalkToCharlie3, this.goGetAnitaKey, this.findInvasionPlans, this.takeInvasionPlansToKing, this.placeTwigs), new Requirement[0]));
        allSteps.add(new PanelDetails("Defeat the Black Demon", Arrays.asList(this.climbDownTrapDoor, this.killBlackDemon, this.talkToKingAfterFight, this.findDaconiaStone, this.giveDaconiaStoneToKingNarnode), this.combatGear, this.food, this.prayerPotions));
        return allSteps;
    }
}

