/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.thegolem;

import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.THE_GOLEM)
public class TheGolem
extends BasicQuestHelper {
    ItemRequirement strangeImplement;
    ItemRequirement strangeImplementHighlight;
    ItemRequirement programHighlight;
    ItemRequirement pestleAndMortarHighlight;
    ItemRequirement mushroomHighlight;
    ItemRequirement vial;
    ItemRequirement inkHighlight;
    ItemRequirement pestleAndMortar;
    ItemRequirement papyrus;
    ItemRequirement letter;
    ItemRequirement clay4Highlight;
    ItemRequirement notesHighlight;
    ItemRequirement phoenixFeather;
    ItemRequirement quill;
    ItemRequirement clay3Highlight;
    ItemRequirement clay2Highlight;
    ItemRequirement clay1Highlight;
    ItemRequirement key;
    ItemRequirement statuette;
    ItemRequirement statuetteHighlight;
    ItemRequirement papyrusHighlight;
    ItemRequirement varrockTeleport;
    ItemRequirement digsiteTeleport;
    ItemRequirement waterskins;
    Requirement inRuin;
    Requirement turnedStatue1;
    Requirement turnedStatue2;
    Requirement turnedStatue3;
    Requirement turnedStatue4;
    Requirement hasReadLetter;
    Requirement added1Clay;
    Requirement added2Clay;
    Requirement added3Clay;
    Requirement talkedToElissa;
    Requirement hasReadNotes;
    Requirement talkedToCurator;
    Requirement inUpstairsMuseum;
    Requirement stolenStatuette;
    Requirement inThroneRoom;
    Requirement openedHead;
    Requirement enteredRuins;
    QuestStep pickUpLetter;
    QuestStep readLetter;
    QuestStep talkToGolem;
    QuestStep useClay;
    QuestStep useClay2;
    QuestStep useClay3;
    QuestStep useClay4;
    QuestStep talkToElissa;
    QuestStep searchBookcase;
    QuestStep readBook;
    QuestStep talkToCurator;
    QuestStep pickpocketCurator;
    QuestStep goUpInMuseum;
    QuestStep openCabinet;
    QuestStep stealFeather;
    QuestStep enterRuin;
    QuestStep useStatuette;
    QuestStep turnStatue1;
    QuestStep turnStatue2;
    QuestStep turnStatue3;
    QuestStep turnStatue4;
    QuestStep enterThroneRoom;
    QuestStep leaveThroneRoom;
    QuestStep leaveRuin;
    QuestStep pickBlackMushroom;
    QuestStep grindMushroom;
    QuestStep useFeatherOnInk;
    QuestStep talkToGolemAfterPortal;
    QuestStep useQuillOnPapyrus;
    QuestStep useImplementOnGolem;
    QuestStep useProgramOnGolem;
    QuestStep pickUpImplement;
    QuestStep enterRuinWithoutStatuette;
    QuestStep enterRuinForFirstTime;
    Zone ruin;
    Zone upstairsMuseum;
    Zone throneRoom;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        this.setupZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        steps.put(0, this.talkToGolem);
        ConditionalStep repairGolem = new ConditionalStep((QuestHelper)this, this.useClay, new Requirement[0]);
        repairGolem.addStep(this.added3Clay, this.useClay4);
        repairGolem.addStep(this.added2Clay, this.useClay3);
        repairGolem.addStep(this.added1Clay, this.useClay2);
        steps.put(1, repairGolem);
        ConditionalStep goTalkToElissa = new ConditionalStep((QuestHelper)this, this.pickUpLetter, new Requirement[0]);
        goTalkToElissa.addStep(this.talkedToCurator, this.pickpocketCurator);
        goTalkToElissa.addStep(new Conditions(this.hasReadNotes, this.enteredRuins), this.talkToCurator);
        goTalkToElissa.addStep(new Conditions(this.notesHighlight, this.enteredRuins), this.readBook);
        goTalkToElissa.addStep(new Conditions(this.talkedToElissa, this.enteredRuins), this.searchBookcase);
        goTalkToElissa.addStep(new Conditions(this.inRuin, this.strangeImplement), this.talkToElissa);
        goTalkToElissa.addStep(new Conditions(this.inRuin), this.pickUpImplement);
        goTalkToElissa.addStep(new Conditions(this.hasReadLetter, this.enteredRuins), this.talkToElissa);
        goTalkToElissa.addStep(this.hasReadLetter, this.enterRuinForFirstTime);
        goTalkToElissa.addStep(this.letter, this.readLetter);
        steps.put(2, goTalkToElissa);
        ConditionalStep getStatuette = new ConditionalStep((QuestHelper)this, this.pickpocketCurator, new Requirement[0]);
        getStatuette.addStep(new Conditions(this.stolenStatuette, this.inRuin), this.useStatuette);
        getStatuette.addStep(this.stolenStatuette, this.enterRuin);
        getStatuette.addStep(new Conditions(this.key, this.inUpstairsMuseum), this.openCabinet);
        getStatuette.addStep(this.key, this.goUpInMuseum);
        steps.put(3, getStatuette);
        ConditionalStep openPortal = new ConditionalStep((QuestHelper)this, this.enterRuin, new Requirement[0]);
        openPortal.addStep(new Conditions(this.turnedStatue4, this.turnedStatue3, this.turnedStatue2, this.inRuin), this.turnStatue1);
        openPortal.addStep(new Conditions(this.turnedStatue4, this.turnedStatue3, this.inRuin), this.turnStatue2);
        openPortal.addStep(new Conditions(this.turnedStatue4, this.inRuin), this.turnStatue3);
        openPortal.addStep(new Conditions(this.inRuin), this.turnStatue4);
        steps.put(4, openPortal);
        ConditionalStep goEnterPortal = new ConditionalStep((QuestHelper)this, this.enterRuin, new Requirement[0]);
        goEnterPortal.addStep(new Conditions(this.inRuin, this.strangeImplement), this.enterThroneRoom);
        goEnterPortal.addStep(new Conditions(this.inRuin), this.pickUpImplement);
        steps.put(5, goEnterPortal);
        ConditionalStep returnToTheGolem = new ConditionalStep((QuestHelper)this, this.talkToGolemAfterPortal, new Requirement[0]);
        returnToTheGolem.addStep(new Conditions(this.inRuin, this.strangeImplement), this.leaveRuin);
        returnToTheGolem.addStep(new Conditions(this.inRuin), this.pickUpImplement);
        returnToTheGolem.addStep(this.inThroneRoom, this.leaveThroneRoom);
        steps.put(6, returnToTheGolem);
        ConditionalStep reprogramTheGolem = new ConditionalStep((QuestHelper)this, this.enterRuinWithoutStatuette, new Requirement[0]);
        reprogramTheGolem.addStep(new Conditions(this.openedHead, this.programHighlight), this.useProgramOnGolem);
        reprogramTheGolem.addStep(new Conditions(this.strangeImplement, this.programHighlight), this.useImplementOnGolem);
        reprogramTheGolem.addStep(new Conditions(this.strangeImplement, this.quill), this.useQuillOnPapyrus);
        reprogramTheGolem.addStep(new Conditions(this.strangeImplement, this.phoenixFeather, this.inkHighlight), this.useFeatherOnInk);
        reprogramTheGolem.addStep(new Conditions(this.strangeImplement, this.inkHighlight), this.stealFeather);
        reprogramTheGolem.addStep(new Conditions(this.strangeImplement, this.mushroomHighlight), this.grindMushroom);
        reprogramTheGolem.addStep(new Conditions(this.inRuin, this.strangeImplement), this.leaveRuin);
        reprogramTheGolem.addStep(new Conditions(this.inRuin), this.pickUpImplement);
        reprogramTheGolem.addStep(new Conditions(this.strangeImplement), this.pickBlackMushroom);
        reprogramTheGolem.addStep(this.inThroneRoom, this.leaveThroneRoom);
        steps.put(7, reprogramTheGolem);
        return steps;
    }

    private void setupZones() {
        this.ruin = new Zone(new WorldPoint(2706, 4881, 0), new WorldPoint(2738, 4918, 0));
        this.upstairsMuseum = new Zone(new WorldPoint(3249, 3440, 1), new WorldPoint(3269, 3457, 1));
        this.throneRoom = new Zone(new WorldPoint(2709, 4879, 2), new WorldPoint(2731, 4919, 2));
    }

    @Override
    public void setupRequirements() {
        this.letter = new ItemRequirement("Letter", 4615);
        this.letter.setHighlightInInventory(true);
        this.strangeImplement = new ItemRequirement("Strange implement", 4619);
        this.strangeImplementHighlight = new ItemRequirement("Strange implement", 4619);
        this.strangeImplementHighlight.setHighlightInInventory(true);
        this.programHighlight = new ItemRequirement("Golem program", 4624);
        this.programHighlight.setHighlightInInventory(true);
        this.pestleAndMortar = new ItemRequirement("Pestle and mortar", 233).isNotConsumed();
        this.pestleAndMortarHighlight = this.pestleAndMortar.highlighted();
        this.mushroomHighlight = new ItemRequirement("Black mushroom", 4620);
        this.mushroomHighlight.setHighlightInInventory(true);
        this.vial = new ItemRequirement("Vial", 229);
        this.inkHighlight = new ItemRequirement("Black mushroom ink", 4622);
        this.inkHighlight.setHighlightInInventory(true);
        this.papyrus = new ItemRequirement("Papyrus", 970);
        this.papyrusHighlight = new ItemRequirement("Papyrus", 970);
        this.papyrusHighlight.setHighlightInInventory(true);
        this.clay4Highlight = new ItemRequirement("Soft clay", 1761, 4);
        this.clay4Highlight.setHighlightInInventory(true);
        this.clay3Highlight = new ItemRequirement("Soft clay", 1761, 3);
        this.clay3Highlight.setHighlightInInventory(true);
        this.clay2Highlight = new ItemRequirement("Soft clay", 1761, 2);
        this.clay2Highlight.setHighlightInInventory(true);
        this.clay1Highlight = new ItemRequirement("Soft clay", 1761, 1);
        this.clay1Highlight.setHighlightInInventory(true);
        this.notesHighlight = new ItemRequirement("Varmen's notes", 4616);
        this.notesHighlight.setHighlightInInventory(true);
        this.phoenixFeather = new ItemRequirement("Phoenix feather", 4621);
        this.phoenixFeather.setHighlightInInventory(true);
        this.quill = new ItemRequirement("Phoenix quill pen", 4623);
        this.quill.setHighlightInInventory(true);
        this.key = new ItemRequirement("Display cabinet key", 4617);
        this.statuette = new ItemRequirement("Statuette", 4618);
        this.statuette.setTooltip("If you've lost it, talk to the Curator in the Varrock museum again");
        this.statuetteHighlight = new ItemRequirement("Statuette", 4618);
        this.statuetteHighlight.setHighlightInInventory(true);
        this.statuetteHighlight.setTooltip("If you've lost it, talk to the Curator in the Varrock museum again");
        this.varrockTeleport = new ItemRequirement("Varrock teleport", 8007);
        this.digsiteTeleport = new ItemRequirement("Digsite teleport", ItemCollections.DIGSITE_PENDANTS);
        this.digsiteTeleport.addAlternates(12403);
        this.waterskins = new ItemRequirement("Waterskins", 1823, -1);
    }

    private void setupConditions() {
        this.inRuin = new ZoneRequirement(this.ruin);
        this.inUpstairsMuseum = new ZoneRequirement(this.upstairsMuseum);
        this.inThroneRoom = new ZoneRequirement(this.throneRoom);
        this.hasReadLetter = new VarbitRequirement(347, 1, Operation.GREATER_EQUAL);
        this.talkedToElissa = new VarbitRequirement(347, 2, Operation.GREATER_EQUAL);
        this.hasReadNotes = new VarbitRequirement(347, 3, Operation.GREATER_EQUAL);
        this.talkedToCurator = new VarbitRequirement(347, 4, Operation.GREATER_EQUAL);
        this.added1Clay = new VarbitRequirement(348, 1);
        this.added2Clay = new VarbitRequirement(348, 2);
        this.added3Clay = new VarbitRequirement(348, 3);
        this.turnedStatue1 = new VarbitRequirement(349, 1);
        this.turnedStatue2 = new VarbitRequirement(350, 1);
        this.turnedStatue3 = new VarbitRequirement(351, 0);
        this.turnedStatue4 = new VarbitRequirement(352, 2);
        this.openedHead = new VarbitRequirement(353, 1);
        this.stolenStatuette = new Conditions(LogicType.OR, new VarbitRequirement(355, 1), this.statuette);
        this.enteredRuins = new VarbitRequirement(356, 1);
    }

    private void setupSteps() {
        this.pickUpLetter = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3479, 3092, 0), "Pick up the letter on the floor in Uzer and read it.", this.letter);
        this.readLetter = new DetailedQuestStep((QuestHelper)this, "Read the letter.", this.letter);
        this.pickUpLetter.addSubSteps(this.readLetter);
        this.talkToGolem = new NpcStep((QuestHelper)this, 5134, new WorldPoint(3485, 3088, 0), "Talk to the Golem in Uzer.", new Requirement[0]);
        this.talkToGolem.addDialogStep("Shall I try to repair you?");
        this.useClay = new NpcStep((QuestHelper)this, 5134, new WorldPoint(3485, 3088, 0), "Use 4 soft clay on the Golem in Uzer.", this.clay4Highlight);
        this.useClay.addIcon(1761);
        this.useClay2 = new NpcStep((QuestHelper)this, 5134, new WorldPoint(3485, 3088, 0), "Use 3 soft clay on the Golem in Uzer.", this.clay3Highlight);
        this.useClay2.addIcon(1761);
        this.useClay3 = new NpcStep((QuestHelper)this, 5135, new WorldPoint(3485, 3088, 0), "Use 2 soft clay on the Golem in Uzer.", this.clay2Highlight);
        this.useClay3.addIcon(1761);
        this.useClay4 = new NpcStep((QuestHelper)this, 5135, new WorldPoint(3485, 3088, 0), "Use 1 soft clay on the Golem in Uzer.", this.clay1Highlight);
        this.useClay4.addIcon(1761);
        this.enterRuinForFirstTime = new ObjectStep((QuestHelper)this, 6373, new WorldPoint(3493, 3090, 0), "Enter the Uzer ruins.", new Requirement[0]);
        this.talkToElissa = new NpcStep((QuestHelper)this, 5138, new WorldPoint(3378, 3428, 0), "Talk to Elissa in the north east of the Digsite.", new Requirement[0]);
        this.talkToElissa.addDialogStep("I found a letter in the desert with your name on.");
        this.searchBookcase = new ObjectStep((QuestHelper)this, 6292, new WorldPoint(3367, 3332, 0), "Search the bookcase in the south east corner of the Digsite Exam Centre.", new Requirement[0]);
        this.readBook = new DetailedQuestStep((QuestHelper)this, "Read the notes.", this.notesHighlight);
        this.talkToCurator = new NpcStep((QuestHelper)this, 5214, new WorldPoint(3256, 3449, 0), "Talk to Curator Haig in the Varrock Museum.", new Requirement[0]);
        this.talkToCurator.addDialogStep("I'm looking for a statuette recovered from the city of Uzer.");
        this.pickpocketCurator = new NpcStep((QuestHelper)this, 5214, new WorldPoint(3256, 3449, 0), "Pickpocket Curator Haig.", new Requirement[0]);
        this.goUpInMuseum = new ObjectStep((QuestHelper)this, 11798, new WorldPoint(3267, 3453, 0), "Go to the first floor of the Varrock Museum and right-click open the golem statue's display case.", this.key);
        this.openCabinet = new ObjectStep((QuestHelper)this, 24626, new WorldPoint(3257, 3453, 1), "Right-click open the golem statue's display case.", this.key);
        this.stealFeather = new NpcStep((QuestHelper)this, 5137, new WorldPoint(3414, 3154, 0), "Steal a feather from the desert phoenix north of Uzer.", new Requirement[0]);
        this.enterRuin = new ObjectStep((QuestHelper)this, 6373, new WorldPoint(3493, 3090, 0), "Enter the Uzer ruins.", this.statuette, this.pestleAndMortar, this.vial, this.papyrus);
        this.enterRuinWithoutStatuette = new ObjectStep((QuestHelper)this, 6373, new WorldPoint(3493, 3090, 0), "Enter the Uzer ruins.", new Requirement[0]);
        this.enterRuin.addSubSteps(this.enterRuinWithoutStatuette);
        this.useImplementOnGolem = new NpcStep((QuestHelper)this, 5136, new WorldPoint(3485, 3088, 0), "Use the strange implement on the Golem in Uzer.", this.strangeImplementHighlight);
        this.useImplementOnGolem.addIcon(4619);
        this.useProgramOnGolem = new NpcStep((QuestHelper)this, 5136, new WorldPoint(3485, 3088, 0), "Use the strange implement on the Golem in Uzer.", this.programHighlight);
        this.useProgramOnGolem.addIcon(4624);
        this.useStatuette = new ObjectStep((QuestHelper)this, 6306, new WorldPoint(2725, 4896, 0), "Use the statue on the empty alcove.", this.statuetteHighlight);
        this.useStatuette.addIcon(4618);
        this.turnStatue1 = new ObjectStep((QuestHelper)this, 6303, new WorldPoint(2718, 4899, 0), "Turn each of the statuettes to face the door.", new Requirement[0]);
        this.turnStatue2 = new ObjectStep((QuestHelper)this, 6304, new WorldPoint(2718, 4896, 0), "Turn each of the statuettes to face the door.", new Requirement[0]);
        this.turnStatue3 = new ObjectStep((QuestHelper)this, 6305, new WorldPoint(2725, 4899, 0), "Turn each of the statuettes to face the door.", new Requirement[0]);
        this.turnStatue4 = new ObjectStep((QuestHelper)this, 6306, new WorldPoint(2725, 4896, 0), "Turn each of the statuettes to face the door.", new Requirement[0]);
        this.turnStatue1.addSubSteps(this.turnStatue2, this.turnStatue3, this.turnStatue4);
        this.enterThroneRoom = new ObjectStep((QuestHelper)this, 6310, new WorldPoint(2722, 4913, 0), "Enter the portal.", new Requirement[0]);
        this.leaveThroneRoom = new ObjectStep((QuestHelper)this, 6282, new WorldPoint(2720, 4883, 2), "Leave the throne room and return to the Golem.", new Requirement[0]);
        this.pickUpImplement = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2713, 4913, 0), "Pick up the strange implement in the north west corner of the ruin.", this.strangeImplement);
        this.leaveRuin = new ObjectStep((QuestHelper)this, 6372, new WorldPoint(2722, 4885, 0), "Leave the ruins.", new Requirement[0]);
        this.pickBlackMushroom = new ObjectStep((QuestHelper)this, 6311, new WorldPoint(3495, 3088, 0), "Pick up some black mushrooms.", new Requirement[0]);
        this.grindMushroom = new DetailedQuestStep((QuestHelper)this, "Grind the mushrooms into a vial.", this.pestleAndMortarHighlight, this.mushroomHighlight, this.vial);
        this.useFeatherOnInk = new DetailedQuestStep((QuestHelper)this, "Use the phoenix feather on the ink.", this.phoenixFeather, this.inkHighlight);
        this.useQuillOnPapyrus = new DetailedQuestStep((QuestHelper)this, "Use the phoenix quill on the papyrus.", this.quill, this.papyrusHighlight);
        this.talkToGolemAfterPortal = new NpcStep((QuestHelper)this, 5136, new WorldPoint(3485, 3088, 0), "Talk to the Golem in Uzer.", new Requirement[0]);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.clay4Highlight, this.vial, this.pestleAndMortar, this.papyrus);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.varrockTeleport, this.digsiteTeleport, this.waterskins);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        return Arrays.asList(new SkillRequirement(Skill.CRAFTING, 20), new SkillRequirement(Skill.THIEVING, 25, true));
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.THIEVING, 1000), new ExperienceReward(Skill.CRAFTING, 1000));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Rubies (by using a chisel and hammer on the throne)", 1603, 2), new ItemReward("Emeralds (by using a chisel and hammer on the throne)", 1605, 2), new ItemReward("Sapphires (by using a chisel and hammer on the throne)", 1607, 2));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("Ability to take the Carpet ride from Shantay Pass to Uzer."));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Arrays.asList(this.talkToGolem, this.useClay, this.pickUpLetter, this.enterRuinForFirstTime, this.pickUpImplement), this.clay4Highlight));
        allSteps.add(new PanelDetails("Finding the statuette", Arrays.asList(this.talkToElissa, this.searchBookcase, this.readBook, this.talkToCurator, this.pickpocketCurator, this.goUpInMuseum, this.openCabinet), new Requirement[0]));
        allSteps.add(new PanelDetails("Opening the portal", Arrays.asList(this.enterRuin, this.useStatuette, this.turnStatue1, this.enterThroneRoom, this.leaveThroneRoom, this.talkToGolemAfterPortal, this.pickBlackMushroom, this.grindMushroom, this.stealFeather, this.useFeatherOnInk, this.useQuillOnPapyrus, this.useProgramOnGolem), this.vial, this.pestleAndMortar, this.papyrus));
        return allSteps;
    }
}

