/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.thegardenofdeath;

import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.questinfo.QuestVarbits;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.widget.WidgetTextRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import com.questhelper.steps.WidgetStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.THE_GARDEN_OF_DEATH)
public class TheGardenOfDeath
extends BasicQuestHelper {
    ItemRequirement secateurs;
    ItemRequirement antipoison;
    ItemRequirement khardestMemoir;
    ItemRequirement fairyRingAccess;
    ItemRequirement xericsTalisman;
    ItemRequirement stoneTablet1;
    ItemRequirement stoneTablet2;
    ItemRequirement stoneTablet3;
    ItemRequirement stoneTablet4;
    ItemRequirement kasondesJournal;
    ItemRequirement wordTranslations;
    ItemRequirement dirtyNote1;
    ItemRequirement dirtyNote2;
    ItemRequirement dirtyNote3;
    ItemRequirement compass;
    ItemRequirement warningNote;
    DetailedQuestStep getJournal;
    DetailedQuestStep readJournal;
    DetailedQuestStep getSecateurs;
    DetailedQuestStep enterHole;
    DetailedQuestStep searchForTablet;
    DetailedQuestStep readTablet1;
    DetailedQuestStep readTranslations;
    DetailedQuestStep attemptTranslation;
    DetailedQuestStep inputWords1;
    DetailedQuestStep leaveHole;
    DetailedQuestStep goToMolch;
    DetailedQuestStep enterMolchHole;
    DetailedQuestStep searchVines;
    DetailedQuestStep cutVines;
    DetailedQuestStep searchForTablet2;
    DetailedQuestStep readTablet2;
    DetailedQuestStep readTranslations2;
    DetailedQuestStep attemptTranslation2;
    DetailedQuestStep inputWords2;
    DetailedQuestStep leaveHole2;
    DetailedQuestStep leaveMolchIsland;
    DetailedQuestStep enterXericShrineHole;
    DetailedQuestStep searchForTablet3;
    DetailedQuestStep readTablet3;
    DetailedQuestStep readTranslations3;
    DetailedQuestStep attemptTranslation3;
    DetailedQuestStep inputWords3;
    DetailedQuestStep leaveHole3;
    DetailedQuestStep enterMorraHole;
    DetailedQuestStep searchForTablet4;
    DetailedQuestStep readTablet4;
    DetailedQuestStep readTranslations4;
    DetailedQuestStep attemptTranslation4;
    DetailedQuestStep inputWords4;
    DetailedQuestStep readTabletFinal;
    DetailedQuestStep readWarningNote;
    Zone hole;
    Zone molchIsland;
    Zone molchHole;
    Zone xericHole;
    Zone morraHole;
    Requirement translationOpen;
    Requirement chatInputOpen;
    Requirement hasCutVines;
    Requirement searchedVines;
    Requirement hasReadTablet2;
    Requirement inXericHole;
    Requirement hasReadTablet3;
    Requirement inMorraHole;
    Requirement hasReadTablet4;
    Requirement inHole;
    Requirement onMolchIsland;
    Requirement inMolchHole;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.getJournal);
        steps.put(2, this.readJournal);
        ConditionalStep t1 = new ConditionalStep((QuestHelper)this, (QuestStep)this.getSecateurs, new Requirement[0]);
        t1.addStep(this.chatInputOpen, this.inputWords1);
        t1.addStep(this.translationOpen, this.attemptTranslation);
        t1.addStep(this.wordTranslations, this.readTranslations);
        t1.addStep(this.stoneTablet1, this.readTablet1);
        t1.addStep(new Conditions(this.inHole, this.secateurs), this.searchForTablet);
        t1.addStep(this.secateurs, this.enterHole);
        steps.put(4, t1);
        steps.put(6, t1);
        steps.put(8, t1);
        steps.put(10, t1);
        steps.put(12, t1);
        steps.put(14, t1);
        ConditionalStep t2 = new ConditionalStep((QuestHelper)this, (QuestStep)this.goToMolch, new Requirement[0]);
        t2.addStep(new Conditions(this.hasReadTablet2, this.chatInputOpen), this.inputWords2);
        t2.addStep(new Conditions(this.hasReadTablet2, this.translationOpen), this.attemptTranslation2);
        t2.addStep(this.hasReadTablet2, this.readTranslations2);
        t2.addStep(this.stoneTablet2, this.readTablet2);
        t2.addStep(this.inHole, this.leaveHole);
        t2.addStep(new Conditions(this.inMolchHole, this.hasCutVines), this.searchForTablet2);
        t2.addStep(new Conditions(this.inMolchHole, this.searchedVines), this.cutVines);
        t2.addStep(this.inMolchHole, this.searchVines);
        t2.addStep(this.onMolchIsland, this.enterMolchHole);
        steps.put(16, t2);
        steps.put(18, t2);
        steps.put(20, t2);
        steps.put(22, t2);
        steps.put(24, t2);
        steps.put(26, t2);
        steps.put(28, t2);
        ConditionalStep t3 = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterXericShrineHole, new Requirement[0]);
        t3.addStep(new Conditions(this.hasReadTablet3, this.chatInputOpen), this.inputWords3);
        t3.addStep(new Conditions(this.hasReadTablet3, this.translationOpen), this.attemptTranslation3);
        t3.addStep(this.hasReadTablet3, this.readTranslations3);
        t3.addStep(this.stoneTablet3, this.readTablet3);
        t3.addStep(this.inXericHole, this.searchForTablet3);
        t3.addStep(this.onMolchIsland, this.leaveMolchIsland);
        t3.addStep(this.inMolchHole, this.leaveHole2);
        steps.put(30, t3);
        steps.put(32, t3);
        steps.put(34, t3);
        steps.put(36, t3);
        steps.put(38, t3);
        ConditionalStep t4 = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterMorraHole, new Requirement[0]);
        t4.addStep(new Conditions(this.hasReadTablet4, this.chatInputOpen), this.inputWords4);
        t4.addStep(new Conditions(this.hasReadTablet4, this.translationOpen), this.attemptTranslation4);
        t4.addStep(this.hasReadTablet4, this.readTranslations4);
        t4.addStep(this.stoneTablet4, this.readTablet4);
        t4.addStep(this.inMorraHole, this.searchForTablet4);
        t4.addStep(this.inXericHole, this.leaveHole3);
        steps.put(40, t4);
        steps.put(42, t4);
        steps.put(44, t4);
        steps.put(46, t4);
        steps.put(48, t4);
        ConditionalStep finalStep = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterMorraHole, new Requirement[0]);
        finalStep.addStep(this.warningNote.alsoCheckBank(this.questBank), this.readWarningNote);
        finalStep.addStep(this.stoneTablet4.alsoCheckBank(this.questBank), this.readTabletFinal);
        finalStep.addStep(this.inMorraHole, this.searchForTablet4);
        steps.put(50, finalStep);
        steps.put(52, finalStep);
        steps.put(54, finalStep);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.secateurs = new ItemRequirement("Secateurs (Obtainable in quest)", 5329);
        this.secateurs.canBeObtainedDuringQuest();
        this.secateurs.addAlternates(7409);
        this.antipoison = new ItemRequirement("Antipoisons", ItemCollections.ANTIPOISONS);
        this.khardestMemoir = new ItemRequirement("Khardest's memoirs or book of the dead for teleports", 21760);
        this.khardestMemoir.addAlternates(25818);
        this.fairyRingAccess = new ItemRequirement("Fairy ring access for quick access to Molch Island (DJR)", ItemCollections.FAIRY_STAFF);
        this.xericsTalisman = new ItemRequirement("Xeric's talisman", 13393);
        this.stoneTablet1 = new ItemRequirement("Stone tablet", 27519);
        this.stoneTablet2 = new ItemRequirement("Stone tablet", 27520);
        this.stoneTablet3 = new ItemRequirement("Stone tablet", 27521);
        this.stoneTablet4 = new ItemRequirement("Stone tablet", 27522);
        this.kasondesJournal = new ItemRequirement("Kasonde's journal", 27511);
        this.wordTranslations = new ItemRequirement("Word translations", 27513);
        this.wordTranslations.setTooltip("Obtained in quest in a stone table in the first hole");
        this.dirtyNote1 = new ItemRequirement("Dirty note", 27515);
        this.dirtyNote2 = new ItemRequirement("Dirty note", 27516);
        this.dirtyNote3 = new ItemRequirement("Dirty note", 27517);
        this.compass = new ItemRequirement("Compass", 27532);
        this.warningNote = new ItemRequirement("Warning note", 27518);
    }

    public void loadZones() {
        this.hole = new Zone(new WorldPoint(1290, 9860, 0), new WorldPoint(1325, 9895, 0));
        this.molchIsland = new Zone(new WorldPoint(1358, 3623, 0), new WorldPoint(1379, 3643, 0));
        this.molchHole = new Zone(new WorldPoint(1362, 9990, 0), new WorldPoint(1388, 10036, 0));
        this.xericHole = new Zone(new WorldPoint(1292, 9995, 0), new WorldPoint(1319, 10039, 0));
        this.morraHole = new Zone(new WorldPoint(1419, 9812, 0), new WorldPoint(1460, 9836, 0));
    }

    public void setupConditions() {
        this.inHole = new ZoneRequirement(this.hole);
        this.onMolchIsland = new ZoneRequirement(this.molchIsland);
        this.inMolchHole = new ZoneRequirement(this.molchHole);
        this.inXericHole = new ZoneRequirement(this.xericHole);
        this.inMorraHole = new ZoneRequirement(this.morraHole);
        this.translationOpen = new WidgetTextRequirement(804, 4, "Translations");
        this.chatInputOpen = new Conditions(LogicType.OR, new WidgetTextRequirement(10616873, "Enter a possible translation for a word you've found:"), new WidgetTextRequirement(229, 1, "You've discovered a new translation", "You've already discovered this translation", "You can't think of any suitable translations"), new WidgetTextRequirement(219, 1, 0, "Attempt another translation?"));
        this.searchedVines = new VarbitRequirement(QuestVarbits.QUEST_THE_GARDEN_OF_DEATH.getId(), 22, Operation.GREATER_EQUAL);
        this.hasCutVines = new VarbitRequirement(QuestVarbits.QUEST_THE_GARDEN_OF_DEATH.getId(), 24, Operation.GREATER_EQUAL);
        this.hasReadTablet2 = new VarbitRequirement(QuestVarbits.QUEST_THE_GARDEN_OF_DEATH.getId(), 28, Operation.GREATER_EQUAL);
        this.hasReadTablet3 = new VarbitRequirement(QuestVarbits.QUEST_THE_GARDEN_OF_DEATH.getId(), 38, Operation.GREATER_EQUAL);
        this.hasReadTablet4 = new VarbitRequirement(QuestVarbits.QUEST_THE_GARDEN_OF_DEATH.getId(), 48, Operation.GREATER_EQUAL);
    }

    public void setupSteps() {
        this.getJournal = new ObjectStep((QuestHelper)this, 46324, new WorldPoint(1314, 3470, 0), "Search the tent in the south east of the Kebos Lowlands.", new Requirement[0]);
        this.getJournal.addDialogStep("Yes.");
        this.readJournal = new DetailedQuestStep((QuestHelper)this, "Read the journal", this.kasondesJournal.highlighted());
        this.getSecateurs = new ObjectStep((QuestHelper)this, 46325, new WorldPoint(1312, 3470, 0), "Search the camping equipment for some secateurs.", new Requirement[0]);
        this.enterHole = new ObjectStep((QuestHelper)this, 46326, new WorldPoint(1308, 3467, 0), "Enter the nearby hole.", this.secateurs);
        this.searchForTablet = new ObjectStep((QuestHelper)this, 46376, new WorldPoint(1306, 9885, 0), "Search the south east table.", new Requirement[0]);
        this.readTablet1 = new DetailedQuestStep((QuestHelper)this, "Read the stone tablet.", this.stoneTablet1.highlighted());
        this.readTablet1.addDialogStep("Yes.");
        this.readTranslations = new DetailedQuestStep((QuestHelper)this, "Read the word translations.", this.wordTranslations.highlighted());
        this.attemptTranslation = new WidgetStep((QuestHelper)this, "Click the 'Attempt Translation' button.", 804, 5);
        this.inputWords1 = new DetailedQuestStep((QuestHelper)this, "Type 'Island', 'Water', 'Time', 'Vessel', and 'North'.", new Requirement[0]);
        this.inputWords1.addDialogStep("Yes.");
        this.leaveHole = new ObjectStep((QuestHelper)this, 46327, new WorldPoint(1309, 9867, 0), "Leave the hole.", new Requirement[0]);
        this.goToMolch = new ObjectStep((QuestHelper)this, 33614, new WorldPoint(1406, 3612, 0), "Travel to Molch island via Boaty, located on the west/north/east sides of Lake Molch.", this.wordTranslations, this.secateurs);
        this.goToMolch.addDialogStep("Molch Island");
        this.enterMolchHole = new ObjectStep((QuestHelper)this, 46434, new WorldPoint(1364, 3637, 0), "Enter the hole on Molch Island.", this.wordTranslations, this.secateurs);
        this.searchVines = new ObjectStep((QuestHelper)this, 46437, new WorldPoint(1375, 10024, 0), "Inspect the vines to the south.", new Requirement[0]);
        this.cutVines = new ObjectStep((QuestHelper)this, 46437, new WorldPoint(1375, 10024, 0), "Cut the vines with secateurs.", this.secateurs.highlighted());
        this.cutVines.addIcon(5329);
        this.searchForTablet2 = new ObjectStep((QuestHelper)this, 46377, new WorldPoint(1373, 10014, 0), "Search the south west stone table.", new Requirement[0]);
        this.readTablet2 = new DetailedQuestStep((QuestHelper)this, "Read the stone tablet, and take the note after closing the tablet's interface.", this.stoneTablet2.highlighted());
        this.readTablet2.addDialogStep("Yes.");
        this.readTranslations2 = new DetailedQuestStep((QuestHelper)this, "Read the word translations.", this.wordTranslations.highlighted());
        this.attemptTranslation2 = new WidgetStep((QuestHelper)this, "Click the 'Attempt Translation' button.", 804, 5);
        this.inputWords2 = new DetailedQuestStep((QuestHelper)this, "Type 'West', 'Poison', 'Body', 'Food', and 'Earth'.", new Requirement[0]);
        this.inputWords2.addDialogStep("Yes.");
        this.leaveHole2 = new ObjectStep((QuestHelper)this, 46330, new WorldPoint(1375, 10033, 0), "Leave the hole.", new Requirement[0]);
        this.leaveMolchIsland = new ObjectStep((QuestHelper)this, 33614, new WorldPoint(1369, 3641, 0), "Travel via Boaty to Molch, and enter the hole near Xeric's Shrine.", this.wordTranslations);
        this.leaveMolchIsland.addDialogStep("Molch");
        this.enterXericShrineHole = new ObjectStep((QuestHelper)this, 46435, new WorldPoint(1314, 3617, 0), "Enter the hole next to Xeric's Shrine.", this.wordTranslations);
        this.searchForTablet3 = new ObjectStep((QuestHelper)this, 46378, new WorldPoint(1311, 10018, 0), "Search the south east stone table.", new Requirement[0]);
        this.readTablet3 = new DetailedQuestStep((QuestHelper)this, "Read the stone tablet.", this.stoneTablet3.highlighted());
        this.readTablet3.addDialogStep("Yes.");
        this.readTranslations3 = new DetailedQuestStep((QuestHelper)this, "Read the word translations.", this.wordTranslations.highlighted());
        this.attemptTranslation3 = new WidgetStep((QuestHelper)this, "Click the 'Attempt Translation' button.", 804, 5);
        this.inputWords3 = new DetailedQuestStep((QuestHelper)this, "Type 'Make', 'Yes', 'No', 'Move', 'Arrive', 'East', and 'South'.", new Requirement[0]);
        this.inputWords3.addDialogStep("Yes.");
        this.leaveHole3 = new ObjectStep((QuestHelper)this, 46333, new WorldPoint(1294, 10033, 0), "Leave the hole.", new Requirement[0]);
        this.enterMorraHole = new ObjectStep((QuestHelper)this, 46436, new WorldPoint(1450, 3511, 0), "Enter the hole in the Ruins of Morra, south west of Shayzien.", this.wordTranslations);
        this.searchForTablet4 = new ObjectStep((QuestHelper)this, 46379, new WorldPoint(1440, 9816, 0), "Search the south stone table.", new Requirement[0]);
        this.readTablet4 = new DetailedQuestStep((QuestHelper)this, "Read the stone tablet.", this.stoneTablet4.highlighted());
        this.readTablet4.addDialogStep("Yes.");
        this.readTranslations4 = new DetailedQuestStep((QuestHelper)this, "Read the word translations.", this.wordTranslations.highlighted());
        this.attemptTranslation4 = new WidgetStep((QuestHelper)this, "Click the 'Attempt Translation' button.", 804, 5);
        this.inputWords4 = new DetailedQuestStep((QuestHelper)this, "Type 'Few', 'Big', 'Sun', 'Moon', 'Life', 'Death', 'Mind', 'Home', 'Air', and 'Fire'.", new Requirement[0]);
        this.inputWords4.addDialogStep("Yes.");
        this.readTabletFinal = new DetailedQuestStep((QuestHelper)this, "Read the final stone tablet again.", this.stoneTablet4.highlighted());
        this.readTabletFinal.addDialogStep("Yes.");
        this.readWarningNote = new DetailedQuestStep((QuestHelper)this, "Read the warning note.", this.warningNote.highlighted());
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Collections.singletonList(this.secateurs);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.xericsTalisman, this.khardestMemoir, this.fairyRingAccess, this.antipoison);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new SkillRequirement(Skill.FARMING, 20));
        return req;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.FARMING, 10000));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Arrays.asList(this.getJournal, this.readJournal, this.getSecateurs, this.enterHole, this.searchForTablet, this.readTablet1, this.readTranslations, this.attemptTranslation, this.inputWords1, this.leaveHole), this.secateurs));
        allSteps.add(new PanelDetails("Investigating Molch", Arrays.asList(this.goToMolch, this.enterMolchHole, this.searchVines, this.cutVines, this.searchForTablet2, this.readTablet2, this.readTranslations2, this.attemptTranslation2, this.inputWords2), this.secateurs, this.wordTranslations));
        allSteps.add(new PanelDetails("Investigating Xeric's Shrine", Arrays.asList(this.leaveHole2, this.leaveMolchIsland, this.enterXericShrineHole, this.searchForTablet3, this.readTablet3, this.readTranslations3, this.attemptTranslation3, this.inputWords3), this.wordTranslations));
        allSteps.add(new PanelDetails("Investigating the Ruins of Morra", Arrays.asList(this.leaveHole3, this.enterMorraHole, this.searchForTablet4, this.readTablet4, this.readTranslations4, this.attemptTranslation4, this.inputWords4, this.readTabletFinal, this.readWarningNote), new Requirement[0]));
        return allSteps;
    }
}

