/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.thefremennikexiles;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.conditional.NpcCondition;
import com.questhelper.requirements.item.ItemOnTileRequirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.ItemRequirements;
import com.questhelper.requirements.player.InInstanceRequirement;
import com.questhelper.requirements.player.PrayerRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.ComplexRequirementBuilder;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Prayer;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.THE_FREMENNIK_EXILES)
public class TheFremennikExiles
extends BasicQuestHelper {
    ItemRequirement combatGear;
    ItemRequirement mirrorShield;
    ItemRequirement kegsOfBeer;
    ItemRequirement moltenGlass;
    ItemRequirement astralRunes;
    ItemRequirement petRock;
    ItemRequirement kegs2Or650Coins;
    ItemRequirement fishingOrFlyFishingRod;
    ItemRequirement fremennikShield;
    ItemRequirement iceGloves;
    ItemRequirement hammer;
    ItemRequirement glassblowingPipe;
    ItemRequirement pickaxe;
    ItemRequirement sealOfPassage;
    ItemRequirement coins150kOrCharos;
    ItemRequirement food;
    ItemRequirement rellekkaTeleport;
    ItemRequirement coins650;
    ItemRequirement restorePot;
    ItemRequirement letter;
    ItemRequirement fang;
    ItemRequirement venomGland;
    ItemRequirement lunarOre;
    ItemRequirement lunarBar;
    ItemRequirement lunarGlass;
    ItemRequirement moltenGlassI;
    ItemRequirement sigil;
    ItemRequirement sigilE;
    ItemRequirement polishedRock;
    ItemRequirement vShield;
    ItemRequirement runeThrowingaxeOrFriend;
    Requirement inYagaHouse;
    Requirement inMine;
    Requirement onIsleOfStone;
    Requirement inTyphorRoom;
    Requirement sealOfPassageOrEliteDiary;
    Requirement killedYoungling;
    Requirement letterNearby;
    Requirement younglingNearby;
    Requirement hasReadLetter;
    Requirement askedAboutGlass;
    Requirement askedAboutRock;
    Requirement askedAboutSigil;
    Requirement askedAboutShield;
    Requirement askedAboutAllShieldParts;
    Requirement triedToThrowRockIntoGeyser;
    Requirement talkedToPeer;
    Requirement rockInGeyser;
    QuestStep buyKegs;
    QuestStep talkToBrundt;
    QuestStep talkToFreygerd;
    QuestStep searchSandpit;
    QuestStep searchSandpitForLetter;
    QuestStep killYoungling;
    QuestStep pickupLetter;
    QuestStep readLetter;
    QuestStep searchRockslide;
    QuestStep searchBoxes;
    QuestStep talkToFreygardWithItems;
    QuestStep talkToBrundtAgain;
    QuestStep talkToBrundtSouthEastOfRellekka;
    QuestStep askAboutShield;
    QuestStep askAboutGlass;
    QuestStep askAboutRock;
    QuestStep askAboutSigil;
    QuestStep getFremennikShield;
    QuestStep enterYagaHouse;
    QuestStep talkToYaga;
    QuestStep enterMine;
    QuestStep mine3Ores;
    QuestStep leaveMine;
    QuestStep makeLunarGlass;
    QuestStep smeltLunarBars;
    QuestStep smithSigil;
    QuestStep talkToFossegrimen;
    QuestStep inspectGeyser;
    QuestStep talkToPeer;
    QuestStep inspectGeyserWithIceGloves;
    QuestStep retrieveRock;
    QuestStep createShield;
    QuestStep talkToBrundtWithShield;
    QuestStep talkToBrundtBackInRellekka;
    QuestStep talkToBrundtWithBeers;
    QuestStep killBasilisks;
    QuestStep travelToIsleOfStone;
    QuestStep talkToBrundtOutsidePuzzle;
    QuestStep solvePuzzle;
    QuestStep enterCaveToFight;
    QuestStep fightTyphor;
    QuestStep fightJormungand;
    QuestStep watchCutscenes;
    QuestStep talkToBrundtToFinish;
    ConditionalStep goMakeSigil;
    ConditionalStep goMakeGlass;
    ConditionalStep goMakeRock;
    ConditionalStep goGetShield;
    Zone lunarMine;
    Zone yagaHouse;
    Zone isleOfStone;
    Zone typhorRoom;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        ConditionalStep getKegsThenStart = new ConditionalStep((QuestHelper)this, this.buyKegs, new Requirement[0]);
        getKegsThenStart.addStep(this.kegsOfBeer.quantity(2), this.talkToBrundt);
        steps.put(0, getKegsThenStart);
        steps.put(5, getKegsThenStart);
        steps.put(10, this.talkToFreygerd);
        ConditionalStep investigate = new ConditionalStep((QuestHelper)this, this.searchSandpit, new Requirement[0]);
        investigate.addStep(new Conditions(this.hasReadLetter, this.fang, this.venomGland), this.talkToFreygardWithItems);
        investigate.addStep(new Conditions(this.hasReadLetter, this.fang), this.searchBoxes);
        investigate.addStep(this.hasReadLetter, this.searchRockslide);
        investigate.addStep(this.letter, this.readLetter);
        investigate.addStep(this.killedYoungling, this.searchSandpitForLetter);
        investigate.addStep(this.letterNearby, this.pickupLetter);
        investigate.addStep(this.younglingNearby, this.killYoungling);
        steps.put(15, investigate);
        steps.put(20, this.talkToBrundtAgain);
        steps.put(25, this.talkToBrundtAgain);
        steps.put(30, this.talkToBrundtAgain);
        steps.put(35, this.talkToBrundtSouthEastOfRellekka);
        steps.put(40, this.talkToBrundtSouthEastOfRellekka);
        this.goMakeGlass = new ConditionalStep((QuestHelper)this, this.enterYagaHouse, new Requirement[0]);
        this.goMakeGlass.addStep(this.moltenGlassI, this.makeLunarGlass);
        this.goMakeGlass.addStep(this.inYagaHouse, this.talkToYaga);
        this.goMakeGlass.setLockingCondition(this.lunarGlass);
        this.goMakeGlass.setBlocker(true);
        this.goMakeSigil = new ConditionalStep((QuestHelper)this, this.enterMine, new Requirement[0]);
        this.goMakeSigil.addStep(this.sigil, this.talkToFossegrimen);
        this.goMakeSigil.addStep(this.lunarBar.quantity(3), this.smithSigil);
        this.goMakeSigil.addStep(this.lunarOre.quantity(3), this.smeltLunarBars);
        this.goMakeSigil.addStep(this.inMine, this.mine3Ores);
        this.goMakeSigil.setLockingCondition(this.sigilE);
        this.goMakeRock = new ConditionalStep((QuestHelper)this, this.inspectGeyser, new Requirement[0]);
        this.goMakeRock.addStep(this.rockInGeyser, this.retrieveRock);
        this.goMakeRock.addStep(this.talkedToPeer, this.inspectGeyserWithIceGloves);
        this.goMakeRock.addStep(this.triedToThrowRockIntoGeyser, this.talkToPeer);
        this.goMakeRock.setLockingCondition(this.polishedRock);
        this.goGetShield = new ConditionalStep((QuestHelper)this, this.getFremennikShield, new Requirement[0]);
        this.goGetShield.setLockingCondition(this.fremennikShield);
        ConditionalStep goMakeShield = new ConditionalStep((QuestHelper)this, this.talkToBrundtSouthEastOfRellekka, new Requirement[0]);
        goMakeShield.addStep(this.vShield, this.talkToBrundtWithShield);
        goMakeShield.addStep(new Conditions(this.askedAboutAllShieldParts, this.fremennikShield, this.lunarGlass, this.sigilE, this.polishedRock), this.createShield);
        goMakeShield.addStep(new Conditions(this.askedAboutAllShieldParts, this.fremennikShield, this.lunarGlass, this.sigilE), this.goMakeRock);
        goMakeShield.addStep(new Conditions(this.askedAboutAllShieldParts, this.fremennikShield, this.lunarGlass), this.goMakeSigil);
        goMakeShield.addStep(new Conditions(this.askedAboutAllShieldParts, this.fremennikShield), this.goMakeGlass);
        goMakeShield.addStep(this.askedAboutAllShieldParts, this.goGetShield);
        steps.put(50, goMakeShield);
        steps.put(55, this.talkToBrundtWithBeers);
        steps.put(60, this.talkToBrundtWithBeers);
        steps.put(65, this.talkToBrundtWithBeers);
        steps.put(70, this.talkToBrundtBackInRellekka);
        steps.put(75, this.talkToBrundtBackInRellekka);
        steps.put(76, this.talkToBrundtBackInRellekka);
        ConditionalStep goDefendRellekka = new ConditionalStep((QuestHelper)this, this.talkToBrundtBackInRellekka, new Requirement[0]);
        goDefendRellekka.addStep(new InInstanceRequirement(), this.killBasilisks);
        steps.put(77, goDefendRellekka);
        steps.put(80, goDefendRellekka);
        ConditionalStep goToIsle = new ConditionalStep((QuestHelper)this, this.travelToIsleOfStone, new Requirement[0]);
        goToIsle.addStep(this.onIsleOfStone, this.talkToBrundtOutsidePuzzle);
        steps.put(85, goToIsle);
        ConditionalStep goDoPuzzle = new ConditionalStep((QuestHelper)this, this.travelToIsleOfStone, new Requirement[0]);
        goDoPuzzle.addStep(this.onIsleOfStone, this.solvePuzzle);
        steps.put(90, goDoPuzzle);
        ConditionalStep goFightTyphor = new ConditionalStep((QuestHelper)this, this.travelToIsleOfStone, new Requirement[0]);
        goFightTyphor.addStep(this.inTyphorRoom, this.fightTyphor);
        goFightTyphor.addStep(this.onIsleOfStone, this.enterCaveToFight);
        steps.put(95, goFightTyphor);
        steps.put(100, goFightTyphor);
        ConditionalStep goFightJorm = new ConditionalStep((QuestHelper)this, this.travelToIsleOfStone, new Requirement[0]);
        goFightJorm.addStep(this.inTyphorRoom, this.fightJormungand);
        goFightJorm.addStep(this.onIsleOfStone, this.enterCaveToFight);
        steps.put(105, goFightJorm);
        steps.put(110, goFightJorm);
        ConditionalStep goFinish = new ConditionalStep((QuestHelper)this, this.travelToIsleOfStone, new Requirement[0]);
        goFinish.addStep(this.inTyphorRoom, this.watchCutscenes);
        goFinish.addStep(this.onIsleOfStone, this.enterCaveToFight);
        steps.put(115, goFinish);
        steps.put(120, this.talkToBrundtToFinish);
        steps.put(125, this.talkToBrundtToFinish);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.combatGear = new ItemRequirement("Combat gear", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.mirrorShield = new ItemRequirement("Mirror shield", 4156).isNotConsumed();
        this.kegsOfBeer = new ItemRequirement("Kegs of beer", 3801);
        this.kegsOfBeer.setTooltip("You can buy some from Rasolo south east of Baxtorian Falls");
        this.moltenGlass = new ItemRequirement("Molten glass", 1775);
        this.astralRunes = new ItemRequirement("Astral runes", 9075);
        this.petRock = new ItemRequirement("Pet rock", 3695).isNotConsumed();
        this.petRock.setTooltip("You can get another from Askeladden in Rellekka");
        this.fishingOrFlyFishingRod = new ItemRequirement("Fishing rod", 307).isNotConsumed();
        this.fishingOrFlyFishingRod.addAlternates(309);
        this.fremennikShield = new ItemRequirement("Fremennik shield", 3758);
        this.fremennikShield.setTooltip("Obtainable during the quest for 150k, or free with a Ring of Charos(a)");
        this.iceGloves = new ItemRequirement("Ice gloves or smiths gloves(i)", 1580).isNotConsumed();
        this.iceGloves.setTooltip("You can get another pair of ice gloves by killing the Ice Queen under White Wolf Mountain");
        this.iceGloves.addAlternates(27031);
        this.hammer = new ItemRequirement("Hammer", ItemCollections.HAMMER).isNotConsumed();
        this.glassblowingPipe = new ItemRequirement("Glassblowing pipe", 1785).isNotConsumed();
        this.pickaxe = new ItemRequirement("Any pickaxe", ItemCollections.PICKAXES).isNotConsumed();
        this.restorePot = new ItemRequirement("Restore potions", ItemCollections.RESTORE_POTIONS);
        this.restorePot.setTooltip("Highly recommended to make up for mistakes");
        this.runeThrowingaxeOrFriend = new ItemRequirement("Rune thrownaxe, or a friend to help enter Waterbirth Isle Dungeon", 805);
        this.sealOfPassage = new ItemRequirement("Seal of passage", 9083).isNotConsumed();
        this.sealOfPassageOrEliteDiary = ComplexRequirementBuilder.or("Seal of Passage").with(new VarbitRequirement(4494, 1)).with(this.sealOfPassage).build();
        this.coins150kOrCharos = new ItemRequirements(LogicType.OR, "Ring of Charos(a) or 150k coins", new ItemRequirement("Ring of Charos(a)", 6465), new ItemRequirement("Coins", ItemCollections.COINS, 150000));
        this.coins650 = new ItemRequirement("Coins", ItemCollections.COINS, 650);
        this.kegs2Or650Coins = new ItemRequirements(LogicType.OR, "2x kegs of beer or 650 coins", this.kegsOfBeer.quantity(2), this.coins650);
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        this.rellekkaTeleport = new ItemRequirement("Rellekka teleports", 11744, -1);
        this.rellekkaTeleport.addAlternates(ItemCollections.ENCHANTED_LYRE);
        this.rellekkaTeleport.addAlternates(ItemCollections.SLAYER_RINGS);
        this.letter = new ItemRequirement("Unsealed letter", 24256);
        this.letter.addAlternates(24257);
        this.fang = new ItemRequirement("Fang", 24254);
        this.venomGland = new ItemRequirement("Venom gland", 24255);
        this.lunarOre = new ItemRequirement("Lunar ore", 9076);
        this.lunarOre.addAlternates(9077);
        this.lunarBar = new ItemRequirement("Lunar bar", 9077);
        this.lunarGlass = new ItemRequirement("Lunar glass", 24261);
        this.moltenGlassI = new ItemRequirement("Molten glass (i)", 24260);
        this.sigil = new ItemRequirement("V sigil", 24258);
        this.sigilE = new ItemRequirement("V sigil (e)", 24259);
        this.polishedRock = new ItemRequirement("Polishing rock", 24262);
        this.vShield = new ItemRequirement("V's shield", 24265);
        this.vShield.addAlternates(24266);
        this.younglingNearby = new NpcCondition(9282);
        this.letterNearby = new ItemOnTileRequirement(this.letter);
        this.killedYoungling = new VarbitRequirement(9460, 1);
        this.hasReadLetter = new VarbitRequirement(9461, 1);
        this.askedAboutShield = new VarbitRequirement(9462, 1, Operation.GREATER_EQUAL);
        this.askedAboutGlass = new VarbitRequirement(9463, 1, Operation.GREATER_EQUAL);
        this.askedAboutRock = new VarbitRequirement(9464, 1, Operation.GREATER_EQUAL);
        this.askedAboutSigil = new VarbitRequirement(9465, 1, Operation.GREATER_EQUAL);
        this.askedAboutAllShieldParts = new Conditions(this.askedAboutShield, this.askedAboutGlass, this.askedAboutRock, this.askedAboutSigil);
        this.triedToThrowRockIntoGeyser = new VarbitRequirement(9464, 2);
        this.talkedToPeer = new VarbitRequirement(9464, 3);
        this.rockInGeyser = new VarbitRequirement(9470, 1);
        this.inYagaHouse = new ZoneRequirement(this.yagaHouse);
        this.inMine = new ZoneRequirement(this.lunarMine);
        this.onIsleOfStone = new ZoneRequirement(this.isleOfStone);
        this.inTyphorRoom = new ZoneRequirement(this.typhorRoom);
    }

    public void loadZones() {
        this.yagaHouse = new Zone(new WorldPoint(2449, 4645, 0), new WorldPoint(2453, 4649, 0));
        this.lunarMine = new Zone(new WorldPoint(2300, 10313, 2), new WorldPoint(2370, 10354, 2));
        this.isleOfStone = new Zone(new WorldPoint(2436, 3986, 0), new WorldPoint(2493, 4033, 0));
        this.typhorRoom = new Zone(new WorldPoint(2437, 10364, 0), new WorldPoint(2477, 10404, 0));
    }

    public void setupSteps() {
        this.talkToBrundt = new NpcStep((QuestHelper)this, 9263, new WorldPoint(2658, 3669, 0), "Talk to Brundt in Rellekka's longhall.", new Requirement[0]);
        this.talkToBrundt.addDialogSteps("Ask for a quest.", "Yes.");
        this.buyKegs = new NpcStep((QuestHelper)this, 3932, new WorldPoint(2662, 3673, 0), "Buy 2 kegs of beer from Thora in Rellekka.", this.coins650);
        this.talkToFreygerd = new NpcStep((QuestHelper)this, 3942, new WorldPoint(2668, 3703, 0), "Talk to Freygerd in north Rellekka.", this.combatGear, this.mirrorShield.equipped());
        this.searchSandpit = new ObjectStep((QuestHelper)this, 4373, new WorldPoint(2668, 3708, 0), "Search the sand pit near Freygerd, ready to fight a basilisk youngling.", this.combatGear, this.mirrorShield.equipped());
        this.searchSandpitForLetter = new ObjectStep((QuestHelper)this, 4373, new WorldPoint(2668, 3708, 0), "Search the sand pit near Freygerd for a letter.", this.letter.highlighted());
        this.killYoungling = new NpcStep((QuestHelper)this, 9282, new WorldPoint(2666, 3708, 0), "Defeat the Basilisk Youngling.", this.combatGear, this.mirrorShield.equipped());
        this.pickupLetter = new ItemStep((QuestHelper)this, "Pick up the letter.", this.letter);
        this.pickupLetter.addSubSteps(this.searchSandpitForLetter);
        this.readLetter = new DetailedQuestStep((QuestHelper)this, "Read the letter.", this.letter.highlighted());
        this.searchRockslide = new ObjectStep((QuestHelper)this, 20091, new WorldPoint(2659, 3704, 0), "Search the rockslide west of the sand pit.", new Requirement[0]);
        this.searchBoxes = new ObjectStep((QuestHelper)this, 20092, new WorldPoint(2668, 3699, 0), "Search the boxes south of Freygerd.", new Requirement[0]);
        this.talkToFreygardWithItems = new NpcStep((QuestHelper)this, 3942, new WorldPoint(2668, 3703, 0), "Return to Freygerd with the items you found.", this.letter, this.fang, this.venomGland);
        this.talkToBrundtAgain = new NpcStep((QuestHelper)this, 9263, new WorldPoint(2658, 3669, 0), "Return to Brundt in Rellekka's longhall.", new Requirement[0]);
        this.talkToBrundtAgain.addDialogStep("Ask about the investigation.");
        this.talkToBrundtSouthEastOfRellekka = new NpcStep((QuestHelper)this, 9266, new WorldPoint(2705, 3634, 0), "Talk to Brundt south east of Rellekka, asking him all available questions.", new Requirement[0]);
        this.askAboutShield = new NpcStep((QuestHelper)this, 9266, new WorldPoint(2705, 3634, 0), "Talk to Brundt south east of Rellekka, asking him all available questions.", new Requirement[0]);
        this.askAboutShield.addDialogStep("Where can I find a Fremennik Shield?");
        this.askAboutGlass = new NpcStep((QuestHelper)this, 9266, new WorldPoint(2705, 3634, 0), "Talk to Brundt south east of Rellekka, asking him all available questions.", new Requirement[0]);
        this.askAboutGlass.addDialogSteps("Where can I get Lunar Glass?");
        this.askAboutRock = new NpcStep((QuestHelper)this, 9266, new WorldPoint(2705, 3634, 0), "Talk to Brundt south east of Rellekka, asking him all available questions.", new Requirement[0]);
        this.askAboutRock.addDialogSteps("How do I make the Polishing Rock?");
        this.askAboutSigil = new NpcStep((QuestHelper)this, 9266, new WorldPoint(2705, 3634, 0), "Talk to Brundt south east of Rellekka, asking him all available questions.", new Requirement[0]);
        this.askAboutSigil.addDialogSteps("How do I make V's Sigil?");
        this.talkToBrundtSouthEastOfRellekka.addSubSteps(this.askAboutShield, this.askAboutGlass, this.askAboutRock, this.askAboutSigil);
        this.enterYagaHouse = new NpcStep((QuestHelper)this, 3836, new WorldPoint(2085, 3931, 0), "Talk to Baba Yaga in the chicken-legged house in the north of Lunar Isle's town.", this.sealOfPassage, this.moltenGlass);
        this.talkToYaga = new NpcStep((QuestHelper)this, 3837, new WorldPoint(2451, 4646, 0), "Talk to Baba Yaga.", this.sealOfPassage, this.moltenGlass);
        this.talkToYaga.addDialogStep("I was wondering if you could help me make Lunar Glass?");
        this.enterYagaHouse.addSubSteps(this.talkToYaga);
        this.enterMine = new ObjectStep((QuestHelper)this, 14996, new WorldPoint(2142, 3944, 0), "Enter the mine in the north east of Lunar Isle.", this.pickaxe);
        this.mine3Ores = new ObjectStep((QuestHelper)this, 15251, "Mine 3 lunar ores from the stalagmites in the area.", this.pickaxe);
        ((ObjectStep)this.mine3Ores).addAlternateObjects(15250);
        this.leaveMine = new ObjectStep((QuestHelper)this, 14995, new WorldPoint(2330, 10353, 2), "Leave the mine.", new Requirement[0]);
        this.makeLunarGlass = new ObjectStep((QuestHelper)this, 34771, new WorldPoint(2158, 3864, 0), "Use the Lunar Altar to make some lunar glass.", this.moltenGlassI, this.astralRunes.quantity(100));
        this.smeltLunarBars = new DetailedQuestStep((QuestHelper)this, "Smelt the lunar ore into bars at any furnace.", this.lunarOre.quantity(3));
        this.smithSigil = new DetailedQuestStep((QuestHelper)this, "Make the V sigil on any anvil.", this.lunarBar.quantity(3));
        this.smithSigil.addDialogStep("Yes.");
        this.talkToFossegrimen = new NpcStep((QuestHelper)this, 808, new WorldPoint(2626, 3598, 0), "Talk to the Fossegrimen south west of Rellekka to enchant the sigil.", this.sigil);
        this.talkToFossegrimen.addDialogStep("Ask about V's Sigil.");
        this.inspectGeyser = new ObjectStep((QuestHelper)this, 20094, new WorldPoint(2766, 3675, 0), "Inspect the geyser north of the Mountain Camp.", this.petRock);
        this.inspectGeyser.addDialogStep("It's for the good of the Province!");
        this.talkToPeer = new NpcStep((QuestHelper)this, 3895, new WorldPoint(2633, 3667, 0), "Talk to Peer the Seer south west of the Rellekka market.", new Requirement[0]);
        this.inspectGeyserWithIceGloves = new ObjectStep((QuestHelper)this, 20094, new WorldPoint(2766, 3675, 0), "Inspect the geyser again.", this.petRock, this.iceGloves.equipped(), this.fishingOrFlyFishingRod);
        this.retrieveRock = new ObjectStep((QuestHelper)this, 20094, new WorldPoint(2766, 3675, 0), "Retrieve your rock from the geyser.", this.iceGloves.equipped(), this.fishingOrFlyFishingRod);
        this.createShield = new DetailedQuestStep((QuestHelper)this, "Use the shield parts together to make V's Shield.", this.fremennikShield.highlighted(), this.lunarGlass.highlighted(), this.polishedRock.highlighted(), this.sigilE.highlighted(), this.glassblowingPipe);
        this.talkToBrundtWithShield = new NpcStep((QuestHelper)this, 9266, new WorldPoint(2705, 3634, 0), "Talk to Brundt south east of Rellekka with V's shield.", this.vShield, this.kegsOfBeer.quantity(2));
        this.talkToBrundtWithBeers = new NpcStep((QuestHelper)this, 9266, new WorldPoint(2705, 3634, 0), "Talk to Brundt with 2 kegs of beer.", this.kegsOfBeer.quantity(2));
        this.talkToBrundtBackInRellekka = new NpcStep((QuestHelper)this, 9263, new WorldPoint(2658, 3669, 0), "Return to Brundt in Rellekka's longhall.", this.combatGear, this.food);
        this.talkToBrundtBackInRellekka.addDialogStep("Ask about the Jormungand.");
        this.getFremennikShield = new DetailedQuestStep((QuestHelper)this, "You can get a fremennik shield from dagannoths in Waterbirth Dungeon or Bardur in Waterbirth Dungeon for 150k, or for free with the Ring of Charos(a). You'll need a friend to get there, or a rune thrownaxe and a pet rock.", this.coins150kOrCharos);
        this.killBasilisks = new NpcStep((QuestHelper)this, 9283, new WorldPoint(2644, 3677, 0), "Kill basilisks until you're told to stop.", true, this.vShield.equipped(), this.combatGear, this.food);
        ((NpcStep)this.killBasilisks).addAlternateNpcs(9284, 9285, 9286, 9287, 9288);
        this.travelToIsleOfStone = new ObjectStep((QuestHelper)this, 37432, new WorldPoint(2623, 3693, 0), "Take the boat to the Isle of Stone.", new Requirement[0]);
        this.talkToBrundtOutsidePuzzle = new NpcStep((QuestHelper)this, 9267, new WorldPoint(2466, 4010, 0), "Talk to Brundt outside the cave entrance.", new Requirement[0]);
        this.solvePuzzle = new ObjectStep((QuestHelper)this, 37433, new WorldPoint(2465, 4012, 0), "Attempt to open the door and solve the puzzle. It's Mastermind, where a red tick means you have one of the correct runes in the wrong position, and a green tick means a correct rune in the correct position.", new Requirement[0]);
        this.enterCaveToFight = new ObjectStep((QuestHelper)this, 37433, new WorldPoint(2465, 4012, 0), "Enter the door, ready to fight.", this.combatGear, this.vShield.equipped());
        this.enterCaveToFight.addDialogStep("Yes.");
        this.fightTyphor = new NpcStep((QuestHelper)this, 9295, new WorldPoint(2457, 10384, 0), "Fight Typhor, who attacks with both Melee and Magic. He is weak to crush.", this.vShield.equipped());
        ((NpcStep)this.fightTyphor).addAlternateNpcs(9296);
        PrayerRequirement protectFromMagic = new PrayerRequirement("Protect from Magic", Prayer.PROTECT_FROM_MAGIC);
        this.fightJormungand = new NpcStep((QuestHelper)this, 9289, new WorldPoint(2457, 10384, 0), "Defeat the Jormungand.", this.vShield.equipped(), protectFromMagic);
        this.fightJormungand.addText("When the screen turns red, have your character face away from him.");
        this.fightJormungand.addText("When frozen in rock, click repeatedly to break out.");
        ((NpcStep)this.fightJormungand).addAlternateNpcs(9290, 9291, 9292);
        this.watchCutscenes = new DetailedQuestStep((QuestHelper)this, "Watch the cutscenes.", new Requirement[0]);
        this.talkToBrundtToFinish = new NpcStep((QuestHelper)this, 9263, new WorldPoint(2658, 3669, 0), "Talk to Brundt in Rellekka's longhall to finish the quest.", new Requirement[0]);
        this.fightJormungand.addSubSteps(this.watchCutscenes, this.talkToBrundtToFinish);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.combatGear, this.mirrorShield, this.kegs2Or650Coins, this.moltenGlass, this.astralRunes.quantity(100), this.petRock, this.runeThrowingaxeOrFriend, this.fishingOrFlyFishingRod, this.fremennikShield, this.iceGloves, this.hammer, this.glassblowingPipe, this.pickaxe, this.sealOfPassage);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.food, this.rellekkaTeleport, this.restorePot);
    }

    @Override
    public List<String> getCombatRequirements() {
        return Arrays.asList("Basilisk Youngling (level 53)", "Basilisk (level 61)", "Monstrous Basilisk (level 135)", "Typhor (level 218)", "The Jormungand (level 363)");
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new SkillRequirement(Skill.CRAFTING, 65));
        req.add(new SkillRequirement(Skill.SLAYER, 60));
        req.add(new SkillRequirement(Skill.SMITHING, 60));
        req.add(new SkillRequirement(Skill.FISHING, 60));
        req.add(new SkillRequirement(Skill.RUNECRAFT, 55));
        req.add(new QuestRequirement(QuestHelperQuest.THE_FREMENNIK_ISLES, QuestState.FINISHED));
        req.add(new QuestRequirement(QuestHelperQuest.LUNAR_DIPLOMACY, QuestState.FINISHED));
        req.add(new QuestRequirement(QuestHelperQuest.MOUNTAIN_DAUGHTER, QuestState.FINISHED));
        req.add(new QuestRequirement(QuestHelperQuest.HEROES_QUEST, QuestState.FINISHED));
        return req;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(2);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.SLAYER, 50000), new ExperienceReward(Skill.CRAFTING, 50000), new ExperienceReward(Skill.RUNECRAFT, 30000));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("V's Shield", 24265, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Access to the Isle of Stone"), new UnlockReward("Ability to kill Basilisk Knights as a slayer task"), new UnlockReward("Ability to craft and equip the Neitiznot faceguard."));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Investigating", Arrays.asList(this.buyKegs, this.talkToBrundt, this.talkToFreygerd, this.searchSandpit, this.killYoungling, this.pickupLetter, this.readLetter, this.searchRockslide, this.searchSandpit, this.talkToFreygardWithItems, this.talkToBrundtAgain, this.talkToBrundtSouthEastOfRellekka), this.combatGear, this.mirrorShield));
        PanelDetails shieldPanel = new PanelDetails("A Fremennik Shield", Collections.singletonList(this.getFremennikShield), this.coins150kOrCharos, this.petRock, this.runeThrowingaxeOrFriend);
        shieldPanel.setLockingStep(this.goGetShield);
        allSteps.add(shieldPanel);
        PanelDetails glassPanel = new PanelDetails("Making Lunar Glass", Arrays.asList(this.enterYagaHouse, this.makeLunarGlass), this.sealOfPassage, this.moltenGlass, this.astralRunes.quantity(100));
        glassPanel.setLockingStep(this.goMakeGlass);
        allSteps.add(glassPanel);
        PanelDetails sigilPanel = new PanelDetails("Making V's Sigil", Arrays.asList(this.enterMine, this.mine3Ores, this.smeltLunarBars, this.smithSigil, this.talkToFossegrimen), this.pickaxe, this.hammer);
        sigilPanel.setLockingStep(this.goMakeSigil);
        allSteps.add(sigilPanel);
        PanelDetails rockPanel = new PanelDetails("Making a Polishing Rock", Arrays.asList(this.inspectGeyser, this.talkToPeer, this.inspectGeyserWithIceGloves, this.retrieveRock), this.petRock, this.iceGloves, this.fishingOrFlyFishingRod);
        rockPanel.setLockingStep(this.goMakeRock);
        allSteps.add(rockPanel);
        allSteps.add(new PanelDetails("Forging the shield", Arrays.asList(this.createShield, this.talkToBrundtWithShield, this.talkToBrundtWithBeers), this.fremennikShield, this.lunarGlass, this.polishedRock, this.sigilE, this.glassblowingPipe, this.kegsOfBeer.quantity(2)));
        allSteps.add(new PanelDetails("Defending Rellekka", Arrays.asList(this.talkToBrundtBackInRellekka, this.killBasilisks, this.travelToIsleOfStone, this.talkToBrundtOutsidePuzzle, this.solvePuzzle, this.enterCaveToFight, this.fightTyphor, this.fightJormungand), this.combatGear));
        return allSteps;
    }
}

