/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.theforsakentower;

import com.questhelper.collections.ItemCollections;
import com.questhelper.helpers.quests.theforsakentower.AltarPuzzle;
import com.questhelper.helpers.quests.theforsakentower.JugPuzzle;
import com.questhelper.helpers.quests.theforsakentower.PotionPuzzle;
import com.questhelper.helpers.quests.theforsakentower.PowerPuzzle;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.Favour;
import com.questhelper.requirements.player.FavourRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.widget.WidgetModelRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.THE_FORSAKEN_TOWER)
public class TheForsakenTower
extends BasicQuestHelper {
    ItemRequirement crank;
    ItemRequirement oldNotes;
    ItemRequirement dinhsHammer;
    ItemRequirement gamesNecklace;
    Requirement inFirstFloor;
    Requirement inSecondFloor;
    Requirement inBasement;
    Requirement inspectedDisplayCase;
    Requirement finishedFurnacePuzzle;
    Requirement generatorStarted;
    Requirement powerPuzzleVisible;
    Requirement finishedPowerPuzzle;
    Requirement finishedPotionPuzzle;
    Requirement finishedAltarPuzzle;
    QuestStep talkToVulcana;
    QuestStep talkToUndor;
    QuestStep enterTheForsakenTower;
    QuestStep inspectDisplayCase;
    QuestStep goDownLadderToBasement;
    QuestStep searchCrate;
    QuestStep inspectGenerator;
    QuestStep inspectPowerGrid;
    QuestStep doPowerPuzzle;
    QuestStep goDownToGroundFloor;
    QuestStep goDownToFirstFloor;
    QuestStep getHammer;
    QuestStep goUpToGroundFloor;
    QuestStep returnToUndor;
    QuestStep returnToVulcana;
    PotionPuzzle potionPuzzle;
    JugPuzzle furnacePuzzleSteps;
    AltarPuzzle altarPuzzle;
    ConditionalStep powerPuzzle;
    Zone firstFloor;
    Zone secondFloor;
    Zone basement;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupRequirements();
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToVulcana);
        steps.put(1, this.talkToVulcana);
        steps.put(2, this.talkToUndor);
        steps.put(3, this.enterTheForsakenTower);
        this.powerPuzzle = new ConditionalStep((QuestHelper)this, this.goDownLadderToBasement, new Requirement[0]);
        this.powerPuzzle.addStep(this.powerPuzzleVisible, this.doPowerPuzzle);
        this.powerPuzzle.addStep(new Conditions(this.inBasement, this.generatorStarted), this.inspectPowerGrid);
        this.powerPuzzle.addStep(new Conditions(this.inBasement, this.crank), this.inspectGenerator);
        this.powerPuzzle.addStep(this.inBasement, this.searchCrate);
        this.powerPuzzle.addStep(this.inFirstFloor, this.goDownToGroundFloor);
        this.powerPuzzle.addStep(this.inSecondFloor, this.goDownToFirstFloor);
        this.powerPuzzle.setLockingCondition(this.finishedPowerPuzzle);
        ConditionalStep puzzleSteps = new ConditionalStep((QuestHelper)this, this.inspectDisplayCase, new Requirement[0]);
        puzzleSteps.addStep(new Conditions(this.inspectedDisplayCase, this.finishedFurnacePuzzle, this.finishedPowerPuzzle, this.finishedPotionPuzzle), this.altarPuzzle);
        puzzleSteps.addStep(new Conditions(this.inspectedDisplayCase, this.finishedFurnacePuzzle, this.finishedPowerPuzzle), this.potionPuzzle);
        puzzleSteps.addStep(new Conditions(this.inspectedDisplayCase, this.finishedFurnacePuzzle), this.powerPuzzle);
        puzzleSteps.addStep(this.inspectedDisplayCase, this.furnacePuzzleSteps);
        steps.put(4, puzzleSteps);
        steps.put(5, puzzleSteps);
        steps.put(6, puzzleSteps);
        steps.put(7, puzzleSteps);
        ConditionalStep gettingHammer = new ConditionalStep((QuestHelper)this, this.getHammer, new Requirement[0]);
        gettingHammer.addStep(this.dinhsHammer, this.returnToUndor);
        gettingHammer.addStep(this.inBasement, this.goUpToGroundFloor);
        gettingHammer.addStep(this.inFirstFloor, this.goDownToGroundFloor);
        gettingHammer.addStep(this.inSecondFloor, this.goDownToFirstFloor);
        steps.put(8, gettingHammer);
        steps.put(9, gettingHammer);
        steps.put(10, this.returnToVulcana);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.crank = new ItemRequirement("Generator crank", 22762);
        this.oldNotes = new ItemRequirement("Old notes", 22774);
        this.dinhsHammer = new ItemRequirement("Dinh's hammer", 22761);
        this.gamesNecklace = new ItemRequirement("Games necklace for accessing Wintertodt", ItemCollections.GAMES_NECKLACES);
    }

    public void setupConditions() {
        this.inFirstFloor = new ZoneRequirement(this.firstFloor);
        this.inSecondFloor = new ZoneRequirement(this.secondFloor);
        this.inBasement = new ZoneRequirement(this.basement);
        this.inspectedDisplayCase = new VarbitRequirement(7804, 1);
        this.finishedPowerPuzzle = new VarbitRequirement(7797, 4);
        this.finishedFurnacePuzzle = new VarbitRequirement(7798, 4);
        this.finishedPotionPuzzle = new VarbitRequirement(7799, 4);
        this.finishedAltarPuzzle = new VarbitRequirement(7800, 2);
        this.generatorStarted = new VarbitRequirement(7797, 2, Operation.GREATER_EQUAL);
        this.powerPuzzleVisible = new WidgetModelRequirement(624, 2, 0, 36246);
    }

    public void setupZones() {
        this.basement = new Zone(new WorldPoint(1374, 10217, 0), new WorldPoint(1389, 10231, 0));
        this.firstFloor = new Zone(new WorldPoint(1376, 3817, 1), new WorldPoint(1388, 3829, 1));
        this.secondFloor = new Zone(new WorldPoint(1377, 3821, 2), new WorldPoint(1386, 3828, 2));
    }

    public void setupSteps() {
        this.talkToVulcana = new NpcStep((QuestHelper)this, 10972, new WorldPoint(1483, 3747, 0), "Talk to Lady Vulcana Lovakengj in the south of Lovakengj.", new Requirement[0]);
        this.talkToVulcana.addDialogStep("I'm looking for a quest.");
        this.talkToVulcana.addDialogStep("I'll get going.");
        this.talkToUndor = new NpcStep((QuestHelper)this, 8544, new WorldPoint(1624, 3942, 0), "Talk to Undor at the entrance to Wintertodt. If you've never talked to Ignisia before, you'll need to talk to her first. She is just north east of Undor. You can teleport there using a Games Necklace, or run north through Arceuus.", new Requirement[0]);
        this.talkToUndor.addDialogStep("I've been sent to help you.");
        this.enterTheForsakenTower = new ObjectStep((QuestHelper)this, 33491, new WorldPoint(1382, 3817, 0), "Enter the Forsaken Tower, west of Lovakengj.", new Requirement[0]);
        this.inspectDisplayCase = new ObjectStep((QuestHelper)this, 34588, new WorldPoint(1382, 3821, 0), "Inspect the display case in the Forsaken Tower.", new Requirement[0]);
        this.goDownToFirstFloor = new ObjectStep((QuestHelper)this, 33485, new WorldPoint(1382, 3827, 2), "Go down from the top floor.", new Requirement[0]);
        this.goDownToGroundFloor = new ObjectStep((QuestHelper)this, 33552, new WorldPoint(1378, 3825, 1), "Go down to the ground floor.", new Requirement[0]);
        this.goUpToGroundFloor = new ObjectStep((QuestHelper)this, 33484, new WorldPoint(1382, 10229, 0), "Leave the tower's basement.", new Requirement[0]);
        this.furnacePuzzleSteps = new JugPuzzle(this);
        this.furnacePuzzleSteps.setLockingCondition(this.finishedFurnacePuzzle);
        this.furnacePuzzleSteps.setBlocker(true);
        this.goDownLadderToBasement = new ObjectStep((QuestHelper)this, 33483, new WorldPoint(1382, 3825, 0), "Climb down the ladder into the tower's basement.", new Requirement[0]);
        this.inspectPowerGrid = new ObjectStep((QuestHelper)this, 34590, new WorldPoint(1382, 10225, 0), "Inspect the power grid.", new Requirement[0]);
        this.inspectPowerGrid.addDialogStep("Yes.");
        this.searchCrate = new ObjectStep((QuestHelper)this, 33498, new WorldPoint(1387, 10228, 0), "Search a crate in the north eastern cell for a generator crank", new Requirement[0]);
        this.inspectGenerator = new ObjectStep((QuestHelper)this, 34589, new WorldPoint(1382, 10219, 0), "Inspect the steam generator in the south of the room", this.crank);
        this.inspectGenerator.addDialogStep("Start the generator.");
        this.doPowerPuzzle = new PowerPuzzle(this);
        this.potionPuzzle = new PotionPuzzle(this);
        this.potionPuzzle.setLockingCondition(this.finishedPotionPuzzle);
        this.altarPuzzle = new AltarPuzzle(this);
        this.altarPuzzle.setLockingCondition(this.finishedAltarPuzzle);
        this.getHammer = new ObjectStep((QuestHelper)this, 34588, new WorldPoint(1382, 3821, 0), "Get the hammer from the display case in the Forsaken Tower.", new Requirement[0]);
        this.returnToUndor = new NpcStep((QuestHelper)this, 8544, new WorldPoint(1624, 3942, 0), "Return Dinh's Hammer to Undor at the entrance to Wintertodt.", this.dinhsHammer);
        this.returnToUndor.addDialogStep("Let's talk about my quest.");
        this.returnToUndor.addDialogStep("Yes.");
        this.returnToVulcana = new NpcStep((QuestHelper)this, 10972, new WorldPoint(1483, 3747, 0), "Return to Lady Vulcana in south Lovakengj to finish the quest.", new Requirement[0]);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.gamesNecklace);
        return reqs;
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        return Arrays.asList(new FavourRequirement(Favour.LOVAKENGJ, 20), new QuestRequirement(QuestHelperQuest.X_MARKS_THE_SPOT, QuestState.FINISHED), new QuestRequirement(QuestHelperQuest.CLIENT_OF_KOUREND, QuestState.FINISHED));
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.MINING, 500), new ExperienceReward(Skill.SMITHING, 500));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Coins", 995, 6000), new ItemReward("Lovakenj Favour Certificate", 22760, 1), new ItemReward("A page for Kharedst's memoirs.", 21760, 1));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Arrays.asList(this.talkToVulcana, this.talkToUndor), new Requirement[0]));
        allSteps.add(new PanelDetails("To the Forsaken Tower", Arrays.asList(this.enterTheForsakenTower, this.inspectDisplayCase), new Requirement[0]));
        allSteps.addAll(this.furnacePuzzleSteps.panelDetails());
        PanelDetails powerPuzzlePanel = new PanelDetails("Power puzzle", Arrays.asList(this.goDownLadderToBasement, this.searchCrate, this.inspectGenerator, this.inspectPowerGrid, this.doPowerPuzzle), new Requirement[0]);
        powerPuzzlePanel.setLockingStep(this.powerPuzzle);
        allSteps.add(powerPuzzlePanel);
        allSteps.addAll(this.potionPuzzle.panelDetails());
        allSteps.addAll(this.altarPuzzle.panelDetails());
        allSteps.add(new PanelDetails("Finishing off", Arrays.asList(this.getHammer, this.returnToUndor, this.returnToVulcana), new Requirement[0]));
        return allSteps;
    }
}

