/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.theforsakentower;

import com.questhelper.QuestHelperPlugin;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.steps.QuestStep;
import java.awt.Color;
import java.awt.Graphics2D;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.client.eventbus.Subscribe;

public class PowerPuzzle
extends QuestStep {
    int[] solvedPositions = new int[]{0, 0, 1, 0, 4, 1, 3, 0, 4, 3, 0, 1, 0, 3, 4, 3, 3, 1, 1, 4, 2, 0, 2, 2, 2, 3, 2, 0, 0, 1, 3, 4, 4, 0, 1, 2};
    boolean[] currentPositionCorrect = new boolean[36];

    public PowerPuzzle(QuestHelper questHelper) {
        super(questHelper, "Click the highlighted boxes to turn the squares to solve the puzzle.");
    }

    @Override
    public void startUp() {
        this.updateSolvedPositionState();
    }

    @Override
    @Subscribe
    public void onVarbitChanged(VarbitChanged varbitChanged) {
        this.updateSolvedPositionState();
    }

    private void updateSolvedPositionState() {
        for (int i = 0; i < 36; ++i) {
            int currentPos = this.client.getVarbitValue(7811 + i);
            this.currentPositionCorrect[i] = this.solvedPositions[i] == 4 ? currentPos == 0 || currentPos == 2 : this.client.getVarbitValue(7811 + i) == this.solvedPositions[i];
        }
    }

    @Override
    public void makeWidgetOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
        super.makeWidgetOverlayHint(graphics, plugin);
        Widget widgetWrapper = this.client.getWidget(624, 2);
        if (widgetWrapper != null) {
            for (int i = 0; i < 36; ++i) {
                Widget widget = widgetWrapper.getChild(i);
                if (widget == null || this.currentPositionCorrect[i]) continue;
                graphics.setColor(new Color(this.questHelper.getConfig().targetOverlayColor().getRed(), this.questHelper.getConfig().targetOverlayColor().getGreen(), this.questHelper.getConfig().targetOverlayColor().getBlue(), 65));
                graphics.fill(widget.getBounds());
                graphics.setColor(this.questHelper.getConfig().targetOverlayColor());
                graphics.draw(widget.getBounds());
            }
        }
    }
}

