/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.theforsakentower;

import com.google.inject.Inject;
import com.questhelper.QuestHelperPlugin;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.OwnerStep;
import com.questhelper.steps.QuestStep;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.runelite.api.Client;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.ui.overlay.components.PanelComponent;

public class PotionPuzzle
extends QuestStep
implements OwnerStep {
    @Inject
    protected EventBus eventBus;
    @Inject
    protected Client client;
    private static final Pattern LINE1 = Pattern.compile("^(.*) is directly left of");
    private static final Pattern LINE2 = Pattern.compile("^(.*) is next to (.*)[.]");
    private static final Pattern LINE3 = Pattern.compile("^(.*) is directly right of (.*)[.]");
    private static final String CLEANSING_FLUID = "Cleansing fluid";
    private boolean fluidFound;
    private int correctFluid = -1;
    protected QuestStep currentStep;
    ItemRequirement oldNotes;
    ItemRequirement fluid1;
    ItemRequirement fluid2;
    ItemRequirement fluid3;
    ItemRequirement fluid4;
    ItemRequirement fluid5;
    ItemRequirement[] fluids;
    Requirement inFirstFloor;
    Requirement inBasement;
    Requirement triedToActivate;
    Requirement cleanedRefinery;
    Requirement inSecondFloor;
    Requirement[] hasFluids;
    DetailedQuestStep goUpLadder;
    DetailedQuestStep goUpStairs;
    DetailedQuestStep goDownToFirstFloor;
    DetailedQuestStep searchPotionCupboard;
    DetailedQuestStep inspectRefinery;
    DetailedQuestStep readNote;
    DetailedQuestStep getFluid;
    DetailedQuestStep useFluidOnRefinery;
    DetailedQuestStep activateRefinery;
    Zone firstFloor;
    Zone basement;
    Zone secondFloor;

    public PotionPuzzle(QuestHelper questHelper) {
        super(questHelper, "");
        this.setupItemRequirements();
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
    }

    @Override
    public void startUp() {
        this.updateSteps();
    }

    @Override
    public void shutDown() {
        this.shutDownStep();
        this.currentStep = null;
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.updateSteps();
    }

    protected void updateSteps() {
        if (this.inBasement.check(this.client)) {
            this.startUpStep(this.goUpLadder);
        } else if (this.inSecondFloor.check(this.client)) {
            this.startUpStep(this.goDownToFirstFloor);
        } else if (this.inFirstFloor.check(this.client)) {
            if (this.cleanedRefinery.check(this.client)) {
                this.startUpStep(this.activateRefinery);
            } else if (!this.triedToActivate.check(this.client)) {
                this.startUpStep(this.inspectRefinery);
            } else if (this.correctFluid != -1) {
                if (!this.fluidFound) {
                    this.getFluid.addWidgetChoice(this.correctFluid - 1, 187, 3);
                    this.getFluid.setText("Take Fluid " + this.correctFluid + " from the table.");
                    this.useFluidOnRefinery.addRequirement((Requirement)this.fluids[this.correctFluid]);
                    this.useFluidOnRefinery.addIcon(this.fluids[this.correctFluid].getId());
                    this.fluidFound = true;
                }
                if (this.hasFluids[this.correctFluid].check(this.client)) {
                    this.startUpStep(this.useFluidOnRefinery);
                } else {
                    this.startUpStep(this.getFluid);
                }
            } else if (this.oldNotes.check(this.client)) {
                this.startUpStep(this.readNote);
            } else {
                this.startUpStep(this.searchPotionCupboard);
            }
        } else {
            this.startUpStep(this.goUpStairs);
        }
    }

    protected void startUpStep(QuestStep step) {
        if (this.currentStep == null) {
            this.currentStep = step;
            this.eventBus.register((Object)this.currentStep);
            this.currentStep.startUp();
            return;
        }
        if (!step.equals(this.currentStep)) {
            this.shutDownStep();
            this.eventBus.register((Object)step);
            step.startUp();
            this.currentStep = step;
        }
    }

    protected void shutDownStep() {
        if (this.currentStep != null) {
            this.eventBus.unregister((Object)this.currentStep);
            this.currentStep.shutDown();
            this.currentStep = null;
        }
    }

    @Override
    public void makeOverlayHint(PanelComponent panelComponent, QuestHelperPlugin plugin, List<String> additionalText, List<Requirement> requirements) {
        if (this.currentStep != null) {
            this.currentStep.makeOverlayHint(panelComponent, plugin, additionalText, requirements);
        }
    }

    @Override
    public void makeWorldOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
        if (this.currentStep != null) {
            this.currentStep.makeWorldOverlayHint(graphics, plugin);
        }
    }

    @Override
    public void makeWorldArrowOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
        if (this.currentStep != null) {
            this.currentStep.makeWorldArrowOverlayHint(graphics, plugin);
        }
    }

    @Override
    public void makeWorldLineOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
        if (this.currentStep != null) {
            this.currentStep.makeWorldLineOverlayHint(graphics, plugin);
        }
    }

    @Override
    public QuestStep getActiveStep() {
        if (this.currentStep != this) {
            return this.currentStep.getActiveStep();
        }
        return this;
    }

    private void setupItemRequirements() {
        this.oldNotes = new ItemRequirement("Old notes", 22774);
        this.oldNotes.setHighlightInInventory(true);
        this.fluid1 = new ItemRequirement("Unknown fluid 1", 22769);
        this.fluid1.setHighlightInInventory(true);
        this.fluid2 = new ItemRequirement("Unknown fluid 2", 22770);
        this.fluid2.setHighlightInInventory(true);
        this.fluid3 = new ItemRequirement("Unknown fluid 3", 22771);
        this.fluid3.setHighlightInInventory(true);
        this.fluid4 = new ItemRequirement("Unknown fluid 4", 22772);
        this.fluid4.setHighlightInInventory(true);
        this.fluid5 = new ItemRequirement("Unknown fluid 5", 22773);
        this.fluid5.setHighlightInInventory(true);
        this.fluids = new ItemRequirement[]{null, this.fluid1, this.fluid2, this.fluid3, this.fluid4, this.fluid5};
    }

    private void setupConditions() {
        this.inFirstFloor = new ZoneRequirement(this.firstFloor);
        this.inSecondFloor = new ZoneRequirement(this.secondFloor);
        this.inBasement = new ZoneRequirement(this.basement);
        this.triedToActivate = new VarbitRequirement(7799, 2);
        this.cleanedRefinery = new VarbitRequirement(7799, 3);
        this.hasFluids = new Requirement[]{null, this.fluid1, this.fluid2, this.fluid3, this.fluid4, this.fluid5};
    }

    private void setupZones() {
        this.basement = new Zone(new WorldPoint(1374, 10217, 0), new WorldPoint(1389, 10231, 0));
        this.firstFloor = new Zone(new WorldPoint(1376, 3817, 1), new WorldPoint(1388, 3829, 1));
        this.secondFloor = new Zone(new WorldPoint(1377, 3821, 2), new WorldPoint(1386, 3828, 2));
    }

    private void setupSteps() {
        this.goUpLadder = new ObjectStep(this.getQuestHelper(), 33484, new WorldPoint(1382, 10229, 0), "Leave the tower's basement.", new Requirement[0]);
        this.goUpStairs = new ObjectStep(this.getQuestHelper(), 33550, new WorldPoint(1378, 3825, 0), "Go to the tower's 1st floor.", new Requirement[0]);
        this.goDownToFirstFloor = new ObjectStep(this.getQuestHelper(), 33485, new WorldPoint(1382, 3827, 2), "Go down from the top floor.", new Requirement[0]);
        this.goUpStairs.addSubSteps(this.goUpLadder, this.goDownToFirstFloor);
        this.searchPotionCupboard = new ObjectStep(this.getQuestHelper(), 33522, new WorldPoint(1387, 3820, 1), "Search the cupboard on the east wall.", new Requirement[0]);
        this.inspectRefinery = new ObjectStep(this.getQuestHelper(), 34595, new WorldPoint(1382, 3819, 1), "Inspect the refinery.", new Requirement[0]);
        this.inspectRefinery.addDialogStep("Yes.");
        this.readNote = new DetailedQuestStep(this.getQuestHelper(), "Read the old notes", this.oldNotes);
        this.getFluid = new ObjectStep(this.getQuestHelper(), 34596, new WorldPoint(1382, 3826, 1), "Attempt to take the correct fluid from the table.", new Requirement[0]);
        this.useFluidOnRefinery = new ObjectStep(this.getQuestHelper(), 34595, new WorldPoint(1382, 3819, 1), "Use the fluid on the refinery.", new Requirement[0]);
        this.useFluidOnRefinery.addDialogStep("Yes.");
        this.activateRefinery = new ObjectStep(this.getQuestHelper(), 34595, new WorldPoint(1382, 3819, 1), "Activate the refinery.", new Requirement[0]);
        this.activateRefinery.addDialogStep("Yes.");
    }

    public List<PanelDetails> panelDetails() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        PanelDetails potionPanel = new PanelDetails("Potion puzzle", Arrays.asList(this.goUpStairs, this.inspectRefinery, this.searchPotionCupboard, this.readNote, this.getFluid, this.useFluidOnRefinery, this.activateRefinery), new Requirement[0]);
        potionPanel.setLockingStep(this);
        allSteps.add(potionPanel);
        return allSteps;
    }

    @Override
    public Collection<QuestStep> getSteps() {
        return Arrays.asList(this.goUpLadder, this.goUpStairs, this.goDownToFirstFloor, this.inspectRefinery, this.searchPotionCupboard, this.readNote, this.getFluid, this.useFluidOnRefinery, this.activateRefinery);
    }

    @Override
    @Subscribe
    public void onWidgetLoaded(WidgetLoaded widgetLoaded) {
        if (widgetLoaded.getGroupId() == 291) {
            Matcher matcher;
            Widget line3Widget;
            Matcher matcher2;
            Widget line2Widget;
            Matcher matcher3;
            Widget line1Widget = this.client.getWidget(291, 9);
            if (line1Widget != null && (matcher3 = LINE1.matcher(line1Widget.getText())).find() && matcher3.group(1).equals(CLEANSING_FLUID)) {
                this.correctFluid = 1;
            }
            if ((line2Widget = this.client.getWidget(291, 10)) != null && (matcher2 = LINE2.matcher(line2Widget.getText())).find()) {
                if (matcher2.group(1).equals(CLEANSING_FLUID)) {
                    this.correctFluid = 2;
                } else if (matcher2.group(2).equals(CLEANSING_FLUID)) {
                    this.correctFluid = 3;
                }
            }
            if ((line3Widget = this.client.getWidget(291, 11)) != null && (matcher = LINE3.matcher(line3Widget.getText())).find()) {
                if (matcher.group(1).equals(CLEANSING_FLUID)) {
                    this.correctFluid = 5;
                } else if (matcher.group(2).equals(CLEANSING_FLUID)) {
                    this.correctFluid = 4;
                }
            }
        }
    }
}

