/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.theforsakentower;

import com.google.inject.Inject;
import com.questhelper.QuestHelperPlugin;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.ItemRequirements;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.OwnerStep;
import com.questhelper.steps.QuestStep;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;
import net.runelite.api.Client;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.api.widgets.Widget;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.ui.overlay.components.PanelComponent;

public class JugPuzzle
extends QuestStep
implements OwnerStep {
    private static final Pattern JUG_VALUES_MATCHER = Pattern.compile("^You add ([0-9]) gallons* of coolant to your ([0-9])-gallon jug.(?: It now contains ([0-9]) gallons* of coolant[.])*(?: Your ([0-9])-gallon jug is left(?: (empty)| with ([0-9]) gallons* of coolant))*");
    private static final Pattern JUG_FILLED = Pattern.compile("^You fill up your ([0-9])-gallon jug");
    private static final Pattern JUG_EMPTIED = Pattern.compile("^You empty the ([0-9])-gallon jug");
    private static final Pattern JUG_CHECKED = Pattern.compile("^The ([0-9])-gallon jug(?: contains ([0-9]) gallons* of coolant| is empty)");
    @Inject
    protected EventBus eventBus;
    @Inject
    protected Client client;
    protected QuestStep currentStep;
    ItemRequirement tinderbox;
    ItemRequirement fiveGallon;
    ItemRequirement eightGallon;
    Requirement missingTinderbox;
    Requirement hasFilledWithFuel;
    Requirement inFirstFloor;
    Requirement inSecondFloor;
    Requirement inBasement;
    DetailedQuestStep syncStep;
    DetailedQuestStep searchCupboardTinderbox;
    DetailedQuestStep searchCupboardJug;
    DetailedQuestStep fill5Gallon;
    DetailedQuestStep use5GallonOn8;
    DetailedQuestStep fill5Gallon2;
    DetailedQuestStep use5GallonOn82;
    DetailedQuestStep empty8Gallon;
    DetailedQuestStep use5GallonOn83;
    DetailedQuestStep fill5Gallon3;
    DetailedQuestStep use5GallonOn84;
    DetailedQuestStep fill5Gallon4;
    DetailedQuestStep use5GallonOn85;
    DetailedQuestStep use5GallonOnFurnace;
    DetailedQuestStep lightFurnace;
    DetailedQuestStep restartPuzzle;
    DetailedQuestStep goUpToGroundFloor;
    DetailedQuestStep goDownToGroundFloor;
    DetailedQuestStep goDownToFirstFloor;
    Zone firstFloor;
    Zone secondFloor;
    Zone basement;
    private final HashMap<String, Integer> jugs = new HashMap();

    public JugPuzzle(QuestHelper questHelper) {
        super(questHelper, "");
        this.jugs.put("5", -1);
        this.jugs.put("8", -1);
        this.setupItemRequirements();
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
    }

    @Override
    public void startUp() {
        this.updateSteps();
    }

    @Override
    public void shutDown() {
        this.shutDownStep();
        this.currentStep = null;
    }

    @Subscribe
    public void onGameTick(GameTick ignoredEvent) {
        this.updateSteps();
    }

    protected void updateSteps() {
        Widget widget = this.client.getWidget(12648450);
        if (widget != null) {
            String text = widget.getText().replace("<br>", " ");
            Matcher jugOnJugMatcher = JUG_VALUES_MATCHER.matcher(text);
            Matcher jugEmptiedMatcher = JUG_EMPTIED.matcher(text);
            Matcher jugFilledMatcher = JUG_FILLED.matcher(text);
            Matcher jugCheckedMatcher = JUG_CHECKED.matcher(text);
            if (jugOnJugMatcher.find()) {
                String targetJug = jugOnJugMatcher.group(2);
                String sourceJug = jugOnJugMatcher.group(4);
                Integer amountAdded = Integer.parseInt(jugOnJugMatcher.group(1));
                if (jugOnJugMatcher.group(3) != null) {
                    this.jugs.put(targetJug, Integer.parseInt(jugOnJugMatcher.group(3)));
                } else {
                    this.jugs.put(targetJug, amountAdded);
                }
                if (jugOnJugMatcher.group(5) != null) {
                    this.jugs.put(sourceJug, 0);
                } else {
                    this.jugs.put(sourceJug, Integer.parseInt(jugOnJugMatcher.group(6)));
                }
            } else if (jugEmptiedMatcher.find()) {
                this.jugs.put(jugEmptiedMatcher.group(1), 0);
            } else if (jugFilledMatcher.find()) {
                this.jugs.put(jugFilledMatcher.group(1), Integer.parseInt(jugFilledMatcher.group(1)));
            } else if (jugCheckedMatcher.find()) {
                if (jugCheckedMatcher.group(2) == null) {
                    this.jugs.put(jugCheckedMatcher.group(1), 0);
                } else {
                    this.jugs.put(jugCheckedMatcher.group(1), Integer.parseInt(jugCheckedMatcher.group(2)));
                }
            }
        }
        if (!this.fiveGallon.check(this.client)) {
            this.jugs.put("5", 0);
        }
        if (!this.eightGallon.check(this.client)) {
            this.jugs.put("8", 0);
        }
        if (this.inBasement.check(this.client)) {
            this.startUpStep(this.goUpToGroundFloor);
        } else if (this.inFirstFloor.check(this.client)) {
            this.startUpStep(this.goDownToGroundFloor);
        } else if (this.inSecondFloor.check(this.client)) {
            this.startUpStep(this.goDownToFirstFloor);
        } else if (this.missingTinderbox.check(this.client)) {
            this.startUpStep(this.searchCupboardTinderbox);
        } else if (this.hasFilledWithFuel.check(this.client)) {
            this.startUpStep(this.lightFurnace);
        } else if (!this.fiveGallon.check(this.client) || !this.eightGallon.check(this.client)) {
            this.startUpStep(this.searchCupboardJug);
        } else if (this.jugs.get("5") == -1 && this.jugs.get("8") == -1) {
            this.startUpStep(this.syncStep);
        } else if (this.jugs.get("5") == 0 && this.jugs.get("8") == 0) {
            this.startUpStep(this.fill5Gallon);
        } else if (this.jugs.get("5") == 5 && this.jugs.get("8") == 0) {
            this.startUpStep(this.use5GallonOn8);
        } else if (this.jugs.get("5") == 0 && this.jugs.get("8") == 5) {
            this.startUpStep(this.fill5Gallon2);
        } else if (this.jugs.get("5") == 5 && this.jugs.get("8") == 5) {
            this.startUpStep(this.use5GallonOn82);
        } else if (this.jugs.get("5") == 2 && this.jugs.get("8") == 8) {
            this.startUpStep(this.empty8Gallon);
        } else if (this.jugs.get("5") == 2 && this.jugs.get("8") == 0) {
            this.startUpStep(this.use5GallonOn83);
        } else if (this.jugs.get("5") == 0 && this.jugs.get("8") == 2) {
            this.startUpStep(this.fill5Gallon3);
        } else if (this.jugs.get("5") == 5 && this.jugs.get("8") == 2) {
            this.startUpStep(this.use5GallonOn84);
        } else if (this.jugs.get("5") == 0 && this.jugs.get("8") == 7) {
            this.startUpStep(this.fill5Gallon4);
        } else if (this.jugs.get("5") == 5 && this.jugs.get("8") == 7) {
            this.startUpStep(this.use5GallonOn85);
        } else if (this.jugs.get("5") == 4) {
            this.startUpStep(this.use5GallonOnFurnace);
        } else {
            this.startUpStep(this.restartPuzzle);
        }
    }

    protected void startUpStep(QuestStep step) {
        if (this.currentStep == null) {
            this.currentStep = step;
            this.eventBus.register((Object)this.currentStep);
            this.currentStep.startUp();
            return;
        }
        if (!step.equals(this.currentStep)) {
            this.shutDownStep();
            this.eventBus.register((Object)step);
            step.startUp();
            this.currentStep = step;
        }
    }

    protected void shutDownStep() {
        if (this.currentStep != null) {
            this.eventBus.unregister((Object)this.currentStep);
            this.currentStep.shutDown();
            this.currentStep = null;
        }
    }

    @Override
    public void makeOverlayHint(PanelComponent panelComponent, QuestHelperPlugin plugin, @NonNull List<String> additionalText, @NonNull List<Requirement> requirements) {
        if (additionalText == null) {
            throw new NullPointerException("additionalText is marked @NonNull but is null");
        }
        if (requirements == null) {
            throw new NullPointerException("requirements is marked @NonNull but is null");
        }
        if (this.currentStep != null) {
            this.currentStep.makeOverlayHint(panelComponent, plugin, additionalText, requirements);
        }
    }

    @Override
    public void makeWorldOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
        if (this.currentStep != null) {
            this.currentStep.makeWorldOverlayHint(graphics, plugin);
        }
    }

    @Override
    public void makeWorldArrowOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
        if (this.currentStep != null) {
            this.currentStep.makeWorldArrowOverlayHint(graphics, plugin);
        }
    }

    @Override
    public void makeWorldLineOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
        if (this.currentStep != null) {
            this.currentStep.makeWorldLineOverlayHint(graphics, plugin);
        }
    }

    @Override
    public QuestStep getActiveStep() {
        if (this.currentStep != null) {
            return this.currentStep.getActiveStep();
        }
        return this;
    }

    private void setupItemRequirements() {
        this.tinderbox = new ItemRequirement("Tinderbox", 590);
        this.fiveGallon = new ItemRequirement("5-gallon jug", 22764);
        this.fiveGallon.setHighlightInInventory(true);
        this.eightGallon = new ItemRequirement("8-gallon jug", 22763);
        this.eightGallon.setHighlightInInventory(true);
    }

    private void setupZones() {
        this.basement = new Zone(new WorldPoint(1374, 10217, 0), new WorldPoint(1389, 10231, 0));
        this.firstFloor = new Zone(new WorldPoint(1376, 3817, 1), new WorldPoint(1388, 3829, 1));
        this.secondFloor = new Zone(new WorldPoint(1377, 3821, 2), new WorldPoint(1386, 3828, 2));
    }

    private void setupConditions() {
        this.missingTinderbox = new ItemRequirements(LogicType.NAND, this.tinderbox);
        this.hasFilledWithFuel = new VarbitRequirement(7798, 3);
        this.inFirstFloor = new ZoneRequirement(this.firstFloor);
        this.inSecondFloor = new ZoneRequirement(this.secondFloor);
        this.inBasement = new ZoneRequirement(this.basement);
    }

    private void setupSteps() {
        this.syncStep = new DetailedQuestStep(this.getQuestHelper(), "Please check both the jugs to continue.", new Requirement[0]);
        this.searchCupboardTinderbox = new ObjectStep(this.getQuestHelper(), 33515, new WorldPoint(1381, 3829, 0), "Search the cupboard on the north wall for a tinderbox.", new Requirement[0]);
        this.searchCupboardJug = new ObjectStep(this.getQuestHelper(), 33514, new WorldPoint(1378, 3826, 0), "Search the cupboard in the south east corner of the north room for a 5 and an 8 gallon jug.", new Requirement[0]);
        this.searchCupboardJug.addDialogStep("Take both.");
        this.fill5Gallon = new ObjectStep(this.getQuestHelper(), 34593, new WorldPoint(1377, 3828, 0), "Fill the 5-gallon jug on the Coolant Dispenser.", this.fiveGallon);
        this.fill5Gallon.addDialogStep("5-gallon jug.");
        this.use5GallonOn8 = new DetailedQuestStep(this.getQuestHelper(), "Use the 5-gallon jug on the 8-gallon jug.", this.fiveGallon, this.eightGallon);
        this.fill5Gallon2 = new ObjectStep(this.getQuestHelper(), 34593, new WorldPoint(1377, 3828, 0), "Fill the 5-gallon jug on the Coolant Dispenser.", this.fiveGallon);
        this.fill5Gallon2.addDialogStep("5-gallon jug.");
        this.use5GallonOn82 = new DetailedQuestStep(this.getQuestHelper(), "Use the 5-gallon jug on the 8-gallon jug.", this.fiveGallon, this.eightGallon);
        this.empty8Gallon = new DetailedQuestStep(this.getQuestHelper(), "Check the 8-gallon jug and empty it.", new Requirement[0]);
        this.use5GallonOn83 = new DetailedQuestStep(this.getQuestHelper(), "Use the 5-gallon jug on the 8-gallon jug.", this.fiveGallon, this.eightGallon);
        this.fill5Gallon3 = new ObjectStep(this.getQuestHelper(), 34593, new WorldPoint(1377, 3828, 0), "Fill the 5-gallon jug on the Coolant Dispenser.", this.fiveGallon);
        this.fill5Gallon3.addDialogStep("5-gallon jug.");
        this.use5GallonOn84 = new DetailedQuestStep(this.getQuestHelper(), "Use the 5-gallon jug on the 8-gallon jug.", this.fiveGallon, this.eightGallon);
        this.fill5Gallon4 = new ObjectStep(this.getQuestHelper(), 34593, new WorldPoint(1377, 3828, 0), "Fill the 5-gallon jug on the Coolant Dispenser.", this.fiveGallon);
        this.fill5Gallon4.addDialogStep("5-gallon jug.");
        this.use5GallonOn85 = new DetailedQuestStep(this.getQuestHelper(), "Use the 5-gallon jug on the 8-gallon jug.", this.fiveGallon, this.eightGallon);
        this.use5GallonOnFurnace = new ObjectStep(this.getQuestHelper(), 34594, new WorldPoint(1383, 3829, 0), "Use the 5-gallon jug, which should contain 4 gallons, on the Furnace Coolant.", this.fiveGallon);
        this.restartPuzzle = new DetailedQuestStep(this.getQuestHelper(), "Unknown puzzle state. Empty both the jugs to continue.", new Requirement[0]);
        this.lightFurnace = new ObjectStep(this.getQuestHelper(), 34591, new WorldPoint(1385, 3829, 0), "Light the furnace.", this.tinderbox);
        this.goDownToFirstFloor = new ObjectStep(this.getQuestHelper(), 33485, new WorldPoint(1382, 3827, 2), "Go down from the top floor.", new Requirement[0]);
        this.goDownToGroundFloor = new ObjectStep(this.getQuestHelper(), 33552, new WorldPoint(1378, 3825, 1), "Go down to the ground floor.", new Requirement[0]);
        this.goUpToGroundFloor = new ObjectStep(this.getQuestHelper(), 33484, new WorldPoint(1382, 10229, 0), "Leave the tower's basement.", new Requirement[0]);
    }

    public List<PanelDetails> panelDetails() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        PanelDetails furnacePanel = new PanelDetails("Furnace puzzle", Arrays.asList(this.searchCupboardTinderbox, this.searchCupboardJug, this.fill5Gallon, this.use5GallonOn8, this.fill5Gallon2, this.use5GallonOn82, this.empty8Gallon, this.use5GallonOn83, this.fill5Gallon3, this.use5GallonOn84, this.fill5Gallon4, this.use5GallonOn85, this.use5GallonOnFurnace, this.lightFurnace), new Requirement[0]);
        furnacePanel.setLockingStep(this);
        allSteps.add(furnacePanel);
        return allSteps;
    }

    @Override
    public Collection<QuestStep> getSteps() {
        return Arrays.asList(this.syncStep, this.searchCupboardTinderbox, this.searchCupboardJug, this.fill5Gallon, this.use5GallonOn8, this.fill5Gallon2, this.use5GallonOn82, this.empty8Gallon, this.use5GallonOn83, this.fill5Gallon3, this.use5GallonOn84, this.fill5Gallon4, this.use5GallonOn85, this.use5GallonOnFurnace, this.restartPuzzle, this.lightFurnace, this.goUpToGroundFloor, this.goDownToFirstFloor, this.goDownToGroundFloor);
    }
}

