/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.theforsakentower;

import com.google.inject.Inject;
import com.questhelper.QuestHelperPlugin;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.OwnerStep;
import com.questhelper.steps.QuestStep;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import lombok.NonNull;
import net.runelite.api.Client;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.ui.overlay.components.PanelComponent;

public class AltarPuzzle
extends QuestStep
implements OwnerStep {
    @Inject
    protected EventBus eventBus;
    @Inject
    protected Client client;
    private QuestStep currentStep;
    ItemRequirement ring1;
    ItemRequirement ring2;
    ItemRequirement ring3;
    ItemRequirement ring4;
    Zone secondFloor;
    Zone floor1;
    Zone basement;
    Requirement inSecondFloor;
    Requirement inFloor1;
    Requirement inBasement;
    DetailedQuestStep goUpLadder;
    DetailedQuestStep goUpStairs;
    DetailedQuestStep goUpToSecondFloor;
    DetailedQuestStep restartStep;
    DetailedQuestStep m1;
    DetailedQuestStep m2;
    DetailedQuestStep m3;
    DetailedQuestStep m4;
    DetailedQuestStep m5;
    DetailedQuestStep m6;
    DetailedQuestStep m7;
    DetailedQuestStep m8;
    DetailedQuestStep m9;
    DetailedQuestStep m10;
    DetailedQuestStep m11;
    DetailedQuestStep m12;
    DetailedQuestStep m13;
    DetailedQuestStep m14;
    DetailedQuestStep m15;
    ArrayList<DetailedQuestStep> rebalanceW = new ArrayList();
    ArrayList<DetailedQuestStep> rebalanceE = new ArrayList();
    ArrayList<DetailedQuestStep> rebalanceC = new ArrayList();

    public AltarPuzzle(QuestHelper questHelper) {
        super(questHelper, "");
        this.setupItemRequirements();
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
    }

    @Override
    public void startUp() {
        this.updateSteps();
    }

    @Override
    public void shutDown() {
        this.shutDownStep();
        this.currentStep = null;
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.updateSteps();
    }

    protected void updateSteps() {
        if (this.inBasement.check(this.client)) {
            this.startUpStep(this.goUpLadder);
        } else if (this.inFloor1.check(this.client)) {
            this.startUpStep(this.goUpToSecondFloor);
        } else if (this.inSecondFloor.check(this.client)) {
            int currentW = this.client.getVarbitValue(7847);
            int currentC = this.client.getVarbitValue(7848);
            int currentE = this.client.getVarbitValue(7849);
            if (currentW == 15) {
                this.startUpStep(this.rebalanceW.get(0));
            } else if (currentW == 14 && currentC == 0 && currentE == 0) {
                this.startUpStep(this.rebalanceE.get(0));
            } else if (currentW == 14 && currentC == 0 && currentE == 1) {
                this.startUpStep(this.rebalanceW.get(1));
            } else if (currentW == 12 && currentC == 0 && currentE == 1) {
                this.startUpStep(this.rebalanceC.get(0));
            } else if (currentW == 12 && currentC == 2 && currentE == 1) {
                this.startUpStep(this.rebalanceE.get(1));
            } else if (currentW == 12 && currentC == 2 && currentE == 0) {
                this.startUpStep(this.rebalanceC.get(1));
            } else if (currentW == 12 && currentC == 3 && currentE == 0) {
                this.startUpStep(this.rebalanceW.get(2));
            } else if (currentW == 8 && currentC == 3 && currentE == 0) {
                this.startUpStep(this.rebalanceE.get(2));
            } else if (currentW == 8 && currentC == 3 && currentE == 4) {
                this.startUpStep(this.rebalanceC.get(2));
            } else if (currentW == 8 && currentC == 2 && currentE == 4) {
                this.startUpStep(this.rebalanceW.get(3));
            } else if (currentW == 9 && currentC == 2 && currentE == 4) {
                this.startUpStep(this.rebalanceC.get(3));
            } else if (currentW == 9 && currentC == 0 && currentE == 4) {
                this.startUpStep(this.rebalanceE.get(3));
            } else if (currentW == 9 && currentC == 0 && currentE == 6) {
                this.startUpStep(this.rebalanceW.get(4));
            } else if (currentW == 8 && currentC == 0 && currentE == 6) {
                this.startUpStep(this.rebalanceE.get(4));
            } else if (currentW == 8 && currentC == 0 && currentE == 7) {
                this.startUpStep(this.rebalanceW.get(5));
            } else if (currentW == 0 && currentC == 0 && currentE == 7) {
                this.startUpStep(this.rebalanceC.get(4));
            } else if (currentW == 0 && currentC == 8 && currentE == 7) {
                this.startUpStep(this.rebalanceE.get(5));
            } else if (currentW == 0 && currentC == 8 && currentE == 6) {
                this.startUpStep(this.rebalanceC.get(5));
            } else if (currentW == 0 && currentC == 9 && currentE == 6) {
                this.startUpStep(this.rebalanceE.get(6));
            } else if (currentW == 0 && currentC == 9 && currentE == 4) {
                this.startUpStep(this.rebalanceW.get(6));
            } else if (currentW == 2 && currentC == 9 && currentE == 4) {
                this.startUpStep(this.rebalanceC.get(6));
            } else if (currentW == 2 && currentC == 8 && currentE == 4) {
                this.startUpStep(this.rebalanceW.get(7));
            } else if (currentW == 3 && currentC == 8 && currentE == 4) {
                this.startUpStep(this.rebalanceE.get(7));
            } else if (currentW == 3 && currentC == 8 && currentE == 0) {
                this.startUpStep(this.rebalanceC.get(7));
            } else if (currentW == 3 && currentC == 12 && currentE == 0) {
                this.startUpStep(this.rebalanceW.get(8));
            } else if (currentW == 2 && currentC == 12 && currentE == 0) {
                this.startUpStep(this.rebalanceE.get(8));
            } else if (currentW == 2 && currentC == 12 && currentE == 1) {
                this.startUpStep(this.rebalanceW.get(9));
            } else if (currentW == 0 && currentC == 12 && currentE == 1) {
                this.startUpStep(this.rebalanceC.get(8));
            } else if (currentW == 0 && currentC == 14 && currentE == 1) {
                this.startUpStep(this.rebalanceE.get(9));
            } else if (currentW == 0 && currentC == 14 && currentE == 0) {
                this.startUpStep(this.rebalanceC.get(9));
            } else {
                this.startUpStep(this.restartStep);
            }
        } else {
            this.startUpStep(this.goUpStairs);
        }
    }

    protected void startUpStep(QuestStep step) {
        if (this.currentStep == null) {
            this.currentStep = step;
            this.eventBus.register((Object)this.currentStep);
            this.currentStep.startUp();
            return;
        }
        if (!step.equals(this.currentStep)) {
            this.shutDownStep();
            this.eventBus.register((Object)step);
            step.startUp();
            this.currentStep = step;
        }
    }

    protected void shutDownStep() {
        if (this.currentStep != this) {
            this.eventBus.unregister((Object)this.currentStep);
            this.currentStep.shutDown();
            this.currentStep = null;
        }
    }

    @Override
    public void makeOverlayHint(PanelComponent panelComponent, QuestHelperPlugin plugin, @NonNull List<String> additionalText, @NonNull List<Requirement> requirements) {
        if (additionalText == null) {
            throw new NullPointerException("additionalText is marked @NonNull but is null");
        }
        if (requirements == null) {
            throw new NullPointerException("requirements is marked @NonNull but is null");
        }
        if (this.currentStep != null) {
            this.currentStep.makeOverlayHint(panelComponent, plugin, additionalText, requirements);
        }
    }

    @Override
    public void makeWorldOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
        if (this.currentStep != null) {
            this.currentStep.makeWorldOverlayHint(graphics, plugin);
        }
    }

    @Override
    public void makeWorldArrowOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
        if (this.currentStep != null) {
            this.currentStep.makeWorldArrowOverlayHint(graphics, plugin);
        }
    }

    @Override
    public void makeWorldLineOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
        if (this.currentStep != null) {
            this.currentStep.makeWorldLineOverlayHint(graphics, plugin);
        }
    }

    @Override
    public QuestStep getActiveStep() {
        if (this.currentStep != this) {
            return this.currentStep.getActiveStep();
        }
        return this;
    }

    private void setupItemRequirements() {
        this.ring1 = new ItemRequirement("Energy disk (level 1)", 22768);
        this.ring2 = new ItemRequirement("Energy disk (level 2)", 22767);
        this.ring3 = new ItemRequirement("Energy disk (level 3)", 22766);
        this.ring4 = new ItemRequirement("Energy disk (level 4)", 22765);
    }

    private void setupConditions() {
        this.inSecondFloor = new ZoneRequirement(this.secondFloor);
        this.inFloor1 = new ZoneRequirement(this.floor1);
        this.inBasement = new ZoneRequirement(this.basement);
    }

    private void setupZones() {
        this.secondFloor = new Zone(new WorldPoint(1377, 3821, 2), new WorldPoint(1386, 3828, 2));
        this.floor1 = new Zone(new WorldPoint(1376, 3817, 1), new WorldPoint(1388, 3829, 1));
        this.basement = new Zone(new WorldPoint(1374, 10217, 0), new WorldPoint(1389, 10231, 0));
    }

    private void setupSteps() {
        this.goUpLadder = new ObjectStep(this.getQuestHelper(), 33484, new WorldPoint(1382, 10229, 0), "Leave the tower's basement.", new Requirement[0]);
        this.goUpStairs = new ObjectStep(this.getQuestHelper(), 33550, new WorldPoint(1378, 3825, 0), "Climb up the staircase to the tower's 1st floor.", new Requirement[0]);
        this.goUpToSecondFloor = new ObjectStep(this.getQuestHelper(), 33486, new WorldPoint(1382, 3827, 1), "Climb up the ladder to the top floor.", new Requirement[0]);
        for (int i = 0; i < 10; ++i) {
            this.rebalanceW.add(new ObjectStep(this.getQuestHelper(), 34598, new WorldPoint(1380, 3824, 2), "Rebalance the west pylon.", new Requirement[0]));
            this.rebalanceC.add(new ObjectStep(this.getQuestHelper(), 34599, new WorldPoint(1382, 3824, 2), "Rebalance the central pylon.", new Requirement[0]));
            this.rebalanceE.add(new ObjectStep(this.getQuestHelper(), 34600, new WorldPoint(1384, 3824, 2), "Rebalance the east pylon.", new Requirement[0]));
        }
        this.m1 = new DetailedQuestStep(this.getQuestHelper(), "Move a disc from the west pylon to the east pylon.", new Requirement[0]);
        this.m1.addSubSteps(this.rebalanceW.get(0), this.rebalanceE.get(0));
        this.m2 = new DetailedQuestStep(this.getQuestHelper(), "Move a disc from the west pylon to the centre pylon.", new Requirement[0]);
        this.m2.addSubSteps(this.rebalanceW.get(1), this.rebalanceC.get(0));
        this.m3 = new DetailedQuestStep(this.getQuestHelper(), "Move a disc from the east pylon to the centre pylon.", new Requirement[0]);
        this.m3.addSubSteps(this.rebalanceE.get(1), this.rebalanceC.get(1));
        this.m4 = new DetailedQuestStep(this.getQuestHelper(), "Move a disc from the west pylon to the east pylon.", new Requirement[0]);
        this.m4.addSubSteps(this.rebalanceW.get(2), this.rebalanceE.get(2));
        this.m5 = new DetailedQuestStep(this.getQuestHelper(), "Move a disc from the centre pylon to the west pylon.", new Requirement[0]);
        this.m5.addSubSteps(this.rebalanceC.get(2), this.rebalanceW.get(3));
        this.m6 = new DetailedQuestStep(this.getQuestHelper(), "Move a disc from the centre pylon to the east pylon.", new Requirement[0]);
        this.m6.addSubSteps(this.rebalanceC.get(3), this.rebalanceE.get(3));
        this.m7 = new DetailedQuestStep(this.getQuestHelper(), "Move a disc from the west pylon to the east pylon.", new Requirement[0]);
        this.m7.addSubSteps(this.rebalanceW.get(4), this.rebalanceE.get(4));
        this.m8 = new DetailedQuestStep(this.getQuestHelper(), "Move a disc from the west pylon to the centre pylon.", new Requirement[0]);
        this.m8.addSubSteps(this.rebalanceW.get(5), this.rebalanceC.get(4));
        this.m9 = new DetailedQuestStep(this.getQuestHelper(), "Move a disc from the east pylon to the centre pylon.", new Requirement[0]);
        this.m9.addSubSteps(this.rebalanceE.get(5), this.rebalanceC.get(5));
        this.m10 = new DetailedQuestStep(this.getQuestHelper(), "Move a disc from the east pylon to the west pylon.", new Requirement[0]);
        this.m10.addSubSteps(this.rebalanceE.get(6), this.rebalanceW.get(6));
        this.m11 = new DetailedQuestStep(this.getQuestHelper(), "Move a disc from the centre pylon to the west pylon.", new Requirement[0]);
        this.m11.addSubSteps(this.rebalanceC.get(6), this.rebalanceW.get(7));
        this.m12 = new DetailedQuestStep(this.getQuestHelper(), "Move a disc from the east pylon to the centre pylon.", new Requirement[0]);
        this.m12.addSubSteps(this.rebalanceE.get(7), this.rebalanceC.get(7));
        this.m13 = new DetailedQuestStep(this.getQuestHelper(), "Move a disc from the west pylon to the east pylon.", new Requirement[0]);
        this.m13.addSubSteps(this.rebalanceW.get(8), this.rebalanceE.get(8));
        this.m14 = new DetailedQuestStep(this.getQuestHelper(), "Move a disc from the west pylon to the centre pylon.", new Requirement[0]);
        this.m14.addSubSteps(this.rebalanceW.get(9), this.rebalanceC.get(8));
        this.m15 = new DetailedQuestStep(this.getQuestHelper(), "Move a disc from the east pylon to the centre pylon.", new Requirement[0]);
        this.m15.addSubSteps(this.rebalanceE.get(9), this.rebalanceC.get(9));
        this.restartStep = new DetailedQuestStep(this.getQuestHelper(), "Unknown state. Restart the puzzle to start again.", new Requirement[0]);
    }

    public List<PanelDetails> panelDetails() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        PanelDetails potionPanel = new PanelDetails("Altar puzzle", Arrays.asList(this.goUpToSecondFloor, this.m1, this.m2, this.m3, this.m4, this.m5, this.m6, this.m7, this.m8, this.m9, this.m10, this.m11, this.m12, this.m13, this.m14, this.m15), new Requirement[0]);
        potionPanel.setLockingStep(this);
        allSteps.add(potionPanel);
        return allSteps;
    }

    @Override
    public Collection<QuestStep> getSteps() {
        ArrayList<QuestStep> steps = new ArrayList<QuestStep>();
        steps.addAll(this.rebalanceC);
        steps.addAll(this.rebalanceW);
        steps.addAll(this.rebalanceE);
        steps.addAll(Arrays.asList(this.goUpLadder, this.goUpStairs, this.goUpToSecondFloor, this.restartStep));
        return steps;
    }
}

