/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.theeyesofglouphrie;

import com.questhelper.collections.ItemCollections;
import com.questhelper.helpers.quests.theeyesofglouphrie.PuzzleStep;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.THE_EYES_OF_GLOUPHRIE)
public class TheEyesOfGlouphrie
extends BasicQuestHelper {
    ItemRequirement bucketOfSap;
    ItemRequirement mudRune;
    ItemRequirement mapleLog;
    ItemRequirement oakLog;
    ItemRequirement hammer;
    ItemRequirement saw;
    ItemRequirement pestleAndMortar;
    ItemRequirement groundMud;
    ItemRequirement magicGlue;
    ItemRequirement mudRuneHighlight;
    ItemRequirement pestleHighlight;
    ItemRequirement bucketOfSapHiglight;
    Requirement inCave;
    Requirement inspectedMachine;
    Requirement inspectedBowl;
    Requirement inHazelmereHut;
    Requirement killedCreature1;
    Requirement killedCreature2;
    Requirement killedCreature3;
    Requirement killedCreature4;
    Requirement killedCreature5;
    Requirement killedCreature6;
    Requirement inFloor1;
    Requirement inFloor2;
    Requirement inFloor3;
    QuestStep enterCave;
    QuestStep talkToBrimstail;
    QuestStep inspectBowl;
    QuestStep inspectMachine;
    QuestStep talkToBrimstailAgain;
    QuestStep goUpToHazelmere;
    QuestStep talkToHazelmere;
    QuestStep enterCaveAgain;
    QuestStep talkToBrimstailAfterHazelmere;
    QuestStep grindMudRunes;
    QuestStep useMudOnSap;
    QuestStep repairMachine;
    QuestStep talkToBrimstailAfterRepairing;
    QuestStep talkToBrimstailForMoreDisks;
    QuestStep operateMachine;
    QuestStep killCreature1;
    QuestStep talkToBrimstailAfterIllusion;
    QuestStep killCreature2;
    QuestStep killCreature3;
    QuestStep killCreature4;
    QuestStep killCreature5;
    QuestStep killCreature6;
    QuestStep climbUpToF1Tree;
    QuestStep climbUpToF2Tree;
    QuestStep climbUpToF3Tree;
    QuestStep talkToNarnode;
    PuzzleStep unlockMachine;
    Zone cave;
    Zone hazelmereHut;
    Zone floor1;
    Zone floor2;
    Zone floor3;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupRequirements();
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        ConditionalStep startQuest = new ConditionalStep((QuestHelper)this, this.enterCave, new Requirement[0]);
        startQuest.addStep(this.inCave, this.talkToBrimstail);
        steps.put(0, startQuest);
        ConditionalStep inspectDevices = new ConditionalStep((QuestHelper)this, this.enterCave, new Requirement[0]);
        inspectDevices.addStep(new Conditions(this.inCave, this.inspectedBowl), this.inspectMachine);
        inspectDevices.addStep(this.inCave, this.inspectBowl);
        steps.put(1, inspectDevices);
        ConditionalStep talkAfterInspect = new ConditionalStep((QuestHelper)this, this.enterCave, new Requirement[0]);
        talkAfterInspect.addStep(this.inCave, this.talkToBrimstailAgain);
        steps.put(2, talkAfterInspect);
        ConditionalStep goTalkToHazelmere = new ConditionalStep((QuestHelper)this, this.goUpToHazelmere, new Requirement[0]);
        goTalkToHazelmere.addStep(this.inHazelmereHut, this.talkToHazelmere);
        steps.put(5, goTalkToHazelmere);
        steps.put(9, goTalkToHazelmere);
        steps.put(10, goTalkToHazelmere);
        steps.put(11, goTalkToHazelmere);
        steps.put(12, goTalkToHazelmere);
        ConditionalStep talkToBrimAfterHazel = new ConditionalStep((QuestHelper)this, this.enterCaveAgain, new Requirement[0]);
        talkToBrimAfterHazel.addStep(this.inCave, this.talkToBrimstailAfterHazelmere);
        steps.put(15, talkToBrimAfterHazel);
        ConditionalStep fixMachine = new ConditionalStep((QuestHelper)this, this.grindMudRunes, new Requirement[0]);
        fixMachine.addStep(new Conditions(this.magicGlue, this.inCave), this.repairMachine);
        fixMachine.addStep(this.magicGlue, this.enterCaveAgain);
        fixMachine.addStep(this.groundMud, this.useMudOnSap);
        steps.put(20, fixMachine);
        steps.put(21, fixMachine);
        steps.put(22, fixMachine);
        steps.put(23, fixMachine);
        ConditionalStep brimstailAfterFixing = new ConditionalStep((QuestHelper)this, this.enterCave, new Requirement[0]);
        brimstailAfterFixing.addStep(this.inCave, this.talkToBrimstailAfterRepairing);
        steps.put(25, brimstailAfterFixing);
        ConditionalStep getMoreTokens = new ConditionalStep((QuestHelper)this, this.enterCave, new Requirement[0]);
        getMoreTokens.addStep(this.inCave, this.unlockMachine);
        steps.put(27, this.unlockMachine);
        steps.put(30, getMoreTokens);
        ConditionalStep goOperateMachine = new ConditionalStep((QuestHelper)this, this.enterCave, new Requirement[0]);
        goOperateMachine.addStep(this.inCave, this.operateMachine);
        steps.put(35, goOperateMachine);
        ConditionalStep prepareToKill = new ConditionalStep((QuestHelper)this, this.enterCave, new Requirement[0]);
        prepareToKill.addStep(this.inCave, this.talkToBrimstailAfterIllusion);
        steps.put(36, prepareToKill);
        ConditionalStep killThemAll = new ConditionalStep((QuestHelper)this, this.enterCave, new Requirement[0]);
        killThemAll.addStep(new Conditions(this.killedCreature1, this.killedCreature5, this.killedCreature6, this.killedCreature4, this.killedCreature3), this.killCreature2);
        killThemAll.addStep(new Conditions(this.killedCreature1, this.killedCreature5, this.killedCreature6, this.killedCreature4, this.inFloor3), this.killCreature3);
        killThemAll.addStep(new Conditions(this.killedCreature1, this.killedCreature5, this.killedCreature6, this.killedCreature4, this.inFloor2), this.climbUpToF3Tree);
        killThemAll.addStep(new Conditions(this.killedCreature1, this.killedCreature5, this.killedCreature6, this.killedCreature4, this.inFloor1), this.climbUpToF2Tree);
        killThemAll.addStep(new Conditions(this.killedCreature1, this.killedCreature5, this.killedCreature6, this.killedCreature4), this.climbUpToF1Tree);
        killThemAll.addStep(new Conditions(this.killedCreature1, this.killedCreature5, this.killedCreature6), this.killCreature4);
        killThemAll.addStep(new Conditions(this.killedCreature1, this.killedCreature5), this.killCreature6);
        killThemAll.addStep(this.killedCreature1, this.killCreature5);
        killThemAll.addStep(this.inCave, this.killCreature1);
        steps.put(40, killThemAll);
        steps.put(45, killThemAll);
        steps.put(50, this.talkToNarnode);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.bucketOfSap = new ItemRequirement("Bucket of sap", 4687);
        this.bucketOfSap.setTooltip("You can get this by using a knife on an evergreen tree with a bucket in your inventory");
        this.bucketOfSapHiglight = new ItemRequirement("Bucket of sap", 4687);
        this.bucketOfSapHiglight.setTooltip("You can get this by using a knife on an evergreen tree with a bucket in your inventory");
        this.bucketOfSapHiglight.setHighlightInInventory(true);
        this.groundMud = new ItemRequirement("Ground mud runes", 9594);
        this.groundMud.setHighlightInInventory(true);
        this.mudRune = new ItemRequirement("Mud rune", 4698);
        this.mudRuneHighlight = new ItemRequirement("Mud rune", 4698);
        this.mudRuneHighlight.setHighlightInInventory(true);
        this.mapleLog = new ItemRequirement("Maple logs", 1517);
        this.oakLog = new ItemRequirement("Oak logs", 1521);
        this.hammer = new ItemRequirement("Hammer", ItemCollections.HAMMER).isNotConsumed();
        this.saw = new ItemRequirement("Saw", ItemCollections.SAW).isNotConsumed();
        this.pestleAndMortar = new ItemRequirement("Pestle and mortar", 233).isNotConsumed();
        this.pestleHighlight = this.pestleAndMortar.highlighted();
        this.magicGlue = new ItemRequirement("Magic glue", 9592);
        this.magicGlue.setHighlightInInventory(true);
    }

    public void setupZones() {
        this.cave = new Zone(new WorldPoint(2379, 9806, 0), new WorldPoint(2415, 9832, 0));
        this.hazelmereHut = new Zone(new WorldPoint(2673, 3085, 1), new WorldPoint(2681, 3089, 1));
        this.floor1 = new Zone(new WorldPoint(2437, 3474, 1), new WorldPoint(2493, 3511, 1));
        this.floor2 = new Zone(new WorldPoint(2437, 3474, 2), new WorldPoint(2493, 3511, 2));
        this.floor3 = new Zone(new WorldPoint(2437, 3474, 3), new WorldPoint(2493, 3511, 3));
    }

    public void setupConditions() {
        this.inCave = new ZoneRequirement(this.cave);
        this.inspectedBowl = new VarbitRequirement(2515, 1);
        this.inspectedMachine = new VarbitRequirement(2516, 1);
        this.inHazelmereHut = new ZoneRequirement(this.hazelmereHut);
        this.killedCreature1 = new VarbitRequirement(2504, 2);
        this.killedCreature2 = new VarbitRequirement(2505, 2);
        this.killedCreature3 = new VarbitRequirement(2506, 2);
        this.killedCreature4 = new VarbitRequirement(2507, 2);
        this.killedCreature5 = new VarbitRequirement(2508, 2);
        this.killedCreature6 = new VarbitRequirement(2509, 2);
        this.inFloor1 = new ZoneRequirement(this.floor1);
        this.inFloor2 = new ZoneRequirement(this.floor2);
        this.inFloor3 = new ZoneRequirement(this.floor3);
    }

    public void setupSteps() {
        int[] brimstailNPCs = new int[]{4914, 11431};
        this.enterCave = new ObjectStep((QuestHelper)this, 17209, new WorldPoint(2404, 3419, 0), "Go talk to Brimstail in his cave in west Tree Gnome Stronghold.", new Requirement[0]);
        this.talkToBrimstail = new NpcStep((QuestHelper)this, brimstailNPCs, new WorldPoint(2410, 9818, 0), "Talk to Brimstail.", new Requirement[0]);
        this.talkToBrimstail.addDialogStep("What's that cute creature wandering around?");
        this.talkToBrimstail.addDialogStep("Yes, that sounds fascinating...");
        this.talkToBrimstail.addDialogStep("Oh, yes I love a bit of History.");
        this.talkToBrimstail.addDialogStep("Yes.");
        this.enterCave.addSubSteps(this.talkToBrimstail);
        this.inspectBowl = new ObjectStep((QuestHelper)this, 17239, new WorldPoint(2388, 9813, 0), "Inspect the singing bowl in the west room.", new Requirement[0]);
        this.inspectMachine = new ObjectStep((QuestHelper)this, 17282, new WorldPoint(2390, 9826, 0), "Attempt to unlock oaknock's machine in the north of the cave.", new Requirement[0]);
        this.talkToBrimstailAgain = new NpcStep((QuestHelper)this, brimstailNPCs, new WorldPoint(2410, 9818, 0), "Talk to Brimstail again.", new Requirement[0]);
        this.talkToBrimstailAgain.addDialogStep("I've had a look in the other room now.");
        this.talkToBrimstailAgain.addDialogStep("Of course, I'd love to!");
        this.goUpToHazelmere = new ObjectStep((QuestHelper)this, 16683, new WorldPoint(2677, 3087, 0), "Go talk to Hazelmere in his hut east of Yanille (Fairy Ring CLS).", new Requirement[0]);
        this.talkToHazelmere = new NpcStep((QuestHelper)this, 1422, new WorldPoint(2677, 3087, 1), "Go talk to Hazelmere in his hut east of Yanille (Fairy Ring CLS).", new Requirement[0]);
        this.talkToHazelmere.addSubSteps(this.goUpToHazelmere);
        this.enterCaveAgain = new ObjectStep((QuestHelper)this, 17209, new WorldPoint(2404, 3419, 0), "Go back to Brimstail's cave in west Tree Gnome Stronghold.", this.pestleAndMortar, this.mudRune, this.bucketOfSap, this.oakLog, this.mapleLog, this.saw, this.hammer);
        this.talkToBrimstailAfterHazelmere = new NpcStep((QuestHelper)this, brimstailNPCs, new WorldPoint(2410, 9818, 0), "Talk to Brimstail.", new Requirement[0]);
        this.talkToBrimstailAfterHazelmere.addDialogStep("I've visited Hazelmere, he told me all sorts of interesting things.");
        this.talkToBrimstailAfterHazelmere.addSubSteps(this.enterCaveAgain);
        this.grindMudRunes = new DetailedQuestStep((QuestHelper)this, "Use the pestle and mortar on some mud runes.", this.pestleHighlight, this.mudRuneHighlight);
        this.useMudOnSap = new DetailedQuestStep((QuestHelper)this, "Use the ground mud runes on the bucket of sap.", this.groundMud, this.bucketOfSapHiglight);
        this.repairMachine = new ObjectStep((QuestHelper)this, 17282, new WorldPoint(2390, 9826, 0), "Use the magic glue on oaknock's machine in the north of the cave.", this.magicGlue, this.oakLog, this.mapleLog, this.saw, this.hammer);
        this.repairMachine.addIcon(9592);
        this.talkToBrimstailAfterRepairing = new NpcStep((QuestHelper)this, brimstailNPCs, new WorldPoint(2410, 9818, 0), "Talk to Brimstail.", new Requirement[0]);
        this.talkToBrimstailAfterRepairing.addDialogStep("I think I've fixed the machine now!");
        this.talkToBrimstailForMoreDisks = new NpcStep((QuestHelper)this, brimstailNPCs, new WorldPoint(2410, 9818, 0), "Talk to Brimstail for more disks.", new Requirement[0]);
        this.talkToBrimstailForMoreDisks.addDialogStep("I can't work out what to do with these discs!");
        this.unlockMachine = new PuzzleStep(this);
        this.unlockMachine.addSubSteps(this.unlockMachine.getSteps());
        this.operateMachine = new ObjectStep((QuestHelper)this, 17282, new WorldPoint(2390, 9826, 0), "Operate the machine.", new Requirement[0]);
        this.unlockMachine.addSubSteps(this.operateMachine);
        this.killCreature1 = new NpcStep((QuestHelper)this, 1241, new WorldPoint(2408, 9819, 0), "Kill the evil creature next to Brimstail.", new Requirement[0]);
        this.killCreature2 = new NpcStep((QuestHelper)this, 1244, new WorldPoint(2465, 3494, 0), "Kill the evil creature next to Narnode.", new Requirement[0]);
        this.killCreature3 = new NpcStep((QuestHelper)this, 1247, new WorldPoint(2466, 3496, 3), "Kill the evil creature at the top of the Grand Tree.", new Requirement[0]);
        this.killCreature4 = new NpcStep((QuestHelper)this, 1250, new WorldPoint(2422, 3526, 0), "Kill the evil creature in the north west of the Stronghold.", new Requirement[0]);
        this.killCreature5 = new NpcStep((QuestHelper)this, 1253, new WorldPoint(2461, 3388, 0), "Kill the evil creature next to the Stronghold's entrance.", new Requirement[0]);
        this.killCreature6 = new NpcStep((QuestHelper)this, 1256, new WorldPoint(2462, 3443, 0), "Kill the evil creature next to the Stronghold's Spirit Tree.", new Requirement[0]);
        this.talkToBrimstailAfterIllusion = new NpcStep((QuestHelper)this, brimstailNPCs, new WorldPoint(2410, 9818, 0), "Talk to Brimstail again.", new Requirement[0]);
        this.talkToBrimstailAfterIllusion.addDialogStep("Phew! I've got that machine working now. What do I need to do now?");
        this.climbUpToF1Tree = new ObjectStep((QuestHelper)this, 16683, new WorldPoint(2466, 3495, 0), "Kill the evil creature at the top of the Grand Tree.", new Requirement[0]);
        this.climbUpToF2Tree = new ObjectStep((QuestHelper)this, 16684, new WorldPoint(2466, 3495, 1), "Kill the evil creature at the top of the Grand Tree.", new Requirement[0]);
        this.climbUpToF3Tree = new ObjectStep((QuestHelper)this, 2884, new WorldPoint(2466, 3495, 2), "Kill the evil creature at the top of the Grand Tree.", new Requirement[0]);
        this.killCreature3.addSubSteps(this.climbUpToF1Tree, this.climbUpToF2Tree, this.climbUpToF3Tree);
        this.talkToNarnode = new NpcStep((QuestHelper)this, 8019, new WorldPoint(2465, 3496, 0), "Talk to King Narnode to finish the quest.", new Requirement[0]);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.bucketOfSap, this.mudRune, this.mapleLog, this.oakLog, this.hammer, this.saw, this.pestleAndMortar);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new QuestRequirement(QuestHelperQuest.THE_GRAND_TREE, QuestState.FINISHED));
        req.add(new SkillRequirement(Skill.CONSTRUCTION, 5));
        req.add(new SkillRequirement(Skill.MAGIC, 46));
        return req;
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("Evil creature (x6)");
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(2);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.MAGIC, 12000), new ExperienceReward(Skill.WOODCUTTING, 2500), new ExperienceReward(Skill.RUNECRAFT, 6000), new ExperienceReward(Skill.CONSTRUCTION, 250));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("A Crystal Saw Seed"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Learning", Arrays.asList(this.enterCave, this.inspectBowl, this.inspectMachine, this.talkToBrimstailAgain, this.talkToHazelmere, this.talkToBrimstailAfterHazelmere, this.grindMudRunes, this.useMudOnSap, this.repairMachine, this.talkToBrimstailAfterRepairing, this.talkToBrimstailForMoreDisks, this.unlockMachine), this.bucketOfSap, this.mudRune, this.mapleLog, this.oakLog, this.hammer, this.saw, this.pestleAndMortar));
        allSteps.add(new PanelDetails("Kill the spies", Arrays.asList(this.talkToBrimstailAfterIllusion, this.killCreature1, this.killCreature5, this.killCreature6, this.killCreature4, this.killCreature3, this.killCreature2, this.talkToNarnode), new Requirement[0]));
        return allSteps;
    }
}

