/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.theeyesofglouphrie;

import com.google.inject.Inject;
import com.questhelper.QuestHelperPlugin;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.OwnerStep;
import com.questhelper.steps.QuestStep;
import com.questhelper.steps.WidgetDetails;
import com.questhelper.steps.WidgetStep;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import lombok.NonNull;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.ui.overlay.components.PanelComponent;

public class PuzzleStep
extends QuestStep
implements OwnerStep {
    @Inject
    protected EventBus eventBus;
    @Inject
    protected Client client;
    protected QuestStep currentStep;
    HashMap<Integer, ItemRequirement> shapeValues = new HashMap();
    HashMap<Integer, List<List<ItemRequirement>>> shapeValues3 = new HashMap();
    HashMap<Integer, List<List<ItemRequirement>>> shapeValues4 = new HashMap();
    ItemRequirement slot1Item;
    ItemRequirement slot2Item;
    ItemRequirement slot3Item;
    ItemRequirement yellowCircleRedTri;
    ItemRequirement greenCircleRedSquare;
    ItemRequirement blueCircleRedPentagon;
    ItemRequirement blueSquareGreenPentagon;
    ItemRequirement indigoCircleOrangeTriangle;
    ItemRequirement yellowSquareGreenTriangle;
    ItemRequirement yellowPentagonBlueTriangle;
    HashMap<Integer, ItemRequirement> shapes = new HashMap();
    WidgetStep clickAnswer1;
    WidgetStep insertDisc;
    WidgetStep clickDiscHole;
    WidgetStep clickDiscHole2;
    WidgetStep clickDiscHole3;
    WidgetStep clickDiscHole4;
    WidgetStep clickAnswer2;
    ObjectStep solvePuzzle;
    ObjectStep getPieces;
    int answer1;
    int answer2;
    int answer3;
    int answer4;
    int items1;
    List<ItemRequirement> items2 = new ArrayList<ItemRequirement>();
    List<ItemRequirement> items3 = new ArrayList<ItemRequirement>();
    List<ItemRequirement> items4 = new ArrayList<ItemRequirement>();
    Item[] lastInv;
    Item[] currentInv;
    int newMostMatch3 = -1;
    int mostMatch4 = -1;

    public PuzzleStep(QuestHelper questHelper) {
        super(questHelper, "Insert and swap discs to make the sum indicated on the machine");
        this.solvePuzzle = new ObjectStep(this.getQuestHelper(), 17282, new WorldPoint(2390, 9826, 0), "Put in the correct pieces.", new Requirement[0]);
        this.getPieces = new ObjectStep(this.getQuestHelper(), 17283, new WorldPoint(2391, 9826, 0), "Swap in your pieces for the indicated pieces. You can also drop the discs then talk to Brimstail for more tokens.", new Requirement[0]);
        this.clickAnswer1 = new WidgetStep(this.getQuestHelper(), "Click the submit button.", 445, 36);
        this.clickAnswer2 = new WidgetStep(this.getQuestHelper(), "Click the submit button.", 189, 39);
        this.insertDisc = new WidgetStep(this.getQuestHelper(), "Insert the correct discs.", 449, 0);
        this.clickDiscHole = new WidgetStep(this.getQuestHelper(), "Insert the disc.", 445, 31);
        this.clickDiscHole2 = new WidgetStep(this.getQuestHelper(), "Insert the disc.", 189, 24);
        this.clickDiscHole3 = new WidgetStep(this.getQuestHelper(), "Insert the disc.", 189, 25);
        this.clickDiscHole4 = new WidgetStep(this.getQuestHelper(), "Insert the disc.", 189, 26);
        this.setupShapes();
    }

    @Override
    public void startUp() {
        super.startUp();
        this.answer1 = this.client.getVarbitValue(2510);
        this.answer2 = this.client.getVarbitValue(2511);
        this.answer3 = this.client.getVarbitValue(2512);
        this.answer4 = this.client.getVarbitValue(2513);
        this.updateSteps();
    }

    @Override
    public void shutDown() {
        this.shutDownStep();
        this.currentStep = null;
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.updateSteps();
    }

    public void updateSteps() {
        if (this.client.getVarbitValue(2502) == 2) {
            this.solvePuzzle2();
        } else {
            this.solvePuzzle1();
        }
    }

    public void solvePuzzle1() {
        int heldDisc = this.client.getVarpValue(856);
        Widget insertWidget = this.client.getWidget(447, 0);
        if (this.client.getVarbitValue(2539) == this.answer1) {
            this.startUpStep(this.clickAnswer1);
            return;
        }
        ItemContainer itemContainer = this.client.getItemContainer(InventoryID.INVENTORY);
        if (itemContainer == null) {
            return;
        }
        Item[] inventoryItemsArr = itemContainer.getItems();
        this.items1 = -1;
        ArrayList<Item> inventoryItems = new ArrayList<Item>(Arrays.asList(inventoryItemsArr));
        for (Integer id : this.shapeValues.get(this.answer1).getAllIds()) {
            int match = this.checkForItems(inventoryItems, id);
            if (match == -1) continue;
            this.items1 = this.shapes.get(id).getId();
            break;
        }
        if (this.items1 == -1) {
            this.getPieces.emptyRequirements();
            this.getPieces.addRequirement((Requirement)this.shapeValues.get(this.answer1));
            this.startUpStep(this.getPieces);
            return;
        }
        if (insertWidget != null && !insertWidget.isHidden()) {
            if (this.items1 == heldDisc) {
                this.startUpStep(this.clickDiscHole);
                return;
            }
            if (this.currentInv != null) {
                List<WidgetDetails> ids = new ArrayList<WidgetDetails>();
                ids = this.getClickableItems(ids, new ArrayList<Integer>(this.items1));
                this.insertDisc.setWidgetDetails(ids);
                this.insertDisc.setRequirements(Collections.singletonList(this.shapes.get(this.items1)));
                this.startUpStep(this.insertDisc);
            }
            return;
        }
        this.solvePuzzle.setRequirements(Collections.singletonList(this.shapes.get(this.items1)));
        this.startUpStep(this.solvePuzzle);
    }

    public void solvePuzzle2() {
        int heldDisc = this.client.getVarpValue(856);
        if (this.client.getVarbitValue(2540) == this.answer2 && this.client.getVarbitValue(2541) == this.answer3 && this.client.getVarbitValue(2542) == this.answer4) {
            this.startUpStep(this.clickAnswer2);
            return;
        }
        ItemContainer itemContainer = this.client.getItemContainer(InventoryID.INVENTORY);
        if (itemContainer == null) {
            return;
        }
        Item[] inventoryItemsArr = itemContainer.getItems();
        ArrayList<Item> inventoryItems = new ArrayList<Item>(Arrays.asList(inventoryItemsArr));
        Widget insertWidget = this.client.getWidget(189, 0);
        int slot1 = this.client.getVarpValue(850);
        int slot2 = this.client.getVarpValue(851);
        int slot3 = this.client.getVarpValue(852);
        int slot4 = this.client.getVarpValue(853);
        int slot5 = this.client.getVarpValue(854);
        int slot6 = this.client.getVarpValue(855);
        this.newMostMatch3 = -1;
        this.mostMatch4 = -1;
        this.lastInv = inventoryItemsArr;
        for (Integer id : this.shapeValues.get(this.answer2).getAllIds()) {
            this.items2 = Collections.singletonList(this.shapeValues.get(this.answer2));
            int match = this.checkForItems(inventoryItems, id);
            if (match != -1) {
                if (((Item)inventoryItems.get(match)).getQuantity() > 1) {
                    Item newItem = new Item(((Item)inventoryItems.get(match)).getId(), ((Item)inventoryItems.get(match)).getQuantity() - 1);
                    inventoryItems.set(match, newItem);
                } else {
                    inventoryItems.remove(match);
                }
            }
            if (id != slot1) continue;
            this.items2 = new ArrayList<ItemRequirement>();
            break;
        }
        ArrayList<ItemRequirement> allRequirements = new ArrayList<ItemRequirement>(this.items2);
        ArrayList<ItemRequirement> newReq3 = new ArrayList<ItemRequirement>();
        ArrayList<Item> newInventory3 = new ArrayList<Item>(inventoryItems);
        for (List<ItemRequirement> reqs : this.shapeValues3.get(this.answer3)) {
            ArrayList<Integer> currentSlotIDs3 = new ArrayList<Integer>(Arrays.asList(slot2, slot3));
            ArrayList<Item> tmpInventory3 = new ArrayList<Item>(inventoryItems);
            ArrayList<ItemRequirement> tmpReqs = new ArrayList<ItemRequirement>(reqs);
            int currentMatches = 0;
            block2: for (ItemRequirement req : reqs) {
                for (int i = 0; i < req.getAllIds().size(); ++i) {
                    int match = this.checkForItems(tmpInventory3, req.getAllIds().get(i));
                    if (match == -1) continue;
                    ++currentMatches;
                    if (((Item)tmpInventory3.get(match)).getQuantity() > 1) {
                        Item newItem = new Item(((Item)tmpInventory3.get(match)).getId(), ((Item)tmpInventory3.get(match)).getQuantity() - 1);
                        tmpInventory3.set(match, newItem);
                    } else {
                        tmpInventory3.remove(match);
                    }
                    if (!currentSlotIDs3.contains(req.getAllIds().get(i))) continue block2;
                    tmpReqs.remove(req);
                    currentSlotIDs3.remove(req.getAllIds().get(i));
                    continue block2;
                }
            }
            if (currentMatches <= this.newMostMatch3 && (currentMatches != this.newMostMatch3 || newReq3.size() <= tmpReqs.size())) continue;
            this.newMostMatch3 = currentMatches;
            newReq3 = tmpReqs;
            newInventory3 = tmpInventory3;
        }
        inventoryItems = newInventory3;
        this.items3 = newReq3;
        for (ItemRequirement requirement : this.items3) {
            boolean foundPreviousItem = false;
            for (int j = 0; j < allRequirements.size(); ++j) {
                if (requirement.getId() != ((ItemRequirement)allRequirements.get(j)).getId()) continue;
                allRequirements.set(j, requirement.quantity(requirement.getQuantity() + ((ItemRequirement)allRequirements.get(j)).getQuantity()));
                foundPreviousItem = true;
                break;
            }
            if (foundPreviousItem) continue;
            allRequirements.add(requirement);
        }
        ArrayList<ItemRequirement> newReq4 = new ArrayList<ItemRequirement>();
        for (List<ItemRequirement> reqs : this.shapeValues4.get(this.answer4)) {
            ArrayList<Integer> currentSlotIDs4 = new ArrayList<Integer>(Arrays.asList(slot4, slot5, slot6));
            ArrayList<Item> tmpInventory4 = new ArrayList<Item>(inventoryItems);
            ArrayList<ItemRequirement> tmpReqs = new ArrayList<ItemRequirement>(reqs);
            int currentMatches = 0;
            block7: for (ItemRequirement req : reqs) {
                for (int i = 0; i < req.getAllIds().size(); ++i) {
                    int match = this.checkForItems(tmpInventory4, req.getAllIds().get(i));
                    if (match == -1) continue;
                    ++currentMatches;
                    if (((Item)tmpInventory4.get(match)).getQuantity() > 1) {
                        Item newItem = new Item(((Item)tmpInventory4.get(match)).getId(), ((Item)tmpInventory4.get(match)).getQuantity() - 1);
                        tmpInventory4.set(match, newItem);
                    } else {
                        tmpInventory4.remove(match);
                    }
                    if (!currentSlotIDs4.contains(req.getAllIds().get(i))) continue block7;
                    tmpReqs.remove(req);
                    currentSlotIDs4.remove(req.getAllIds().get(i));
                    continue block7;
                }
            }
            if (currentMatches <= this.mostMatch4 && (currentMatches != this.mostMatch4 || newReq4.size() <= tmpReqs.size())) continue;
            this.mostMatch4 = currentMatches;
            newReq4 = tmpReqs;
        }
        this.items4 = newReq4;
        for (ItemRequirement newRequirement : this.items4) {
            boolean foundPreviousItem = false;
            for (int j = 0; j < allRequirements.size(); ++j) {
                if (newRequirement.getId() != ((ItemRequirement)allRequirements.get(j)).getId()) continue;
                allRequirements.set(j, newRequirement.quantity(newRequirement.getQuantity() + ((ItemRequirement)allRequirements.get(j)).getQuantity()));
                foundPreviousItem = true;
                break;
            }
            if (foundPreviousItem) continue;
            allRequirements.add(newRequirement);
        }
        boolean hasAllDiscs = true;
        for (ItemRequirement requirement : allRequirements) {
            if (requirement.check(this.client)) continue;
            hasAllDiscs = false;
            break;
        }
        if (!hasAllDiscs) {
            this.getPieces.emptyRequirements();
            this.getPieces.addItemRequirements(allRequirements);
            this.startUpStep(this.getPieces);
            return;
        }
        if (insertWidget != null && !insertWidget.isHidden()) {
            for (ItemRequirement itemRequirement : this.items2) {
                if (itemRequirement.getId() != heldDisc) continue;
                this.startUpStep(this.clickDiscHole2);
                return;
            }
            for (ItemRequirement itemRequirement : this.items3) {
                if (itemRequirement.getId() != heldDisc) continue;
                this.startUpStep(this.clickDiscHole3);
                return;
            }
            for (ItemRequirement itemRequirement : this.items4) {
                if (itemRequirement.getId() != heldDisc) continue;
                this.startUpStep(this.clickDiscHole4);
                return;
            }
            if (this.currentInv != null) {
                List<WidgetDetails> ids = new ArrayList<WidgetDetails>();
                if (!this.items2.isEmpty()) {
                    ids = this.getClickableItems(ids, this.items2.iterator().next().getAllIds());
                } else if (!this.items3.isEmpty()) {
                    ids = this.getClickableItems(ids, this.items3.iterator().next().getAllIds());
                } else if (!this.items4.isEmpty()) {
                    ids = this.getClickableItems(ids, this.items4.iterator().next().getAllIds());
                }
                this.insertDisc.setWidgetDetails(ids);
                this.insertDisc.emptyRequirements();
                this.insertDisc.addItemRequirements(allRequirements);
                this.startUpStep(this.insertDisc);
            }
            return;
        }
        this.solvePuzzle.setRequirements(Collections.singletonList(this.slot1Item));
        this.solvePuzzle.emptyRequirements();
        this.solvePuzzle.addItemRequirements(allRequirements);
        this.startUpStep(this.solvePuzzle);
    }

    public List<WidgetDetails> getClickableItems(List<WidgetDetails> ids, List<Integer> items) {
        for (int j = 0; j < this.currentInv.length; ++j) {
            if (!items.contains(this.currentInv[j].getId())) continue;
            ids.add(new WidgetDetails(449, 0, j));
        }
        return ids;
    }

    public int checkForItems(List<Item> items, int potentialMatch) {
        for (int i = 0; i < items.size(); ++i) {
            if (items.get(i).getId() != potentialMatch) continue;
            return i;
        }
        return -1;
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (event.getContainerId() == 440) {
            ItemContainer container = event.getItemContainer();
            this.currentInv = container.getItems();
        }
    }

    public void setupShapes() {
        this.slot1Item = new ItemRequirement("For part 1 get:", -1, -1);
        this.slot2Item = new ItemRequirement("For part 2 get:", -1, -1);
        this.slot3Item = new ItemRequirement("For part 3 get:", -1, -1);
        this.shapes.put(9597, new ItemRequirement("Red circle", 9597));
        this.shapes.put(9601, new ItemRequirement("Orange circle", 9601));
        this.shapes.put(9605, new ItemRequirement("Yellow circle", 9605));
        this.shapes.put(9609, new ItemRequirement("Green circle", 9609));
        this.shapes.put(9613, new ItemRequirement("Blue circle", 9613));
        this.shapes.put(9617, new ItemRequirement("Indigo circle", 9617));
        this.shapes.put(9621, new ItemRequirement("Violet circle", 9621));
        this.shapes.put(9598, new ItemRequirement("Red triangle", 9598));
        this.shapes.put(9602, new ItemRequirement("Orange triangle", 9602));
        this.shapes.put(9606, new ItemRequirement("Yellow triangle", 9606));
        this.shapes.put(9610, new ItemRequirement("Green triangle", 9610));
        this.shapes.put(9614, new ItemRequirement("Blue triangle", 9614));
        this.shapes.put(9618, new ItemRequirement("Indigo triangle", 9618));
        this.shapes.put(9622, new ItemRequirement("Violet triangle", 9622));
        this.shapes.put(9599, new ItemRequirement("Red square", 9599));
        this.shapes.put(9603, new ItemRequirement("Orange square", 9603));
        this.shapes.put(9607, new ItemRequirement("Yellow square", 9607));
        this.shapes.put(9611, new ItemRequirement("Green square", 9611));
        this.shapes.put(9615, new ItemRequirement("Blue square", 9615));
        this.shapes.put(9619, new ItemRequirement("Indigo square", 9619));
        this.shapes.put(9623, new ItemRequirement("Violet square", 9623));
        this.shapes.put(9600, new ItemRequirement("Red pentagon", 9600));
        this.shapes.put(9604, new ItemRequirement("Orange pentagon", 9604));
        this.shapes.put(9608, new ItemRequirement("Yellow pentagon", 9608));
        this.shapes.put(9612, new ItemRequirement("Green pentagon", 9612));
        this.shapes.put(9616, new ItemRequirement("Blue pentagon", 9616));
        this.shapes.put(9620, new ItemRequirement("Indigo pentagon", 9620));
        this.shapes.put(9624, new ItemRequirement("Violet pentagon", 9624));
        this.yellowCircleRedTri = new ItemRequirement("Yellow circle/red triangle", 9598);
        this.yellowCircleRedTri.addAlternates(9605);
        this.greenCircleRedSquare = new ItemRequirement("Green circle/red square", 9609);
        this.greenCircleRedSquare.addAlternates(9599);
        this.blueCircleRedPentagon = new ItemRequirement("Blue circle/red pentagon", 9613);
        this.blueCircleRedPentagon.addAlternates(9600);
        this.indigoCircleOrangeTriangle = new ItemRequirement("Indigo circle/orange triangle", 9617);
        this.indigoCircleOrangeTriangle.addAlternates(9602);
        this.yellowSquareGreenTriangle = new ItemRequirement("Yellow square/green triangle", 9607);
        this.yellowSquareGreenTriangle.addAlternates(9610);
        this.yellowPentagonBlueTriangle = new ItemRequirement("Yellow pentagon/blue triangle", 9608);
        this.yellowPentagonBlueTriangle.addAlternates(9614);
        this.blueSquareGreenPentagon = new ItemRequirement("Blue square/green pentagon", 9615);
        this.blueSquareGreenPentagon.addAlternates(9612);
        this.shapeValues.put(1, this.shapes.get(9597));
        this.shapeValues.put(2, this.shapes.get(9601));
        this.shapeValues.put(3, this.yellowCircleRedTri);
        this.shapeValues.put(4, this.greenCircleRedSquare);
        this.shapeValues.put(5, this.blueCircleRedPentagon);
        this.shapeValues.put(6, this.indigoCircleOrangeTriangle);
        this.shapeValues.put(7, this.shapes.get(9621));
        this.shapeValues.put(8, this.shapes.get(9603));
        this.shapeValues.put(9, this.shapes.get(9606));
        this.shapeValues.put(10, this.shapes.get(9604));
        this.shapeValues.put(12, this.yellowSquareGreenTriangle);
        this.shapeValues.put(15, this.yellowPentagonBlueTriangle);
        this.shapeValues.put(16, this.shapes.get(9611));
        this.shapeValues.put(18, this.shapes.get(9618));
        this.shapeValues.put(20, this.blueSquareGreenPentagon);
        this.shapeValues.put(21, this.shapes.get(9622));
        this.shapeValues.put(24, this.shapes.get(9619));
        this.shapeValues.put(25, this.shapes.get(9616));
        this.shapeValues.put(28, this.shapes.get(9623));
        this.shapeValues.put(30, this.shapes.get(9620));
        this.shapeValues.put(35, this.shapes.get(9624));
        for (int i = 0; i < 35; ++i) {
            ItemRequirement shape1 = this.shapeValues.get(i);
            for (int j = 0; j < 35; ++j) {
                ItemRequirement shape2 = this.shapeValues.get(j);
                if (shape1 == null || shape2 == null) continue;
                this.shapeValues3.computeIfAbsent(i + j, sv2 -> new ArrayList());
                this.shapeValues3.get(i + j).add(Arrays.asList(shape1, shape2));
                for (int k = 0; k < 35; ++k) {
                    ItemRequirement shape3 = this.shapeValues.get(k);
                    if (shape3 == null) continue;
                    this.shapeValues4.computeIfAbsent(i + j + k, sv3 -> new ArrayList());
                    this.shapeValues4.get(i + j + k).add(Arrays.asList(shape1, shape2, shape3));
                }
            }
        }
    }

    protected void startUpStep(QuestStep step) {
        if (this.currentStep == null) {
            this.currentStep = step;
            this.eventBus.register((Object)this.currentStep);
            this.currentStep.startUp();
            return;
        }
        if (!step.equals(this.currentStep)) {
            this.shutDownStep();
            this.eventBus.register((Object)step);
            step.startUp();
            this.currentStep = step;
        }
    }

    protected void shutDownStep() {
        if (this.currentStep != null) {
            this.eventBus.unregister((Object)this.currentStep);
            this.currentStep.shutDown();
            this.currentStep = null;
        }
    }

    @Override
    public void makeOverlayHint(PanelComponent panelComponent, QuestHelperPlugin plugin, @NonNull List<String> additionalText, @NonNull List<Requirement> requirements) {
        if (additionalText == null) {
            throw new NullPointerException("additionalText is marked @NonNull but is null");
        }
        if (requirements == null) {
            throw new NullPointerException("requirements is marked @NonNull but is null");
        }
        if (this.currentStep != null) {
            this.currentStep.makeOverlayHint(panelComponent, plugin, additionalText, requirements);
        }
    }

    @Override
    public void makeWorldOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
        if (this.currentStep != null) {
            this.currentStep.makeWorldOverlayHint(graphics, plugin);
        }
    }

    @Override
    public void makeWorldArrowOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
        if (this.currentStep != null) {
            this.currentStep.makeWorldArrowOverlayHint(graphics, plugin);
        }
    }

    @Override
    public void makeWorldLineOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
        if (this.currentStep != null) {
            this.currentStep.makeWorldLineOverlayHint(graphics, plugin);
        }
    }

    @Override
    public QuestStep getActiveStep() {
        if (this.currentStep != null) {
            return this.currentStep.getActiveStep();
        }
        return this;
    }

    @Override
    public Collection<QuestStep> getSteps() {
        return Arrays.asList(this.solvePuzzle, this.getPieces, this.clickAnswer1, this.clickAnswer2, this.insertDisc, this.clickDiscHole, this.clickDiscHole2, this.clickDiscHole3, this.clickDiscHole4);
    }
}

